<?php $__env->startSection('title'); ?>
  Master Customer
    <a onclick="addForm()" class="btn btn-success"><i class="fa fa-plus-circle"></i> New Customer </a>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
   ##parent-placeholder-6e5ce570b4af9c70279294e1a958333ab1037c86##
   <li>customer</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>     
<div class="row">
  <div class="col-xs-12">
    <div class="box">
      <div class="box-body">  

<table class="table table-striped table-padding table-bordered" id="tbl-customer" width="100%">
<thead>
   <tr class="tblheader">
      <th>Nama</th>
      <th>Alamat</th>
      <th>Kota</th>
	  <th>No.HP</th>
	  <th>Area</th>
	  <th>Lvl</th>
      <th width="50">Opsi</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>

<?php echo $__env->make('customer.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "<?php echo e(route('customer.data')); ?>",
       "type" : "GET"
     }
   }); 
   
   $('#modal-form form').validator().on('submit', function(e){
      
      $('#submit-control').html(' simpan data ');
      $('#submit-control').attr('disabled','disabled');
      
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         if(save_method == "add") url = "<?php echo e(route('customer.store')); ?>";
         else url = "customer/"+id;
         
         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');
			 
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " Master Customer baru berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");	
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
     }
   });
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('New Customer');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "customer/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Customer');
       
       $('#id').val(data.id_cust);
	   $('#nama').val(data.cus_name);
       $('#alamat').val(data.cus_address);
       $('#kota').val(data.cus_kota);
	   $('#nohp').val(data.cus_nohp);
	   $('#nohp2').val(data.cus_nohp2);
	   $('#level').val(data.cus_level);
	   $('#area').val(data.cus_area);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/myprojeq/public_html/otman/resources/views/customer/index.blade.php ENDPATH**/ ?>