 <?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'HomeController@index')->name('home');
Route::get('/home', 'HomeController@index')->name('home');
Route::get('/logout', '\App\Http\Controllers\Auth\LoginController@logout')->name('logout');

Auth::routes();

Route::group(['middleware' => 'web'], function(){
   
    Route::get('user/profil', 'UserController@profil')->name('user.profil');
    Route::patch('user/{id}/change', 'UserController@changeProfil');

});

Route::group(['middleware' => ['auth']], function(){
    
    Route::get('upload/upload', 'UploadController@upload')->name('upload.upload');
	Route::post('upload/proses', 'UploadController@proses_upload')->name('upload.proses');
	Route::resource('upload', 'UploadController');
    	
    Route::get('rute/data', 'RuteController@listData')->name('rute.data');
    Route::get('rute/{id}/batal', 'RuteController@batal')->name('rute.batal');
    Route::get('rute/{id}/detail', 'RuteController@detail')->name('rute.detail');
    Route::get('rute/{tgl}/{tp}/listrute', 'RuteController@listrute')->name('rute.listrute');
    Route::get('rute/{id}/tampil', 'RuteController@tampil')->name('rute.tampil');   
    Route::resource('rute', 'RuteController');
       
    Route::get('customer/data', 'CustomerController@listData')->name('customer.data');
    Route::resource('customer', 'CustomerController');
    
    Route::get('category/data', 'CategoryController@listData')->name('category.data');
    Route::get('category/getdata', 'CategoryController@getData')->name('category.getdata');
    Route::get('category/{id}/edit', 'CategoryController@edit');
    Route::resource('category', 'CategoryController');   

    Route::get('formbs/{tgl1}/{tgl2}/data', 'FormBSController@listData')->name('formbs.data');
    Route::get('formbs/getdata', 'FormBSController@getData')->name('formbs.getdata');
    Route::resource('formbs', 'FormBSController'); 

    Route::get('mutasi/data', 'MutasiController@listData')->name('mutasi.data');
    Route::get('mutasi/data1', 'MutasiController@listData1')->name('mutasi.data1');
    Route::get('mutasi/{id}/edit', 'MutasiController@edit');
    Route::resource('mutasi', 'MutasiController');

    Route::get('supplier/data', 'SupplierController@listData')->name('supplier.data');
    Route::get('supplier/pilihdata', 'SupplierController@pilihData')->name('supplier.pilihdata');
    Route::resource('supplier', 'SupplierController'); 
   
/*--- master ---------*/
    Route::get('master/index_payment', 'MasterController@index_payment')->name('master.index_payment');
    Route::get('master/datadpayment', 'MasterController@dataPayment')->name('master.datapayment');
    Route::post('master/simpanpayment', 'MasterController@simpanPayment')->name('master.simpanpayment');    
    Route::get('master/{id}/editpayment', 'MasterController@editPayment')->name('master.editpayment');
    Route::get('master/{id}/simpaneditpayment', 'MasterController@simpaneditPayment')->name('master.simpaneditpayment');
    Route::get('master/listpayment', 'MasterController@listPayment')->name('master.listpayment');
    Route::get('master/typepayment', 'MasterController@typePayment')->name('master.typepayment');
    
    Route::get('master/index_variant', 'MasterController@index_variant')->name('master.index_variant');
    Route::get('master/datavariant', 'MasterController@dataVariant')->name('master.datavariant');
    Route::post('master/simpanvariant', 'MasterController@simpanVariant')->name('master.simpanvariant');    
    Route::get('master/{id}/editvariant', 'MasterController@editVariant')->name('master.editvariant');
    Route::get('master/{id}/simpaneditvariant', 'MasterController@simpaneditVariant')->name('master.simpaneditvariant');

    Route::get('master/index_mobil', 'MasterController@index_mobil')->name('master.index_mobil');
    Route::get('master/datamobil', 'MasterController@dataMobil')->name('master.datamobil');
    Route::post('master/simpanmobil', 'MasterController@simpanMobil')->name('master.simpanmobil');    
    Route::get('master/{id}/editmobil', 'MasterController@editMobil')->name('master.editmobil');
    Route::get('master/{id}/simpaneditmobil', 'MasterController@simpaneditMobil')->name('master.simpaneditmobil');
    
    Route::get('master/index_area', 'MasterController@index_area')->name('master.index_area');
    Route::get('master/dataarea', 'MasterController@dataArea')->name('master.dataarea');
    Route::post('master/simpanarea', 'MasterController@simpanArea')->name('master.simpanarea');    
    Route::get('master/{id}/editarea', 'MasterController@editArea')->name('master.editarea');
    Route::get('master/{id}/simpaneditarea', 'MasterController@simpaneditArea')->name('master.simpaneditarea');
    
    Route::resource('master', 'MasterController');
    
/*---------- kanvas ---------------*/
    Route::get('kanvas/index', 'KanvasController@index')->name('kanvas.index');
    Route::get('kanvas/getdata', 'KanvasController@getData')->name('kanvas.getdata');
    Route::get('kanvas/inputstock', 'KanvasController@inputStock')->name('kanvas.inputstock');
    Route::get('kanvas/{id}/datadetail', 'KanvasController@dataDetail')->name('kanvas.datadetail');
    Route::get('kanvas/{id}/loadheader', 'KanvasController@loadHeader')->name('kanvas.loadheader');
    Route::post('kanvas/{id}/simpandetail', 'KanvasController@simpanDetail')->name('kanvas.simpandetail');
    Route::get('kanvas/{id}/edit', 'KanvasController@edit')->name('kanvas.edit');
    Route::get('kanvas/{id}/editdetail', 'KanvasController@editDetail')->name('kanvas.editdetail');
    Route::get('kanvas/{id}/simpaneditdetail', 'KanvasController@simpaneditDetail')->name('kanvas.simpaneditdetail');
    Route::get('kanvas/{id}/cetakdokumen', 'KanvasController@cetakDokumen')->name('kanvas.cetakdokumen');
    Route::get('kanvas/{id}/postingkanvas', 'KanvasController@postingKanvas')->name('kanvas.postingkanvas');
    Route::get('kanvas/index_stock', 'KanvasController@index_stock')->name('kanvas.index_stock');
    Route::get('kanvas/{id}/datastock', 'KanvasController@dataStock')->name('kanvas.datastock');
    Route::get('kanvas/index_sale', 'KanvasController@index_sale')->name('kanvas.index_sale');
    Route::get('kanvas/{id}/penjualan', 'KanvasController@penjualan')->name('kanvas.penjualan');
    Route::post('kanvas/{id}/newinvoice', 'KanvasController@newInvoice');
    Route::get('kanvas/{id}/kanvasdetail', 'KanvasController@kanvasDetail')->name('kanvas.kanvasdetail');
    Route::get('kanvas/{id}/loadinvoice', 'KanvasController@loadInvoice')->name('kanvas.loadinvoice');
    Route::get('kanvas/{id}/loadsummary', 'KanvasController@loadSummary')->name('kanvas.loadsummary');
    Route::get('kanvas/{id}/{msl}/tampilproduct', 'KanvasController@tampilProduct')->name('kanvas.tampilproduct');
    Route::post('kanvas/simpansale', 'KanvasController@simpanSale')->name('kanvas.simpansale');
    Route::get('kanvas/{id}/potongan', 'KanvasController@potongan')->name('kanvas.potongan');
    Route::get('kanvas/{id}/simpanpotongan', 'KanvasController@simpanPotongan')->name('kanvas.simpanpotongan');
    Route::get('kanvas/{id}/{mode}/updqty', 'KanvasController@updQty')->name('kanvas.updqty');
    Route::get('kanvas/{id}/cetakinvoice', 'KanvasController@cetakInvoice')->name('kanvas.cetakinvoice');
    Route::get('kanvas/{id}/postingsale', 'KanvasController@postingSale')->name('kanvas.postingsale');
    Route::get('kanvas/jurnalkanvas', 'KanvasController@jurnalKanvas')->name('kanvas.jurnalkanvas');
    Route::get('kanvas/{tgl1}/{tgl2}/tampiljurnal', 'KanvasController@tampilJurnal')->name('kanvas.tampiljurnal');
    Route::get('kanvas/pelunasan', 'KanvasController@pelunasan')->name('kanvas.pelunasan');
    Route::get('kanvas/index_cicilan', 'KanvasController@index_cicilan')->name('kanvas.index_cicilan');
    Route::get('kanvas/cicilan', 'KanvasController@cicilan')->name('kanvas.cicilan');
    Route::get('kanvas/tesprinter', 'KanvasController@testprinter')->name('kanvas.testprinter');
    Route::get('kanvas/print_go', 'KanvasController@print_go')->name('kanvas.print_go');
    
    Route::resource('kanvas', 'KanvasController');
    
// Sales by Salesman

    Route::get('sessi/index', 'SessiController@index')->name('sessi.index');
    Route::get('sessi/startsessi', 'SessiController@startSessi')->name('sessi.start_sessi');
    Route::get('sessi/data', 'SessiController@listData')->name('sessi.data');
    Route::get('sessi/cekstatus', 'SessiController@cekstatus')->name('sessi.cekstatus');
    Route::get('sessi/ceksessi', 'SessiController@ceksessi')->name('sessi.ceksessi');
    Route::get('sessi/closing1', 'SessiController@closing1')->name('sessi.closing1');
    Route::get('sessi/cetakrekap', 'SessiController@cetakRekap')->name('sessi.cetakrekap');
    Route::get('sessi/index_mgr', 'SessiController@sessiMgr')->name('sessi.sessi_mgr');
    Route::get('sessi/listsessi', 'SessiController@listSessi')->name('sessi.listsessi');
    Route::get('sessi/{id}/detail', 'SessiController@detail')->name('sessi.detail');
    Route::resource('sessi', 'SessiController');

    Route::get('sales/cashier', 'SalesController@cashier')->name('sales.cashier');
    Route::get('sales/datacashier', 'SalesController@dataCashier')->name('sales.datacashier');
    Route::post('sales/simpancashier', 'SalesController@simpanCashier')->name('sales.simpancashier');
    Route::get('sales/{id}/editcashier', 'SalesController@editCashier')->name('sales.editcashier');
    Route::get('sales/{id}/simpaneditcashier', 'SalesController@simpaneditcashier')->name('sales.simpaneditcashier');
    Route::get('sales/lisdata', 'SalesController@listData')->name('sales.listdata');
    Route::get('sales/index_product', 'SalesController@index_product')->name('sales.index_product');
    Route::get('sales/productlist', 'SalesController@ProductList')->name('sales.productlist');
    Route::get('sales/index_stock', 'SalesController@index_stock')->name('sales.index_stock');
    Route::get('sales/stock', 'SalesController@stock')->name('sales.stock');
    Route::get('sales/index_penjualan', 'SalesController@index_penjualan')->name('sales.index_penjualan');
    Route::get('sales/datapenjualan', 'SalesController@datapenjualan')->name('sales.datapenjualan');
    Route::post('sales/newinvoice', 'SalesController@newInvoice')->name('sales.newinvoice');
    Route::get('sales/{id}/{idsl}/tampilproduct', 'SalesController@tampilProduct')->name('sales.tampilproduct');
    Route::get('sales/{id}/saledetail', 'SalesController@saleDetail')->name('sales.saledetail');
    Route::get('sales/{id}/cetakstruk', 'SalesController@cetakStruk')->name('kanvas.cetakstruk');
    Route::get('sales/index_biaya', 'SalesController@index_biaya')->name('sales.index_biaya');
    Route::get('sales/{id}/databiaya', 'SalesController@dataBiaya')->name('sales.databiaya');
    Route::post('sales/{id}/addbiaya', 'SalesController@addBiaya');
    Route::get('sales/{id}/loadinvoice', 'SalesController@loadInvoice')->name('sales.loadinvoice');
    Route::get('sales/{id}/loadsummary', 'SalesController@loadSummary')->name('sales.loadsummary');
    Route::post('sales/simpansale', 'SalesController@simpanSale')->name('sales.simpansale');
    Route::get('sales/{id}/potongan', 'SalesController@potongan')->name('sales.potongan');
    Route::get('sales/{id}/simpanpotongan', 'SalesController@simpanPotongan')->name('sales.simpanpotongan');
    Route::get('sales/{id}/{mode}/updqty', 'SalesController@updQty')->name('sales.updqty');
    Route::post('sales/{id}/closebill', 'SalesController@closeBill')->name('sales.closebill');
    Route::get('sales/{id}/cetakstruk', 'SalesController@cetakStruk')->name('sales.cetakstruk');
    Route::get('sales/{id}/cetaksementara', 'SalesController@cetakSementara')->name('sales.cetaksementara');
    Route::get('sales/testprinter', 'SalesController@testPrinter')->name('sales.testprinter');
    Route::get('sales/index_customer', 'SalesController@index_customer')->name('sales.index_customer');
    Route::get('sales/mastercustomer', 'SalesController@masterCustomer')->name('sales.mastercustomer');
    Route::get('sales/tescetak', 'SalesController@tescetak')->name('sales.tescetak');
    Route::get('sales/index_reprint', 'SalesController@index_reprint')->name('sales.index_reprint');
    Route::get('sales/reprintstruk', 'SalesController@reprintstruk')->name('sales.reprintstruk');
    Route::get('sales/test_scanner', 'SalesController@testScanner')->name('sales.test_scanner');
    Route::get('sales/datacategory', 'SalesController@dataCategory')->name('sales.datacategory');
    Route::get('sales/index_profile', 'SalesController@index_profile')->name('sales.index_profile');
    Route::get('sales/editprofile', 'SalesController@editProfile')->name('sales.editprofile');
    Route::get('sales/simpanprofile', 'SalesController@simpanProfile')->name('sales.simpanprofile');

    Route::resource('sales', 'SalesController');
    

///product
    Route::get('product/data', 'ProductController@listData')->name('product.data');	//yg ini tidak bisa proses serverside
    Route::get('product/getdata', 'ProductController@getData')->name('product.getdata');
    Route::get('product/pilihdata', 'ProductController@pilihData')->name('product.pilihdata');   
    Route::get('product/{id}/lihat', 'ProductController@show');	
    Route::post('product/simpansatuan', 'ProductController@simpansatuan')->name('product.simpansatuan');
    
    Route::get('product/masukbarang', 'ProductController@masukBarang')->name('product.masukbarang');
    Route::get('product/barangin', 'ProductController@barangin')->name('product.barangin');    
    Route::post('product/createmasuk', 'ProductController@createmasuk')->name('product.createmasuk');
    Route::get('product/{id}/loadheader', 'ProductController@loadHeader')->name('product.loadheader');
    Route::get('product/{id}/datadetail', 'ProductController@dataDetail')->name('product.datadetail');
    Route::post('product/{id}/simpandetail', 'ProductController@simpanDetail')->name('product.simpandetail');
    Route::get('product/{id}/simpaneditdetail', 'ProductController@simpanEditDetail')->name('product.simpaneditdetail');
    Route::get('product/{id}/editdetail', 'ProductController@editDetail')->name('product.editdetail');
    Route::get('product/{id}/cetakdokumen', 'ProductController@cetakDokumen')->name('product.cetakdokumen');
    Route::get('product/{id}/postingstock', 'ProductController@postingStock')->name('product.postingstock');
    Route::get('product/index_stock', 'ProductController@index_stock')->name('product.index_stock');
    Route::get('product/datastock', 'ProductController@dataStock')->name('product.datastock');    
    Route::resource('product', 'ProductController');

    Route::get('stock/getdata1', 'StockController@getData1')->name('stock.getdata1');
    Route::get('stock/getdata0', 'StockController@getData0')->name('stock.getdata0');   
    Route::get('stock/listdata', 'StockController@listData')->name('stock.data');   
    Route::get('stock/{id}/detail1', 'StockController@detail1')->name('stock.detail1');
    Route::get('stock/{id}/detail2', 'StockController@detail2')->name('stock.detail2');
    Route::get('stock/{id}/detail3', 'StockController@detail3')->name('stock.detail3');
    Route::get('stock/{id}/detail4', 'StockController@detail4')->name('stock.detail4');
    Route::get('stock/{id}/detail5', 'StockController@detail5')->name('stock.detail5');
    Route::get('stock/{id}/detail6', 'StockController@detail6')->name('stock.detail6');
    Route::get('stock/{id}/detail7', 'StockController@detail7')->name('stock.detail7');   
    Route::get('stock/{id}/lihat', 'StockController@show');
    Route::get('stock/change_sts', 'StockController@change_sts')->name('stock.change_sts');
    Route::get('stock/getdata_1', 'StockController@getData_1')->name('stock.getdata_1');
    Route::get('stock/getdata_0', 'StockController@getData_0')->name('stock.getdata_0');      
    Route::get('stock/{id}/change_0', 'StockController@change_0')->name('stock.change_0');
    Route::get('stock/{id}/change_1', 'StockController@change_1')->name('stock.change_1');
    Route::resource('stock', 'StockController');

    Route::get('pilihproduct/index', 'PilihproductController@index')->name('pilihproduct.index');
    Route::get('pilihproduct/action', 'PilihproductController@action')->name('pilihproduct.action'); 
    Route::resource('pilihproduct', 'PilihproductController');

//dropdown
    Route::get('dropdown/merkAjax/{id}', 'DropdownController@merkAjax')->name('dropdown.getdata');
    Route::resource('dropdown', 'DropdownController');   

//message
    Route::get('message/index', 'MessageController@index')->name('message.index');
    Route::get('message/{id}/lihat', 'MessageController@lihat')->name('message.lihat');
    Route::get('message/getmessage', 'MessageController@getMessage')->name('message.getMessage');
    Route::get('message/warning', 'MessageController@warning')->name('message.warning');
    Route::resource('message', 'MessageController');
   
//invoice
    Route::get('invoice/index', 'InvoiceController@index_a')->name('invoice.index');
    Route::get('invoice/history', 'InvoiceController@history')->name('invoice.history');
    Route::get('invoice/getdata', 'InvoiceController@getData')->name('invoice.getdata');
    Route::get('invoice/getheader', 'InvoiceController@getheader')->name('invoice.header');
    Route::get('invoice/history_header', 'InvoiceController@history_header')->name('invoice.history_header');
    Route::get('invoice/{id}/input',  'InvoiceController@input')->name('invoice.input');  
    Route::get('invoice/{id}/tampil', 'InvoiceController@tampil')->name('invoice.tampil');
    Route::get('invoice/create', 'InvoiceController@create')->name('invoice.create');
    Route::get('invoice/pilihdata', 'InvoiceController@pilihData')->name('invoice.pilihdata');  
    Route::get('invoice/{id}/lihat', 'InvoiceController@show');
    Route::get('invoice/{id}/update', 'InvoiceController@update');	//->name('purchase.update');
    Route::get('invoice/{id}/reprint', 'InvoiceController@reprint');
    Route::get('invoice/detail', 'InvoiceController@detail'); 
    Route::get('invoice/{id}/tambah', 'InvoiceController@tambah');
    Route::get('invoice/{id}/edit', 'InvoiceController@edit');
    Route::get('invoice/{id}/batal', 'InvoiceController@batal');
    Route::get('invoice/{id}/simpanedit', 'InvoiceController@simpanEdit')->name('invoice.simpanedit');
    Route::resource('invoice', 'InvoiceController');

// invoice detail
    Route::get('invoicedetail/{id}/input', 'InvoiceDetailController@input')->name('invoicedetail.input');
    Route::get('invoicedetail/{id}/tampil', 'InvoiceDetailController@tampil')->name('invoicedetail.tampil');
    Route::get('invoicedetail/data', 'InvoiceDetailController@listdata')->name('invoicedetail.data');
    Route::get('invoicedetail/data2', 'InvoiceDetailController@listdata2')->name('invoicedetail.data2');
    Route::get('invoicedetail/loadsummary', 'InvoiceDetailController@loadsummary')->name('invoicedetail.loadsummary');
    Route::get('invoicedetail/{id}/update', 'InvoiceDetailController@update')->name('invoicedetail.update');
    Route::get('invoicedetail/{id}/lihat', 'InvoiceDetailController@show')->name('invoicedetail.lihat');
    Route::post('invoicedetail/store', 'InvoiceDetailController@store')->name('invoicedetail.store');
    Route::get('invoicedetail/{id}/caribrg', 'InvoiceDetailController@caribrg');
    Route::get('invoicedetail/printForm', 'InvoiceDetailController@printForm')->name('invoicedetail.cetak');
    Route::get('invoicedetail/reprintForm', 'InvoiceDetailController@reprintForm')->name('invoicedetail.reprint');
    Route::resource('invoicedetail', 'InvoiceDetailController');

// stock opname
    Route::get('stockopname/index', 'StockOpnameController@index')->name('stockopname.index');
    Route::get('stockopname/history', 'StockOpnameController@history')->name('stockopname.history');
    Route::get('stockopname/getdata', 'StockOpnameController@getData')->name('StockOpname.getdata');
    Route::get('stockopname/getheader', 'StockOpnameController@getheader')->name('stockopname.header');
    Route::get('stockopname/history_header', 'StockOpnameController@history_header')->name('stockopname.history_header');
    Route::get('stockopname/{id}/input',  'StockOpnameController@input')->name('stockopname.input');
    Route::get('stockopname/{id}/display',  'StockOpnameController@display')->name('stockopname.display');  
    Route::get('stockopname/{id}/tampil', 'StockOpnameController@tampil')->name('stockopname.tampil');
    Route::get('stockopname/create', 'StockOpnameController@create')->name('stockopname.create');
    Route::get('stockopname/pilihdata', 'StockOpnameController@pilihData')->name('stockopname.pilihdata');  
    Route::get('stockopname/{id}/lihat', 'StockOpnameController@show');
    Route::get('stockopname/{id}/update', 'StockOpnameController@update');	//->name('purchase.update');
    Route::get('stockopname/{id}/reprint', 'StockOpnameController@reprint');
    Route::get('stockopname/detail', 'StockOpnameController@detail'); 
    Route::get('stockopname/{id}/tambah', 'StockOpnameController@tambah');
    Route::get('stockopname/{id}/posting', 'StockOpnameController@posting');
    Route::get('stockopname/printform', 'StockOpnameController@printform')->name('stockopname.printform');
    Route::get('stockopname/printpdf', 'StockOpnameController@printpdf');
   
    Route::resource('stockopname', 'StockOpnameController');

// opname detail
    Route::get('stockopnamedetail/{id}/input', 'StockOpnameDetailController@input')->name('stockopnamedetail.input');
    Route::get('stockopnamedetail/{id}/tampil', 'StockOpnameDetailController@tampil')->name('stockopnamedetail.tampil');
    Route::get('stockopnamedetail/data', 'StockOpnameDetailController@listdata')->name('stockopnamedetail.data');
    Route::get('stockopnamedetail/data_history', 'StockOpnameDetailController@listdata_history')->name('stockopnamedetail.data_history');
    Route::get('stockopnamedetail/data2', 'StockOpnameDetailController@listdata2')->name('stockopnamedetail.data2');
    Route::get('stockopnamedetail/{id}/getdata1', 'StockOpnameDetailController@getdata1')->name('stockopnamedetail.getdata1');
    Route::get('stockopnamedetail/{id}/getdata0', 'StockOpnameDetailController@getdata0')->name('stockopnamedetail.getdata0');
    Route::get('stockopnamedetail/loadsummary', 'StockOpnameDetailController@loadsummary')->name('stockopnamedetail.loadsummary');
    Route::get('stockopnamedetail/loadform/{dis}/{ppn}/{total}', 'StockOpnameDetailController@loadForm');
    Route::get('stockopnamedetail/{id}/update', 'StockOpnameDetailController@update')->name('stockopnamedetail.update');
    Route::get('stockopnamedetail/{id}/lihat', 'StockOpnameDetailController@show')->name('stockopnamedetail.lihat');
    Route::post('stockopnamedetail/store', 'StockOpnameDetailController@store')->name('stockopnamedetail.store');
    Route::post('stockopnamedetail/simpan', 'StockOpnameDetailController@simpan')->name('stockopnamedetail.simpan');
    Route::get('stockopnamedetail/{id}/caribrg', 'StockOpnameDetailController@caribrg');
    Route::get('stockopnamedetail/{id}/printForm', 'StockOpnameDetailController@printForm');
    Route::get('stockopnamedetail/reprintForm', 'StockOpnameDetailController@reprintForm')->name('stockopnamedetail.reprint');
    Route::resource('stockopnamedetail', 'StockOpnameDetailController');

//transfer
    Route::get('transfer/index', 'TransferController@index_a')->name('transfer.index');
    Route::get('transfer/history', 'TransferController@history')->name('transfer.history');
    Route::get('transfer/getdata', 'TransferController@getData')->name('transfer.getdata');
    Route::get('transfer/getheader', 'TransferController@getheader')->name('transfer.header');
    Route::get('transfer/history_header', 'TransferController@history_header')->name('transfer.history_header');
    Route::get('transfer/{id}/input',  'TransferController@input')->name('transfer.input');  
    Route::get('transfer/{id}/detail_history', 'TransferController@detail_history')->name('transfer.detail_history');
    Route::get('transfer/{id}/tampil', 'TransferController@tampil')->name('transfer.tampil');
    Route::get('transfer/create', 'TransferController@create')->name('transfer.create');
    Route::get('transfer/pilihdata', 'TransferController@pilihData')->name('transfer.pilihdata');  
    Route::get('transfer/{id}/lihat', 'TransferController@show');
    Route::get('transfer/{id}/update', 'TransferController@update');	
    Route::get('transfer/{id}/printform', 'TransferController@printform')->name('transfer.cetak');
    Route::get('transfer/detail', 'TransferController@detail'); 
    Route::get('transfer/{id}/tambah', 'TransferController@tambah');
    Route::get('transfer/index_terima', 'TransferController@index_terima')->name('transfer.index_terima');
    Route::get('transfer/dataterima', 'TransferController@dataterima')->name('transfer.dataterima');
    Route::get('transfer/{id}/terima', 'TransferController@terima')->name('transfer.terima');
    Route::get('transfer/{id}/updatestock', 'TransferController@updatestock')->name('transfer.updatestock');
    Route::resource('transfer', 'TransferController');

//transfer detail
    Route::get('transferdetail/{id}/input', 'TransferDetailController@input')->name('transferdetail.input');
    Route::get('transferdetail/{id}/tampil', 'TransferDetailController@tampil')->name('transferdetail.tampil');
    Route::get('transferdetail/data', 'TransferDetailController@listdata')->name('transferdetail.data');
    Route::get('transferdetail/data2', 'TransferDetailController@listdata2')->name('transferdetail.data2');
    Route::get('transferdetail/{id}/update', 'TransferDetailController@update')->name('transferdetail.update');
    Route::get('transferdetail/{id}/lihat', 'TransferDetailController@show')->name('transferdetail.lihat');
    Route::post('transferdetail/store', 'TransferDetailController@store')->name('transferdetail.store');
    Route::get('transferdetail/{id}/caribrg', 'TransferDetailController@caribrg');
    Route::get('transferdetail/cetak', 'TransferDetailController@cetak')->name('transferdetail.cetak');
    Route::get('transferdetail/reprintForm', 'TransferDetailController@reprintForm')->name('transferdetail.reprint');
    Route::get('transferdetail/historydata', 'TransferDetailController@historyData')->name('transferdetail.historydata');
    Route::resource('transferdetail', 'TransferDetailController');

//penjualan
    Route::get('penjualan/index', 'PenjualanController@index_a')->name('penjualan.index');
    Route::get('penjualan/history', 'PenjualanController@history')->name('penjualan.history');
    Route::get('penjualan/getdata', 'PenjualanController@getData')->name('penjualan.getdata');
    Route::get('penjualan/getheader', 'PenjualanController@getheader')->name('penjualan.header');
    Route::get('penjualan/{tgl1}/{tgl2}/history_header', 'PenjualanController@history_header')->name('penjualan.history_header');
    Route::get('penjualan/{id}/history_detail', 'PenjualanController@history_detail')->name('penjualan.history_detail');
    Route::get('penjualan/{id}/edit', 'PenjualanController@edit')->name('penjualan.edit');
    Route::get('penjualan/{id}/pelunasan', 'PenjualanController@pelunasan')->name('penjulana.pelunasan');
    Route::get('penjualan/{id}/printdo', 'PenjualanController@printdo')->name('penjualan.printdo');
    Route::get('penjualan/{id}/input',  'PenjualanController@input')->name('penjualan.input');  
    Route::get('penjualan/{id}/tampil', 'PenjualanController@tampil')->name('penjualan.tampil');
    Route::get('penjualan/create', 'PenjualanController@create')->name('penjualan.create');
    Route::get('penjualan/pilihdata', 'PenjualanController@pilihData')->name('penjualan.pilihdata');  
    Route::get('penjualan/{id}/lihat', 'PenjualanController@show');
    Route::get('penjualan/{id}/update', 'PenjualanController@update');	
    Route::get('penjualan/{id}/batal', 'PenjualanController@batal')->name('penjualan.batal');
    Route::get('penjualan/{id}/posting', 'PenjualanController@posting');
    Route::get('penjualan/{id}/printform', 'PenjualanController@printform')->name('penjualan.cetak');
    Route::get('penjualan/detail', 'PenjualanController@detail'); 
    Route::get('penjualan/{id}/tambah', 'PenjualanController@tambah');
    Route::get('penjualan/{tgrute}/{id_rute}/cekrute', 'PenjualanController@cekrute')->name('penjualan.cekrute');
    Route::get('penjualan/{id}/updatestock', 'PenjualanController@updatestock')->name('penjualan.updatestock');
    Route::get('penjualan/tampilsatuan', 'PenjualanController@tampilsatuan')->name('penjualan.tampilsatuan');
    Route::get('penjualan/tampilkemasan', 'PenjualanController@tampilkemasan')->name('penjualan.tampilkemasan');    

//tagihan    
    Route::get('penjualan/tagihan', 'PenjualanController@tagihan')->name('penjualan.tagihan');
    Route::get('penjualan/tagihan_hdr', 'PenjualanController@tagihan_hdr')->name('penjualan.tagihan_hdr');
    Route::get('penjualan/{rute}/simpantagih', 'PenjualanController@simpantagih')->name('penjualan.simpantagih');
    Route::post('penjualan/{bill}/simpantagih_add', 'PenjualanController@simpantagih_add')->name('penjualan.simpantagih_add');
    Route::get('penjualan/history_tagihan', 'PenjualanController@history_tagihan')->name('penjualan.history_tagihan');
    Route::post('penjualan/printbill', 'PenjualanController@printbill')->name('penjualan.printbill');
    Route::post('penjualan/printpdf/{ukur}/{rute}', 'PenjualanController@printpdf')->name('penjualan.printpdf');
    Route::post('penjualan/{bill}/reprint', 'PenjualanController@reprint')->name('penjualan.reprint');
    Route::get('penjualan/pdf', 'PenjualanController@exportPDF');
    Route::get('penjualan/cetakbill', 'PenjualanController@cetakbill')->name('penjualan.cetkabill');
    Route::get('penjualan/{tgl1}/{tgl2}/tagihan_hist', 'PenjualanController@tagihan_hist')->name('penjualan.tagihan_hist');
    Route::get('penjualan/{id}/histtagihan_detail', 'PenjualanController@histtagihan_detail')->name('penjualan.histtagihan_detail');
    Route::get('penjualan/{id}/tagihan_add', 'PenjualanController@tagihan_add')->name('penjualan.tagihan_add');
    Route::get('penjualan/{id}/delhistory', 'PenjualanController@delhistory')->name('penjualan.delhistory');
    Route::get('penjualan/index_unpost', 'PenjualanController@index_unpost')->name('penjualan.index_unpost');
    Route::get('penjualan/data_unpost', 'PenjualanController@data_unpost')->name('penjualan.data_unpost');
    Route::get('penjualan/{id}/unposting', 'PenjualanController@unposting')->name('penjualan.unposting');
    Route::resource('penjualan', 'PenjualanController');

//penjualan detail
    Route::get('penjualandetail/{id}/input', 'PenjualanDetailController@input')->name('penjualandetail.input');
    Route::get('penjualandetail/{id}/tampil', 'PenjualanDetailController@tampil')->name('penjualandetail.tampil');
    Route::get('penjualandetail/data', 'PenjualanDetailController@listdata')->name('penjualandetail.data');
    Route::get('penjualandetail/data2', 'PenjualanDetailController@listdata2')->name('penjualandetail.data2');
    Route::post('penjualandetail/simpan', 'PenjualanDetailController@simpan')->name('penjualandetail.simpan');
    Route::get('penjualandetail/loadsummary', 'PenjualanDetailController@loadsummary')->name('penjualandetail.loadsummary');
    Route::get('penjualandetail/{id}/update', 'PenjualanDetailController@update')->name('penjualandetail.update');
    Route::get('penjualandetail/{id}/lihat', 'PenjualanDetailController@show')->name('penjualandetail.lihat');
    Route::post('penjualandetail/store', 'PenjualanDetailController@store')->name('penjualandetail.store');
    Route::get('penjualandetail/{id}/caribrg', 'PenjualanDetailController@caribrg');
    Route::get('penjualandetail/{id}/cetak', 'PenjualanDetailController@cetak')->name('penjualandetail.cetak');
    Route::get('penjualandetail/reprintForm', 'PenjualanDetailController@reprintForm')->name('penjualandetail.reprint');
    Route::get('penjualandetail/historydata', 'PenjualanDetailController@historyData')->name('penjualandetail.historydata');
    Route::resource('penjualandetail', 'PenjualanDetailController');

//piutang
    Route::get('piutang/getheader', 'PiutangController@getheader')->name('piutang.header');
    ROute::get('piutang/history', 'PiutangController@history')->name('piutang.history');
    Route::get('piutang/{tgl1}/{tgl2}/history_header', 'PiutangController@history_header')->name('piutang.history_header');
    Route::get('piutang/hist_header', 'PiutangController@hist_header')->name('piutang.hist_header');
    Route::get('piutang/{id}/input', 'PiutangController@input')->name('piutang.input');
    Route::get('piutang/data', 'PiutangController@listdata')->name('piutang.data');
    Route::post('piutang/simpan', 'PiutangController@simpan')->name('piutang.simpan');
    Route::get('piutang/loadsummary', 'PiutangController@loadsummary');
    Route::get('piutang/{id}/edit', 'PiutangController@edit');
    Route::get('piutang/{id}/posting', 'PiutangController@posting');
    Route::get('piutang/index_cicil', 'PiutangController@index_cicil')->name('piutang.index_cicil');
    Route::get('piutang/getcicil', 'PiutangController@getCicil')->name('piutang.getcicil');
    Route::get('piutang/{id}/cicil', 'PiutangController@cicil')->name('piutang.cicil');
    Route::get('piutang/{id}/simpancicil', 'PiutangController@simpancicil')->name('piutang.simpancicil');
    Route::get('piutang/{id}/batal', 'PiutangController@batal')->name('piutang.batal');
    Route::get('piutang/{id}/detail', 'PiutangController@detail');
    Route::get('piutang/{id}/ubahstatus', 'PiutangController@ubahStatus')->name('piutang.ubahstatus');
    Route::resource('piutang', 'PiutangController');


//-----------------------------------------------------------------------------------//
//   Route::get('user/data', 'UserController@listData')->name('user.data');
//   Route::get('user/index_logs', 'UserController@index_logs')->name('user.index_logs');
//   Route::get('user/getlogs', 'UserController@getlogs')->name('user.getlogs');
//   Route::resource('user', 'UserController');

    Route::get('pembelian/data', 'PembelianController@listData')->name('pembelian.data');
    Route::get('pembelian/{id}/tambah', 'PembelianController@create');
    Route::get('pembelian/{id}/lihat', 'PembelianController@show');
    Route::resource('pembelian', 'PembelianController');   

    Route::get('pembelian_detail/{id}/data', 'PembelianDetailController@listData')->name('pembelian_detail.data');
    Route::get('pembelian_detail/loadform/{diskon}/{total}', 'PembelianDetailController@loadForm');
    Route::resource('pembelian_detail', 'PembelianDetailController');   

    Route::get('report/index_sale', 'ReportController@index_sale')->name('report.index_sale');
    Route::get('report/index_saledetail', 'ReportController@index_saledetail')->name('report.index_saledetail');
    Route::get('report/index_lunas', 'ReportController@index_lunas')->name('report.index_lunas');
    Route::get('report/index_beli', 'ReportController@index_beli')->name('report.index_beli');
    Route::get('report/{tgl1}/{tgl2}/getdata', 'ReportController@getData')->name('report.getdata');
    Route::get('report/pdf/{awal}/{akhir}', 'ReportController@exportPDF');     
    Route::get('report/{tgl1}/{tgl2}/pelunasan', 'ReportController@pelunasan')->name('report.pelunasan');
    Route::get('report/pelunasanpdf/{tgl1}/{tgl2}', 'ReportController@pelunasanpdf')->name('report.pelunasanpdf');
    Route::get('report/{tgl1}/{tgl2}/pembelian', 'ReportController@pembelian')->name('report.pembelian');  
    Route::get('report/pembelianpdf/{tgl1}/{tgl2}', 'ReportController@pembelianpdf')->name('report.pembelianpdf');
    Route::get('report/detail/{awal}/{akhir}/{cash}/{credit}', 'ReportController@reportDetail')->name('report.reportdetail');
    Route::get('report/excell/{awal}/{akhir}/{cash}/{credit}', 'ReportController@reportExcell')->name('report.reportexcell');
    Route::resource('report', 'ReportController');    

    Route::get('laporan', 'LaporanController@index')->name('laporan.index');
    Route::post('laporan', 'LaporanController@refresh')->name('laporan.refresh');
    Route::get('laporan/data/{awal}/{akhir}', 'LaporanController@listData')->name('laporan.data'); 
    Route::get('laporan/pdf/{awal}/{akhir}', 'LaporanController@exportPDF');

    Route::get('setor/getheader', 'SetorController@getheader')->name('setor.header');
    Route::get('setor/index_detail', 'SetorController@index_detail')->name('setor.index_detail');
    Route::get('setor/{id}/input', 'SetorController@input');
    Route::get('setor/{id}/update', 'SetorController@update');
    Route::get('setor/{id}/lihat', 'SetorController@show');
    Route::get('setor/{id}/edit', 'SetorController@edit')->name('setor.edit');
    Route::get('setor/{id}/cetak', 'SetorController@printform')->name('setor.cetak');
    Route::get('setor/{id}/posting', 'SetorController@posting');
    Route::get('setor/{id}/slip', 'SetorController@slip');
    Route::get('setor/{id}/removeimage', 'SetorController@removeimage');
    Route::get('setor/{id}/batal', 'SetorController@batal')->name('setor.batal');
    Route::resource('setor', 'SetorController');

    Route::get('setordetail/tampildetail', 'SetorDetailController@tampildetail')->name('setordetail.detail');
    Route::post('setordetail/simpandetail', 'SetorDetailController@simpandetail')->name('setordetail.simpandetail');
    Route::get('setordetail/loadsummary', 'SetorDetailController@loadsummary')->name('setordetail.loadsummary');
    Route::resource('setordetail', 'SetorDetailController');

	Route::get('print/redeemlist','PrintController@index')->name('print.index');
	Route::get('printlist/prnpriview','PrintController@prnpriview');
	Route::resource('printlist', 'PrintController');

 	//Route::get('livesearch/index', 'LivesearchController@index')->name('livesearch.index'); 
	Route::get('livesearch/action', 'LivesearchController@action')->name('livesearch.action');
	Route::resource('livesearch', 'LivesearchController');
 
    Route::resource('setting', 'SettingController');
    
    
    Route::get('export/tes_excel', 'ExportController@tes_excel')->name('export.tes_excel');
    
    Route::get('notification/sendmessage', 'NotificationController@sendMessage')->name('notification.sendmessage');
    
    
});

Route::group(['middleware' => ['web', 'cekgroup:MANAGER' ]], function(){
    
    Route::get('user/data', 'UserController@listData')->name('user.data');
    Route::get('user/{id}/delete', 'UserController@delete')->name('user.delete');
    Route::get('user/index_logs', 'UserController@index_logs')->name('user.index_logs');
    Route::get('user/{tgl1}/{tgl2}/getlogs', 'UserController@getlogs')->name('user.getlogs');
    Route::get('user/{tgl1}/{tgl2}/activity', 'UserController@getactivity')->name('user.activity');
    Route::resource('user', 'UserController');    
});

