
@extends('layouts.app')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style>
        .tblheader {
 			background: #2F4F4F;
			color: white;
			font-size: 15px;
			alignment: center;
        }
    </style>
</head>

@section('title')
  User Activity
@endsection

@section('breadcrumb')
   @parent
   <li>user activity</li>
@endsection

@section('content')     
<div class="row">
  <div class="col-xs-12">
      <div class="box">
       <div class="box-body">  
       
		<label for="prd" class="col-md-1 control-label">Periode</label>
		<div class="col-md-3">
			<input id="awal" type="date" class="form-control" name="awal" value="{{ date('Y-m-d', strtotime("-35 day", strtotime(date('Y-m-d')))) }}" autofocus required>
		</div>
		<div class="col-md-3">
			<input id="akhir" type="date" class="form-control" name="akhir" value="{{ date('Y-m-d') }}" autofocus required>
		</div>

		<div class="col-md-4"> 
			<button type="button" class="btn btn-primary btn-sm" onclick="showHistory()"><i class="fa fa-table"></i> View </button>
		</div>       

        <table class="table table-striped table-padding table-bordered" id="tbl-logs" style="background: #DCDCDC;" width="100%">
            <thead>
               <tr class="tblheader">
                  <th width="15%">Time</th>
                  <th width="15%">Nama User</th>
                  <th width="25%">Title</th>
                  <th width="45%">Activity</th>
               </tr>
            </thead>
            <tbody></tbody>
        </table>

      </div>
    </div>
  </div>
</div>

@endsection

@section('script')

<script type="text/javascript">
var table;

showHistory();

function showHistory()
{
    var tgl1=$('#awal').val();
    var tgl2=$('#akhir').val();
    
    $(document).ready(function(){
        $('#tbl-logs').DataTable({
         "processing" : true,
         "destroy": true,
         "dom": "bftip",
         "ajax" : {
                "url" : "{{ DIR_APP }}user/"+tgl1+"/"+tgl2+"/activity",
                "type" : "GET"
            }
       }); 
    });  
}


</script>
@endsection