@extends('layouts.app')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style>
		.tblheader {
			background: #2F4F4F;
			color: white;
			font-size: 15px;
			alignment: center;
		}
	</style>
</head>

@section('title')
  Master Supplier
    <a onclick="addForm()" class="btn btn-success"><i class="fa fa-plus-circle"></i> New Supplier</a>
		
@endsection

@section('breadcrumb')
   @parent
   <li>supplier</li>
@endsection

@section('content')     
<div class="row">
  <div class="col-xs-12">
    <div class="box">
 
      <div class="box-body">  

<table class="table table-striped table-padding table-bordered" id="tbl-supplier"  width="100%">
<thead>
   <tr class="tblheader">
      <th width="40">KODE</th>
      <th>Nama Supplier</th>
      <th>Alamat</th>
      <th>Telpon</th>
      <th width="50">Opsi</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>

@include('supplier.form')
@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('supplier.data') }}",
       "type" : "GET"
     }
   }); 
   
   $('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 $('#submit-control').html(' data sedang disimpan ... ');
		 $('#submit-control').attr('disabled','disabled');		  
		 
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('supplier.store') }}";
         else url = "supplier/"+id;
         
         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           success : function(data){
             $('#modal-form').modal('hide');
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');
             table.ajax.reload();
           },
           error : function(){
             alert("Tidak dapat menyimpan data!");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
     }
   });
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('New Supplier');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "supplier/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Supplier');
       
       $('#id').val(data.id_supp);
	   $('#kode').val(data.sup_id);
       $('#nama').val(data.sup_nama);
       $('#alamat').val(data.sup_alamat);
       $('#telpon').val(data.sup_telp);
	   $('#kota').val(data.sup_kota);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function deleteData(id){
   if(confirm("Apakah yakin data akan dihapus?")){
     $.ajax({
       url : "supplier/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload();
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}
</script>
@endsection