<!-- page menampilkan form detail input opname -->

@extends('layouts.app')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   

	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>	


</head>


@section('title')
 <table>

 	<tr><td width="120"><b>Tgl. Opname</b></td><td><b>{{ tanggal_indonesia($m_opn->opn_tgl, false) }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>stock opname</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-produk" method="post" id="form-produk">
{{ csrf_field() }}
  
  <input type="hidden" id="idtrx" name="idtrx" value="{{ $idopn }}">
  
		<button id="submit-control" type="submit" class="btn btn-success pull-right simpan"><i class="fa fa-floppy-o"> </i> Posting </button>
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 

<div class="form-group">
    <div class="col-sm-3">
        <div class="input-group">
          <input id="kode" type="hidden" class="form-control" name="kode" autofocus required readonly="true">
          <span class="input-group-btn">
            <button onclick="showProduct()" type="button" class="btn btn-info">Barang Satuan</button>
          </span>

          <input id="kode2" type="hidden" class="form-control" name="kode2" autofocus required readonly="true">
          <span class="input-group-btn">
            <button onclick="showProduct2()" type="button" class="btn btn-success">Barang Kemasan</button>
          </span>

        </div>
    </div>
</div>

</form>


<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<!--
<div class="row">
    
<!-- <div style="height:400px; overflow-y: scroll;">  -->

<table class="table table-fixed table-striped table-bordered tabel-opndetail" id="opndetail">

<thead>
              
   <tr class="tblheader">
      <th width="20">No</th>
      <th>Deskripsi</th>
      <th>TYPE</th>
      <th>QTY</th>
	  <th>ISI</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

<!-- </div> -->

    <div class="col-md-8" align="right">
    	<label>Total QTY &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    </div>
    <div class="col-md-3">
    	<div id="total-qty"	style="background: DarkSlateGray; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    </div> 
    
</form>


<div class="box-footer">
<!--    
    <div class="col-md-8" align="right">
    	<label>Total QTY &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    </div>
    <div class="col-md-3">
    	<div id="total-qty"	style="background: DarkSlateGray; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    </div>          
-->    
	<div class="col-md-3">
		<form class="form form-horizontal form-rekaptrx" method="GET" action="/wawan/stockopname/{{ $idopn }}/posting">
			{{ csrf_field() }}
			<input type="hidden" name="idtrx" value="{{ $idopn }}">
		</form>
	</div>          

</div>

            </div>
        </div>
    </div>
</div>

@include('stockopname_detail.produk')
@include('stockopname_detail.produk2')
@include('stockopname_detail.form')

@endsection

@section('script')

<!------------------------------------------------- javascript -------------------------------->

<script type="text/javascript">
var table, table1, save_method;
var id_trx=$('#idtrx').val();

$(function(){
  //$('.tabel-produk').DataTable();
  $('.tabel-produk2').DataTable();
  	
	tblsatuan = $('.tabel-satuan').DataTable({
        "scrollY": '50vh',
        "scrollCollapse": true,
        "bSort": true,
		"destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
	
	tblkemasan = $('.tabel-kemasan').DataTable({
        "scrollY": '50vh',
        "scrollCollapse": true,
        "bSort": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });

	
  table = $('.tabel-opndetail').DataTable({
     "scrollY": '47vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bti',
     "ajax" : {
     "url" : "{{ route('stockopnamedetail.data') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
   loadSummary();
 });



   $('.form-produk').on('submit', function(e){
      return false;
   });

   $('#kode').change(function(){
      addItem();
   });
   
    $('#kode2').change(function(){
      addItem2();
   });

});


	
/* simpan edit detail */
$('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 
         var id  = $('#id').val();
		 url = "/wawan/stockopnamedetail/"+id+"/update";
         $.ajax({
           url : url,
           type : "GET",
           data : $('#modal-form form').serialize(),
           success : function(data){
             $('#modal-form').modal('hide');
             table.ajax.reload();
           },
           error : function(){
			 return false;
          }   
        });
        return false;
    }
    
}); 

///////////////////////////////////////

/* posting */

$('.simpan').click(function(){
    document.querySelector('#form-produk').addEventListener('submit', function(e) {       
    var form = this;

    e.preventDefault(); // -- prevent form from submitting

    swal({
        title: "Anda Yakin ingin memposting Opname ?",
        text: "Data Opname akan diposting ke Stock & tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Posting'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
                }).then(function() {
            $('.form-rekaptrx').submit(); // -- submit form programmatically
        });
        } else {
            swal("Batal", "Opname masih bisa diedit :)", "error");
        }
        })
    });    
});


/*---------------------------------------------------------------*/
function addItem(){

  $.ajax({
    url : "{{ route('stockopnamedetail.store') }}",
    type : "POST",
	dataType: "JSON",
    data : $('.form-produk').serialize(),
    success : function(data)
		{
			if(data.msg=="error")
				{
				 swal("WARNING", " KODE ini sudah ada  !","error");
					$('#kode').val('').focus();
				}else{
					$('#kode').val('').focus();
					table.ajax.reload(function() { loadSummary(); }) ;         
				}
		},
			error : function(){
			swal("DANGER", " Detail Opname Gagal disimpan, HUB. IT !","error");
			}
			});
         return false;

}

/*---------------------------------------------------------------*/
function addItem2(){

  $.ajax({
    url : "{{ route('stockopnamedetail.simpan') }}",
    type : "POST",
	dataType: "JSON",
    data : $('.form-produk').serialize(),
    success : function(data)
		{
			if(data.msg=="error")
				{
				 swal("WARNING", " Data ini sudah diinput !","error");
					$('#kode2').val('').focus();
				}else{
					$('#kode2').val('').focus();
					table.ajax.reload(function(){loadSummary(); }) ;         
				}
		},
			error : function(){
		//alert(" Tidak dapat menyimpan data ! ");
			swal("DANGER", " Detail Opname Gagal disimpan, HUB. IT !","error");
			}
			});
         return false;

}
/*-------------------------------------------------------------*/
function selectItem(kode){
	$('#kode').val(kode);
	$('#modal-produk').modal('hide');
	addItem();
}

function selectItem2(kode2){
	$('#kode2').val(kode2);
	$('#modal-produk2').modal('hide');
	addItem2();
}


/* tampilkan form produk barang satuan */
function showProduct(){
	
	$('#modal-produk').modal('show');

    tblsatuan.ajax.url("/wawan/stockopnamedetail/"+id_trx+"/getdata1");
	tblsatuan.ajax.reload();
}  


/* tampilkan form produk barang kemasan */
function showProduct2(){
	
	$('#modal-produk2').modal('show');
  
    tblkemasan.ajax.url("/wawan/stockopnamedetail/"+id_trx+"/getdata0");
	tblkemasan.ajax.reload();  
}


function editForm(id){
	
	   save_method = "edit";
	   $('input[name=_method]').val('PATCH');
	   $('#modal-form form')[0].reset();
	   $.ajax({
		 url : "/wawan/stockopnamedetail/"+id+"/edit",
		 type : "GET",
		 dataType : "JSON",
		 success : function(data){
		   $('#modal-form').modal('show');
		   $('.modal-title').text('Edit Detail Opname');
		   
		   $('#id').val(data.id_opn);
		   $('#nama').val(data.nama_brg);	   
		   $('#isi').val(data.opn_tns);
		   $('#qty').val(data.opn_qty);       
		 
		 },
		 error : function(){
		   alert("Tidak dapat menampilkan data Opname !");
		 }
	   });
}

function inputForm(id){
   save_method = "add";
   $('input[name=_method]').val('PATCH');
   $('#modal-form_input form')[0].reset();

   $.ajax({
     url : "/sbo/transferdetail/"+id+"/caribrg",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_input').modal('show');
       $('.modal-title').text('Input Detail Transfer');
       
       $('#idbrg').val(data.id);
	   $('#kdbrg_').val(data.kode_brg);
       $('#nama_').val(data.nama_brg);	   
       $('#gross_').val(data.harga_list);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

/* modul delete */
function deleteItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/wawan/stockopnamedetail/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload(function(){
			loadSummary();
          }); 
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

/* mreferesh perubahan total sale */

function loadSummary(){
	
  $.ajax({
	   url : "/wawan/stockopnamedetail/loadsummary",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#total-qty').text(data.totalqty);
			
       },
       error : function(){
         alert("Tidak dapat menampilkan data total Qty !");
		 return false;
       }
  });
}

function error_mess(){
	swal("WARNING"," Anda tidak punya Akses ! ","error");
}

</script>

@endsection