@extends('layouts.myform2')

@section('title')
	Pilih Master SKU Promotion &nbsp;&nbsp;&nbsp;{{ $toko->str_name }} &nbsp;&nbsp;
	<a onclick="window.history.back()" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	
	
@endsection

@section('breadcrumb')
   @parent
   <li>pilih produk promotion</li>
@endsection

<head>
    <title>Master SKU</title>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<script type="text/javascript" src="/mms/public/adminLTE/dist/css/sweetalert.min.js"></script>
	
</head>


@section('content')   
<div class="row">
  <div class="col-xs-13">
    <div class="box">
      <div class="box-body">  


<form method="post" id="form-produk">
{{ csrf_field() }}

<table class="table table-striped table-bordered" id="produk">
<thead>
   <tr class="success">
      <th>SKU</th>
      <th>Description</th>
       <th>Aksi</th>
   </tr>
</thead>
<tbody></tbody>
</table>
</form>

    </div>
	</div>
	</div>
</div>	

@include('promotion.form_promo')

@endsection

@section('script')


<script type="text/javascript">
var save_method;
$(document).ready(function() {
	var table = $('#produk').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('promotion.pilihdata') }}",
        "columns":[
            { "data": "sku_kode","width": "35px"},
            { "data": "sku_name" },
				
			{
                "data": "id_price",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
                           return '<a onclick="addForm('+data+')" class="btn btn-success btn-sm"><i class="fa fa-plus"></i></a>'
                         }
            }
  			
        ]
     });
	 
//});
	 
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         url = "{{ route('promotion.store') }}";

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data, sudah terdaftar !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " Promotion baru berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");			 
           }   
         });
         return false;
	 }
   });
});


function addForm(id){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form form')[0].reset();
   $.ajax({
	 url : "/mms/promotion/"+id+"/tambah",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Add Promotion');
       
		$('#id').val(data.id_sku);
		$('#kode').val(data.sku_kode)
		$('#nama').val(data.sku_name).attr('readonly', true);
		$('#reg1').val(data.price_01);
		$('#reg2').val(data.price_02);
		$('#reg3').val(data.price_03);
		$('#reg4').val(data.price_04);	 
		$('#reg5').val(data.price_05);
		$('#reg6').val(data.price_06);
		$('#reg7').val(data.price_07);
		$('#reg8').val(data.price_08);		
		$('#reg9').val(data.price_09);				
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function add_Form(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('New Promotion');
}
  
</script>


@endsection