<!-- page menampilkan form detail input setor -->

@extends('layouts.myform')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   
  	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>


</head>


@section('title')
 <table>

	<tr><td width="120"><b>Tgl. Setor</b></td><td><b>{{ tanggal_indonesia($setor->setor_tgl, false) }}</b></td></tr>
	<tr><td width="120"><b>Bank</b></td><td><b>{{ $setor->setor_bank }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>setoran</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-setor" method="post" id="form-setor">
{{ csrf_field() }}
  
  <input type="hidden" name="idtrx" value="{{ $idtrx }}">
  
	    <a href="/wawan/setor/{{ $idtrx }}/cetak" class="btn btn-primary pull-right cetak"><i class="fa fa-print"> </i> Cetak Report </a>
		<button id="submit-posting" type="submit" class="btn btn-success pull-right simpan"><i class="fa fa-floppy-o"> </i> Posting </button>		
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 

</form>


<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<div class="row">
    
<!-- <div style="height:400px; overflow-y: scroll;">  -->
<button onclick="addForm()" type="button" class="btn btn-success"> Add detail </button>

<table class="table table-fixed table-striped table-bordered tabel-setordetail" id="setordetail">

<thead>
              
   <tr class="tblheader">
      <th width="20">No</th>
      <th>Deskripsi</th>
      <th>TYPE</th>
      <th>Nominal</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>

</form>

<div class="box-footer">
    <div class="col-md-8" align="right">
        	<label>Total Setoran  &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    </div>
    <div class="col-md-3">
    	<div id="total-rp" style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    </div>          
	<div class="col-md-3">
		<form class="form form-horizontal form-rekaptrx" method="GET" action="/wawan/setor/{{ $idtrx }}/posting">
			{{ csrf_field() }}
			<input type="hidden" name="idtrx" value="{{ $idtrx }}">
		</form>
	</div>          

</div>

            </div>
        </div>
    </div>
</div>

@include('setor.form')

@endsection

@section('script')

<!------------------------------------------------- javascript -------------------------------->

<script type="text/javascript">
var table, table1, save_method;
var id_trx=$('#idtrx').val();

$(function(){

  table = $('.tabel-setordetail').DataTable({
     "scrollY": '58vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bt',
     "ajax" : {
     "url" : "{{ route('setordetail.detail') }}",
     "type" : "GET"
	}

     }).on('draw.dt', function(){
       loadSummary();
     });

}); 
 
//submit simpan add detail
	  
      $('#modal-form').on("submit", function(e) {	      
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan data ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('setordetail.simpandetail') }}";
         else url = "setor/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#cus').focus().select();
				 }else{
					$('#modal-form').modal('hide');
					swal("SUCCESS", " Detail Setoran berhasil disimpan ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
					loadSummary();
				 }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
});

///////////////////////////////////////

/* simpan data ke ms_sale dan posting->stock , cetak  ---> purchase.update */

$('.simpan').click(function(){
    document.querySelector('#form-setor').addEventListener('submit', function(e) {       
    var form = this;

    e.preventDefault(); // -- prevent form from submitting

    swal({
        title: "Anda Yakin ingin memposting Setoran ?",
        text: "Data Setoran akan diposting & tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Posting'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
                }).then(function() {
            $('.form-rekaptrx').submit(); // -- submit form programmatically
        });
        } else {
            swal("Batal", "Setoran masih bisa diedit :)", "error");
        }
        })
    });    
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('Detail Setoran');
} 	 


/* modul delete */
function deleteItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/wawan/setordetail/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload(function(){
			loadSummary();
          }); 
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

/* mreferesh perubahan total sale */

function loadSummary(){
	
  $.ajax({
	   url : "/wawan/setordetail/loadsummary",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#total-rp').text(data.totalrp);
       },
       error : function(){
         alert("Tidak dapat menampilkan total setoran !");
		 return false;
       }
  });
}

function error_mess(){
	swal("WARNING"," Anda tidak punya Akses ! ","error");
}

</script>

@endsection