@extends('layouts.app')

@section('title')
    Sessi Penjualan
@endsection

@section('breadcrumb')
   @parent
   <li>session</li>
@endsection


@section('content')     
<div class="row">
  <div class="col-xs-12">
    <div class="box">
       <div class="box-body">  

<table class="table table-striped table-padding table-bordered" id="tbl-sessi" width="100%">
<thead>
   <tr class="tblheader">
      <th>Tanggal</th>
      <th>Kasir</th>
      <th>Modal</th>
      <th>BRUTTO</th>
      <th>DISC</th>
      <th>NETTO</th>
      <th>BIAYA</th>
      <th>Status</th>
      <th>Action</th>
   </tr>
</thead>
<tbody></tbody>
</table>
<br>

      </div>
    </div>
  </div>
</div>

@include('sessi.detail')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;

$(document).ready(function() {
   table = $('#tbl-sessi').DataTable({
     "processing" : true,
     "lengthMenu": [[7, 20, 50, -1], [7, 20, 50, "All"]],       //pilihan jumlah record show
     "ajax" : {
       "url" : "{{ route('sessi.listsessi') }}",
       "type" : "GET"
     }
   }); 
   
});

tbldetail = $('.tabel-detail').DataTable({
	"dom" : 'bt',
    "bSort" : false,
    "paging": false,
	"retrieve" : true,
    "destroy": true,	 
    "processing" : true
});	

function showDetail(id){
  $('#modal-detail').modal('show');
	
  tbldetail.ajax.url("{{ DIR_APP }}sessi/"+id+"/detail");
  tbldetail.ajax.reload();

}
</script>
@endsection