@extends('layouts.app')

<head>
	<style>
        th, td,tr { height:35px;
            border:none;
            border-bottom:1px grey solid;
            font-size:14px; font-weight:normal; 
        }
        
        th {font-size:15px; font-weight:normal; border-top:1px grey solid; }
        
	</style>    
</head>


@section('title')
	Master Cashier
@endsection

@section('breadcrumb')
   @parent
   <li>product</li>
@endsection


@section('content')   

<div class="row">
  <div class="col-xs-12 col-md-8 col-sm-8">
      
<section id="tabeldata" class="show">
    
    <div class="box" style="border-top:2px grey solid">
      <div class="box-body">  

    <form method="post" id="form-produk">
    {{ csrf_field() }}
    
     <a onclick="addKasir()" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> New Cashier </a>&nbsp;
    
        <table "table table-striped table-padding table-bordered" id="kasir" width="100%">
            <thead>
               <tr>
                    <th>Nama</th>
                    <th>Tgl.Kerja</th>
                    <th>Outlet</th>
                    <th width="5%">Action</th>
               </tr>
            </thead>
            <tbody></tbody>
        </table>
    </form>
    
        </div>
	</div>
</section>

<!------------------------------------------------------->

<section id="formdata" class="hide">
    
    <div class="box" style="padding:20px 50px 20px 50px;border-top:2px grey solid">
        <div class="box-body">
            
    <form class="form-horizontal" data-toggle="validator" method="post" id="formkasir">
    {{ csrf_field() }} {{ method_field('POST') }}
    
    <input type="hidden" id="id" name="id">
    
    <h3 class="text-center">Form Kasir</h3>
    <br>

    <div class="row">
        
        <div class="col-sm-12 col-md-12 col-xs-12">
            
        <div class="form-group">
            <label>Nama Kasir</label>
            <input id="nama" type="text" class="form-control" name="nama" autofocus required autocomplete="off">
        </div>
   
        <div class="form-group">
            <label>Password</label>
            <input id="psw" type="text" class="form-control" name="psw" autofocus required autocomplete="off">
        </div>


        <div class="form-group">
            <label>Tgl. Kerja</label>
    	    <input  class="form-control" name="tgl" id="tgl" type="date" autocomplete="off" autofocus required>
    	    <small class="text-muted">Tanggal Masuk Kerja</small>
    	</div>

        <div class="form-group">
            <label>Outlet</label>
            <select id="outlet" type="text" class="form-control" name="outlet" autofocus required>
                <option value=""> -- Pilih Outlet -- </option>
                @foreach($outlet as $list)
                <option value="{{ $list->id }}">{{ $list->outlet_name }}</option>
                @endforeach
                <small class="text-muted">Outlet tempat bertugas</small>
            </select>
        </div>

        
        <br>
        <div class="form-group">
    		<button id="submit-control" type="submit" class="btn btn-primary btn-sm btn-save"><i class="fa fa-floppy-o"></i> Save </button>
    		<a onclick="tutupform()" class="btn btn-warning btn-sm"><i class="fa fa-times-circle"></i> Cancel </a>
        </div>
    </div>
    

        </div>
    </div>
 </section>   

</div>	

@endsection

@section('script')

<script type="text/javascript">

$(function(){
   table = $('#kasir').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('sales.datacashier') }}",
       "type" : "GET"
     }
});      


//submit
	  $('#formkasir').validator().on("submit", function(e) {
      if(!e.isDefaultPrevented()){
		  
		 $('#submit-control').html(' data sedang disimpan... ');
		 $('#submit-control').attr('disabled','disabled');
		 
         var id = $('#id').val();
         if(save_method == "add") {url = "{{ DIR_APP }}sales/simpancashier"; tipe="POST"; }
         else { url = "{{ DIR_APP }}sales/"+id+"/simpaneditcashier"; tipe="GET"; }

         $.ajax({
           url : url,
           type : tipe,
           data : $('#formkasir').serialize(),
           dataType: 'JSON',		   
           success : function(data){
			 $('#submit-control').html('<i class="fa fa-floppy-o"></i> Save');
			 $('#submit-control').removeAttr('disabled');
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data !","error");
                $('#nama').focus().select();
             }else{
 
                table.ajax.reload();
                tutupform();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");	
			 $('#submit-control').html('<i class="fa fa-floppy-o"></i> Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
});


function addKasir(){
	save_method="add";
    bukaform();	
    $('input[name=_method]').val('POST');
}

function bukaform(){
    $('#tabeldata').removeClass('show');
    $('#tabeldata').addClass('hide');
    $('#formdata').removeClass('hide');
    $('#formdata').addClass('show');
    
    document.getElementById("formkasir").reset();
}

function tutupform(){
    $('#formdata').removeClass('show');
    $('#formdata').addClass('hide');
    $('#tabeldata').removeClass('hide');
    $('#tabeldata').addClass('show');
    
    document.getElementById("formkasir").reset();
}

function editForm(id){
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $.ajax({
        url : "{{ DIR_APP }}sales/"+id+"/editcashier",
        type : "GET",
        dataType : "JSON",
        success : function(data){
 
            bukaform();
        
            $('#id').val(data.id);
	  
            $('#nama').val(data.cashier_name);
            $('#psw').val(data.password);
            $('#tgl').val(data.tglkerja);
            $('#outlet').val(data.outlet_id);
	    },
            error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });
}


function tampilKasir(id){
   $.ajax({
     url : "{{ DIR_APP }}sales/"+id+"/editcashier",
     type : "GET",
     dataType : "JSON",
     success : function(data){

       $('#idkasir').val(data.id);
       $('#namakasir').val(data.cashier_name);
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


</script>


@endsection