@extends('layouts.app')

@section('title')
  Master Rute &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
    <a onclick="addForm()" class="btn btn-success"><i class="fa fa-plus-circle"></i> New Route </a>
@endsection

@section('breadcrumb')
   @parent
   <li>Rute</li>
@endsection

@section('content')     

<form method="POST">
    {{ csrf_field() }}
    
<div class="row">
  <div class="col-xs-12">
    <div class="box">
      <div class="box-body">  
      
<input type="hidden" id="mgr" name="mgr" value="{{ Auth::user()->group }}">
<input type="hidden" id="tglsekarang" name="tglsekarang" value="{{ $sekarang }}">

<table class="table table-striped table-padding table-bordered" id="tbl-rute"  width="100%">
<thead>
   <tr class="tblheader">     
        <th>Tanggal</th>
        <th>Rute</th>
        <th>Driver</th>
        <th>No.POL</th>
        <th width="90">Opsi</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>
</form>

@include('rute.form')
@include('rute.detail')
@endsection

@section('script')
<script type="text/javascript">
var table, tbldetail, save_method, mgr;

mgr=$('#mgr').val();

$(function(){
   table = $('#tbl-rute').DataTable({
     "processing" : true,
     "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       
     "ajax" : {
       "url" : "{{ route('rute.data') }}",
       "type" : "GET"
     }
   }); 
   
	tbldetail = $('.tabel-detail').DataTable({
         "bSort": false,
         "processing" : true,
		 "paging" : false,
    	 "dom" : 'bt',
    });	     
   
   $('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 $('#submit-control').html(' Data sedang disimpan ... ');
		 $('#submit-control').attr('disabled','disabled');
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('rute.store') }}";
         else url = "rute/"+id;
         
         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           success : function(data){
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			   
             $('#modal-form').modal('hide');
             table.ajax.reload();
           },
           error : function(){
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');				   
             alert(" Tidak dapat menyimpan data! ");
           }   
         });
         return false;
     }
   });
   
});



function addForm(){
   save_method = "add";
   tg = $('#tglsekarang').val();
   
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('New Route');
   
   $('#tgl').val($('#tglsekarang').val());
   
   if(mgr=="MANAGER"){
       $('#tgl').removeAttr('disabled');
   }else{
       $('#tgl').attr('readonly', true);
   }
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "rute/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Route');
       
       $('#id').val(data.id_route);
       $('#tgl').val(data.tanggal);
       $('#tgl').attr('readonly', true);
	   $('#nama').val(data.route_name);
       $('#sopir').val(data.driver);
       $('#nopol').val(data.no_pol);
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function batal(id){
   if(confirm("  Apakah yakin Rute ini akan dibatalkan ?  ")){
     $.ajax({
       url : "/wawan/rute/"+id+"/batal",
       type : "GET",
       dataType : "JSON",
       success : function(data){
            //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " Rute Gagal dibatalkan  !","error");
				 }else{
					swal("SUCCESS", " Pembatalan Rute berhasil ! ","success");
					table.ajax.reload();	
				 }
       },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat dihapus, harap hubungi IT !","error");
			}   
         });
       return false;
	}
}

function listData(id){
	
    $('#modal-detail').modal('show');
	
    tbldetail.ajax.url("rute/"+id+"/detail");
	tbldetail.ajax.reload();

}


</script>
@endsection