@extends('layouts.app')

@section('title')
  Stock Product&nbsp;&nbsp;&nbsp;&nbsp;
  <a onclick="printstock()" class="btn btn-outline-info btn-sm"><i class="fa fa-print"></i> Print Report Stock </a>
@endsection

@section('breadcrumb')
   @parent
   <li>Stock Product</li>
@endsection

@section('content')     
<section id="tbl-data" class="show">
<div class="row">
  <div class="col-xs-12 col-md-12 col-sm-12">
    <div class="box" style="border-top:2px black solid">
       <div class="box-body"> 
       
    

<table class="table table-hover table-bordered table-padding table-responsive" id="tbl-stock" width="100%">
<thead>
   <tr class="tblheader">
      <th width="40%">Nama Product</th>
      <th width="10%">Awal</th>
      <th width="10%">Masuk</th>
      <th width="10%">Keluar</th>
      <th width="10%">Sisa</th>
      <th width="6%">action</th>
   </tr>
</thead>
<tbody></tbody>
</table>
</form>

      </div>
    </div>
  </div>
</div>
</section>

<section id="data-detail" class="hide">
   <div class="container-fluid"> 
      <div class="col-sm-12 col-md-12 col-xs-12">
                
         <div class="card" style="border-top:2px black solid;">
            <span><a onclick="tutupDetail()" class="btn btn-flat pull-right" id="xclose"> X </a></span>
            <div class="card-block">
               <h6>DETAIL STOCK</h6>
               <table class="table table-bordered tabel-detail" width="100%">
                  <thead>
                     <tr class="tblheader">
                        <th>Deskripsi</th>
                        <th>Value</th>
                     </tr>
                  </thead>
                  <tbody></tbody>
               </table>
            </div>
         </div>
      </div>
   </div>
</section>

@endsection

@section('script')
<script type="text/javascript">
var  save_method;

$(function(){
   table = $('#tbl-stock').DataTable({
     "processing" : true,
     "language": {
         "searchPlaceholder": "Search" },   // Placeholder for the search box     
     "ajax" : {
         "url" : "{{ route('product.datastock') }}",
         "type" : "GET"
      }
   }); 
})

function stockDetail(id){
    alert(id);
}

function editForm(id){
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $.ajax({
        url : "product/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
        
            bukaForm();
        
            $('#id').val(data.id);
            $('#kode').val(data.kode_brg).attr('readonly', true);
            $('#nama').val(data.nama_brg);
	        $('#kecil').val(data.vol_small);
	        $('#besar').val(data.vol_big);
	        $('#stnbig').val(data.stn_big);
	        $('#stnsmall').val(data.stn_small);
            $('#desk').val(data.description);
            $('#pokok').val(data.harga_pokok);
            $('#jual').val(data.harga_jual);
       
        },
            error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });
} 

/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
   
    document.getElementById("form-input").reset();
    $('#kode').removeAttr('readonly', 'disabled');
}


function tutupForm(){
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

   document.getElementById("form-input").reset();
}

function bukaForm(){
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}   



tbldetail = $('.tabel-detail').DataTable({
   "paging": false,
   "processing" : true,
	"searching" : false,
	"destroy" : true,
   "bSort": false,
   "iDisplayLength" : 15,
   "dom" : 'bt',
});

function showDetail(id){
    bukaDetail();
    tbldetail.ajax.url("bahan/"+id+"/tampil");
    tbldetail.ajax.reload();
}

function bukaDetail(){
   $('#tbl-data').addClass("hide");
	$('#form-data').addClass("hide");
	$('#data-detail').removeClass('hide');
	$('#data-detail').addClass('show');
}

function tutupDetail(){
	$('#data-detail').removeClass('show');
	$('#data-detail').addClass('hide');
   $('#tbl-data').removeClass('hide');
   $('#tbl-data').addClass("show");
}

</script>
@endsection