@extends('layouts.myform')

@section('title')
Master Selling Price
		<a onclick="window.location='{{ route('home') }}'" class="btn btn-warning"><i class="fa fa-home"></i> Home </a>		
@endsection

@section('breadcrumb')
   @parent
   <li>price</li>
@endsection

<head>
    <title>Master Harga</title>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
 
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	<script type="text/javascript" src="public/adminLTE/dist/css/sweetalert.min.js"></script>

<!------------------------------>
	
	<style>
	table {
	  border-collapse: collapse;
	  border-spacing: 0;
	  width: 100%;
	  border: 1px solid #ddd;
	}

	th, td {
	  text-align: left;
	  padding: 8px;
	}

	tr:nth-child(even){background-color: #f2f2f2}
	</style>

</head>


@section('content')   
<div class="row">
  <div class="col-xs-13">
    <div class="box">

	 <div class="box-body">  

<form method="post" id="form-price">
{{ csrf_field() }}

<div class="table-responsive">

<table class="table table-striped table-bordered" id="price">
<thead>
   <tr class="success">
      <th>SKU</th>
      <th>Description</th>
      <th>Price 1</th>
      <th>Price 2</th>
	  <th>Price 3</th>
	  <th>Price 4</th>
      <th>Price 5</th>
	  <th>Price 6</th>
      <th>Price 7</th>
      <th>Price 8</th>
      <th>Price 9</th>
      <th>Aksi</th>
   </tr>
</thead>
<tbody></tbody>
</table>

</div>

</form>

    </div>
	</div>
	</div>
</div>	


@include('price.form')

@endsection

@section('script')

<script type="text/javascript">
var table1, save_method;
$(document).ready(function() {
	var table = $('#price').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('price.getdata') }}",
        "columns":[
            { "data": "price_sku", "width": "15px"},
            { "data": "sku_name", "searchable": false, "width": "250px"},
			
			{ "data": "price_01", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_02", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_03", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_04", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_05", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_06", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_07", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_08", "orderable":false, "searchable":false, "width": "45px" },
			{ "data": "price_09", "orderable":false, "searchable":false, "width": "45px" },			
			{
                "data": "id_price",
                "sClass": "text-center",
                "orderable": false,
				"width": "20px",
                "mRender": function (data) {
                          return '  <a onclick="editForm('+data+')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a> '
						  //return '<a href="price/'+data+'/edit" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i></a>'
                         }
            }
  			
        ]
     });

//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('price.store') }}";
         else url = "price/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " Master Harga berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");			 
           }   
         });
         return false;
	 }
	
	});
	 
});

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "price/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Master Harga');
       
        $('#id').val(data.id_price);
        $('#kode').val(data.price_sku.concat(' - ',data.sku_name)).attr('readonly', true);
     //   $('#nama').val(data.sku_name).attr('readonly', true);
	    $('#harga1').val(data.price_01).attr('readonly',false);
		$('#harga2').val(data.price_02).attr('readonly',false);
		$('#harga3').val(data.price_03).attr('readonly',false);
		$('#harga4').val(data.price_04).attr('readonly',false);
		$('#harga5').val(data.price_05).attr('readonly',false);
		$('#harga6').val(data.price_06).attr('readonly',false);
		$('#harga7').val(data.price_07).attr('readonly',false);
		$('#harga8').val(data.price_08).attr('readonly',false);
		$('#harga9').val(data.price_09).attr('readonly',false);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


function showDetail(id){
	
    $('#modal-form').modal('show');				//menampilkan form detail
	
    table1.ajax.url("price/"+id+"/lihat");		//proses query sesuai id
	table1.ajax.reload();						//menampilkan hasil query

}

</script>

@endsection