<!-- page menampilkan form detail input invoice -->

@extends('layouts.app')

<!--
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   
  	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>


</head>
-->


@section('title')
 <table>

    <tr><td width="210"><b>Customer </b></td><td><b>{{ $customer->cus_name.' - '.$customer->cus_address }}</b></td></tr>
	<tr><td width="210"><b>TOTAL BAYAR + Pembulatan </b></td><td><b>{{ format_uang($m_piutang->total_bayar - $m_piutang->pembulatan) }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>pelunasan piutang</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-invoice" method="post" id="form-invoice">
{{ csrf_field() }}
  
  <input type="hidden" name="idtrx" value="{{ $idtrx }}">
  
		<button id="submit-control" type="submit" class="btn btn-success btn-sm pull-right simpan"><i class="fa fa-floppy-o"> </i> Posting </button>
		<button type="button" class="btn btn-warning btn-sm pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 

  <div class="form-group">
      <div class="col-md-3">
        <div class="input-group">
          <input id="kode" type="hidden" class="form-control" name="kode" autofocus required readonly="true">
          <span class="input-group-btn">
            <button onclick="showInvoice()" type="button" class="btn btn-info btn-sm"> Pilih Invoice </button>
          </span>
        </div>
      </div>
  </div>

</form>


<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<!--<div class="row">-->
    
<!-- <div style="height:400px; overflow-y: scroll;">  -->

<table class="table table-fixed table-striped table-bordered tabel-trxdetail" id="trxdetail">

<thead>
              
   <tr class="tblheader">
      <th width="20">No</th>
      <th>NO.INVOICE</th>
	  <th>Tgl.Invoice</th>
      <th>TYPE</th>
      <th>TOTAL</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>

</form>

<div class="box-footer">
    <div class="col-md-8" align="right">
     	<label><font size="5">Total Invoice Rp &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</font></label><br>
    </div>
    <div class="col-md-3">
    	<div id="total-rp" style="background: DarkCyan; color: #fff; font-size: 30px; text-align: right; height: 36px"></div>
    </div>          
	<div class="col-md-3">
		<form class="form form-horizontal form-rekaptrx" method="GET" action="/wawan/piutang/{{ $idtrx }}/posting">
			{{ csrf_field() }}
			<input type="hidden" name="idtrx" value="{{ $idtrx }}">
		</form>
	</div>          

</div>

            </div>
        </div>
    </div>
</div>

@include('piutang.invoice')

@endsection

@section('script')

<!------------------------------------------------- javascript -------------------------------->

<script type="text/javascript">
var table, table1, save_method;
var id_trx=$('#idtrx').val();

$(function(){
  $('.tabel-invoice').DataTable();
    
  table = $('.tabel-trxdetail').DataTable({
     "scrollY": '58vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bt',
     "ajax" : {
     "url" : "{{ route('piutang.data') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
	loadSummary();
 });

  $('.form-invoice').on('submit', function(e){
     return false;
  });
   
    $('#kode').change(function(){
      addItem();
   });
   
});


/* simpan edit detail */
$('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 
         var id  = $('#id').val();
		 url = "/wawan/piutang/"+id+"/update";
         $.ajax({
           url : url,
           type : "GET",
           data : $('#modal-form form').serialize(),
           success : function(data){
             $('#modal-form').modal('hide');
             table.ajax.reload();
           },
           error : function(){
			 return false;
          }   
        });
        return false;
    }
    
}); 

///////////////////////////////////////

/* posting pelunasan */

$('.simpan').click(function(){
    document.querySelector('#form-invoice').addEventListener('submit', function(e) {       
    var form = this;

    e.preventDefault(); // -- prevent form from submitting

    swal({
        title: "Anda Yakin ingin memposting Pelunasan ?",
        text: "Data tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Simpan'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
                }).then(function() {
            $('.form-rekaptrx').submit(); // -- submit form programmatically
        });
        } else {
            swal("Batal", "Pelunasan masih bisa diedit :)", "error");
        }
        })
    });    
});


/*---------------------------------------------------------------*/
function addItem(){

  $.ajax({
    url : "{{ route('piutang.simpan') }}",
    type : "POST",
    data : $('.form-invoice').serialize(),
    success : function(data)
		{
			if(data.msg=="error")
				{
				 swal("WARNING", " Invoice ini sudah ada di data !","error");
					$('#kode').val('').focus();
				}else{
					$('#kode').val('').focus();
					table.ajax.reload(function() { loadSummary(); }) ;         
				}
		},
			error : function(){
			swal("DANGER", " Detail Piutang Gagal disimpan, HUB. IT !","error");
			}
			});
         return false;

}

/*---------------------------------------------------------------*/
function selectItem(kode){
	$('#kode').val(kode);
	$('#modal-invoice').modal('hide');
	addItem();
}


/* tampilkan form produk barang satuan */
function showInvoice(){
  $('#modal-invoice').modal('show');
}


function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/wawan/penjualandetail/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Detail Transaksi');
       
       $('#id').val(data.id_dsale);
       $('#nama').val(data.nama_brg);	   
     
       $('#isi').val(data.isi);
	   $('#retail').val(data.harga_retail);
       $('#qty').val(data.qty);       
	   $('#dis').val(data.potongan);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Transfer !");
     }
   });
}

function inputForm(id){
   save_method = "add";
   $('input[name=_method]').val('PATCH');
   $('#modal-form_input form')[0].reset();

   $.ajax({
     url : "/sbo/transferdetail/"+id+"/caribrg",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_input').modal('show');
       $('.modal-title').text('Input Detail Transfer');
       
       $('#idbrg').val(data.id);
	   $('#kdbrg_').val(data.kode_brg);
       $('#nama_').val(data.nama_brg);	   
       $('#gross_').val(data.harga_list);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

/* modul delete */
function deleteItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/wawan/piutang/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload(function(){
			loadSummary();
          }); 
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

/* mreferesh perubahan total sale */

function loadSummary(){
  $.ajax({
	   url : "/wawan/piutang/loadsummary",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#total-rp').text(data.totalrp);
       },
       error : function(){
         alert("Tidak dapat menampilkan data total penjualan !");
		 return false;
       }
  });
}

</script>

@endsection