@extends('layouts.app')


@section('title')
	
	<tr><td>Pembayaran Sebagian </td></tr>	
@endsection

@section('breadcrumb')
   @parent
   <li>Pelunasan Piutang Customer</li>
@endsection

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Pelunasan Piutang Customer</title>

	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	
	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script> 

</head>


@section('content')   
<div class="row">
	<div class="col-sm-12">
		<div class="box">
				<div class="box-body">  

<form method="post" id="form-cicilan">
{{ csrf_field() }}

<input id="tgl" type="hidden" value="{{ date('Y-m-d') }}">
<input type="hidden" id="mgr" name ="mgr" value="{{ Auth::user()->group }}">

<table class="table table-striped table-padding table-bordered" id="tblcicilan" width="100%">
<thead>
   <tr class="tblheader">
		<th>NO.Invoice</th>
 	    <th>Tanggal</th>
 	    <th>Customer</th>
        <th>TOTAL</th>
		<th>BAYAR-1</th>
		<th>BAYAR-2</th>
		<th>BAYAR-3</th>
		<th>BAYAR-4</th>
		<th>BAYAR-5</th>
		<th>SISA</th>
        <th width="8%">Opsi</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('piutang.form_cicil')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method, mgr;

mgr = $('#mgr').val();

$(function(){
   table = $('.table').DataTable({
     "processing" : true,
	// "iDisplayLength" : 7,
	 "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],
     "ajax" : {
       "url" : "{{ route('piutang.getcicil') }}",
       "type" : "GET"
     }
   }); 
   
//submit
	  $(document).on("submit", function(e) {
       if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan Cicilan ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         url = "/wawan/piutang/"+id+"/simpancicil";

         $.ajax({
           url : url,
           type : "GET",
           data : $('#modal-form_cicil form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#tp').focus().select();
				 }else{
					$('#modal-form_cicil').modal('hide');
					swal("SUCCESS", " Cicilan berhasil disimpan ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
				 }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
  
})  
/*-------------------------------------------------*/

function addCicil(id){
   save_method = "edit";
   var tglx = $('#tgl').val();

   $('input[name=_method]').val('PATCH');
   $('#modal-form_cicil form')[0].reset();
   $.ajax({
     url : "/wawan/piutang/"+id+"/cicil",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_cicil').modal('show');
       $('.modal-title').text('Input Cicilan');
       
       $('#id').val(data.id_sale);

	   $('#noinv').val(data.sale_no);
       $('#cus').val(data.cust_id).attr('disabled', 'disabled');
       $('#tp1').val(data.bayar1_type);	   
	   $('#ttlinv').val(data.sale_netto);
	  
//cicilan 1
	    if(data.sale_bayar1==0)
	    {
	        $('#tgl1').val(tglx);
		    $('#ttl1').val(data.sale_bayar1); 
		    $('#ttl1').removeAttr('disabled');
		    $('#tp1').removeAttr('disabled');
		    $('#ket1').removeAttr('disabled');
		   
		    $('#tgl2').attr('disabled', 'disabled');
		    $('#tgl3').attr('disabled', 'disabled');
		    $('#tgl4').attr('disabled', 'disabled');
		    $('#tgl5').attr('disabled', 'disabled');
		   
		    $('#tp2').attr('disabled','disabled');
		    $('#tp3').attr('disabled','disabled');
		    $('#tp4').attr('disabled','disabled');
		    $('#tp5').attr('disabled','disabled');
		   
		    $('#ttl2').attr('disabled', 'disabled');
		    $('#ttl3').attr('disabled', 'disabled');
		    $('#ttl4').attr('disabled', 'disabled');
		    $('#ttl5').attr('disabled', 'disabled');
		   
		    $('#ket2').attr('disabled', 'disabled');
		    $('#ket3').attr('disabled', 'disabled');
		    $('#ket4').attr('disabled', 'disabled');
		    $('#ket5').attr('disabled', 'disabled');
		   
    	/*kunci tgl */
            if(mgr=="MANAGER")
            {
                $('#tgl1').removeAttr('readonly','disabled');  
            }else{
                $('#tgl1').attr('readonly', true);  
            }   
		   
	    }
	    
//cicilan 2	    
	   if(data.sale_bayar1>0 && data.sale_bayar2==0)
	    {

            $('#tgl1').val(data.bayar1_tgl);               
	        $('#tgl2').val(tglx);
	       
		    $('#ttl1').val(data.sale_bayar1);
		    $('#tp1').val(data.bayar1_type);
		    $('#ket1').val(data.bayar1_note); 
		    
		    $('#ttl2').removeAttr('disabled');
		    $('#tp2').removeAttr('disabled');
		    $('#ket2').removeAttr('disabled');
		   
		    $('#tgl1').attr('disabled', 'disabled');
		    $('#tgl3').attr('disabled', 'disabled');
		    $('#tgl4').attr('disabled', 'disabled');
		    $('#tgl5').attr('disabled', 'disabled');
		   
		    $('#tp1').attr('disabled','disabled');
		    $('#tp3').attr('disabled','disabled');
		    $('#tp4').attr('disabled','disabled');
		    $('#tp5').attr('disabled','disabled');
		   
		    $('#ttl1').attr('disabled', 'disabled');
		    $('#ttl3').attr('disabled', 'disabled');
		    $('#ttl4').attr('disabled', 'disabled');
		    $('#ttl5').attr('disabled', 'disabled');
		   
		    $('#ket1').attr('disabled', 'disabled');
		    $('#ket3').attr('disabled', 'disabled');
		    $('#ket4').attr('disabled', 'disabled');
		    $('#ket5').attr('disabled', 'disabled');		   

      /*kunci tgl */
            if(mgr=="MANAGER")
            {
                $('#tgl2').removeAttr('disabled');  
            }else{
                $('#tgl2').attr('disabled','disabled');  
            }   		   
	    }	    

//cicilan 3		   
	   if(data.sale_bayar1>0 && data.sale_bayar2>0 && data.sale_bayar3==0)
	    {

            $('#tgl1').val(data.bayar1_tgl);
            $('#tgl2').val(data.bayar2_tgl);               
	        $('#tgl3').val(tglx);
	       
		    $('#ttl1').val(data.sale_bayar1);
		    $('#ttl2').val(data.sale_bayar2);
		    $('#tp1').val(data.bayar1_type);
		    $('#ket1').val(data.bayar1_note); 		    
		    $('#tp2').val(data.bayar2_type);
		    $('#ket2').val(data.bayar2_note); 		    
		    
		    $('#ttl3').removeAttr('disabled');
		    $('#tp3').removeAttr('disabled');
		    $('#ket3').removeAttr('disabled');
		   
		    $('#tgl1').attr('disabled', 'disabled');
		    $('#tgl2').attr('disabled', 'disabled');
		    $('#tgl4').attr('disabled', 'disabled');
		    $('#tgl5').attr('disabled', 'disabled');
		   
		    $('#tp1').attr('disabled','disabled');
		    $('#tp2').attr('disabled','disabled');
		    $('#tp4').attr('disabled','disabled');
		    $('#tp5').attr('disabled','disabled');
		   
		    $('#ttl1').attr('disabled', 'disabled');
		    $('#ttl2').attr('disabled', 'disabled');
		    $('#ttl4').attr('disabled', 'disabled');
		    $('#ttl5').attr('disabled', 'disabled');
		   
		    $('#ket1').attr('disabled', 'disabled');
		    $('#ket2').attr('disabled', 'disabled');
		    $('#ket4').attr('disabled', 'disabled');
		    $('#ket5').attr('disabled', 'disabled');
		   
	    /*kunci tgl */
            if(mgr=="MANAGER")
            {
                $('#tgl3').removeAttr('disabled');  
            }else{
                $('#tgl3').attr('disabled','disabled');  
            }   
	    }	   
	    
//cicilan 4	   
	   if(data.sale_bayar1>0 && data.sale_bayar2>0 && data.sale_bayar3>0 && data.sale_bayar4==0)
	    {

            $('#tgl1').val(data.bayar1_tgl);
            $('#tgl2').val(data.bayar2_tgl);     
            $('#tgl3').val(data.bayar3_tgl);     
	        $('#tgl4').val(tglx);
	       
		    $('#ttl1').val(data.sale_bayar1);
		    $('#ttl2').val(data.sale_bayar2);
		    $('#ttl3').val(data.sale_bayar3); 
		    $('#tp1').val(data.bayar1_type);
		    $('#ket1').val(data.bayar1_note); 		    
		    $('#tp2').val(data.bayar2_type);
		    $('#ket2').val(data.bayar2_note); 		    
		    $('#tp3').val(data.bayar3_type);
		    $('#ket3').val(data.bayar3_note); 		    


		    $('#ttl4').removeAttr('disabled');
		    $('#tp4').removeAttr('disabled');
		    $('#ket4').removeAttr('disabled');
		   
		    $('#tgl1').attr('disabled', 'disabled');
		    $('#tgl2').attr('disabled', 'disabled');
		    $('#tgl3').attr('disabled', 'disabled');
		    $('#tgl5').attr('disabled', 'disabled');
		   
		    $('#tp1').attr('disabled','disabled');
		    $('#tp2').attr('disabled','disabled');
		    $('#tp3').attr('disabled','disabled');
		    $('#tp5').attr('disabled','disabled');
		   
		    $('#ttl1').attr('disabled', 'disabled');
		    $('#ttl2').attr('disabled', 'disabled');
		    $('#ttl3').attr('disabled', 'disabled');
		    $('#ttl5').attr('disabled', 'disabled');
		   
		    $('#ket1').attr('disabled', 'disabled');
		    $('#ket2').attr('disabled', 'disabled');
		    $('#ket3').attr('disabled', 'disabled');
		    $('#ket5').attr('disabled', 'disabled');

		/*kunci tgl */
            if(mgr=="MANAGER")
            {
                $('#tgl4').removeAttr('disabled');  
            }else{
                $('#tgl4').attr('disabled','disabled');  
            }   
	    }	   	    

//cicilan 5	   
	   if(data.sale_bayar1>0 && data.sale_bayar2>0 && data.sale_bayar3>0 && data.sale_bayar4>0 && data.sale_bayar5==0)
	    {

            $('#tgl1').val(data.bayar1_tgl);
            $('#tgl2').val(data.bayar2_tgl);     
            $('#tgl3').val(data.bayar3_tgl);    
            $('#tgl4').val(data.bayar4.tgl)
	        $('#tgl5').val(tglx);
	       
		    $('#ttl1').val(data.sale_bayar1);
		    $('#ttl2').val(data.sale_bayar2);
		    $('#ttl3').val(data.sale_bayar3);
		    $('#ttl4').val(data.sale_bayar4); 
		    $('#tp1').val(data.bayar1_type);
		    $('#ket1').val(data.bayar1_note); 		    
		    $('#tp2').val(data.bayar2_type);
		    $('#ket2').val(data.bayar2_note); 		    
		    $('#tp3').val(data.bayar3_type);
		    $('#ket3').val(data.bayar3_note); 		    
		    $('#tp4').val(data.bayar4_type);
		    $('#ket4').val(data.bayar4_note); 		    
		    
		    $('#ttl5').removeAttr('disabled');
		    $('#tp5').removeAttr('disabled');
		    $('#ket5').removeAttr('disabled');
		   
		    $('#tgl1').attr('disabled', 'disabled');
		    $('#tgl2').attr('disabled', 'disabled');
		    $('#tgl3').attr('disabled', 'disabled');
		    $('#tgl4').attr('disabled', 'disabled');
		   
		    $('#tp1').attr('disabled','disabled');
		    $('#tp2').attr('disabled','disabled');
		    $('#tp3').attr('disabled','disabled');
		    $('#tp4').attr('disabled','disabled');
		   
		    $('#ttl1').attr('disabled', 'disabled');
		    $('#ttl2').attr('disabled', 'disabled');
		    $('#ttl3').attr('disabled', 'disabled');
		    $('#ttl4').attr('disabled', 'disabled');
		   
		    $('#ket1').attr('disabled', 'disabled');
		    $('#ket2').attr('disabled', 'disabled');
		    $('#ket3').attr('disabled', 'disabled');
		    $('#ket4').attr('disabled', 'disabled');		
		
		/*kunci tgl */
            if(mgr=="MANAGER")
            {
                $('#tgl5').removeAttr('disabled');  
            }else{
                $('#tgl5').attr('disabled','disabled');   
            }   
	    }	   	    	    
	    
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
}


function editCicil(id){
   save_method = "edit";

   $('input[name=_method]').val('PATCH');
   $('#modal-form_cicil form')[0].reset();
   $.ajax({
     url : "/wawan/piutang/"+id+"/cicil",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_cicil').modal('show');
       $('.modal-title').text('Edit Cicilan');
       
       $('#id').val(data.id_sale);
	   $('#noinv').val(data.sale_no);
       $('#cus').val(data.cust_id).attr('disabled', 'disabled');
	   $('#ttlinv').val(data.sale_netto);
	   
	   if(data.sale_bayar1==0)
	    {
		   $('#ttl1').val(data.sale_bayar1); 
		   $('#ttl1').attr('disabled','disabled');
		   $('#tp1').attr('disabled','disabled');
		   $('#tgl1').attr('disabled', 'disabled');
		   $('#ket1').attr('disabled', 'disabled');
	    }else{
	       $('#ttl1').val(data.sale_bayar1);
	       $('#tp1').val(data.bayar1_type);
		   $('#tp1').removeAttr('disabled');
		   $('#ttl1').removeAttr('disabled');
		   $('#tgl1').val(data.bayar1_tgl);
		   $('#tgl1').removeAttr('disabled');
		   $('#ket1').val(data.bayar1_note);
		   $('#ket1').removeAttr('disabled');

	    }
	    
	   if(data.sale_bayar2==0)
	    {
		    $('#ttl2').attr('disabled','disabled');
		    $('#tp2').attr('disabled','disabled');
		    $('#tgl2').attr('disabled', 'disabled');
		    $('#ket2').attr('disabled', 'disabled');
	    }else{		   
	        $('#ttl2').val(data.sale_bayar2); 
		    $('#tp2').removeAttr('disabled');
		    $('#tp2').val(data.bayar2_type);
		    $('#ttl2').removeAttr('disabled');
		    $('#tgl2').val(data.bayar2_tgl);
		    $('#tgl2').removeAttr('disabled');
	        $('#ket2').val(data.bayar2_note);
		    $('#ket2').removeAttr('disabled');
	    }	    
		   
	   if(data.sale_bayar3==0)
	    {
		   $('#ttl3').attr('disabled','disabled');
		   $('#tp3').attr('disabled','disabled');		 
		   $('#tgl3').attr('disabled', 'disabled');
		   $('#ket3').attr('disabled', 'disabled');
	    }else{		   
	       $('#ttl3').val(data.sale_bayar3);  
		   $('#tp3').removeAttr('disabled');
		   $('#tp3').val(data.bayar3_type);
		   $('#ttl3').removeAttr('disabled');
		   $('#tgl3').val(data.bayar3_tgl);
		   $('#tgl3').removeAttr('disabled');
		   $('#ket3').val(data.bayar3_note);
		   $('#ket3').removeAttr('disabled');

	    }	    
	    
	   if(data.sale_bayar4==0)
	    {
		   $('#ttl4').attr('disabled','disabled');
		   $('#tp4').attr('disabled','disabled');		 
		   $('#tgl4').attr('disabled', 'disabled');
		   $('#ket4').attr('disabled', 'disabled');
	    }else{		   
	       $('#ttl4').val(data.sale_bayar3);  
		   $('#tp4').removeAttr('disabled');
		   $('#tp4').val(data.bayar3_type);
		   $('#ttl4').removeAttr('disabled');
		   $('#tgl4').val(data.bayar3_tgl);
		   $('#tgl4').removeAttr('disabled');
		   $('#ket4').val(data.bayar4_note);
		   $('#ket4').removeAttr('disabled');

	    }	    
	    
	   if(data.sale_bayar5==0)
	    {
		   $('#ttl5').attr('disabled','disabled');
		   $('#tp5').attr('disabled','disabled');		 
		   $('#tgl5').attr('disabled', 'disabled');
		   $('#ket5').attr('disabled', 'disabled');
	    }else{		   
	       $('#ttl5').val(data.sale_bayar3);  
		   $('#tp5').removeAttr('disabled');
		   $('#tp5').val(data.bayar3_type);
		   $('#ttl5').removeAttr('disabled');
		   $('#tgl5').val(data.bayar3_tgl);
		   $('#tgl5').removeAttr('disabled');
		   $('#ket5').val(data.bayar5_note);
		   $('#ket5').removeAttr('disabled');

	    }	    	    

     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
}

function err_mess()
{
    swal("WARNING", " Anda tidak punya Akses ! ","error");
}

</script>

@endsection
