@extends('layouts.app')

<head>
    <style>
        .dataTables_wrapper .dataTables_length { display:none; }
        .dataTables_wrapper .dataTables_filter { margin-top:-20px; }
    </style>
</head>    

@section('title')

	History Pelunasan Piutang
	
@endsection

@section('breadcrumb')
   @parent
   <li>Pelunasan Piutang Customer</li>
   &nbsp;&nbsp;

@endsection


@section('content')   
<div class="row"> 
	<div class="col-sm-12">
		<div class="box">
		    <div class="box-header"></div>
			<div class="box-body"> 
			
		<label for="prd" class="col-md-1 control-label">Periode</label>
		<div class="col-md-3">
			<input id="awal" type="date" class="form-control" name="awal" value="{{ date('Y-m-d', strtotime("-35 day", strtotime(date('Y-m-d')))) }}" autofocus required>
		</div>
		<div class="col-md-3">
			<input id="akhir" type="date" class="form-control" name="akhir" value="{{ date('Y-m-d') }}" autofocus required>
		</div>

		<div class="col-md-4"> 
			<button type="button" class="btn btn-primary btn-sm" onclick="showHistory()"><i class="fa fa-table"></i> View </button>
		</div>			
			

<form method="post" id="form-piutang">
{{ csrf_field() }}


<table class="table table-striped table-padding table-bordered" id="tblpiutang"  width="100%">

<!-- <table id="tblpiutang" class="table-responsive noSwipe table table-striped table-hover table-fw-widget">    -->
<thead>
   <tr class="tblheader">
   
 	    <th width="10%">Tanggal</th>
 	    <th width="20%">Customer</th>
        <th width="10%">BAYAR</th>
		<th width="10%">Tl.Invoice</th>
		<th width="10%">Pembulatan</th>
		<th width="5%">TYPE</th>
		<th width="20%">Keterangan</th>
		<th width="10%">User</th>
		<th width="5%">STATUS</th>
        <th width="5%">Opsi</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('piutang.detail')

@endsection

@section('script')
<script type="text/javascript">
var table, tbldetail, stsbatal;

//stsbatal = $('#batal').val();

showHistory();

function showHistory()
{
    var tgl1=$('#awal').val();
    var tgl2=$('#akhir').val();

     $(document).ready(function(){
       table = $('#tblpiutang').DataTable({
         "processing" : true,
         "destroy": true,
        // "lengthMenu": [[8, 10, 20, -1], [8, 10, 20, "All"]],
         "ajax" : {
           "url" : "{{ DIR_APP }}piutang/"+tgl1+"/"+tgl2+"/history_header",
           "type" : "GET"
         }
       }); 
    });
}

	tbldetail = $('.tabel-detail').DataTable({
         "bSort": false,
         "processing" : true,
         "paging" : false,
    	 "dom" : 'bti',
    });	

    
function showDetail(id){
	
//	alert("show detail "+id);
    $('#modal-detail').modal('show');
	
    tbldetail.ajax.url("/wawan/piutang/"+id+"/detail");
	tbldetail.ajax.reload();

}

function editStatus(id){
   if(confirm("  Apakah Status Pelunasan akan diubah ?  ")){
     $.ajax({
       url : "/wawan/piutang/"+id+"/ubahstatus",
       type : "GET",
       dataType : "JSON",
       success : function(data){
            //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " Ubah Status Gagal !","error");
				 }else{
					swal("SUCCESS", " Ubah Status berhasil ! ","success");
					table.ajax.reload();	
				 }
       },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			}   
         });
       return false;
	}    
}

</script>

@endsection
