@extends('layouts.app')

@section('title')

	History Pelunasan Piutang
	
@endsection

@section('breadcrumb')
   @parent
   <li>Pelunasan Piutang Customer</li>
   &nbsp;&nbsp;

@endsection


<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<!--    <title>Pelunasan Piutang Customer</title>-->

	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	
	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>

</head>


@section('content')   
<div class="row"> 
	<div class="col-sm-12">
		<div class="box">
			<div class="box-body"> 

<form method="post" id="form-piutang">
{{ csrf_field() }}


<table class="table table-striped table-padding table-bordered" id="tblpiutang"  width="100%">

<!-- <table id="tblpiutang" class="table-responsive noSwipe table table-striped table-hover table-fw-widget">    -->
<thead>
   <tr class="tblheader">
   
 	    <th width="10%">Tanggal</th>
 	    <th width="20%">Customer</th>
        <th width="10%">BAYAR</th>
		<th width="10%">Tl.Invoice</th>
		<th width="10%">Pembulatan</th>
		<th width="5%">TYPE</th>
		<th width="20%">Keterangan</th>
		<th width="15%">User</th>
        <th width="5%">Opsi</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('piutang.detail')

@endsection

@section('script')
<script type="text/javascript">
var table, tbldetail, stsbatal;

$(document).ready(function() {
	var table = $('#tblpiutang').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('piutang.hist_header') }}",
        "columns":[
            { "data": "lunas_tgl" },
 
			{ "data": "cus_name", "sClass": "text", "orderable":true, "searchable":false	},
			
            { "data": "total_bayar", "searchable": false },	
            
			{ "data" : "lunas_total", "searchable": false },
			{ "data" : "pembulatan", "searchable": false },
			{ "data" : "sts_batal" },
			{ "data" : "lunas_notes" },
			{ "data" : "user_id" },
			
			{
                "data": "id_piutang",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
						    return '<a onclick="showDetail('+data+')" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>'
                         }
            }
  			
        ]
     });

});

	tbldetail = $('.tabel-detail').DataTable({
         "bSort": false,
         "processing" : true,
         "paging" : false,
    	 "dom" : 'bti',
    });	

    
function showDetail(id){
	
//	alert("show detail "+id);
    $('#modal-detail').modal('show');
	
    tbldetail.ajax.url("/wawan/piutang/"+id+"/detail");
	tbldetail.ajax.reload();

}


</script>

@endsection
