<?php

namespace App;
use App\User;
?>

@extends('layouts.print')

@section('title')
  Print Invoice &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  	<a onclick="window.location='{{ route('home') }}'" class="btn btn-primary"><i class="fa fa-home"></i> Home </a>
	<a onclick="window.history.go(-1)" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	<a onclick="myFunction()" class="btn btn-success"><i class="fa fa-print"></i>Print Dokumen</a>

    <script>
        function myFunction() {
          window.print();
        }
    </script>	
@endsection

@section('breadcrumb')
   @parent
   <li>invoice</li>
   <li>print</li>
@endsection

@section('content')

<center>
    @if($msale->status_retur==1)
        <Font size="5">Invoice Penjualan</font>
    @else
        <Font size="5">RETUR/BS</font>
    @endif
</center>

<table style="width:90%">

<p>
	<tr><td width="65">Customer: </td><td width="600">{{ $customer->cus_name }}</td><td width='90'><strong>NO. Invoice:</strong></td><td><strong>{{ $msale->sale_no }}</strong></td></tr>
	<tr><td>Alamat:</td><td>{{ $customer->cus_address }}</td><td>Tgl. Inv:</td><td>{{ tanggal_indonesia($msale->sale_tgl, false) }}</td></tr>
</table>
<br>

<!-- <table class="table table-striped" style="width:90%"> -->
<table cellspacing="5" cellpadding="5" border="1" style="width:90%">

<tr>

	<th width="20" class="text-center">NO.</th>
	<th width="250">DESKRIPSI</th>
	<th width="60" class="text-center">Hg.Satuan</th>
	<th width="50" class="text-center">ISI</th>
	<th width="50" class="text-center">Qty</th>
	<th width="50" class="text-center">Disc</th>
	<th width="80" class="text-center">Jumlah</th>
</tr>

@foreach ($dsale as $list)
	
	<tr>
	    <td align="center" height="15">{{ $no++ }}</td>
    	<td>{{ $list->nama_brg }}</td>
    	<td align="right">{{ format_uang($list->harga_retail) }}</td>
    	<td align="center">{{ $list->isi }}</td>
    	<td align="center">{{ $list->qty }}</td>
    	<td align="center">{{ $list->potongan }}</td>
    	@if($list->type_brg==1)
    	<td align="right">{{ format_uang($list->harga_retail * $list->qty * $list->isi - $list->potongan ) }}</td>
    	@else
    	<td align="right">{{ format_uang($list->harga_retail * $list->isi - $list->potongan) }}</td> 
    	@endif
    </tr>
	
@endforeach

<!-- <tr><td></td><td align="right"><b>TOTAL Invoice</b></td><td></td><td></td><td></td><td></td><td align="right"><b>{{ format_uang($msale->sale_netto) }}</b></tr> -->
<tr><td></td><td align="right"><b>TOTAL Invoice</b></td><td></td><td></td><td></td><td></td><td align="right"><b>{{ format_uang($totalrp) }}</b></tr>

</table>
<br>
<table style="width:90%">
    <tr><td width="50"></td><td>{{ User::NamaUser($msale->user_id)->username }}</td><td width="150"></td><td>Mengetahui</td><td width="150">Tanda Terima</td></tr>
    
</table>

<h4>MAKSIMUM CICILAN : 5 Kali</h4>
@endsection