<!-- page menampilkan form historey invoice/ invoice posted -->

@extends('layouts.myform')

<head>
  
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   
  	<script type="text/javascript" src="/sbo/public/adminLTE/dist/css/sweetalert.min.js"></script>


</head>


@section('title')
 <table>

    <tr><td width="100"><b>Supplier</b></td><td><b>{{ $supplier->sup_id.' - '.$supplier->sup_nama }}</b></td></tr>
	<tr><td width="100"><b>Tgl. Invoice</b></td><td><b>{{ tanggal_indonesia($m_inv->inv_tgl, false) }}</b></td></tr>
	<tr><td width="100"><b>No. Invoice</b></td><td><b>{{ $m_inv->inv_no }}</b></td></tr>
	<tr><td width="100"><b>PPN / Disc</b></td><td><b>{{ $m_inv->inv_ppn.'%  /  '.$m_inv->inv_disc.'%' }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>invoice</li>
   <li>history</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-invoice" method="GET" id="form-invoice" action="/sbo/invoice/{{ $idinv }}/reprint">
{{ csrf_field() }}
  
  <input type="hidden" name="idinv" value="{{ $idinv }}">
  
	    <button id="submit" type="submit" class="btn btn-success pull-right simpan"><i class="fa fa-floppy-o"></i>Print Invoice </button>
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 
</form>
<br>

<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<div class="row">
    
<table class="table table-fixed table-striped table-bordered tabel-invdetail" id="invdetail">

<thead>
              
   <tr class="danger">
      <th width="20">No</th>
	  <th width="35">KODE</th>
      <th>Deskripsi</th>
	  <th>No.Serial</th>
      <th>Hg.Gross</th>
	  <th>QTY</th>
	  <th>Disc</th>
	  <th>Jumlah</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>

</form>

<div class="box-footer">
          
	<div class="col-md-8" align="right">
		<label>Sub Total&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;Rp.</label><br>
		<label>Disc Tambahan&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;Rp.</label><br>
		<label>P P N&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;Rp.</label><br><br>
		<label>Total Invoice Incl PPN&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;Rp.</label>
	</div>
	<div class="col-md-3">
		<div id="sub-total"	style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
		<div id="disc-spc" style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
		<div id="tampil-ppn" style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
		<div id="tampil-totalinv" style="background: DarkSlateGray; color: #fff; font-size: 28px; text-align: right; height: 45px"></div>
	</div>
	
	<div class="col-md-3">
		<form class="form form-horizontal form-rekapinv"> 
			{{ csrf_field() }}
			<input type="hidden" name="idinv" value="{{ $idinv }}">
			<input type="hidden" name="totalinv" id="totalinv">
			<input type="hidden" name="ppn" id="ppn" value="{{ $m_inv->inv_ppn }}">
			<input type="hidden" name="dis" id="dis" value="{{ $m_inv->inv_disc }}">
		</form>
	</div>          

</div>

                </div>
            </div>
        </div>
    </div>
</div>


@include('invoice_detail.form')

@endsection

@section('script')

<script type="text/javascript">
var table, table1, save_method;

$(function(){
  $('.tabel-produk').DataTable();
  table = $('.tabel-invdetail').DataTable({
      
     "scrollY": '40vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bt',
     "ajax" : {
     "url" : "{{ route('invoicedetail.data2') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
   loadForm($('#dis').val(), $('#ppn').val());
 });

});


function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/sbo/invoicedetail/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Detail Invoice');
       
       $('#id').val(data.id_inv);
	   $('#kdbrg').val(data.kode_brg).attr('readonly', true);
       $('#nama').val(data.nama_brg).attr('readonly', true);	   
       $('#noseri').val(data.no_seri).attr('readonly', true);
	   $('#gross').val(data.inv_gross).attr('readonly', true);
	   $('#disc1').val(data.inv_disc1).attr('readonly', true);
       $('#qty').val(data.inv_qty).attr('readonly', true);
	   
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

function inputForm(id){
   save_method = "add";
   $('input[name=_method]').val('PATCH');
   $('#modal-form_input form')[0].reset();

   $.ajax({
     url : "/sbo/invoicedetail/"+id+"/caribrg",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_input').modal('show');
       $('.modal-title').text('Input Detail Invoice');
       
       $('#idbrg').val(data.id);
	   $('#kdbrg_').val(data.kode_brg);
       $('#nama_').val(data.nama_brg);	   
       $('#gross_').val(data.harga_list);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}


/* mreferesh perubahan total po */

function loadForm(dis=0, ppn=0){
 // $('#totalpo1').val($('.totalpo1').text());
	
  $.ajax({
	   url : "/sbo/invoicedetail/loadform/"+dis+"/"+ppn+"/"+$('.totalinv').text(),
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#sub-total').text(data.subtotal);
			$('#disc-spc').text(data.discspc);
			$('#tampil-ppn').text(data.tlppn);
			$('#tampil-totalinv').text(data.totalinv);
       },
       error : function(){
         //alert("Tidak dapat menampilkan data total po !");
		 return false;
       }
  });
}
</script>

@endsection