@extends('layouts.app')


@section('title')

    <a onclick="printPDF()"  class="btn btn-danger"><i class="fa fa-file-pdf-o"></i> Print Tagihan</a>
    <a onclick="simpanTagihan()" class="btn btn-primary"><i class="fa fa-floppy-o"></i> Simpan </a>

    <label for="ukuran" class="col-md-2 control-label">TAGIHAN </label>
      <div class="col-md-2">
      <select id="ukuran" class="form-control" name="ukuran">
        <option value="1">Ukuran A4</option>
        <option value="2">Setengah A4</option>
      </select>
    </div>

  
@endsection

@section('breadcrumb')
   @parent
   <li>Tagihan</li>
@endsection

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Tagihan</title>

	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	
    <script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>  

        <style>
			.tbl_tgh {
			    position:absolute;
				top: 110px;
				left: 240px;
				width: 1100px;
				height: 485px;
			}
 
		</style>
			
</head>


@section('content')   

<div class="row">
    <div class="tbl_tgh">
        <div class="box">
		    <div class="box-body">  

<form method="post" id="form-bill">
{{ csrf_field() }}

       <label for="rt" class="col-md-1 control-label"><h4>Rute</h4></label>
        <div class="col-md-4">
          <select id="rute" type="text" class="form-control" name="rute" autofocus required>
            <option value=""> -- Pilih Rute -- </option>
            @foreach($rute as $list)
            <option value="{{ $list->id_route }}">{{ $list->route_name." - ".$list->driver." - ".$list->no_pol }}</option>
    		@endforeach	
           </select>
        </div>

<table class="table table-hover table-padding table-bordered" width="100%">
<thead>
   <tr class="tblheader">
      <th width="10px"><input type="checkbox" value="1" id="select-all"></th>   
	  <th width="25px">Rute</th>
 	  <th width="50px">Sopir</th>
      <th width="40px">No.Invoice</th>
	  <th width="30px">Tanggal</th>
      <th width="250px">Customer</th>
	  <th width="70px">TOTAL</th>
	  <th width="10px">Type</th>
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

            </div>
		</div>
	</div>	
</div>

@include('penjualan.printbill')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
    table = $('.table').DataTable({
        "scrollY": '52vh',
        "scrollCollapse": true,
     //   "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
        "paging": false,      
        "processing" : true,
        "serverside" : true,
        "ajax" : {
            "url" : "{{ route('penjualan.tagihan_hdr') }}",
            "type" : "GET"
            },
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false
        }],
        'order': [1, 'asc']     
   }); 
   
    $('#select-all').click(function(){
        $('input[type="checkbox"]').prop('checked', this.checked);
    });
   
})
   
function showData(id){
   save_method = "edit";

   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "penjualan/"+id+"/lihat",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Data Detail');
       
       $('#id').val(data.id_plist);
	   $('#supp').val(data.sup_kode.concat(' - ',data.sup_nama));
  	   $('#nama').val(data.list_sku.concat(' - ',data.sku_name));
	   $('#box').val(data.prc_box).attr('readonly', true);
       $('#pcs').val(data.prc_pcs).attr('readonly', true);
       $('#gross').val(data.prc_hrggross).attr('readonly', true);
	   $('#disc1').val(data.prc_disc1).attr('readonly', true);
	   $('#disc2').val(data.prc_disc2).attr('readonly', true);
	   $('#disc3').val(data.prc_disc3).attr('readonly', true);
	   $('#ppn').val(data.prc_ppn).attr('readonly', true);
	   $('#status').val(data.prc_status).attr('readonly', true);
	   $('#expd').val(data.list_exp).attr('readonly', true);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
   
}

function printBill(){
  if($('input:checked').length < 1){
    //alert('Pilih data yang akan dicetak!');
    swal("WARNING"," Pilih Invoice Tagihan yang mau dicetak !! ","info");
  }else{
    $('#form-bill').attr('target', '_blank').attr('action', "/wawan/penjualan/printbill").submit();       //--> open new windows
   // $('#form-bill').attr('action', "/wawan/penjualan/printbill").submit();
  }
}

function printPDF(){
    
    var ukur = $('#ukuran').val();
    var rute = $('#rute').val();
    
    if(rute==""){ 
        alert("rute harus dipilih ! ");
        return;
    }
    
    if($('input:checked').length < 1){
        //alert('Pilih data yang akan dicetak!');
        swal("WARNING"," Pilih Invoice Tagihan yang mau dicetak !! ","info");
    }else{
        $('#form-bill').attr('target', '_blank').attr('action', "/wawan/penjualan/printpdf/"+ukur+"/"+rute).submit();       //--> open new windows
   
    }
}

function simpanTagihan(){

    var rute = $('#rute').val();
    if(rute==""){ 
        alert("rute harus dipilih ! ");
        return;
    }
    
    if($('input:checked').length < 1){
        //alert('Pilih data yang akan dicetak!');
        swal("WARNING"," Pilih Invoice Tagihan yang mau disimpan !! ","info");
    }else{
        $.ajax({
            url : "/wawan/penjualan/"+rute+"/simpantagih",
            type : "GET",
            dataType: "JSON",
            data : $('#form-bill').serialize(),
            success : function(data){
                //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " Tagihan gagal disimpan !","error");
				 }else{
					swal("SUCCESS", " Tagihan berhasil disimpan ! ","success");
				 }
            },
                error : function(){
                alert("Tidak dapat menyimpan tagihan !");
            }
        });
    }
}

function exportPDF(){
	_url="/wawan/penjualan/pdf";
	window.open(_url,'_blank');		//open new tab
}

function printAll(){
  if($('input:checked').length < 1){
    alert('Pilih data yang akan dihapus!');
  }else if(confirm("Apakah yakin akan menghapus semua data terpilih?")){
     $.ajax({
       url : "/wawan/penjualan/printbill",
       type : "POST",
       data : $('#form-bill').serialize(),
       success : function(data){
         table.ajax.reload();
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}


function printBill2(){
    $('#modal-form_bill').modal('show');
    $('#modal-form_bill form')[0].reset();            
    $('.modal-title').text('Print Tagihan');
}

</script>

@endsection
