@extends('layouts.app')

@section('title')
	Daftar Stock&nbsp;&nbsp;&nbsp;
		<a onclick="window.location='{{ route('home') }}'" class="btn btn-warning"><i class="fa fa-home"></i> Home </a>		
@endsection

@section('breadcrumb')
   @parent
   <li>stock</li>
@endsection

<head>
    <title>Daftar Stock</title>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
 
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	<script type="text/javascript" src="public/adminLTE/dist/css/sweetalert.min.js"></script>

</head>


@section('content')   
<div class="row">
  <div class="col-xs-12">
    <div class="box">
      <div class="box-body">  


<form method="post" id="form-stock">
{{ csrf_field() }}

<table class="table table-striped table-bordered" id="stock">
<thead>
   <tr class="info">
      <th>Cbg</th>
      <th>ID</th>
      <th>Description</th>
      <th>NO.Seri</th>
      <th>desk</th>
      <th>Stock</th>
      <th>Opsi</th>
   </tr>
</thead>
<tbody></tbody>
</table>
</form>

    </div>
	</div>
	</div>
</div>	


@endsection

@section('script')


<script type="text/javascript">
var tbldetail;
$(document).ready(function() {
	var table = $('#stock').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('stock.getdata') }}",
        "columns":[
            { "data": "cbg_kode" },
            { "data": "product_id"},
            { "data": "nama_brg" },
            { "data": "no_seri" },
			{
				"data": "deskripsi",
				"visible": false,
				"searchable": true
			},
			{  "data" : "stock_akhir" },
			{
                "data": "id_stock",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
                       return '<a onclick="showDetail('+data+')" class="btn btn-primary btn-sm"><i class="fa fa-list"></i></a>'
                         }
            }
  			
        ]
     });

	tbldetail = $('.tabel-detail').DataTable({
	 "dom" : 'btp',
     "bSort" : false,
	 "retrieve" : true,	 
     "processing" : true
	 
    });	
		 
});

function showDetail(id){
	
    $('#modal-detail').modal('show');
	
    tbldetail.ajax.url("stock/"+id+"/lihat");
	tbldetail.ajax.reload();

}


</script>

@endsection