<!DOCTYPE html>

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<style>
		.tblheader {
			background: #2F4F4F;
			color: white;
			font-size: 15px;
			alignment: center;
		}
	</style>    
</head>

@extends('layouts.app')

@section('title')
  Data Stock
    <a onclick="addForm()" class="btn btn-success"><i class="fa fa-print"></i> Print Stock </a>
	<a onclick="window.location='{{ route('home') }}'" class="btn btn-warning"><i class="fa fa-home"></i> Home </a>			
@endsection

@section('breadcrumb')
   @parent
   <li>stock</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
      <div class="box-body">  

<!--
<form method="post" id="form-stock">
{{ csrf_field() }}
-->

<table class="table table-striped table-padding table-bordered" id="stock" style="background: #DCDCDC;" width="100%">
<thead>
	<tr class="tblheader">
		<th width="50px">No.</th>
		<th>Deskripsi</th>
		<th>Stock</th>
		<th width="50">Opsi</th>
    </tr>
</thead>
<tbody></tbody>
</table>

<!--</form>-->

      </div>
    </div>
  </div>
</div>

@include('stock.detail')

@endsection

@section('script')
<script type="text/javascript">
var  tbldetail;
$(function(){
   var table = $('#stock').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('stock.data') }}",
       "type" : "GET"
     }
   }); 
   
	tbldetail = $('.tabel-detail').DataTable({
     "bSort" : true,
	 "retrieve" : true,	 
     "processing" : true
	 
    });	   

});


function showDetail(id){
	
    $('#modal-detail').modal('show');
	
    tbldetail.ajax.url("stock/"+id+"/lihat");
	tbldetail.ajax.reload();

}

function detailForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "stock/"+id+"/detail",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Bahan');
       
       $('#id').val(data.id_bhn);
	   $('#kode').val(data.bhn_kode).attr('readonly', true);
       $('#nama').val(data.bhn_name);

       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

</script>
@endsection

