@extends('layouts.app')


@section('title')
    Unposting Penjualan
@endsection

@section('breadcrumb')
   @parent
   <li>Unposting Penjualan</li>
@endsection


@section('content')   
<div class="row">
	<div class="col-sm-12">
		<div class="box">
			<div class="box-body">  

<form method="post" id="form-penjualan">
{{ csrf_field() }}


<table class="table table-striped table-padding table-bordered" id="tblpenjualan" width="100%">
<thead>
   <tr class="tblheader">
   
 	    <th width="5%">Rute</th>
        <th width="15%">No.Invoice</th>
	    <th width="10%">Tanggal</th>
        <th width="35%">Customer</th>
        <th width="10%">TOTAL</th>
        <th width="15%">User</th>
        <th width="5%"></th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>


@endsection

@section('script')
<script type="text/javascript">
var table, save_method;


$(function(){
   table = $('#tblpenjualan').DataTable({
     "processing" : true,
     "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
     "dom": "bftip",
     "ajax" : {
       "url" : "{{ route('penjualan.data_unpost') }}",
       "type" : "GET"
     }
   }); 
})

function unPosting(id){
   if(confirm("  Apakah yakin Invoice akan di-Unposting ?  ")){
     $.ajax({
       url : "{{ DIR_APP }}penjualan/"+id+"/unposting",
       type : "GET",
       dataType : "JSON",
       success : function(data){
            //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " Invoice Gagal di-Unposting !","error");
				 }else{
					swal("SUCCESS", " Unposting Invoice berhasil ! ","success");
					table.ajax.reload();	
				 }
       },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			}   
         });
       return false;
	}
}


</script>


@endsection
