@extends('layouts.app')


@section('title')
	
	<tr><td width="80">Penjualan & Retur &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ tanggal_indonesia(date('Y-m-d'),false) }}</td>
    	&nbsp;&nbsp;&nbsp;
    	<a onclick="addForm()" class="btn btn-success"><i class="fa fa-plus-circle"> </i> New Transaksi </a> 
    	<a onclick="printDO()" class="btn btn-warning"><i class="fa fa-print"> </i> Print DO Keluar </a>
 
	</tr>	
@endsection

@section('breadcrumb')
   @parent
   <li>Penjualan & Retur</li>
@endsection


@section('content')   
<div class="row">
	<div class="col-sm-12">
		<div class="box">
			<div class="box-body">  

<form method="post" id="form-penjualan">
{{ csrf_field() }}

<input type="hidden" id="mgr" name ="mgr" value="{{ Auth::user()->group }}"> 

<table class="table table-striped table-padding table-bordered" id="tblpenjualan" width="100%">
<thead>
   <tr class="tblheader">
   
 	    <th width="25">Rute</th>
 	    <th width="40">Sopir</th>
        <th width="30">No.Invoice</th>
	    <th width="30">Tanggal</th>
        <th width="125">Customer</th>
        <th width="70">TOTAL</th>
        <th width="20">TYPE</th>
        <th width="40">User</th>
        <th width="3"></th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('penjualan.penjualan_create')
@include('penjualan.penjualan_do')
@include('penjualan.rutelist')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method, mgr;

mgr = $('#mgr').val();

$(function(){
   table = $('#tblpenjualan').DataTable({
     "processing" : true,
//     "iDisplayLength": 8,
     "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
     "order" : [3,'DESC'],
     "ajax" : {
       "url" : "{{ route('penjualan.header') }}",
       "type" : "GET"
     }
   }); 
   
 	tblrute = $('.tabel-rute').DataTable({
        "scrollY": '55vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bt',
    });
    
//submit
	  //$(document).on("submit", function(e) {
      $('#modal-form_create').on("submit", function(e) {	      
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan Create ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('penjualan.store') }}";
         else url = "penjualan/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form_create form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#cus').focus().select();
				 }else{
					$('#modal-form_create').modal('hide');
					swal("SUCCESS", " Transfer baru berhasil dicreate ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
				 }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
   
/*--- submit edit header ---*/   

	  $('#modal-form_edit').on("submit", function(e) {
      if(!e.isDefaultPrevented()){
		 //alert('edit header');
		 $('#submit-edit').html(' Simpan Edit ... ');
		 $('#submit-edit').attr('disabled','disabled');
		  
         var id = $('#id').val();
         url = "penjualan/"+id+"/editheader";

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form_edit form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				 if(data.msg=="error"){
					$('#submit-edit').html('Save');
					$('#submit-edit').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#rute2').focus().select();
				 }else{
					$('#modal-form_create').modal('hide');
					swal("SUCCESS", " Edit berhasil disimpan ! ","success");
					$('#submit-edit').html('Save');
					$('#submit-edit').removeAttr('disabled');					
					table.ajax.reload();
				 }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-edit').html('Save');
			 $('#submit-edit').removeAttr('disabled');			 
			}   
         });
       return false;
	 }
});       
   
})  
/*-------------------------------------------------*/

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form_create').modal('show');
   $('#modal-form_create form')[0].reset();            

   $('#cus').removeAttr('disabled');
   $('#tipe').removeAttr('disabled');
   
   if(mgr=="MANAGER")
   {
       $('#tgltrx').removeAttr('disabled');  
   }else{
       $('#tgltrx').attr('readonly', true);  }
} 	 

function batal(id){
   if(confirm("  Apakah yakin Invoice akan dibatalkan ?  ")){
     $.ajax({
       url : "/wawan/penjualan/"+id+"/batal",
       type : "GET",
       dataType : "JSON",
       success : function(data){
            //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " Invoice Gagal dibatalkan karena masih ada transaksi !","error");
				 }else{
					swal("SUCCESS", " Pembatalan Invoice berhasil ! ","success");
					table.ajax.reload();	
				 }
       },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			}   
         });
       return false;
	}
}

function editHeader(id){
   save_method = "edit";

   $('input[name=_method]').val('PATCH');
   $('#modal-form_create form')[0].reset();
   $.ajax({
     url : "/wawan/penjualan/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_create').modal('show');
       $('.modal-title').text('Edit Header');
       
       $('#id').val(data.id_sale);
	   
       $('#tipe').val(data.status_retur).attr('disabled','disabled');
       $('#cus').val(data.cust_id).attr('disabled', 'disabled');
	   $('#rute').val(data.sale_route);
	   $('#nmrute').val(data.route_name.concat(' - ',data.no_pol.concat(' - ',data.driver)));
	   $('#tgltrx').val(data.sale_tgl);
	   
       if(mgr=="MANAGER")
       {
           $('#tgltrx').removeAttr('disabled');  
       }else{
           $('#tgltrx').attr('readonly', true);  }	   

     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
}


function printDO(){
    $('#modal-form_do').modal('show');
    $('#modal-form_do form')[0].reset();            
    //$('.modal-title').text('Print DO Keluar');
}

</script>


@endsection
