@extends('layouts.app')

<head>

    <style>
        .dataTables_wrapper .dataTables_length { display:none; }
        .dataTables_wrapper .dataTables_filter { margin-top:-20px; }
    </style>
    
</head>

@section('title')
	
	<tr><td width="80">History Tagihan</td></tr>	
@endsection

@section('breadcrumb')
   @parent
   <li>history tagihan</li>
@endsection


@section('content')   
<div class="row">
	<div class="col-sm-12">
		<div class="box">
			<div class="box-header"></div>
				<div class="box-body">  

		<label for="prd" class="col-md-1 control-label">Periode</label>
		<div class="col-md-3">
			<input id="awal" type="date" class="form-control" name="awal" value="{{ date('Y-m-d', strtotime("-35 day", strtotime(date('Y-m-d')))) }}" autofocus required>
		</div>
		<div class="col-md-3">
			<input id="akhir" type="date" class="form-control" name="akhir" value="{{ date('Y-m-d') }}" autofocus required>
		</div>

		<div class="col-md-4"> 
			<button type="button" class="btn btn-primary btn-sm" onclick="showData()"><i class="fa fa-table"></i> View </button>
		</div>


<table class="table table-striped table-padding table-bordered" id="history"  width="100%">
<thead>
   <tr class="tblheader">
   
	  <th>Tanggal</th>
      <th>Deskripsi</th>
	  <th>User</th>
      <th width="50">opsi</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>

			</div>
		</div>
	</div>	
</div>

@include('penjualan.tagihan_list')
@include('penjualan.tagihan_add')

@endsection


@section('script')
<script type="text/javascript">

showData();

function showData(){
    
    var tgl1=$('#awal').val();
    var tgl2=$('#akhir').val();
    
    $(document).ready(function(){
        var table=$('#history').DataTable({
         "processing" : true,
         "destroy" : true,
         "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
         "ajax" : {
           "url" : "{{ DIR_APP }}penjualan/"+tgl1+"/"+tgl2+"/tagihan_hist",
           "type" : "GET"
         }
       }); 
    });  
}

	tbldetail = $('.tabel-detail').DataTable({
         "bSort": false,
         "processing" : true,
    	 "dom" : 'btp',
    });	
    
    tbldetail2 = $('.tabel-detail2').DataTable({
        "scrollY": '60vh',
        "scrollCollapse": true,
        "paging": false,      
        "processing" : true,
        "serverside" : true,        
        "bSort": true,
        "processing" : true,
    	"dom" : 'bt',
    });	
    

function showDetail(id){
    
    $('#detail_hist').modal('show');
	$('#idtagih').val(id);
	
    tbldetail.ajax.url("/wawan/penjualan/"+id+"/histtagihan_detail");
	tbldetail.ajax.reload();

}

function addList(){
    var idbill = $('#idtagih').val();   
    
    $('#detail_add').modal('show');

    tbldetail2.ajax.url("/wawan/penjualan/"+idbill+"/tagihan_add");
	tbldetail2.ajax.reload();

}


function simpanAdd(){
    
    var idbill = $('#idtagih').val();  

    if($('input:checked').length < 1){
        //alert('Pilih data yang akan dicetak!');
        swal("WARNING"," Pilih Invoice Tagihan yang mau disimpan !! ","info");
    }else{
        $.ajax({
            url : "/wawan/penjualan/"+idbill+"/simpantagih_add",
            type : "POST",
            dataType: "JSON",
            data : $('#form-addbill').serialize(),
            success : function(data){
                //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " Tagihan gagal disimpan !","error");
				 }else{
				    $('#detail_add').modal('hide');
					tbldetail.ajax.reload();
					$('#modal_hist').focus().select();
				 }
            },
                error : function(){
                alert("Tidak dapat menyimpan tagihan !");
            }
        });
    }
}

/* modul delete */
function delItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/wawan/penjualan/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         tbldetail.ajax.reload();
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

function reprint(){
    var idbill = $('#idtagih').val();  
    $('#form-listbill').attr('target', '_blank').attr('action', "/wawan/penjualan/"+idbill+"/reprint").submit();       //--> open new windows
}

function delHist(id){
   if(confirm("  Apakah yakin menghapus History ?  ")){
     $.ajax({
       url : "/wawan/penjualan/"+id+"/delhistory",
       type : "GET",
       dataType : "JSON",
       success : function(data){
            //alert('berhasil dibatalkan ')
				 if(data.msg=="error"){
					swal("WARNING", " History Gagal dihapus karena masih ada transaksi !","error");
				 }else{
					swal("SUCCESS", " Hostory berhasil dihapus ! ","success");
					$('#history').DataTable().ajax.reload();
					//table.ajax.reload();	
				 }
       },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat diproses, harap hubungi IT !","error");
			}   
         });
       return false;
	}
}


</script>

@endsection
