<!DOCTYPE html>
<html>
@extends('layouts.app')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
	
	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>
	
	<style>
		
			.tbl_kms {
			    position:absolute;
				top: 100px;
				left: 240px;
				width: 37%;
				height: 520px;
			}				

			.tbl_stn {
			    position:absolute;
				top: 100px;
				right: 10px;
				width: 43%;
				height: 475px;
			}	
			
			.wrap {
			  width: 50%;
			  display: inline-block;
			  margin: 10px;
			}
			
		
			.tblheader {
				background: #2F4F4F;
				color: white;
				font-size: 15px;
				alignment: center;
			}

	</style>


</head>

@section('title')

  Mutasi Stock Kemasan -> Satuan

@endsection

<!------------------>

@section('content')
<div class="row">
    <div class="tbl_kms">
        <div class="box">
            <div class="box-body">
                
<table class="table table-striped table-padding table-bordered" id="tbl-stock0" width="100%">
<thead>
   <tr class="tblheader">
   
      <th width="65%">Deskripsi</th>
      <th width="15%">Tgl.Invoice</th>
	  <th width="15%">STOCK</th>
      <th width="5%">opsi</th> 	  
 
	</tr>
</thead>

<tbody></tbody>	 

</table>
            </div>
        </div>
    </div>
</div>

<!----------------------------------------->

<div class="row">
    <div class="tbl_stn">
        <div class="box">
            <div class="box-body">
<table class="table table-striped table-padding table-bordered" id="tbl-stock1"  width="100%">
<thead>
   <tr class="tblheader">
      <th>Tanggal</th>
      <th>Barang Asal</th>
 	  <th>Barang Tujuan</th>
	  <th>QTY/Tons</th>
	  <th>User</th>
	</tr>
</thead>

<tbody></tbody>	 

</table>
            </div>
        </div>
    </div>
</div>

@include('mutasi.form')

@endsection

<!-------------------------------->

@section('script')

<script type="text/javascript">
var table, tbl_stock, save_method, table1;

// type barang kemasan
	jQuery(document).ready(function($){
	table = $('#tbl-stock0').DataTable({
        "scrollY": '60vh',
        "scrollCollapse": true,
        "paging": false,
        "processing" : true,
	    "searching" : false,
	    "destroy" : true,
	    "dom" : 'bti',	 
        "ajax" : {
            "url" : "mutasi/data",
            "type" : "GET"
            }
        });
    });
    
// type barang satuan
	jQuery(document).ready(function($){
	table1 = $('#tbl-stock1').DataTable({
        "scrollY": '55vh',
        "scrollCollapse": true,
        "paging": false,
        "processing" : true,
	    "searching" : true,
	    "destroy" : true,
	    "dom" : 'fbti',	 
        "ajax" : {
            "url" : "mutasi/data1",
            "type" : "GET"
            }
        });
    });

//submit
	  //$(document).on("submit", function(e) {
      $('#modal-form').on("submit", function(e) {	      
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan Mutasi ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('mutasi.store') }}";
         else url = "mutasi/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#qty').focus().select();
				 }else{
					$('#modal-form').modal('hide');
					swal("SUCCESS", " Mutasi Stock berhasil disimpan ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
					table1.ajax.reload();
				 }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
   

function MutasiForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "mutasi/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
		 
		 if(data.child_to > 0){
		   $('#modal-form').modal('show');
		   $('.modal-title').text('Mutasi Stock');
		   
		   $('#id').val(data.id_inv);
		   $('#brg1').val(data.id_brg);
		   $('#brg').val(data.nama_brg);
		   $('#brg2').val(data.child_to);
		   $('#brg2').attr('disabled','disabled');
		 }else{
			swal("WARNING", " Produk ini tidak ada turunan, tidak bisa mutasi !","warning");
		 };
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


</script>

@endsection
</html>