<head>
    <style>
        th, td,tr { height:35px;
            border:none;
            border-bottom:1px grey solid;
            font-size:14px; font-weight:normal; 
        }
        
        th {font-size:15px; font-weight:normal; border-top:1px grey solid; }
        
    </style>
</head>

@extends('layouts.app')

@section('title')
	Master Variant
@endsection

@section('breadcrumb')
   @parent
   <li>Master Variant</li>
@endsection

@section('content')     
    
<div class="row">
    
    <div class="col-xs-12 col-md-12 col-sm-12">
        <div class="box" style="border-top:1px black solid;border-radius:2px;">
            <div class="box-body"> 
            
<section id="tbl-data" class="show">      
    
    <a onclick="addForm()" class="btn btn-success"><i class="fa fa-plus-circle"></i> New Variant </a>&nbsp;
    
    <table "table table-hover table-bordered table-padding table-responsive" id="tbl-variant" width="100%">
        <thead>
            <tr>
                <th width="5%">Variant</th>
                <th width="10%">KODE</th>
                <th width="50%">Deskripsi</th>
                <th width="8%">action</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>

</section>

<section id="form-data" class="hide">
    
    <form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
    {{ csrf_field() }} {{ method_field('POST') }}
    
    <span><a onclick="tutupForm()" class="btn btn-flat pull-right" id="xclose"> X </a></span>
        
    <h4>Master Variant</h4>    
   
    <div class="col-sm-2 col-md-2 col-xs-0"></div>
    
    <div class="col-sm-8 col-md-8 col-xs-12">
   
        <input type="hidden" id="id" name="id">
        <input type="hidden" id="tpvar"name="tpvar" value="1">
        
        <div style="margin-left:200px; font-size:3vh">   
            Type Variant&nbsp;&nbsp;&nbsp;&nbsp;
            <input type="radio" id="color" name="variant" checked>
            <label> COLOR</label>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <input type="radio" id="size" name="variant">
            <label> SIZE</label><br>
        </div>   

        <div class="form-group">
            <label for="nama">KODE</label>
            <input type="text" id="kode" name="kode" maxlength="10" class="form-control" autofocus autocomplete="off" required>
            <small class="text-muted">Kode Variant max. 10kar</small>
        </div>
         
        <div class="form-group">
            <label for="nama">Deskripsi</label>
            <input type="text" id="nama" name="nama" class="form-control" autofocus autocomplete="off" required>
        </div>

        <br>
        <div class="form-group">
            <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
            <button id="tutup" onclick="tutupForm()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
        </div>
        
    </div>
        
    </form>  

</section>
<!------------------->
           </div>
        </div>    
    </div>
</div>

@endsection

<!-------------------------------------------------------->
@section('script')
<script type="text/javascript">
var  save_method, table, tblinput;


$(function(){
   table = $('#tbl-variant').DataTable({
     "processing" : true,
     "order": [[0,'ASC']],
     "language": {
         "searchPlaceholder": "Search" },   // Placeholder for the search box     
     "ajax" : {
         "url" : "{{ route('master.datavariant') }}",
         "type" : "GET"
      }
   }); 
})

/*** new Driver ***/
    $('#form-input').on('submit', function(e){
        if(!e.isDefaultPrevented()){
            var id = $('#id').val();
            if(save_method == "add"){ url = "{{ route('master.simpanvariant') }}"; tipe="POST"; }
            else { url = "{{ DIR_APP }}master/"+id+"/simpaneditvariant"; tipe="GET"; }
         
        $.ajax({
            url : url,
            type : tipe,
            data : $('#form-input').serialize(),
            dataType: 'JSON',		   
            success : function(data){
               
                if(data.msg=="error"){
                    swal("WARNING", " Gagal menyimpan data !","error");
                    
                }else{
                    tutupForm();
                    $('#tbl-variant').DataTable().ajax.reload();
                }   
 		    },
                error : function(){
			        swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
                }   
            });
        return false;
	    }
    });


function editForm(id){
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $.ajax({
        url : "{{ DIR_APP }}master/"+id+"/editvariant",
        type : "GET",
        dataType : "JSON",
        success : function(data){
        
            bukaForm();
        
            $('#id').val(data.id);
            $('#kode').val(data.variant_kode);
            $('#kode').attr('readonly', true);
            $('#nama').val(data.variant_name);

            if(data.varian_init=="CL"){
                $('#color').is(':checked');
            }else{
                $('#size').is(':checked');
            }
        },
            error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });
} 

/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
   
    document.getElementById("form-input").reset();
    $('#kode').attr('readonly', false)
}


function tutupForm(){
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

    document.getElementById("form-input").reset();
}

function bukaForm(){
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}   

$('#color').on('change', function(){
    if($('#color').is(':checked')) { $('#tpvar').val(1); }
})

$('#size').on('change', function(){
    if($('#size').is(':checked')) { $('#tpvar').val(2); }
})

</script>
@endsection