@extends('layouts.app')

@section('title')
	Master Mobil&nbsp;&nbsp;&nbsp;
	
    <a onclick="addForm()" class="btn btn-success"><i class="fa fa-plus-circle"></i> New Mobil </a>&nbsp;
	
@endsection

@section('breadcrumb')
   @parent
   <li>Master Mobil</li>
@endsection

@section('content')     
    
<div class="row">
    
    <div class="col-xs-12 col-md-12 col-sm-12">
        <div class="box" style="border-top:2px black solid;border-radius:5px;">
            <div class="box-body"> 
            
<section id="tbl-data" class="show">      

    <table class="table table-hover table-bordered table-padding table-responsive" id="tbl-mobil" width="100%">
        <thead>
           <tr class="tblheader">
              <th width="10%">NO.</th>
              <th width="50%">NO.Polisi</th>
              <th width="8%">action</th>
           </tr>
        </thead>
        <tbody></tbody>
    </table>

</section>

<section id="form-data" class="hide">
    
    <form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
    {{ csrf_field() }} {{ method_field('POST') }}
    
    <span><a onclick="tutupForm()" class="btn btn-flat pull-right" id="xclose"> X </a></span>
        
    <h6>Master Driver</h6>    
   
    <div class="col-sm-2 col-md-2 col-xs-0"></div>
    
    <div class="col-sm-8 col-md-8 col-xs-12">
   
        <input type="hidden" id="id" name="id">
         
        <div class="form-group">
            <label for="nama">No. Polisi</label>
            <input type="text" id="nopol" name="nopol" class="form-control" autofocus autocomplete="off" required>
        </div>

        <br>
        <div class="form-group">
            <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
            <button id="tutup" onclick="tutupForm()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
        </div>
        
    </div>
        
    </form>  

</section>
<!------------------->
           </div>
        </div>    
    </div>
</div>

@endsection

<!-------------------------------------------------------->
@section('script')
<script type="text/javascript">
var  save_method, table, tblinput;


$(function(){
   table = $('#tbl-mobil').DataTable({
     "processing" : true,
     "order": [[1,'DESC']],
     "language": {
         "searchPlaceholder": "Search" },   // Placeholder for the search box     
     "ajax" : {
         "url" : "{{ route('master.datamobil') }}",
         "type" : "GET"
      }
   }); 
})

/*** new Driver ***/
    $('#form-input').on('submit', function(e){
        if(!e.isDefaultPrevented()){
            var id = $('#id').val();
            if(save_method == "add"){ url = "{{ route('master.simpanmobil') }}"; tipe="POST"; }
            else { url = "{{ DIR_APP }}master/"+id+"/simpaneditmobil"; tipe="GET"; }
         
        $.ajax({
            url : url,
            type : tipe,
            data : $('#form-input').serialize(),
            dataType: 'JSON',		   
            success : function(data){
               
                if(data.msg=="error"){
                    swal("WARNING", " Gagal menyimpan data !","error");
                    
                }else{
                    tutupForm();
                    $('#tbl-mobil').DataTable().ajax.reload();
                }   
 		    },
                error : function(){
			        swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
                }   
            });
        return false;
	    }
    });


function editForm(id){
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $.ajax({
        url : "{{ DIR_APP }}master/"+id+"/editmobil",
        type : "GET",
        dataType : "JSON",
        success : function(data){
        
            bukaForm();
        
            $('#id').val(data.id);
            $('#nopol').val(data.no_pol);
        },
            error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });
} 

/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
   
    document.getElementById("form-input").reset();
}


function tutupForm(){
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

    document.getElementById("form-input").reset();
}

function bukaForm(){
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}   



</script>
@endsection