<!DOCTYPE html>

<html lang="{{ config('app.locale') }}">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>{{ config('app.name', 'MMS') }}</title>
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  
  <link rel="stylesheet" href="{{ asset('public/adminLTE/bootstrap/css/bootstrap.min.css') }}">
  <link rel="stylesheet" href="{{ asset('public/font-awesome/css/font-awesome.min.css') }}">
  <link rel="stylesheet" href="{{ asset('public/adminLTE/dist/css/AdminLTE.min.css') }}">
  <link rel="stylesheet" href="{{ asset('public/adminLTE/dist/css/skins/skin-purple.min.css') }}">
  <link rel="stylesheet" href="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.css') }}">
  <link rel="stylesheet" href="{{ asset('public/adminLTE/plugins/datepicker/datepicker3.css') }}">
  
	<script type="text/javascript" src="public/adminLTE/dist/css/sweetalert.min.js"></script>  
</head>

<body class="hold-transition skin-purple  sidebar-mini">
<div class="wrapper">

   <!-- Header -->
  <header class="main-header">

    <a href="#" class="logo">
		<span class="logo-mini"><b>MMS</b></span> 
		<span class="logo-lg"><b>Merchandise</b>System</span> 
    </a>


    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>
      
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
         
          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                <img src="{{ asset('public/images/admin.png') }}" class="user-image" alt="User Image">
                <span class="hidden-xs">{{ Auth::user()->username }}</span>
            </a>
            <ul class="dropdown-menu">
                <li class="user-header">
                    <img src="{{ asset('public/images/admin.png') }}" class="img-circle" alt="User Image">

                    <p>
                      {{ Auth::user()->username }}
					  {{ Auth::user()->group }}
                    </p>
                </li>
                <li class="user-footer">
                    <div class="pull-left">
                        <a class="btn btn-default btn-flat" href="{{ route('user.profil') }}">Edit Profil</a>
                    </div>
                    <div class="pull-right">
                        <a class="btn btn-default btn-flat" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"> Logout
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            {{ csrf_field() }}
                        </form>
                    </div>
                </li>

            </ul>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <!-- End Header -->


  <!-- Sidebar -->
  <aside class="main-sidebar">

    <section class="sidebar">
      <ul class="sidebar-menu">
        <li class="header">MENU NAVIGATION</li>

        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> <span>Dashboard</span></a></li>

		<li class="treeview">
		  <a href="#"><i class="fa fa-object-group"></i> <span>Grouping</span> <i class="fa fa-angle-down pull-right"></i></a>
		    <ul class="treeview-menu">
				<li><a href="{{ route('divisi.index') }}"><i class="fa fa-list-alt"></i> <span>Divisi</span></a></li>
				<li><a href="{{ route('department.index') }}"><i class="fa fa-th-list"></i> <span>Department</span></a></li>
				<li><a href="{{ route('category.index') }}"><i class="fa fa-cogs"></i> <span>Category</span></a></li>
				<li><a href="{{ route('brand.index') }}"><i class="fa fa-btc"></i> <span>Brand</span></a></li>
				<li><a href="{{ route('generic.index') }}"><i class="fa fa-columns"></i> <span>Generic Category</span></a></li>
			</ul>
		</li>	  

		<li class="treeview">
		  <a href="#"><i class="fa fa-paste"></i> <span>Master</span> <i class="fa fa-angle-down pull-right"></i></a>
		    <ul class="treeview-menu">
				<li><a href="{{ route('product.index') }}"><i class="fa fa-cubes"></i> <span>Master Barang/SKU</span></a></li>
				<li><a href="{{ route('home') }}"><i class="fa fa-barcode"></i> <span>Master Barcode</span></a></li>
				<li><a href="{{ route('supplier.index') }}"><i class="fa fa-truck"></i> <span>Master Supplier</span></a></li>
				<li><a href="{{ route('pilihproduct.index') }}"><i class="fa fa-user"></i> <span>Master Buyer</span></a></li>
				<li><a href="{{ route('origin.index') }}"><i class="fa fa-globe"></i> <span>Master Origin/Asal Produk</span></a></li>
				<li><a href="{{ route('toko.index') }}"><i class="fa fa-bank"></i> <span>Master Store</span></a></li>
			</ul>
		</li>	 

		<li class="treeview">
		  <a href="#"><i class="fa fa-dollar"></i> <span>Price Management</span> <i class="fa fa-angle-down pull-right"></i></a>
		    <ul class="treeview-menu">
				<li><a href="{{ route('price.index') }}"><i class="fa fa-money"></i> <span>Selling Price</span></a></li>
				<li><a href="{{ route('pricelist.index') }}"><i class="fa fa-tag"></i> <span>Price List Supplier</span></a></li>
				<li><a href="{{ route('home') }}"><i class="fa fa-percent"></i> <span>Promotion</span></a></li>
			</ul>
		</li>	

 		<li class="treeview">
		  <a href="#"><i class="fa fa-shopping-cart"></i> <span>Purchasing (PO)</span> <i class="fa fa-angle-down pull-right"></i></a>
		    <ul class="treeview-menu">
				<li><a href="{{ route('home') }}"><i class="fa fa-edit"></i> <span>PO Type A</span></a></li>
				<li><a href="{{ route('home') }}"><i class="fa fa-copy"></i> <span>PO Type B</span></a></li>
			</ul>
		</li>	
		
	  	<li><a href="{{ route('user.index')        }}"><i class="fa fa-user"></i> <span>User</span></a></li>   
        <li><a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
			<i class="fa fa-sign-out"></i><span>Logout </span></a></li>

      </ul>
    </section>
  </aside>
  <!-- End Sidebar -->

  <!-- Content  -->
  <div class="content-wrapper">
  <section class="content-header"> 
      <h4>
        @yield('title')
      </h4>
      <ol class="breadcrumb">
        @section('breadcrumb')
        <li><a href="#"><i class="fa fa-home"></i>Home</a></li>
        @show
      </ol>
   </section> 

    <section class="content">
        @yield('content')
    </section>
  </div>
  <!-- End Content -->

  <!-- Footer -->

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      Merchandise Management System
	</div>
       <strong>Copyright &copy; 2019 <a href="#">JM Group</a>.</strong> All rights reserved.
  </footer>
  <!-- End Footer -->
 
<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/dist/js/app.min.js') }}"></script>

<script src="{{ asset('public/adminLTE/plugins/chartjs/Chart.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script src="{{ asset('public/js/validator.min.js') }}"></script>

@yield('script')

</body>
</html>