<!DOCTYPE html>
<!-----project : otman --------->

<html lang="{{ config('app.locale') }}">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ config('app.name', 'MyProject') }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
 
    <link rel="stylesheet" href="{{ asset('public/adminLTE/bootstrap/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('public/font-awesome/css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('public/adminLTE/dist/css/AdminLTE.min.css') }}">
    <link rel="stylesheet" href="{{ asset('public/adminLTE/dist/css/skins/skin-black-light.min.css') }}">
    <link rel="stylesheet" href="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('public/adminLTE/plugins/datepicker/datepicker3.css') }}">

	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>  
	<script type="text/javascript" src="{{ DIR_APP }}public/adminLTE/dist/css/sweetalert.min.js"></script> 
 
	<script src="https://js.pusher.com/4.1/pusher.min.js"></script>
	
	@if(Auth::user()->group=="MANAGER" || Auth::user()->group=="IT")
	  <script>
		var pusher = new Pusher('{{env("MIX_PUSHER_APP_KEY")}}', {
		  cluster: '{{env("PUSHER_APP_CLUSTER")}}',
		  encrypted: true
		});

		var channel = pusher.subscribe('notify-channel');
		channel.bind('App\\Events\\Notify', function(data) {
		  //alert(data.message);
		  swal('Pusher', data.message,'info');
		});
		
	  </script>	
	@endif    
    

    <style>
          ::-webkit-scrollbar {
				width: 3px;
			}

			::-webkit-scrollbar-track {
				-webkit-box-shadow: inset 0 0 6px rgba(0,0,255,0.3); 
				border-radius: 10px;
			}

			::-webkit-scrollbar-thumb {
				border-radius: 10px;
				-webkit-box-shadow: inset 0 0 6px rgba(0,0,255,0.9); 
			}

        #menuUtama { font-size : 13px; }
        #menuUtama a:hover { 
            border-left: 2px rgb(53, 88, 247) solid; 
            background : rgb(217, 242, 243) ;
        }
      
        .tblheader {
 			background: #2F4F4F;
			color: white;
			font-size: 15px;
			alignment: center;           
        }
		
        .notification {
          background-color: blue;
          color: white;
          text-decoration: none;
          padding: 7px 11px;
          position: absolute;
          top: 60px;
          right:80px;
          display: inline-block;
          border-radius: 2px;
        }
        
        .notification:hover {
          background: yellow;
        }
        
        .notification .badge {
          position: absolute;
          top: -4px;
          right: -10px;
          padding: 4px 7px;
          border-radius: 50%;
          background-color: red;
          color: white;
        }
        
        .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_page,        
        .dataTables_wrapper .ui-button {
            font-size:14px;
            padding: 0px;
            }
        
        /* change "height" caused by exaggerated padding */
        .dataTables_wrapper .ui-toolbar {
                padding: 0px;
            }        
            
        
        .btn-group-xs > .btn, .btn-xs {
              padding: .25rem .4rem;
              font-size: .875rem;
              line-height: .5;
              border-radius: .2rem;
              margin-top:-5px;
              margin-bottom:-4px;

            }
        
        .btn-outline-info, .btn-outline-warning, .btn-outline-success { 
                border:1px black solid;
                font-size: 2vh;
                margin-top:-7px;
                margin-bottom:-5px;
                padding:3px 7px;
            }
        
        .btn-success, .btn-danger, .btn-primary, .btn-warning, .btn-info {border:1px solid black; color:black; background-color:white;}
        
        .btn-success:hover {background-color: #90EE90; }
        .btn-primary:hover {background-color: #87CEEB; }
        .btn-danger:hover { background-color: #F08080; }
        .btn-warning:hover { background-color: #FFA07A; }
        .btn-info:hover { background-color: #DDA0DD; }
        
        .table-hover tbody tr:hover td, .table-hover tbody tr:hover th {
             background-color: #98FB98;
            }
            
        .table-bordered { border: .01rem #E6E6FA solid; }
        
        .table td { 
                padding: -4px 10px; 
                font-size: 15px;
                border: .02rem black solid;
            }      
            
        .table tr { height:13px; padding: -4px 10px;}

        .table th { padding 0.2rem 2rem; font-size:15px; 
                background-color:#008080;
                color:white;height:21px;
                border: .02rem #E6E6FA solid;
            }
            

        .table {border-collapse: collapse; border: .02rem #E6E6FA solid;}
        
        .table tbody {
            padding:-0.2rem 2rem; 
            font-size: 15px;
        } 
        
        .modal .table td { 
              font-size:15px;
              padding:3px 6px;
            }  
            
         label {
             font-family: Verdana, Arial, Helvetica, sans-serif;
             font-size: small;
         }
         input[type="text"] {
             font-size: 13px;
         }         
         select[type="text"]{
             font-size: 13px;
         }         
         textarea[type="text"] {
             font-size: 13px;
         }                 


        .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_page,        
        .dataTables_wrapper .ui-button {
            font-size:12px;
            padding: 10px 10px 10px 10px;
            }
        
        /* change "height" caused by exaggerated padding */
        .dataTables_wrapper .ui-toolbar {
                padding: 10px 10px 10px 10px;
            }
        
        .dataTables_wrapper .dataTables_filter label { font-size:0px;  }
        .dataTables_wrapper .dataTables_filter input { font-size:12px; width:100%; margin-bottom:-25px; margin-top:-35px;}
        .dataTables_wrapper .dataTables_paginate { font-size:12px; }
        
        .dataTables_wrapper .dataTables_length select {
            width:75px;
            font-size:15px;
            padding-top:0.2rem;
            padding-bottom:0.2rem;
        }
        
        .dataTables_wrapper .dataTables_length { display:none };

        th, td,tr { height:35px;
            border:none;
            border-bottom:1px grey solid;
            font-size:14px; font-weight:normal; 
        }
        
        th {font-size:15px; font-weight:normal; border-top:1px grey solid; }

    </style>
</head>

<body class="hold-transition skin-black-light  sidebar-mini">
<div class="wrapper">

   <!-- Header -->
  <header class="main-header">

    <a href="#" class="logo">
		<span class="logo-mini"><b>Eazy</b></span>
		<span class="logo-lg"><b>EazyPos</b>System</span> 
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
<!--------
    <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <img src="{{ asset('logo.png') }}" style="width:25px;height:25px;">
        <font size="3" face="verdana">  Wawan </font>
         <span class="sr-only">Toggle navigation </span>      
    </a>
--->

   <a href="#" data-toggle="offcanvas" role="button" style="height:45px;width:50px;">
        <img src="{{ DIR_APP }}logo.png" style="width:30px;height:30px; margin-top:10px;margin-left:10px">
         <span class="sr-only">Toggle navigation </span>      
    </a>

                
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">

          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                <img src="{{ asset('public/images/admin.png') }}" class="user-image" alt="User Image">
                <span class="hidden-xs">{{ Auth::user()->username }}</span>
            </a>
            
            <ul class="dropdown-menu">
                <li class="user-header">
                    <img src="{{ asset('public/images/admin.png') }}" class="img-circle" alt="User Image">

                    <p>
                      {{ Auth::user()->username }}
					  {{ Auth::user()->group }}
                    </p>
                </li>
                <li class="user-footer">
                    <div class="pull-left">
                        <a class="btn btn-default btn-flat" href="{{ route('user.profil') }}">Edit Profil</a>
                    </div>
                    <div class="pull-right">
                        <a class="btn btn-default btn-flat" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"> Logout
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            {{ csrf_field() }}
                        </form>
                    </div>
                </li>

            </ul>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <!-- End Header -->


  <!-- Sidebar -->
  <aside class="main-sidebar">

    <section class="sidebar">
      <ul class="sidebar-menu" id="menuUtama">
      <li class="header"></li>

        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> <span>Dashboard</span></a></li>

		<li class="treeview">
		  <a href="#"><i class="fa fa-paste"></i> <span><strong>Master</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
				<li><a href="{{ route('category.index') }}"><i class="fa fa-cogs"></i> <span>Master Category</span></a></li>		        
				<li><a href="{{ route('product.index') }}"><i class="fa fa-truck"></i> <span>Master Product</span></a></li>
				<li><a href="{{ route('master.index_variant') }}"><i class="fa fa-cubes"></i> <span>Master Variant</span></a></li>
			</ul>
		</li>	 

		<li class="treeview">
		  <a href="#"><i class="fa fa-truck"></i> <span><strong>Barang Masuk/Pembelian</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
    		<li><a href="{{ route('invoice.index') }}"><i class="fa fa-shopping-cart"></i> <span>Pembelian Baru</span></a></li>
    		<li><a href="{{ route('invoice.history') }}"><i class="fa fa-history"></i> <span>History Pembelian</span></a></li>
            </ul>
        </li>
        
		<li class="treeview">
		  <a href="#"><i class="fa fa-shopping-bag"></i> <span><strong>Sesi Penjualan</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
    		<li><a href="{{ route('sessi.sessi_mgr') }}"><i class="fa fa-shopping-cart"></i> <span>Display Penjualan</span></a></li>
    		<li><a href="{{ route('home') }}"><i class="fa fa-history"></i> <span>Report Penjualan</span></a></li>
    		<li><a href="{{ route('master.index_payment') }}"><i class="fa fa-money"></i> <span>Type Pembayaran</span></a></li>
            </ul>
        </li>        
        
        <li><a href="{{ route('sales.cashier') }}"><i class="fa fa-user"></i> <span>Daftar Kasir</span></a></li>
        
        <!--
        <li><a href="{{ route('kanvas.testprinter') }}"><i class="fa fa-print"></i> <span>Test Printer</span></a></li>
        <li><a href="{{ route('user.index') }}"><i class="fa fa-user"></i> <span>User</span></a></li>
        -->
        
        <li><a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
			<i class="fa fa-power-off"></i><span>Logout </span></a></li>
        
        @if(Auth::user()->username=='alfredo')
            <li><a href="{{ route('notification.sendmessage') }}"><i class="fa fa-file-o"></i> <span>Test Pusher</span></a></li>           
        @endif
        
    </section>
  </aside>
  <!-- End Sidebar -->

  <!-- Content  -->
    <div class="content-wrapper">
        <section class="content-header" style="height:30px;margin-top:-5px;"> 
            <font size="3">
                @yield('title')
            </font>
            <ol class="breadcrumb">
                @section('breadcrumb')
                <li><a href="#"><i class="fa fa-home"></i>Home</a></li>
                @show
            </ol>
        </section> 

        <section class="content">
            @yield('content')
        </section>
    </div>
  <!-- End Content -->

  <!-- Footer -->

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
       Management System
	</div>
       <strong>Copyright &copy; 2020 <a href="#">My Project</a></strong> All rights reserved.
  </footer>
  <!-- End Footer -->
 
<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/dist/js/app.min.js') }}"></script>

<script src="{{ asset('public/adminLTE/plugins/chartjs/Chart.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
<script src="{{ asset('public/adminLTE/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script src="{{ asset('public/js/validator.min.js') }}"></script>

@yield('script')

</body>
</html>