@extends('layouts.app')

@section('title')
  Penjualan Kanvas &nbsp;&nbsp;&nbsp;&nbsp;
  <!--<a onclick="printstock()" class="btn btn-outline-info btn-sm"><i class="fa fa-print"></i> Print Report Stock </a>-->
@endsection

@section('breadcrumb')
   @parent
   <li>Penjualan Kanvas</li>
@endsection

@section('content')     


<div class="row">
    
  <div class="col-xs-12 col-md-12 col-sm-12">
    <div class="box" style="border-top:2px black solid">
       <div class="box-body"> 
       
 <section id="tbl-data" class="show">   
 
        <div class="form-group">

            <label>No. Kanvas</label>
                &nbsp;&nbsp;&nbsp;&nbsp;<button id="btnnew" onclick="newInvoice()" class="btn btn-primary btn-sm hide pull-right" style="margin-bottom:5px"> New Invoice </button>
                <select id="kdkvs" type="text" class="form-control" name="kdkvs" autofocus required>
                    <option value=""> -- Pilih Kanvas -- </option>
                    @foreach($kvs as $list)
                    <option value="{{ $list->id }}">{{ $list->kode.' / '.$list->no_pol.' / '.$list->driver.' / '.$list->sales }}</option>
                    @endforeach
                </select>
        </div>

<table class="table table-hover table-bordered table-padding table-responsive" id="tbl-sale" style="width:auto;">
    <thead>
        <tr class="tblheader">
            <th width="5%">Tanggal</th>
            <th width="20%">NO.Invoice</th>
            <th width="55%">Customer</th>
            <th width="5%"> +</th>
        </tr>
    </thead>
    <tbody></tbody>
</table>


</section>

<!---- new invoice form --->
<section id="form-invoice" class="hide">
    
    <form class="form-horizontal" data-toggle="validator" method="post" id="form-new">
    {{ csrf_field() }} {{ method_field('POST') }}
    
    <span><a onclick="tutupForm()" class="btn btn-flat pull-right" id="xclose"> X </a></span>
        
    <h4>New Invoice</h4>    
   
    <div class="col-sm-2 col-md-2 col-xs-0"></div>
    
    <div class="col-sm-8 col-md-8 col-xs-12">
   
        <input type="hidden" id="id" name="id">
        <input type="hidden" id="kontankredit" name="kontankredit" value="A">
         
        <div class="form-group">
            <label>Tanggal</label>
            <input id="tgl" type="date" class="form-control" name="tgl" autofocus required autocomplete="off">
            <small class="text-muted">Tanggal Invoice </small>
        </div>         
    
        <div class="form-group">
            <label>Customer</label>
            <select id="cus" type="text" class="form-control" name="cus" autofocus required>
                <option value=""> -- Pilih Customer -- </option>
                @foreach($cust as $list)
                <option value="{{ $list->id_cust }}">{{ $list->cus_name.'/'.$list->cus_nohp }}</option>
                @endforeach
            </select>
        </div>

        <div style="margin-left:200px; font-size:3vh">   
            Pilih Type Invoice:&nbsp;&nbsp;&nbsp;&nbsp;
            <input type="radio" id="kontan" name="kontan" value="1">
            <label> KONTAN</label>
            <input type="radio" id="kredit" name="kontan" value="2">
            <label> KREDIT</label><br>
        </div>   

        <br>
        <div class="form-group">
            <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
            <button id="tutup" onclick="tutupForm()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
        </div>
        
    </div>
        
    </form>  

</section>

<!----- tampil detail --->

<section id="tbl-detail" class="hide">
    
    <form id="form-header" class="form form-horizontal form-hdr" method="post">
        {{ csrf_field() }} {{ method_field('POST') }}
        
        <a onclick="tutupInvoice()" class="btn btn-flat pull-right" id="xclose"><i class="fa fa-times"></i></a>
        <h4 id="noinv">NO Invoice</h4>
        <h4 id="tipe">type</h4>
        <h4 id="customer">Customer</h4>
        <h4 id="tglinv">Tgl Invoice</h4> 
        
        <h3 class="text-left" style="margin-bottom:-30px;" id="totalsale">Total </h3>
    
        <input type="hidden" id="id_msale" name="id_msale">
        <input id="kode" type="hidden" class="form-control" name="kode">
    
        <section id="btnheader" class="show">
            <div class="text-right" style="margin-top:-20px;">
            <button id="submit-posting" type="submit" class="btn btn-success btn-sm posting"><i class="fa fa-check"> </i> Posting</button>
            <a onclick="showProduct()" class="btn btn-danger btn-sm"><i class="fa fa-plus"></i> Add Detail</a>
            </div>
        </section>
    
        <div class="text-center" style="margin-top:-30px;">
            <a onclick="cetakInvoice()" class="btn btn-info btn-sm" style="border:1px black solid;"><i class="fa fa-print"></i> Print Invoice </a>
        </div>
    
        <table class="table table-striped table-bordered table-padding table-responsive tabel-detail" id="detailinput"  width="100%">
            <thead>
                <tr class="tblheader">
                    <th width="33%">Nama PRODUK</th>
                    <th width="20%">HARGA</th>
                    <th width="10%">QTY</th>
                    <th width="10%">DISC</th>
                    <th width="15%">JUMLAH</th>
                    <th width="12%"></th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>        
    </form>
</section>

<!----------------------------->
<section id="data-detail" class="hide">
    
    <form class="form-horizontal" data-toggle="validator" method="post" id="form-inputdetail">
        {{ csrf_field() }} {{ method_field('POST') }}
        
        <span><a onclick="tutupDetail()" class="btn btn-flat pull-right" id="xclose"><i class="fa fa-times"></i></a></span>
        <h4>Input Detail Produk</h4>        
        
        <div class="col-sm-2 col-md-2 col-xs-0"></div>
        <div class="col-sm-8 col-md-8 col-xs-12">
        
        <input type="hidden" id="iddetail" name="iddetail">

            <div class="form-group">
                <label>Produk</label>
                <select id="prd" type="text" class="form-control" name="prd" autofocus required>
                    
                </select>
                <small class="text-muted">Pilih Produk</small>
            </div> 		        
		
            <div class="form-group">
                <label>Satuan Stock</label>
                <input type="text" class="form-control" id="stn" name="stn" required autocomplete="off" readonly="true">
            </div>
                
            <div class="form-group">
                <label>QTY</label>
                <input id="qty" type="number" class="form-control" name="qty" value="0" autofocus required autocomplete="off">
                <small class="text-muted">Jumlah QTY</small>
            </div>

            <br>

            <div class="form-group">
                <button id="submit-detail" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
                <button id="tutupdetail" onclick="tutupDetail()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
            </div>                
        </div>
    </form>      
    
</section>


</div>
</div>
</div>
</div>

@include('kanvas.product')
@include('kanvas.form_disc')

@endsection

@section('script')
<script type="text/javascript">
var  save_method;

function tampilData(id){
    $(function(){
       table = $('#tbl-sale').DataTable({
         "processing" : true,
         "destroy": true,
         "sort": false,
         "dom": "btip",
         "language": {
             "searchPlaceholder": "Search" },   // Placeholder for the search box     
         "ajax" : {
             "url" : "{{ DIR_APP }}kanvas/"+id+"/penjualan",
             "type" : "GET"
          }
       }); 
    })
}


$('#kdkvs').on('change', function()
{
    var idkvs=$('#kdkvs').val();

    $('#btnnew').removeClass('hide');
    $('#btnnew').addClass('show');
    tampilData(idkvs);   
})

/*** new  ***/
    $('#form-new').on('submit', function(e){

        if($('#kontankredit').val()=="A"){ alert("Type Invoice harus dipilih !"); return false; }

        if(!e.isDefaultPrevented()){
            var id = $('#kdkvs').val();
            url = "{{ DIR_APP }}kanvas/"+id+"/newinvoice";

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-new').serialize(),
            dataType: 'JSON',		   
            success : function(data){
                if(data.msg=="error"){
                    swal("WARNING", " Gagal menyimpan data !","error");
                    
                }else{
                    tutupForm();
                    $('#tbl-sale').DataTable().ajax.reload();
                }   
 		    },
                error : function(){
			        swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
                }   
            });
        return false;
	    }
    });


function newInvoice(){
	save_method="add";
    $('input[name=_method]').val('POST');
    
    $('#tbl-data').removeClass('show');
    $('#tbl-data').addClass('hide');
    $('#form-invoice').removeClass('hide');
    $('#form-invoice').addClass('show')
    
    document.getElementById("form-new").reset();
}

function tutupForm(){
    $('#tbl-data').removeClass('hide');
    $('#tbl-data').addClass('show');
    $('#form-invoice').removeClass('show');
    $('#form-invoice').addClass('hide')
    
}

function addSale(id){
    bukaInvoice();
    showDetail(id);
    loadInvoice(id);
    loadSummary(id);
}

$('#kontan').on('change', function(){
    if($('#kontan').is(':checked')) { $('#kontankredit').val(1); }
})

$('#kredit').on('change', function(){
    if($('#kredit').is(':checked')) { $('#kontankredit').val(2); }
})

function bukaInvoice(){
    $('#tbl-data').addClass("hide");
	$('#form-data').addClass("hide");
	$('#tbl-detail').removeClass('hide');
	$('#tbl-detail').addClass('show');
}

function tutupInvoice(){
    $('#tbl-data').addClass("show");
	$('#tbl-data').removeClass("hide");
	$('#tbl-detail').removeClass('show');
	$('#tbl-detail').addClass('hide');
}

function showDetail(id){
    
    tblinput=$('.tabel-detail').DataTable({
        "paging": false,
        "processing" : true,
    	"searching" : false,
    	"destroy" : true,
        "bSort": false,
        "iDisplayLength" : 10,
        "ajax" : {
            "url" : "{{ DIR_APP }}kanvas/"+id+"/kanvasdetail",
            "type" : "GET"
        }
    })    
}

function loadInvoice(id){
	$.ajax({
       url : "{{ DIR_APP }}kanvas/"+id+"/loadinvoice",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
            $('#noinv').text("NO. Invoice :"+data.no_invoice);
            if(data.type==1){
                $('#tipe').text("PEMBAYARAN : KONTAN");
            }else{
                $('#tipe').text("PEMBAYARAN : KREDIT");
            }
            $('#customer').text("Customer :"+data.cus_name);
            $('#tglinv').text("Tanggal :"+data.tanggal);
            $('#id_msale').val(data.id);

            if(data.is_posted==1) { $('#btnheader').removeClass('show'); $('#btnheader').addClass('hide'); }
         
        },
       error : function(){
         alert(" gagal tampil data ! ");
       }
  });     
  
}

function loadSummary(idmsale){
    //var idmsale = $('#id_msale').val();
	$.ajax({
       url : "{{ DIR_APP }}kanvas/"+idmsale+"/loadsummary",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
         $('#totalsale').text("TOTAL :"+data.totalsale);
        },
       error : function(){
         alert(" gagal tampil data ! ");
       }
  });     
}


function bukaDetail(){
    $('#tbl-data').addClass("hide");
	$('#form-data').addClass("hide");
	$('#data-detail').removeClass('hide');
	$('#data-detail').addClass('show');
}

function tutupDetail(){
	$('#data-detail').removeClass('show');
	$('#data-detail').addClass('hide');
    $('#tbl-data').removeClass('hide');
    $('#tbl-data').addClass("show");
}

/* tampilkan form produk barang satuan */
function showProduct(){
    var idkvs=$('#kdkvs').val();
    var idmsl=$('#id_msale').val();
    
    $('#modal-produk').modal('show');
    tblproduk.ajax.url("{{ DIR_APP }}kanvas/"+idkvs+"/"+idmsl+"/tampilproduct");
	tblproduk.ajax.reload();
}

tblproduk = $('.tabel-produk').DataTable({
    "bSort": false,
    "processing" : true,
	"paging" : true,
    "dom" : 'bftp',
});	

function selectItem(kode){
	$('#kode').val(kode);
	$('#modal-produk').modal('hide');
	addItem();
}

function addItem(){
    var idmsale=$('#id_msale').val();
    
    $.ajax({
        url : "{{ DIR_APP }}kanvas/simpansale",
        type : "POST",
        data : $('.form-hdr').serialize(),
        success : function(data)
		    {
			    if(data.msg=="error")
				{
				    swal("WARNING", " Produk ini sudah ada di Invoice !","error");
				}else{

					$('#detailinput').DataTable().ajax.reload(); loadSummary(idmsale);
				}
		    },
			error : function(){
			swal("DANGER", " Detail Penjualan Gagal disimpan, HUB. IT !","error");
			}
		});
     return false;

}


function potSale(id){
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
   //$('#modal-disc form')[0].reset();
    $.ajax({
        url : "{{ DIR_APP }}kanvas/"+id+"/potongan",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#modal-disc').modal('show');

            $('#id2').val(data.id);
	  
            $('#prod').val(data.nama_brg);
            $('#harga').val(data.harga);
            $('#qty2').val(data.qty_sale);
            $('#pot').val(data.potongan);
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


/*** potongan  ***/
    $('#modal-disc form').validator().on('submit', function(e){
        var idmsale=$('#id_msale').val();
        if(!e.isDefaultPrevented()){
            var id = $('#id2').val();
            url = "{{ DIR_APP }}kanvas/"+id+"/simpanpotongan";

        $.ajax({
            url : url,
            type : "GET",
            data : $('#modal-disc form').serialize(),
            dataType: 'JSON',		   
            success : function(data){
                if(data.msg=="error"){
                    swal("WARNING", " Gagal menyimpan data !","error");
                    
                }else{
                    $('#modal-disc').modal('hide');
                    $('#detailinput').DataTable().ajax.reload(); loadSummary(idmsale);
                }   
 		    },
                error : function(){
			        swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
                }   
            });
        return false;
	    }
    });
    

function minSale(id){
    updQTY(id,0);
}

function plusSale(id){
    updQTY(id,1);
}

function updQTY(id,mode){
    
    var idmsale=$('#id_msale').val();
    
	$.ajax({
        url : "{{ DIR_APP }}kanvas/"+id+"/"+mode+"/updqty",
        type : "GET",
	    dataType : "JSON",
        success : function(data)
		    {
			if(data.msg=="error")
				{
				 swal("WARNING", " data tidak dapat disimpan !","error");
					return false;
				}else{
					$('#detailinput').DataTable().ajax.reload(); loadSummary(idmsale);
				}
		    },
			error : function(){
			swal("DANGER", " Data Gagal disimpan, HUB. IT !","error");
			}
		});
     return false;
}

function cetak_Invoice(){
    var idmsale = $('#id_msale').val();
    window.location="{{ DIR_APP }}kanvas/"+idmsale+"/cetakinvoice";
    window.location.reload(true);
    
}

function cetakInvoice(){
    var idmsale = $('#id_msale').val();
    window.open("{{ DIR_APP }}kanvas/"+idmsale+"/cetakinvoice");       //--> open new windows
    location.reload();
}

/****  posting ***/
$('.posting').click(function(){
    document.querySelector('#form-header').addEventListener('submit', function(e) {       
    var form = this;
    var idmsale = $('#id_msale').val();
    
    e.preventDefault(); // <--- prevent form from submitting

    swal({
        title: "Anda Yakin ingin Posting data ?",
        text: "Data  tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Posting'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm',
                text: 'Klik OK untuk Confirmasi !',
                icon: 'info'
                }).then(function() {
                    window.location="{{ DIR_APP }}kanvas/"+idmsale+"/postingsale";
                });
            } else {
                swal("Batal", "data masih bisa diedit :)", "error");
            }
        })
    });    
});




</script>
@endsection