<!-- page menampilkan form historey invoice/ invoice posted -->

@extends('layouts.myform')

<head>
  
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   
  	<script type="text/javascript" src="/sbo/public/adminLTE/dist/css/sweetalert.min.js"></script>


</head>


@section('title')
 <table>

    <tr><td width="100"><b>Supplier</b></td><td><b>{{ $supplier->sup_id.' - '.$supplier->sup_nama }}</b></td></tr>
	<tr><td width="100"><b>Tgl. Invoice</b></td><td><b>{{ tanggal_indonesia($m_inv->inv_tgl, false) }}</b></td></tr>
	<tr><td width="100"><b>No. Invoice</b></td><td><b>{{ $m_inv->inv_no }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>invoice</li>
   <li>history</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-invoice" method="GET" id="form-invoice" action="/sbo/invoice/{{ $idinv }}/reprint">
{{ csrf_field() }}
  
  <input type="hidden" name="idinv" value="{{ $idinv }}">
  
	    <button id="submit" type="submit" class="btn btn-success pull-right simpan"><i class="fa fa-floppy-o"></i>Print Invoice </button>
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 
</form>
<br>

<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<div class="row">
    
<table class="table table-fixed table-striped table-bordered tabel-invdetail" id="invdetail">

<thead>
              
   <tr class="danger">
      <th width="20">No</th>
	  <th>Deskripsi</th>
	  <th>No.Serial</th>
      <th>Hg.Gross</th>
	  <th>QTY</th>
	  <th>Disc</th>
	  <th>Jumlah</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>

</form>

<div class="box-footer">
    <div class="col-md-8" align="right">
    	<label>Total QTY &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    	<label>Total Rp &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    </div>
    <div class="col-md-3">
    	<div id="total-qty"	style="background: DarkSlateGray; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    	<div id="total-rp" style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    </div>      
	<div class="col-md-3">
		<form class="form form-horizontal form-rekapinv" method="GET" action="/wawan/invoice/{{ $idinv }}/update">
			{{ csrf_field() }}
			<input type="hidden" name="idinv" value="{{ $idinv }}">
			<input type="hidden" name="totalinv" id="totalinv">
		</form>
	</div>          

</div>


                </div>
            </div>
        </div>
    </div>
</div>


@include('invoice_detail.form')

@endsection

@section('script')

<script type="text/javascript">
var table, table1, save_method;

$(function(){
  $('.tabel-produk').DataTable();
  table = $('.tabel-invdetail').DataTable({
      
     "scrollY": '40vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bt',
     "ajax" : {
     "url" : "{{ route('invoicedetail.data2') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
   loadSummary();
 });

});



/* mreferesh perubahan total inv */
function loadSummary(){
	
  $.ajax({
	   url : "/wawan/invoicedetail/loadsummary",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#total-qty').text(data.totalqty);
			$('#total-rp').text(data.totalrp);
       },
       error : function(){
		 return false;
       }
  });
}

</script>

@endsection