<!-- page menampilkan form detail input invoice -->

@extends('layouts.myform')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
	
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<!--
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   -->
  	<script type="text/javascript" src="{{ DIR_APP }}public/adminLTE/dist/css/sweetalert.min.js"></script>


</head>


@section('title')
<form class="form form-horizontal form-header" method="post" id="form-header" style="margin-bottom:-10px;">
    {{ csrf_field() }}
    
 <table>

    <tr><td width="120"><b>Supplier</b></td><td width="500"><b>{{ $supplier->sup_id.' - '.$supplier->sup_nama }}</b></td></tr>
	<tr><td width="120"><b>Tgl. Invoice</b></td><td><b>{{ tanggal_indonesia($m_inv->inv_tgl, false) }}</b></td></tr>
	<tr><td width="120"><b>No. Invoice</b></td><td><b>{{ $m_inv->inv_no }}</b>    
	
	<td></td><td>
	    <button id="submit-control" type="submit" class="btn btn-success simpan"><i class="fa fa-floppy-o"> </i> Posting & Cetak Invoice </button>
    </td></tr>
</table>
</form>

@endsection

@section('breadcrumb')
   @parent
   <li>invoice</li>
   <li>input detail</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-produk" method="post" id="form-produk">
{{ csrf_field() }}
  
  <input type="hidden" name="idinv" value="{{ $idinv }}">
  
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 

  <div class="form-group">
    <!--  <label for="kode" class="col-md-1 control-label" align="left">List Barang</label> -->
      <div class="col-md-3">
        <div class="input-group">
          <input id="kode" type="hidden" class="form-control" name="kode" autofocus required readonly="true">
          <span class="input-group-btn">
            <button onclick="showProduct()" type="button" class="btn btn-danger"><i class="fa fa-plus"></i> Add Item </button>
          </span>
        </div>
      </div>
  </div>

 </form>


<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<div class="row">
    
<!-- <div style="height:400px; overflow-y: scroll;">  -->

<table class="table table-fixed table-striped table-bordered tabel-invdetail" id="invdetail">

<thead>
              
   <tr class="tblheader">
      <th width="20">No</th>
      <th>Deskripsi</th>
      <th>Hg.Satuan</th>
	  <th>Colly</th>
	  <th>Volume</th>
	  <th>Stn Vol</th>
	  <th>Jumlah</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>



</form>

<div class="box-footer">
    <div class="col-md-8" align="right">
    	<label>Total QTY &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    	<label>Total Rp &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
    </div>
    <div class="col-md-3">
    	<div id="total-qty"	style="background: DarkSlateGray; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    	<div id="total-rp" style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
    </div>      
	<div class="col-md-3">
		<form class="form form-horizontal form-rekapinv" method="GET" action="/wawan/invoice/{{ $idinv }}/update">
			{{ csrf_field() }}
			<input type="hidden" name="idinv" value="{{ $idinv }}">
			<input type="hidden" name="totalinv" id="totalinv">
		</form>
	</div>          

</div>

                </div>
            </div>
        </div>
    </div>
</div>


@include('invoice_detail.produk')
@include('invoice_detail.form')

@endsection

@section('script')

<script type="text/javascript">
var table, table1, save_method;
var id_inv=$('#idinv').val();

$(function(){
  $('.tabel-produk').DataTable();
  table = $('.tabel-invdetail').DataTable({
      
     "scrollY": '40vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bt',
     "ajax" : {
     "url" : "{{ route('invoicedetail.data') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
   loadSummary();
 });


  $('.form-produk').on('submit', function(e){
      return false;
   });

   $('#kode').change(function(){
      addItem();
   });

/*simpan detail dari form_input */
//$('#modal-form_input form').validator().on('submit', function(e){
   //   if(!e.isDefaultPrevented()){
		 
   //      var id  = $('#id').val();
		 //url = "/sbo/invoicedetail/"+id+"/update";
	//	 url : "{{ route('invoicedetail.store') }}",
    //     $.ajax({
//           url : url,
//           type : "POST",
//           data : $('#modal-form_input form').serialize(),
//           success : function(data){
//             $('#modal-form_input').modal('hide');
//             table.ajax.reload();
//           },
//           error : function(){
//			 return false;
//          }   
//        });
        //return false;
//    }

//		addItem();
});


/* simpan edit detail */
$('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 
         var id  = $('#id').val();
		 url = "/wawan/invoicedetail/"+id+"/update";
         $.ajax({
           url : url,
           type : "GET",
           data : $('#modal-form form').serialize(),
           success : function(data){
             $('#modal-form').modal('hide');
             table.ajax.reload();
           },
           error : function(){
			 return false;
          }   
        });
        return false;
    }
    
}); 

///////////////////////////////////////

/* posting: simpan data ke ms_invoice dan posting->stock , cetak   */

$('.simpan').click(function(){
    document.querySelector('#form-header').addEventListener('submit', function(e) {       
    var form = this;

    e.preventDefault(); // -- prevent form from submitting

    swal({
        title: "Anda Yakin ingin memposting Invoice ?",
        text: "Data Invoice akan diposting ke Stock & tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Posting'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
                }).then(function() {
            $('.form-rekapinv').submit(); // -- submit form programmatically
        });
        } else {
            swal("Batal", "Invoice masih bisa diedit :)", "error");
        }
        })
    });    
});


/*---------------------------------------------------------------*/
function addItem(){

  $.ajax({
    url : "{{ route('invoicedetail.store') }}",
    type : "POST",
    data : $('.form-produk').serialize(),
    success : function(data)
		{
			if(data.msg=="error")
				{
				 swal("WARNING", " KODE ini sudah ada di Invoice !","error");
					$('#kode').val('').focus();
				}else{
					$('#kode').val('').focus();
					//table.ajax.reload(function(){loadForm($('#dis').val(), $('#ppn').val()); }) ;         
					table.ajax.reload();
				}
		},
			error : function(){
		//alert(" Tidak dapat menyimpan data ! ");
			swal("DANGER", " Detail Invoice Gagal disimpan, HUB. IT !","error");
			}
			});
         return false;

}

function selectItem(kode){
	$('#kode').val(kode);
	$('#modal-produk').modal('hide');
	addItem();
	//inputForm(kode);
}

/* tampilkan form produk pricelist */
function showProduct(){
  $('#modal-produk').modal('show');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/wawan/invoicedetail/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Detail Invoice');
       
       $('#id').val(data.id_inv);
     
       $('#nama').val(data.nama_brg);	   
	   $('#gross').val(data.inv_gross);
	   $('#qty').val(data.inv_qty);   
	   
       if(data.type_brg==0){     
           $('#type').val('KEMASAN');
    	   $('#isi').val(data.tonase_vol);	   
    	   $('#satuan').val(data.tonase_stn);
        }else{	   
	       $('#type').val('SATUAN');
    	   $('#isi').val(data.inv_isi);	   
    	   $('#satuan').val(data.inv_stn);
        }
 
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

function inputForm(id){
   save_method = "add";
   $('input[name=_method]').val('PATCH');
   $('#modal-form_input form')[0].reset();

   $.ajax({
     url : "/wawan/invoicedetail/"+id+"/caribrg",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_input').modal('show');
       $('.modal-title').text('Input Detail Invoice');
       
       $('#idbrg').val(data.id);
	 
       $('#nama_').val(data.nama_brg);	   
       $('#gross_').val(data.harga_list);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

/* modul delete */
function deleteItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/wawan/invoicedetail/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload(function(){
			loadSummary();
          }); 
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

/* mreferesh perubahan total inv */
function loadSummary(){
	
  $.ajax({
	   url : "/wawan/invoicedetail/loadsummary",
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#total-qty').text(data.totalqty);
			$('#total-rp').text(data.totalrp);
       },
       error : function(){
		 return false;
       }
  });
}

function error_mess(){
	swal("WARNING"," Anda tidak punya Akses ! ","error");
}

</script>

@endsection