@extends('layouts.app')

@section('title')
	
	<tr><td width="80">Toko :&nbsp;&nbsp;</td><td>{{ $toko->str_kode }}&nbsp;&nbsp;-&nbsp;&nbsp;{{ $toko->str_name }}
	&nbsp;&nbsp;[&nbsp;Zone Price :&nbsp; {{ $toko->str_zone }}&nbsp;]</td></tr>&nbsp;&nbsp;
	<a onclick href="/mms/promotion/{{ $toko->id_store }}/pilihsku" class="btn btn-success"><i class="fa fa-plus-circle"> </i> New Promotion </a> 
	<a onclick="window.history.back()" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	
	
@endsection

@section('breadcrumb')
   @parent
   <li>purchase</li>
@endsection

<head>
    <title>Purchase </title>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>

	<script type="text/javascript" src="/mms/public/adminLTE/dist/css/sweetalert.min.js"></script>

</head>


@section('content')   
<div class="row">
  <div class="col-sm-12">
    <div class="box">
      <div class="box-header"></div>
      <div class="box-body">  

<form method="post" id="form-purchase">
{{ csrf_field() }}

<div style="overflow-x:auto;">

<table class="table table-striped table-bordered table-condensed" id="purchase">
<thead>
   <tr class="success">
      <th width="10">Action</th> 
	  <th>Toko</th>	  
      <th>SKU</th>
      <th>Description</th>
	  <th>Start</th>
	  <th>End</th>
	  <th>QTY</th>
	  <th>MAX</th>
      <th>Price 1</th>
	  <th>Promo 1</th>
	  <th>Disc 1</th>
      <th>Price 2</th>
	  <th>Promo 2</th>
	  <th>Disc 2</th>
      <th>Price 3</th>
	  <th>Promo 3</th>
	  <th>Disc 3</th>
      <th>Price 4</th>
	  <th>Promo 4</th>
	  <th>Disc 4</th>
      <th>Price 5</th>
	  <th>Promo 5</th>
	  <th>Disc 5</th>
      <th>Price 6</th>
	  <th>Promo 6</th>
	  <th>Disc 6</th>
      <th>Price 7</th>
	  <th>Promo 7</th>
	  <th>Disc 7</th>
      <th>Price 8</th>
	  <th>Promo 8</th>
	  <th>Disc 8</th>
      <th>Price 9</th>
	  <th>Promo 9</th>
	  <th>Disc 9</th>
   </tr>
</thead>
<tbody></tbody>
<thead>
   <tr class="success">
      <th width="10">Action</th> 
	  <th>Toko</th>	  
	  <th>Supl</th>
      <th>SKU</th>
      <th>Description</th>
	  <th>Hg.Gross</th>
	  <th>Stn</th>
	  <th>Isi</th>
	  <th>Disc1</th>
      <th>Disc2</th>
	  <th>Disc3</th>
	  <th>Order</th>
      <th>Netto</th>
   </tr>
</thead>
</table>
</form>

    </div>
	</div>
	</div>
</div>	
</div>

@include('promotion.form_promo')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('purchase.getdata') }}",
       "type" : "GET"
     }
   }); 
   
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('promotion.store') }}";
         else url = "/mms/promotion/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " Master Promo baru berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");			 
           }   
         });
         return false;
	 }
   });
   
   
function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "promotion/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Supplier');
       
       $('#id').val(data.id_supp);
	   $('#kode').val(data.sup_id).attr('readonly', true);
       $('#nama').val(data.sup_nama);
       $('#alamat').val(data.sup_alamat);
       $('#telpon').val(data.sup_telp);
	   $('#kota').val(data.sup_kota);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}
	 

});

function showData(id){
   save_method = "edit";

   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/mms/pricelist/"+id+"/lihat",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Data Detail');
       
       $('#id').val(data.id_plist);
	   $('#supp').val(data.sup_kode.concat(' - ',data.sup_nama));
  	   $('#nama').val(data.list_sku.concat(' - ',data.sku_name));
	   $('#box').val(data.prc_box).attr('readonly', true);
       $('#pcs').val(data.prc_pcs).attr('readonly', true);
       $('#gross').val(data.prc_hrggross).attr('readonly', true);
	   $('#disc1').val(data.prc_disc1).attr('readonly', true);
	   $('#disc2').val(data.prc_disc2).attr('readonly', true);
	   $('#disc3').val(data.prc_disc3).attr('readonly', true);
	   $('#ppn').val(data.prc_ppn).attr('readonly', true);
	   $('#status').val(data.prc_status).attr('readonly', true);
	   $('#expd').val(data.list_exp).attr('readonly', true);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
   
}


</script>

@endsection
