@extends('layouts.app')

@section('title')
    Dashboard
@endsection

@section('breadcrumb')
   @parent
   <li>Dashboard</li>
@endsection

@section('content') 
   
@if( $messages>0 )
    <!--	<a href="message/index" class="notification">
      <span><i class="fa fa-envelope"></i> message</span>
      <span class="badge">{{ $messages }}</span>
    </a> --> 
    <body onload="showNotif()"></body>
@endif


<!-- logs activity -->
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-6 col-xs-12 col-md-12"> 
            <div class="box">
    			<div class="panel-body">

                    <div style="padding:3px; overflow:auto; width:100%px; height:68vh">	
        				<label><font size="2">--- Aktivitas Terakhir ---</font></label>
        				<ul class="user-timeline user-timeline-compact">
        				@foreach ($UserLog as $key=> $log)
        					@if($key==0)
        						<li class="latest">
        							<div class="user-timeline-date">{{ date_format($log->created_at,"M d, Y, H:i:s") }}</div>
        							<strong><div class="usr-timeline-title">{!! $log->title !!}</div></strong>
        							<div class="user-timeline-description">{!! $log->content !!}</div>
        						</li>
        					@else
        						<li>
        							<div class="user-timeline-date">{{ date_format($log->created_at,"M d, Y, H:i:s") }}</div>
        							<strong><div class="usr-timeline-title">{!! $log->title !!}</div></strong>
        							<div class="user-timeline-description">{!! $log->content !!}</div>
        						</li>	
        					@endif
        				@endforeach
        				</ul>
        			</div> 
        		</div>
        	</div>
        </div>
    </div>
</div>

@endsection


@section('script')
<script type="text/javascript">

    //refresh setiap 3menit
    $(document).ready(function() {
      setInterval(function() {
        cache_clear()
      }, 180000);
    });
    
    function cache_clear() {
       window.location.reload(true);
       // window.location.reload(); use this if you do not remove cache
    }
    
    
    function showNotif(){
       $.ajax({
         url : "message/warning",
         type : "GET",
         dataType : "JSON",
         success : function(data){    
    	    swal(data.mess_title, data.mess_text ,"info");
            }
        });
    }

</script>

@endsection



