@extends('layouts.app')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<style>
        th, td,tr { height:35px;
            border:none;
            border-bottom:1px grey solid;
            font-size:14px; font-weight:normal; 
        }
        
        th {font-size:15px; font-weight:normal; border-top:1px grey solid; }
        
	</style>    
</head>

@section('title')
  Master Category

@endsection

@section('breadcrumb')
   @parent
   <li>category</li>
@endsection


@section('content')     
<div class="row">
        
    <div class="col-xs-12 col-md-8 col-sm-12">

    <section id="tabeldata" class="show">        
    <div class="box" style="border-top:2px grey solid">
      <div class="box-body">  
          
        <form method="POST">      
        {{ csrf_field() }}
        
            <a onclick="newCategory()" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> New Category </a>
        
            <table "table table-striped table-padding table-bordered" id="category" width="100%">
                <thead>
                    <tr>
                        <th>Category</th>
                        <th>Status</th>
                        <th width="30">Opsi</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            
        </form>

            </div>
        </div>
</section>

<section id="formdata" class="hide">
    <div class="box" style="padding:20px 50px 20px 50px;border-top:2px grey solid">
        <div class="box-body">
            
    <form class="form-horizontal" data-toggle="validator" method="post" id="formcategory">
    {{ csrf_field() }} {{ method_field('POST') }}
   
    <h4 class="text-center">Form Category</h4>

    <br>
    
    <input type="hidden" id="id" name="id">
    	
    <div class="form-group">
        <label>Nama Category</label>
        <input id="nama" type="text" class="form-control" name="nama" autofocus required autocomplete="off">
    </div>

    <div class="form-group">
        <button id="submit-cust" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
        <a id="tutupform" onclick="tutupform()" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</a>
    </div>

    </form>    


        </div>
    </div>
 </section>       
        
    </div>
</div>

@include('category.form')
@endsection

@section('script')
<script type="text/javascript">
var  save_method;


    $(function(){
        table = $('#category').DataTable({
            "processing" : true,
            "ajax" : {
                "url" : "{{ route('category.data') }}",
                "type" : "GET"
            }
        });
    });
   
   $('#formcategory').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 $('#submit-control').html(' data sedang disimpan ... ');
		 $('#submit-control').attr('disabled','disabled');		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('category.store') }}";
         else url = "category/"+id;
         
         $.ajax({
           url : url,
           type : "POST",
           data : $('#formcategory').serialize(),
           success : function(data){
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');	
             $('#modal-form').modal('hide');
             table.ajax.reload();
             tutupform();
           },
           error : function(){
             alert("Tidak dapat menyimpan data!");
           }   
         });
         return false;
     }
	  
   });


function newCategory(){
	save_method="add";
    bukaform();	
    $('input[name=_method]').val('POST');
}

function bukaform(){
    $('#tabeldata').removeClass('show');
    $('#tabeldata').addClass('hide');
    $('#formdata').removeClass('hide');
    $('#formdata').addClass('show');
    
    document.getElementById("formcategory").reset();
}

function tutupform(){
    $('#formdata').removeClass('show');
    $('#formdata').addClass('hide');
    $('#tabeldata').removeClass('hide');
    $('#tabeldata').addClass('show');
    
    document.getElementById("formcategory").reset();
}


function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "category/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
        bukaform();
        $('#id').val(data.id_cat);
        $('#nama').val(data.category_name);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


</script>
@endsection