<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\User_logs;

use Auth;
use Hash;
use Datatables;
use DB;

class UserController extends Controller
{
   public function index()
   {
     
      return view('user.index'); 
   }

   public function listData()
   {
   
     $user = User::where('level', '=', 1)
                      ->where('is_delete',0)
                      ->orderBy('users.username', 'ASC')
                      ->get();
     $no = 0;
     $data = array();
     foreach($user as $list){
       $no ++;
       $row = array();
       $row[] = $no ;
       $row[] = $list->username;
       $row[] = $list->group;
       $row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id.') " class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a> 
					<a onclick="deleteItem('.$list->id.') " class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a> 
				</div>';
				
       $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
   }

   public function store(Request $request)
   {
      $user = new User;
      $user->username 	= $request['nama'];
      $user->email 		= $request['email'];
      $user->password	= bcrypt($request['password']);
     
	//  $user->remember_token	= "";
	 
      $user->level 		= 1;
	  $user->group		= $request['group'];
      $user->foto 		= "user.png";
	  
	  if($request['group']== "MANAGER"){
		$user->master_edit	=1;
		$user->master_del	=1;
		$user->group_edit	=1;
		$user->group_del	=1;
		$user->beli_edit	=1;
		$user->beli_del		=1;
		$user->sale_edit	=1;
		$user->sale_del		=1;
		$user->bayar_del	=1;
		$user->bayar_edit	=1;
		$user->lunas_edit	=1;
		$user->lunas_del	=1;
		$user->mutasi_add   =1;
		$user->bs_add       =1;
		$user->bs_kembali   =1;
		$user->setor_add    =1;
		$user->tagihan_del  =1;
		$user->user_add		=1;
	  }else{
		$user->master_edit	=0;
		$user->master_del	=0;
		$user->group_edit	=0;
		$user->group_del	=0;
		$user->beli_edit	=0;
		$user->beli_del		= $request['beli'];;
		$user->sale_edit	=0;
		$user->sale_del		= $request['jual'];
		$user->bayar_del	=0;
		$user->bayar_edit	=0;
		$user->lunas_edit	=0;
		$user->lunas_del	= $request['lunas'];
		$user->mutasi_add   =0;
		$user->bs_add       =0;
		$user->bs_kembali   =0;
		$user->setor_add    =0;
		$user->tagihan_del  = $request['tagih'];
		$user->user_add		=0;
	  }		  		  
		
      $user->save();
// insert logs
		$userid	= $request['nama'];
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Tambah User';
		$userlog->content	= 'User baru '.$userid.' berhasil ditambah oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		
	  
	    echo json_encode(array('msg'=>'success')); 
   }

    public function show($id){
        $uu = User::find($id);
        echo json_encode($uu);
    }
    
   public function edit($id)
   {
     $user = User::find($id);
     echo json_encode($user);
   }

   public function update(Request $request, $id)
   {
      $user = User::find($id);
      $user->username 	= $request['nama'];
      $user->email 		= $request['email'];
	  $user->group		= $request['group'];
	  
	  if($request['group']== "MANAGER"){
		$user->master_edit	=1;
		$user->master_del	=1;
		$user->group_edit	=1;
		$user->group_del	=1;
		$user->beli_edit	=1;
		$user->beli_del		=1;
		$user->sale_edit	=1;
		$user->sale_del		=1;
		$user->bayar_del	=1;
		$user->bayar_edit	=1;
		$user->lunas_edit	=1;
		$user->lunas_del	=1;
		$user->mutasi_add   =1;
		$user->bs_kembali   =1;
		$user->setor_add    =1;
		$user->tagihan_del  =1;
		$user->user_add		=1;
	  }else{
		$user->master_edit	=0;
		$user->master_del	=0;
		$user->group_edit	=0;
		$user->group_del	=0;
		$user->beli_edit	=0;
		$user->beli_del		= $request['beli'];;
		$user->sale_edit	=0;
		$user->sale_del		= $request['jual'];
		$user->bayar_del	=0;
		$user->bayar_edit	=0;
		$user->lunas_edit	=0;
		$user->lunas_del	= $request['lunas'];
		$user->mutasi_add   = $request['mts'];
		$user->bs_kembali   = $request['bs'];
		$user->setor_add    = $request['setor'];
		$user->tagihan_del  = $request['tagih'];
		$user->user_add		=0;
	  }		  
	  
      if(!empty($request['password'])) $user->password = bcrypt($request['password']);
      $user->update();
	  
      echo json_encode(array('msg'=>'success')); 
   }
   
    public function delete($id){
       $uu = User::find($id);
       $nm = $uu->username;
       
       $uu->is_delete = 1;
       $uu->username = $nm.'(del)';
       $uu->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Delete User';
		$userlog->content	= 'User '.$nm.' berhasil didelete oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(['msg'=>'success']);
    }
    

   public function destroy($id)
   {
      $user = User::find($id);
      $user->delete();
   }

   public function profil()
   {
      $user = Auth::user();
      return view('user.profil', compact('user')); 
   }

   public function changeProfil(Request $request, $id)
   {
      $msg = "succcess";
      $user = User::find($id);
      if(!empty($request['password'])){
        if(Hash::check($request['passwordlama'], $user->password)){
         $user->password = bcrypt($request['password']);
        }else{
         $msg = 'error';
        }
      } 

      if ($request->hasFile('foto')) {
         $file = $request->file('foto');
         $nama_gambar = "fotouser_".$id.".".$file->getClientOriginalExtension();
         $lokasi = public_path('images');

         $file->move($lokasi, $nama_gambar);
         $user->foto         = $nama_gambar;  
         
         $datagambar = $nama_gambar;
      }else{
         $datagambar = $user->foto; 
      }

      $user->update();
      echo json_encode(array('msg'=>$msg, 'url'=> asset('public/images/'.$datagambar))); 
   }
   
/********************-------------------------------------------*/
    function index_logs()
    {
        return view('user.activity');
    }   
   
    function get_logs()
    {
     //	$logs = User_logs::leftjoin('users', 'userlogs.user_id', '=', 'users.id');
     	                       // ->orderby('userlogs.id', 'DESC');
     	                       
     	$logs = DB::table('userlogs')
     	            ->select(DB::raw('userlogs.id as id_logs, title, user_id, content, userlogs.created_at, users.username'))
     	            ->leftjoin('users', 'userlogs.user_id', '=', 'users.id');

		return Datatables::of($logs)->make(true);
    }
    
    
    public function getactivity($awal, $akhir){
        
     	$logs = DB::table('userlogs')
     	                ->select(DB::raw('userlogs.id as id_logs, title, user_id, content, userlogs.created_at, users.username'))
     	                ->leftjoin('users', 'userlogs.user_id', '=', 'users.id')
                        ->whereBetween('userlogs.created_at', [$awal, $akhir])
                        ->get();
                                
        $data=[];
        foreach($logs as $dt){
            $row=[];
            $row[]=$dt->created_at;
            $row[]=$dt->username;
            $row[]=$dt->title;
            $row[]=$dt->content;
            
            $data[]=$row;
        }
        
        $output=["data"=>$data];
        return response()->json($output);
                                
    }
    
    
}
