<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Supplier;
use App\User_logs;
use Auth;


class SupplierController extends Controller
{
   public function index()
   {
      return view('supplier.index'); 
   }

   public function listData()
   {
   
     $supplier = Supplier::orderBy('sup_nama', 'desc')->get();
     $no = 0;
     $data = array();
     foreach($supplier as $list){
       $no ++;
       $row = array();
       $row[] = $list->sup_id;
       $row[] = $list->sup_nama;
       $row[] = $list->sup_alamat;
       $row[] = $list->sup_telp;
       $row[] = '<div class="btn-group">
               <a onclick="editForm('.$list->id_supp.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
			   </div>';
       $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
   }

//--------------------------------------

   public function pilihData()
   {
   
     $supplier = Supplier::orderBy('sup_nama', 'desc')->get();
     $no = 0;
     $data = array();
     foreach($supplier as $list){
       $no ++;
       $row = array();
       $row[] = $list->sup_id;
       $row[] = $list->sup_nama;
       $row[] = $list->sup_alamat;
       $row[] = $list->sup_kota;
       $row[] = '<div class="btn-group">
               <a href="pricelist/'.$list->id_supp.'/tampil" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
			   </div>';
			      
       $data[] = $row;
	     
     }

     $output = array("data" => $data);
     return response()->json($output);
   }

//----------------

   public function store(Request $request)
   {
      $supplier = new Supplier;
	  $kodesupp = $request['kode'];
	  $supplier->sup_id		= $kodesupp;
      $supplier->sup_nama   = $request['nama'];
      $supplier->sup_alamat = $request['alamat'];
      $supplier->sup_telp 	= $request['telpon'];
	  $supplier->sup_kota	= $request['kota'];
	  $supplier->save();
	  
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Tambah Master Supplier';
		$userlog->content	= 'Master Supplier '.$kodesupp.' berhasil ditambah oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		
   }

   public function edit($id)
   {
     $supplier = Supplier::find($id);
     echo json_encode($supplier);
   }

   public function update(Request $request, $id)
   {
      $supplier = Supplier::find($id);
	  $kodesupp	= $supplier->sup_id;
      $supplier->sup_nama 	= $request['nama'];
      $supplier->sup_alamat = $request['alamat'];
      $supplier->sup_telp 	= $request['telpon'];
	  $supplier->sup_kota	= $request['kota'];
      $supplier->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit Master Supplier';
		$userlog->content	= 'Master Supplier '.$kodesupp.' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();	  
   }

   public function destroy($id)
   {
      $supplier = Supplier::find($id);
      $supplier->delete();
   }
   
   public static function Supplier($id){
       return Supplier::find($id);
   }
   
}
