<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Cabang;
use App\StockOpname;
use App\StockOpnameDetail;
use App\Stock;
use App\InvoiceDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

class StockOpnameDetailController extends Controller
{

	public function index()
	{
		return view('stockopname_detail.index');
	}
	
   public function listData()
   {
		$mopn	= StockOpname::find(session('idopn'));
		
		$dtopname	= StockOpnameDetail::where('dt_opname.opname_id', session('idopn'))
											->orderBy('id_opn','DESC')
											->get();
										
				
		$no=0;
		$totaltns	= 0;
		$totalqty	= 0;

		$last_no	= 0;
		$data = array();
				
		foreach($dtopname as $list){
			$no++;

			$tp="";
			if(Product::Product($list->product_id)->type_brg==0)
			{ $tp="KEMASAN"; }else{ $tp="SATUAN";}
			
			$row = array();
			
			
			
			$row[] = $no;
			$row[] = Product::Product($list->product_id)->nama_brg;
			$row[] = $tp;			
			$row[] = $list->opn_qty;
			$row[] = $list->opn_tns;
			$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_opn.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
					<a onclick="deleteItem('.$list->id_opn.')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
					</div>';

            $totalqty += $list->opn_qty;
            
			$data[] = $row;		

			}
		

		$output = array("data" => $data);
		return response()->json($output);
	}
			
//------ detail history----------------------
   public function listData_history()
   {
		$mopn	= StockOpname::find(session('idopn'));
		
		$dtopname	= StockOpnameDetail::where('dt_opname.opname_id', session('idopn'))
											->orderBy('id_opn','DESC')
											->get();
										
				
		$no=0;
		$totaltns	= 0;
		$totalqty	= 0;

		$last_no	= 0;
		$data = array();
				
		foreach($dtopname as $list){
			$no++;

			$tp="";
			if(Product::Product($list->product_id)->type_brg==0)
			{ $tp="KEMASAN"; }else{ $tp="SATUAN";}
			
			$row = array();
			
			
			
			$row[] = $no;
			$row[] = Product::Product($list->product_id)->nama_brg;
			$row[] = $tp;			
			$row[] = $list->opn_qty;
			$row[] = $list->opn_tns;
            $totalqty += $list->opn_qty;
            
			$data[] = $row;		

			}
		

		$output = array("data" => $data);
		return response()->json($output);
	}
			
//----------------------------------------------------------------//
	public function getdata1($id){
		
        $opn = DB::table('dt_opname')
                    ->select(DB::raw('product_id'))
                    ->where('dt_opname.opname_id', '=', $id)
					->whereNull('dt_opname.inv_id')
					->get();
		
		$dataopn=array();
		foreach($opn as $list){
		$dataopn[] = $list->product_id; }
		
		//utk barang satuan
 		$dtstock	= Stock::leftJoin('ms_product', 'dt_stock.brg_id', 'ms_product.id')
									->where('dt_stock.active_sts', '=', 1)
									->where('ms_product.type_brg', '=', 1)
									->whereNotIn('ms_product.id', $dataopn)
									->get();
			$data=array();

			foreach($dtstock as $list){
				
				$row=array();

				$row[]= $list->nama_brg ;
				$row[]= format_uang($list->harga_jual);
				$row[]= format_uang($list->stock_akhir);
				$row[]= '<div class="btn-btn">
							<a onclick="selectItem('.$list->id_stock.')" class="btn btn-primary btn-md"><i class="fa fa-check"></i></a>
						</div>';
						
				$data[]=$row;
			}
		
		$output = array("data" => $data);
		return response()->json($output);	
			
	}

	public function getdata0($id){
		
        $opn = DB::table('dt_opname')
                    ->select(DB::raw('inv_id'))
                    ->where('dt_opname.opname_id', '=', $id)
					->whereNotNull('dt_opname.inv_id')
					->get();
		
		$dataopn=array();
		foreach($opn as $list){
		$dataopn[] = $list->inv_id; }
		
		//utk barang kemasan
            $dtinv      = InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
                                    ->where('dt_invoice.type_brg', '=', '0')
                                    ->where('dt_invoice.inv_posted', '=', '1')
                                    ->where('dt_invoice.active_sts', '=', 1)
                                //    ->where('dt_invoice.inv_qty','>','dt_invoice.qty_sale + dt_invoice.qty_out')
									->whereNotIn('dt_invoice.id_inv', $dataopn)
                                    ->get();			
			$data=array();

			foreach($dtinv as $list){
				
				$row=array();

				$row[]= $list->nama_brg ;
				$row[]= $list->inv_tgl;
				$row[]= $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
				$row[]= $list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj;
				$row[]= format_uang($list->harga_jual);
				$row[]= '<div class="btn-btn">
							<a onclick="selectItem2('.$list->id_inv.')" class="btn btn-primary btn-md"><i class="fa fa-check"></i></a>
						</div>';
						
				$data[]=$row;
			}
		
		$output = array("data" => $data);
		return response()->json($output);	
			
	}
		
/*--------------------------------------------------------------------*/
   public function listData2()
   {
		$minv	= Invoice::find(session('idinv'));
		
		$ppn	= $minv->inv_ppn;
		$disc1	= $minv->inv_disc;
			
		$dtinvoice	= InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
										->where('dt_invoice.invoice_id', session('idinv'))->get();
										
				
		$no=0;
		$totalinv1	= 0;
		$totalinv	= 0;
		$disc1	 	= 0;
		$disc2		= 0;
		$disc3		= 0;
			
		$last_no	= 0;
		$data = array();
				
		foreach($dtinvoice as $list){
			$no++;
			$jlh 	= $list->inv_gross*$list->inv_qty;
			$disc1	= $jlh *$list->inv_disc1/100;
			$jumlahinv	= $jlh - $disc1;
			
			$row = array();
				
			$row[] = $no;
			$row[] = $list->kode_brg;
			$row[] = $list->nama_brg;
			$row[] = $list->no_seri;			
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_gross).'</div>';
			$row[] = $list->inv_qty.' '.$list->inv_stn;
			$row[] = $list->inv_disc1;
			$row[] = '<div class="text" align="right">'.format_uang($jumlahinv).'</div>';
			$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_inv.')" class="btn btn-primary btn-sm"><i class="fa fa-eye"> detail </i></a>
					</div>';

			$totalinv1 += $list->inv_gross * $list->inv_qty;
										
			$totalinv = $totalinv1;	
							
			$data[] = $row;		

			}
				
		$no++;
		$data[] = array($no,"","","","<span class='hide totalopn'>$totalinv</span>", "<span class='hide totalqty'>$totalqty</span>", "", "","");
				
		$output = array("data" => $data);
		return response()->json($output);
	}
			

    public function loadSummary(){
        
		$idop = session('idopn');
		$dtopn	= StockOpnameDetail::where('opname_id', $idop)->get();
		
		$totalqty=0;
										
        foreach($dtopn as $list){
            
            $totalqty += $list->opn_qty;
        }
        
        $data = array("totalqty"=>format_uang($totalqty));
                      
        return response()->json($data);
    }
////////////////////////////////////////////////////////////////////////

   public function loadForm($totalqty, $totalopn){
	 
     $data = array("totalopn" => format_uang($totalopn),		
        "totalqty" => format_uang($totalqty));
        
        return response()->json($data);
   }

 
///-- add item ----------------------------------------------------- yg sebelumnya */
//simpan detail type satuan
	public function store(Request $request)
	{
	    $mopn		= StockOpname::find(session('idopn'));
	    
		$idstock	= $request['kode'];
		$stock		= Stock::find($idstock);
		$idbrg		= $stock->brg_id;
		
//cek data 
		$opn = StockOpnameDetail::where('opname_id', '=', session('idopn'))
									->where('product_id', '=', $idbrg)
									->count();
									
		if( $opn !=0 ){
			return json_encode(array('msg'=>'error'));
		}		

		$opndetail	= New StockOpnameDetail;
		
		$opndetail->opname_id	= $mopn->id_opname;
		$opndetail->product_id	= $idbrg;
		//$opndetail->type_brg    = Product::Product($idbrg)->type_brg;
		$opndetail->harga_jual  = Product::Product($idbrg)->harga_jual;
		$opndetail->opn_qty		= 1;		//default qty
		$opndetail->opn_tns     = 1;
		$opndetail->qty_stock   = $stock->stock_akhir;
		$opndetail->user_id	= Auth::user()->id;
		
		$opndetail->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Opname Detail '.tanggal_indonesia($mopn->opn_tgl, false);
			$userlog->content	= Product::Product($idbrg)->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}
	
//simpan detail type kemasan
	public function simpan(Request $request)
	{
	    $mopn		= StockOpname::find(session('idopn'));
	
		$idinv  	= $request['kode2'];
		$dtinv  	= InvoiceDetail::find($idinv);
		$idbrg		= $dtinv->id_brg;

//cek data 
		$opn = StockOpnameDetail::where('opname_id', '=', session('idopn'))
									->where('inv_id', '=', $idinv)
									->count();
									
		if( $opn !=0 ){
			return json_encode(array('msg'=>'error'));
		}

		$qstk = $dtinv->inv_qty - $dtinv->qty_sale - $dtinv->qty_out + $dtinv->qty_adj;
		$tstk = $dtinv->tonase_vol - $dtinv->tonase_sale - $dtinv->tonase_out + $dtinv->tonase_adj;

		$opndetail	= New StockOpnameDetail;
		
		$opndetail->opname_id	= $mopn->id_opname;
		$opndetail->product_id	= $idbrg;
		$opndetail->inv_id		= $idinv;
		$opndetail->harga_jual  = Product::Product($idbrg)->harga_jual;
		$opndetail->opn_qty		= 1;		//default qty
		$opndetail->opn_tns     = 1;
		$opndetail->qty_stock   = $qstk;
		$opndetail->tns_stock	= $tstk;
	
		$opndetail->user_id	= Auth::user()->id;
		
		$opndetail->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Opname Detail '.tanggal_indonesia($mopn->opn_tgl, false);
			$userlog->content	= Product::Product($idbrg)->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}	
/*----------------------------------------------------------------*/
	public function show($id)
	{
		//$dtinv = InvoiceDetail::find($id);
		$barang = Product::find($id);
	 
		echo json_encode($barang);		
	}
	
    public function edit($id)
    {
      $dtopn = StockOpnameDetail::find($id);
	  $barang = Product::find($dtopn->product_id);
	 
	  echo json_encode(array_merge(json_decode($barang, true),json_decode($dtopn, true)));
	
    }

    public function caribrg($id)
    {
	  $barang = Product::find($id);
	 
	  echo json_encode($barang);
    }
////////////////
    public function update(Request $request, $id)		
    {
		$dtopn 		= StockOpnameDetail::find($id);
		
		$dtopn->opn_qty    = $request['qty'];
		$dtopn->opn_tns    = $request['isi'];
		$dtopn->user_id	   = Auth::user()->id; 
 
		$dtopn->update();
		

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit QTY Opname ';
		$userlog->content	=  Product::Product($dtopn->product_id)->nama_brg. 'berhasil diedit by. '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }
	


   public function destroy($id)
   {
		$dtopn = StockOpnameDetail::find($id);
	  
		$dtopn->delete(); 
   }
	
	public function printForm()
	{
		
		$mopn		= StockOpname::find(session('idopn'));
		
		$dopn	 	= StockOpnameDetail::leftjoin('ms_product', 'dt_opname.product_id', 'ms_product.id')
									->where('dt_opname.opname_id', '=', session('idopn'))
									->get();
		$tlqty=0;
		$tlval=0;
		
		foreach($dopn as $list){
			$tlqty += $list->opn_qty;
			$tlval += ($list->opn_qty * $list->harga_retail);
		}

		$cabang	= Cabang::find($mopn->cabang_id);
		$no 	= 1;
     
	 	return view('stockopname_detail.printopn', compact('mopn','dopn','no','cabang', 'tlqty', 'tlval')); 
   } 	
   
/*  reprint po */
	public function reprintForm()
	{
		
		$minv		= Invoice::find(session('idinv'));
		
		$dinv	 	= InvoiceDetail::leftjoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
									->where('dt_invoice.invoice_id', '=', session('idinv'))
									->get();
								
									
		$supplier	= Supplier::find($minv->supp_id);

		$no 		= 1;

	 	return view('invoice_detail.reprintinv', compact('minv','dinv','no','supplier')); 
   } 	   
	
}	
