<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\InvoiceDetail;
use App\Stock;
use App\StockOpname;
use App\StockOpnameDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
use PDF;
use Redirect;


class StockOpnameController extends Controller
{

	public function index()
	{		
		return view('stockopname.index');
	}
	
	public function history()
	{		
		return view('stockopname.history');
	}	

//------------------------------history detail


    function getheader()
    {
		$tglnow = date("Y-m-d");

     	$stopname = StockOpname::where('ms_opname.opn_posted',0)
									->where('opn_tgl', '=', $tglnow)
									->get();
		
		$no=1;
		$data = array();
		
		foreach($stopname as $list)
		{
			$row = array();
				   
			$row[] = $no++;
			$row[] = tanggal_indonesia($list->opn_tgl, false);

	        $sss = $list->opn_posted;
			$sts="";
				switch ($sss){
					case '0': $sts = 'Not Posted'; break;
					case '1': $sts = 'Posted'; break;}
			$row[] = $sts;

			
		    $row[] = '<div class="btn-btn">
						<a href="stockopname/'.$list->id_opname.'/input" class="btn btn-plus btn-sm"><i class="fa fa-check"> </i></a>
					 </div>';	

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }
/*------------------------------------------------------*/
    function history_header()
    {
     	$stopname = StockOpname::where('ms_opname.opn_posted','=',1)
									->get();
		
		$no=0;
		$data = array();
		
		foreach($stopname as $list)
		{
			$row = array();
			$no++;
			
			$row[] = $no;
			$row[] = tanggal_indonesia($list->opn_tgl, false);

	        $sss = $list->opn_posted;
			$sts="";
				switch ($sss){
					case '0': $sts = 'Not Posted'; break;
					case '1': $sts = 'Posted'; break;}
			$row[] = $sts;

			
		    $row[] = '<div class="btn-btn">
						<a href="'.$list->id_opname.'/display" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
					 </div>';	

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);			

    }

///-- create new opname
	public function store(Request $request)
	{
		$tglopn		= $request['tglopn'];

		$stopname	= New StockOpname;
		
		$stopname->opn_tgl	    = $tglopn;
		$stopname->user_id	    = Auth::user()->id;
		
		$stopname->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Stock Opname Baru';
			$userlog->content	= 'Stock Opname  berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}

//-------------------------------
	function input($id)
	{
		session(['idopn'=>$id]);
		
		$idopn  = $id;
		$opname	= StockOpname::where('id_opname',$id)->get();
		
		foreach($opname as $list)
		{
			$tglopn	= $list->opn_tgl;
			$posted	= $list->opn_posted;
		}
		
		if($posted==1)
		{
			//return Redirect::route('invoice.index');	
			return $this->index();		//view('stockopname.index');
		}else{
		
    		$no=1;
    		$m_opn		= StockOpname::find($id);
    		
           //utk barang satuan
 			$dtstock	= Stock::leftJoin('ms_product', 'dt_stock.brg_id', 'ms_product.id')
									->where('dt_stock.stock_akhir', '>', 0)
									->where('ms_product.type_brg', '=', 1)
									->where('dt_stock.active_sts', '=', 1)
									->get();

            //utk barang kemasan ambil dari data barang masuk yg status_sale=0 type=0
            $dtinv      = InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
                                    ->where('dt_invoice.type_brg', '=', '0')
                                    ->where('dt_invoice.inv_posted', '=', '1')
                                    ->where('dt_invoice.inv_qty','>','dt_invoice.qty_sale + dt_invoice.qty_out')
                                    ->where('dt_invoice.active_sts', '=', 1)
                                    ->get();									
  
    		return view('stockopname_detail.index', compact('m_opn','dtstock','dtinv','idopn','no'));
		}
	
	} 
	
/*-----------------------------------------------------*/

	function display($id)
	{
		session(['idopn'=>$id]);
		
		$idopn  = $id;
		$no     = 1;
    	$m_opn	= StockOpname::find($id);
    
		return view('stockopname_detail.index_history', compact('m_opn','idopn','no'));

	} 

/*-----------------------------------------------------*/
	function tampil($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
			$ppn	= $list->inv_ppn;
			$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		$no=1;
		$m_inv		= Invoice::find($id);
		$supplier	= Supplier::find($idsupp);
		$product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    	
    
		return view('invoice_detail.index_history', compact('m_inv','supplier','product','idinv','no'));

	} 
/*-----------------------------------------------------*/
    public function edit($id)
    {
      $produk = Product::find($id);
      echo json_encode($produk);
    }
    

    public function show($id)
    {
        $stopn = StockOpname::find($id);
        echo json_encode($stopn);
        
    }


/////////////////////////////////////////////////////////////////////////

	/* posting opname ke stock */
	
    public function posting($id)
    {

		$mopn    	= StockOpname::find($id);
        $tglopn     = $mopn->opn_tgl;
          
		$dtopn  	= StockOpnameDetail::where('opname_id', $id )
		                                ->where('opn_posted', 0)
		                                ->get();

    /* proses postign stock */
		foreach($dtopn as $list) 
        {
            $id_detail  = $list->id_opn;
            $qty        = $list->opn_qty * $list->opn_tns;
            $idbrg      = $list->product_id;
			$idinv		= $list->inv_id;				 
			$qqq 		= $list->opn_qty;				 
			$ttt 		= $list->opn_tns;
			
            $tp		    = Product::Product($list->product_id)->type_brg;
            
			if($tp==1)
			{
			     /* reset all transaksi, update stock awal */
			     $stk = Stock::where('brg_id', '=', $idbrg)->get();
				 foreach( $stk as $dtstock) {
					 
					 $stock = Stock::find($dtstock->id_stock);
					 
					 $stock->barang_masuk	= 0;
					 $stock->penjualan      = 0;
					 $stock->stock_awal     = $qty;
					 $stock->trf_in		    = 0;
					 $stock->trf_out        = 0;
					 $stock->adjustment     = 0;
					 $stock->stock_akhir    = $qty;
					 $stock->tgl_opn		= $tglopn;
					 $stock->user_id        = Auth::user()->id;
					 
					 $stock->update();
				 }
			 }else{
			     
				 /** barang kemasan update data invoice nya di kolom adj */
				 
				 $dtinv = InvoiceDetail::find($idinv);	
				 				 
				 $adjq= $qqq - ($dtinv->inv_qty - $dtinv->qty_sale - $dtinv->qty_out );
				 $adjt= $ttt - ($dtinv->tonase_vol - $dtinv->tonase_sale - $dtinv->tonase_out );
				 
				 $dtinv->qty_adj 	= $adjq;
				 $dtinv->tonase_adj	= $adjt;
                 $dtinv->tgl_opname	= $tglopn;				 
                 
				 $dtinv->update();
			 
			 }

            /*update status posted opn detail */
            $det_opn = StockOpnameDetail::find($id_detail);
            $det_opn->opn_posted = 1;
            $det_opn->type_brg = $tp;
            $det_opn->update();
            
		 }
		 
		 /* update ms_opname */
		 
		 $mopn->opn_posted   = 1;
		 $mopn->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Posting Stock Opname';
		$userlog->content	= 'Posting Stock Opname  tgl '.tanggal_indonesia($tglopn, false).' berhasil diposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

 		//return Redirect::route('stockopnamedetail.cetak');					//cetak invoice
 		return Redirect::route('home');
    }

/* reprint inv */
    public function reprint($id)
    {
		session(['idinv'=>$id]);
		return Redirect::route('invoicedetail.reprint');				//cetak po
    }


// print form opname
    public function printform()
    {
        return view('stockopname.print_form');
    }
    
    public function printpdf()
    {
        $satuan = Stock::where('stock_akhir','!=', 0)
                            ->get();
                            
        $kemasan = DB::table('dt_invoice')
                    ->select(DB::raw('id_inv, type_brg, id_brg, inv_tgl, inv_qty, tonase_vol, qty_sale, tonase_sale, qty_out, tonase_out, qty_adj, tonase_adj'))
                    ->where('dt_invoice.type_brg', '=', 0)
                    ->whereRaw('tonase_vol - tonase_sale - tonase_out + tonase_adj != ?', [0])
					->orderBy('id_brg', 'ASC')
					->orderBy('inv_tgl', 'ASC')
                    ->get();	         
        
        $data = array();
     	$no=0;   
  
        foreach($satuan as $list){
            
            $row = array();
            $no++;
            
            $row[] = $no;
            $row[] = Product::Product($list->brg_id)->nama_brg;
            $row[] = format_uang($list->stock_akhir);
            $row[] = "";
            $row[] = "";
            
            $data[] = $row;
        }
		$data[] = array("---", "", "","","");
		
		$no=0;
        foreach($kemasan as $list){

            $no++;
            $qty = $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
            $tns = $list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj;
            
            $row = array();
            
            $row[] = $no;
            $row[] = Product::Product($list->id_brg)->nama_brg;
            $row[] = format_uang($qty).' / '.$tns;
            $row[] = "";
            $row[] = tanggal_indonesia($list->inv_tgl, false);
        
            $data[] = $row;
        }
        
        $data[] = array("---", "eof", "","","");
        
        $pdf = app('dompdf.wrapper');
        $pdf->getDomPDF()->set_option("enable_php", true);
        $pdf->loadView('stockopname.pdf_form', compact('data'));
        
        $pdf->setPaper('a4', 'portrait');
         
        return $pdf->stream();
        
    }
	
}
