<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Category;
use App\Supplier;
use App\Customer;
use App\Stock;
use App\Invoice;
use App\InvoiceDetail;
use App\Penjualan;
use App\PenjualanDetail;
use App\Mutasi;
use App\User;
use App\User_logs;
use Datatables;
use DB;
use Closure;
use Auth;


class StockController extends Controller
{
	
    public function index()
    {

		$category 	= Category::all()->sortBy('cat_name');  
		$supplier	= Supplier::all()->sortBy('sup_nama');

		return view('stock.index', compact('category','supplier'));
    }	

    function listdata()
    {

        $stock  = DB::table('dt_stock')
                        ->select(DB::raw('product_id, sum(stock_akhir) as stock '))
                        ->groupBy('product_id')                  
                        ->get();
                        
        $data = array();
        $no=1;
        foreach($stock as $list){
           
           $row = array();
		   $row[] = '<font size="4">'.$no++.'</font>';
           $row[] = '<font size="4">'.self::Product($list->product_id)->nama_brg.'</font>';
           $row[] = '<font size="4"><strong>'.format_uang($list->stock).'</strong></font>';
           $row[] = '<div class="btn-btn"><a onclick="showDetail('.$list->product_id.')" class="btn btn-primary btn-sm"><i class="fa fa-list"></i></a></div>';
           $data[] = $row;
        }

     $output = array("data" => $data);
     return response()->json($output);
   }

/*-----------------------------------------------------*/
    function getdata1()
    {

        $stock = DB::table('dt_stock')
                    ->leftjoin('ms_product', 'dt_stock.brg_id', '=', 'ms_product.id')
                    ->where('dt_stock.active_sts', '=', 1)
                    ->get();

        $data = array();

        foreach($stock as $list){
           
           $row = array();

           $row[] = $list->nama_brg;
           $row[] = number_format($list->stock_akhir,2,",",".");
           $row[] = '<div class="btn-btn"><a onclick="showDetail1('.$list->id_stock.')" class="btn btn-primary btn-xs"><i class="fa fa-list"></i></a></div>';
           $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
    }
    
/*-----------------------------------------------------*/
    function getdata0()
    {

        $stock = DB::table('dt_invoice')
                    ->select(DB::raw('dt_invoice.*, dt_invoice.created_at as tgl_msk, dt_invoice.active_sts'))
                    ->leftjoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
                    ->where('ms_product.type_brg', '=',0)
                    ->where('dt_invoice.active_sts', '=',1)
                    ->get();

        $data = array();

        foreach($stock as $list){
           
           $qtyoh = $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
           $stkoh = $list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj;
           $qtyout= $list->qty_sale + $list->qty_out ;
           $tonout= $list->tonase_sale + $list->tonase_out + $list->tonase_adj;
           
           $row = array();

           $row[] = $this->Product($list->id_brg)->nama_brg;
           $row[] = format_uang($list->inv_qty).' / '.number_format($list->tonase_vol,2,",",".");
           $row[] = format_uang($list->qty_sale).' / '.number_format($list->tonase_sale,2,",",".");
           $row[] = format_uang($list->qty_out).' / '.number_format($list->tonase_out,2,",",".");
           $row[] = format_uang($list->qty_adj).' / '.number_Format($list->tonase_adj,2,",",".");
           $row[] = format_uang($qtyoh).' / '.number_format($stkoh,2,",",".");
           $row[] = '<div class="btn-btn"><a onclick="showDetail('.$list->id_inv.')" class="btn btn-primary btn-xs"><i class="fa fa-list"></i></a></div>';
           $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);

    }
    
    function detail1($id){
        
        $dtinvoice = InvoiceDetail::leftjoin('ms_invoice', 'dt_invoice.invoice_id','=','ms_invoice.id_invoice')
						->where('dt_invoice.id_inv', '=', $id)
						->orderby('ms_invoice.inv_no','ASC')->get();
						
		$data=array();
		foreach($dtinvoice as $list){
		    $row = array();
		    $row[] = tanggal_indonesia($list->inv_tgl, false);
		    $row[] = $list->inv_no;
		    $row[] = Supplier::Supplier($list->supp_id)->sup_nama;
		    $row[] = $list->inv_qty;
		    $row[] = $list->tonase_vol;
		    
		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
        
    }
	    
	function detail2($id){

        $dtsale = PenjualanDetail::leftjoin('ms_sale', 'dt_sale.sale_id','=','ms_sale.id_sale')
						->where('dt_sale.inv_id', '=', $id)
						//->where('ms_sale.status_retur','=',1)
						->orderby('ms_sale.sale_tgl','DESC')->get();
						
		$data=array();
		
		foreach($dtsale as $list){
		    $row = array();
		    $row[] = tanggal_indonesia($list->sale_tgl, false);
		    $row[] = $list->sale_no;
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = $list->qty;
		    $row[] = $list->isi;
		    
		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
       	    
	}
	
    function detail3($id){
        
        $dtinvoice = InvoiceDetail::leftjoin('ms_invoice', 'dt_invoice.invoice_id','=','ms_invoice.id_invoice')
						->where('dt_invoice.id_inv', '=', $id)
						->get();
						
		$data=array();
		foreach($dtinvoice as $list){
			
			$sisaq = $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
			$sisat = $list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj;
			
		    $row = array();
		    $row[] = format_uang($list->inv_qty).' / '.$list->tonase_vol;
		    $row[] = format_uang($list->qty_sale).' / '.$list->tonase_sale;
		    $row[] = format_uang($list->qty_out).' / '.$list->tonase_out;
		    $row[] = format_uang($list->qty_adj).' / '.$list->tonase_adj;
		    if(!is_null($list->tgl_opname)){
		    $row[] = tanggal_indonesia($list->tgl_opname, false); }else{ $row[]=""; }
			$row[] = format_uang($sisaq).' / '.number_format($sisat,2,",",".");
		    
		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
        
    }
    
	function detail7($id){

        $dtmts = Mutasi::where('inv_id', '=', $id)
						->orderby('mts_tgl','DESC')->get();
						
		$data=array();
		
		foreach($dtmts as $list){
		    $row = array();
		    $row[] = tanggal_indonesia($list->mts_tgl, false);
		    $row[] = Product::Product($list->brg_tujuan)->nama_brg;
		    $row[] = format_uang($list->mts_qty);
		    $row[] = $list->mts_tonase;
		    
		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
       	    
	}    
    
/*----------------------------------------------------------------*/
   function detail4($id){
        
		$stk = Stock::find($id);
		$tglawal = $stk->tgl_opn;
		$idbrg	 = $stk->brg_id;
		
        $dtinvoice = InvoiceDetail::leftjoin('ms_invoice', 'dt_invoice.invoice_id','=','ms_invoice.id_invoice')
						->where('dt_invoice.id_brg', '=', $idbrg)
					//	->where('ms_invoice.inv_tgl', '>', $tglawal)
					    ->orderBy('ms_invoice.inv_tgl', 'DESC')
						->get();
						
		$data=array();
		foreach($dtinvoice as $list){
		    $row = array();
		    $row[] = tanggal_indonesia($list->inv_tgl,false);
		    $row[] = $list->inv_no;
		    $row[] = Supplier::Supplier($list->supp_id)->sup_nama;
		    $row[] = $list->inv_qty;
		    $row[] = $list->inv_isi;
		    
		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
        
    }
	    
	function detail5($id){
		$stk = Stock::find($id);
		$tglawal = $stk->tgl_opn;
		$idbrg	 = $stk->brg_id;		

        $dtsale = PenjualanDetail::leftjoin('ms_sale', 'dt_sale.sale_id', '=', 'ms_sale.id_sale')
									->where('dt_sale.brg_id', '=', $idbrg)
									//->where('ms_sale.sale_tgl', '>', $tglawal)
									->orderBy('ms_sale.sale_tgl', 'DESC')
									->get();
						
		$data=array();
		
		foreach($dtsale as $list){
		    $row = array();
		    $row[] = tanggal_indonesia($list->sale_tgl, false);
		    $row[] = $list->sale_no;
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = $list->qty;
		    $row[] = $list->isi;
		    
		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
       	    
	}
	
    function detail6($id){
        
        $list = Stock::find($id);
						
		$data=array();
				
		$row = array();
		$row[] = $list->stock_awal;
		$row[] = $list->barang_masuk;
		$row[] = $list->penjualan;
		$row[] = $list->trf_in;
		$row[] = $list->adjustment;
		$row[] = $list->stock_akhir;
		    
		$data[]= $row;
		
        
        $output = array("data" => $data);
        return response()->json($output);
        
    }	
/*----------------------------------------------------------------*/	
    function pilihdata()
    {
     	 $Produk = Product::leftJoin('ms_category', 'ms_category.id_cat', '=', 'ms_product.cat_id');
	 
		return Datatables::of($Produk)->make(true);
    }	

    public function store(Request $request)
    {
		$kode		= $request['kode'];
		$ada_kode	= DB::table('ms_product')
						->where('kode_brg', $kode)->count();
							
		if ($ada_kode<>0)
		{
			return json_encode(array('msg'=>'error'));
		} else {
		
	//save msster sku
			$produk = new Product;
		
			$produk->kode_brg	 = $kode;
			$produk->nama_brg    = $request['nama'];
			$produk->cat_id      = $request['cat'];
			$produk->brand		 = $request['brand'];
			$produk->supplier	 = $request['supl'];
			$produk->bahan	 	 = $request['bahan'];
			$produk->ukuran		 = $request['ukuran'];
			$produk->harga_list	 = $request['hglist'];
			$produk->harga_retail= $request['retail'];
			$produk->harga_bawah = $request['bawah'];
			$produk->deskripsi	 = $request['desk'];
			$produk->status_brg	 = 1;
			$produk->user_id	 = Auth::user()->id;
	 
			$produk->save();

		
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Master Barang Baru';
			$userlog->content	= 'Barang '.$kode.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
        
		}
    }

    public function edit($id)
    {
      $produk = Product::find($id);
      echo json_encode($produk);
    }


   public function show($id)
   {
	    $stdetail 	= Stock::where('product_id',$id)
	                        ->orderBy('dt_stock.cabang_id', 'DESC')
							->get();
	                        
		$data = array();		
		
		foreach ($stdetail as $detail)
		{
    		$row    = array();
			$row[]  = self::Cabang($detail->cabang_id)->cbg_kode;
			$row[]	= self::Product($detail->product_id)->nama_brg;
			$row[]  = $detail->no_seri;
			$row[]	= format_uang($detail->stock_akhir);
			
			$data[]	= $row;
		}

     $output = array("data" => $data);
     return response()->json($output);
	 
   }

////////////////
	
    public function update(Request $request, $id)
    {
		$produk = Product::find($id);
		
			$kode	= $produk->kode_brg;
			
			$produk->nama_brg    = $request['nama'];
			$produk->cat_id      = $request['cat'];
			$produk->brand		 = $request['brand'];
			$produk->supplier	 = $request['supl'];
			$produk->no_seri	 = $request['noseri'];
			$produk->ukuran	 	 = $request['ukuran'];
			$produk->harga_list	 = $request['hglist'];
			$produk->harga_retail= $request['retail'];
			$produk->harga_bawah = $request['bawah'];			
			$produk->deskripsi   = $request['desk'];
			$produk->user_id	 = Auth::user()->id; 
 
			$produk->update();
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit Master Product';
		$userlog->content	= 'Produk '.$kode.' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }

    public function koreksi()
    {
        
    }
    
    public function Product($id){
      return Product::find($id);
    }   
    
    public function Cabang($id){
      return Cabang::find($id);
    }  
    
    public function change_sts(){
     
        return view('stock.change_sts');   
    }
    
/*-----------------------------------------------------*/
    function getdata_1()
    {

        $stock = DB::table('dt_stock')
                    ->leftjoin('ms_product', 'dt_stock.brg_id', '=', 'ms_product.id')
                    ->get();

        $data = array();

        foreach($stock as $list){
           
           $row = array();

           $row[] = $list->nama_brg;
           $row[] = format_uang($list->stock_akhir);
           if($list->active_sts==1){
                $row[] = '<a onclick="change_1('.$list->id_stock.')" class="btn btn-success btn-xs"> active </a>';
           }else{
                $row[] = '<a onclick="change_1('.$list->id_stock.')" class="btn btn-danger btn-xs"> non active </a>';
           }
           
           $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
    }
    
/*-----------------------------------------------------*/
    function getdata_0()
    {

        $stock = DB::table('dt_invoice')
                    ->select(DB::raw('dt_invoice.*, dt_invoice.created_at as tgl_msk, dt_invoice.active_sts'))
                    ->leftjoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
                    ->where('ms_product.type_brg', '=',0)
                    ->get();

        $data = array();

        foreach($stock as $list){
           
           $qtyoh = $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
           $stkoh = $list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj;
           $qtyout= $list->qty_sale + $list->qty_out + $list->qty_adj;
           $tonout= $list->tonase_sale + $list->tonase_out + $list->tonase_adj;
           
           $row = array();

           $row[] = $this->Product($list->id_brg)->nama_brg;
           $row[] = format_uang($list->inv_qty).' / '.$list->tonase_vol;
           $row[] = format_uang($qtyout).' / '.$tonout;
           $row[] = format_uang($qtyoh).' / '.$stkoh;
          if($list->active_sts==1){
                $row[] = '<a onclick="change_0('.$list->id_inv.')" class="btn btn-success btn-xs"> active </a>';
           }else{
                $row[] = '<a onclick="change_0('.$list->id_inv.')" class="btn btn-danger btn-xs"> non active </a>';
           }           
           
           $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);

    }
    
    public function change_1($id){
        
        $stock = Stock::find($id);
        if($stock->active_sts==1){ $sts=0; }else{ $sts=1;}
        
        $stock->active_sts= $sts;
        $stock->update();
        
        echo json_encode(array('msg'=>'success'));
    }
    
     public function change_0($id){
        
        $inv = InvoiceDetail::find($id);
        if($inv->active_sts==1){ $sts=0; }else{ $sts=1;}
        
        $inv->active_sts= $sts;
        $inv->update();
        
        echo json_encode(array('msg'=>'success'));
    }
    
}
