<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Customer;
use App\Rute;
use App\Penjualan;
use App\Piutang;
use App\Setor;
use App\SetorDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;
use PDF;

class SetorDetailController extends Controller
{


    function tampildetail()
    {
        $idsetor    = session('idtrx');
        $dtsetor    = SetorDetail::where('setor_id', '=', $idsetor)->get();
        
        $no=0;
        $data = array();
        
        foreach($dtsetor as $list){
            $no++;
            $row = array();
            
            $row[] = $no;
            $row[] = $list->deskripsi;
            $row[] = $list->type;
            $row[] = '<div class="text-bold" align="right">'.format_uang($list->nominal).'</div>';
            
			if(Auth::user()->group=="MANAGER")
            {			
		        $row[] = '<div class="btn-btn">
				   <a onclick="deleteItem('.$list->id_dsetor.')" class="btn btn-danger btn-sm"><i class="fa fa-times"></i></a>
				   </div>';	
            }else{
                $row[] = "...";
            }
            
            $data[] = $row;
        }
        
        $output = array("data" => $data);
		return response()->json($output);	
        
    }

    public function simpandetail(Request $request){
        
        $idstr = session('idtrx');
        
        $dsetor = New SetorDetail;
        $dsetor->setor_id   = $idstr;
        $dsetor->deskripsi  = $request['desk'];
        $dsetor->nominal    = $request['nom'];
        $dsetor->type       = $request['tipe'];
        $dsetor->save();
        
        echo json_encode(array('msg'=>'success'));
    }

    public function destroy($id){
        
        $dsetor = SetorDetail::find($id);
        
        if($dsetor->status_hdr==1){
            return json_encode(array('msg'=>'error'));
        }else{
        
            $dsetor->delete();
        
            echo json_encode(array('msg'=>'success'));
        }
    }

    public function loadSummary(){
        
		$dtrans	= SetorDetail::where('setor_id',session('idtrx'))->get();
		
		$totalrp=0;

        foreach($dtrans as $list){
            
			if($list->type=="D"){
			    $totalrp += $list->nominal;
			}else{
			    $totalrp -= $list->nominal;
			}
        }
        
        $mtrans = Setor::find(session('idtrx'));
        
        $mtrans->setor_total = $totalrp ;
        $mtrans->update();
        
        $data = array("totalrp" =>format_uang($totalrp));
                      
        return response()->json($data);
    }

/*-----------------------------------------------------*/
	function tampil($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
			$ppn	= $list->inv_ppn;
			$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		$no=1;
		$m_inv		= Invoice::find($id);
		$supplier	= Supplier::find($idsupp);
		$product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    	
    
		return view('invoice_detail.index_history', compact('m_inv','supplier','product','idinv','no'));

	} 
	
/*-----------------------------------------------------*/
    public function edit($id)
    {
        $str = SetorDetail::find($id);
        echo json_encode($str);
    }
    
 
    public function show($id)
    {
        $dt = SetorDetail::find($id);
        echo json_encode($dt);
    }



	public function batal($id)	
	{
		$msale = Penjualan::find($id);
		
		if ($msale->sale_netto != 0){
			echo json_encode(array('msg'=>'error'));
		}else{	
			$msale->sale_batal = 1;
			$msale->update();
			echo json_encode(array('msg'=>'success'));
		}
	}	
	
/////////////////////////////////////////////////////////////////////////

	/* posting sale ke stock & cetak invoice */
	
    public function posting($id)
    {

		$msale 	    = Penjualan::find($id);
		$noinv      = $msale->sale_no;
		
		$dtinv  	= PenjualanDetail::where('sale_id', $id )->get();

		$totalinv	= 0;

		foreach($dtinv as $list){
            
            $iddsale    = $list->id_dsale;
            $idbrg      = $list->brg_id;
            $tglsale    = $list->sale_tgl;
            $qty        = $list->qty * $list->isi;
            $posted     = $list->sale_posted;
            
            if($list->type_brg==0){
			    $totalinv += $list->isi * $list->harga_retail - $list->potongan ;
            }else{
                $totalinv += $list->qty * $list->isi * $list->harga_retail - $list->potongan ;
            }

            if($list->type_brg==1){			
			    /* posting stock */
			    $data_stock  = Stock::where('brg_id',$idbrg)
			                    ->get();

			     if ($posted==0 AND $msale->status_retur==1){			     
    			     /*update stock */
    			     foreach ($data_stock as $dtstock)
    			     { 
    			        $stkakhir   = $dtstock->stock_akhir;
    			        $idstock    = $dtstock->id_stock; 
    			        $jual       = $dtstock->penjualan;
    			     }
    			     
    			     $stock = Stock::find($idstock);
    			     
    			     $stock->penjualan      = $jual + $qty;
    			     $stock->tgl_jual       = $tglsale;
    			     $stock->stock_akhir    = $stkakhir - $qty;
    			     
			         $stock->update();
			     } 
			 }

            /*update status posted inv detail */
            $det_sale = PenjualanDetail::find($iddsale);
            $det_sale->sale_posted = 1;
            
            $det_sale->update();
            
 		 }
		 
		 /* update ms_sale */
		 
		 $msale->sale_netto     = $totalinv;
		 $msale->sale_posted    = 1;
		 $msale->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Posting Penjualan';
		$userlog->content	= 'Inovice No. '.$noinv.' berhasil diposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

 		return Redirect::route('penjualan.index');					//cetak invoice
 		
    }

/* reprint inv */
    public function printform($id)
    {
		$mtrf	= Transfer::find($id);
		$dtrf	= TransferDetail::leftjoin('ms_product', 'dt_transfer.product_id', 'ms_product.id')
									->where('dt_transfer.transfer_id', $id)->get();
					
		$cabang	= Cabang::find($mtrf->to_id);
		$no=1;
		$totalqty=10;
		//return Redirect::route('transferdetail.print');				//cetak po
		return view('transfer_detail.cetak', compact('mtrf', 'dtrf', 'cabang', 'no', 'totalqty'));
    }

/*=================================================================================*/
/* print DO keluar pertgl hari ini */

    public function printdo($id){
        $tgl = date('Y-m-d');
        $no  = 1;
        $idrute = $id;
        
        $data = DB::table('dt_sale as A')
                ->select('A.brg_id','A.brg_nama','B.sale_route','A.type_brg')
                ->addSelect(DB::raw('SUM(A.qty) as qty, SUM(A.isi) as isi'))
                ->leftjoin('ms_sale as B', function($join)
                    {
                        $join->on('A.sale_id', '=', 'B.id_sale');
                    })
                ->where('B.sale_tgl','=', $tgl)
                ->where('B.sale_route', '=', $id)
				->where('B.status_retur', '=', 1)
                ->groupBy('A.brg_id')
                ->groupBy('A.brg_nama')
                ->groupBy('B.sale_route')
                ->groupBy('A.type_brg')
                ->get();
    
 
        //foreach($data as $list){ $idrute = $list->sale_route ;break;}        
        
        return view('penjualan.cetakdo', compact('data','no','idrute'));
    }

/* posting stock */
	/* posting opname ke stock & cetak opname */
	
    public function updatestock($id)
    {

		$mtrf    	= Transfer::find($id);
        $tgltrf     = $mtrf->trf_tgl;
        $idfrom     = $mtrf->from_id;
		$idto		= $mtrf->to_id;
        $cabang     = Cabang::find($idto);
        
		$dtrf 	 	= TransferDetail::where('transfer_id', $id )
		                                ->where('trf_posted', 0)
		                                ->get();

    /* proses posting stock  kurangi stock asal(from_id) dan tambah stock tujuan(to_id) */
		foreach($dtrf as $list) 
        {
            $id_detail  = $list->id_trf;
            $qty        = $list->trf_qty;
            $idbrg      = $list->product_id;
            $noseri     = $list->no_seri;
            
			$data_stock  = Stock::where('cabang_id', $idfrom)
			                    ->where('product_id', $idbrg)
			                    ->where('no_seri', $noseri)
			                    ->get();

			/* update stock asal (dikurangi) */			
			foreach ($data_stock as $dtstock)
			{  $idstock    = $dtstock->id_stock; }
			   			     
  			    $datastock  = Stock::find($idstock);
				$stk_old	= $datastock->stock_akhir;
				$out_old	= $datastock->trf_out;
				    			     
    			$datastock->trf_out       = $out_old + $qty;
    			$datastock->tgl_trout     = $tgltrf;
    			$datastock->stock_akhir   = $stk_old - $qty;
    			$datastock->user_id       = Auth::user()->id;
			    
		        $datastock->update();

			/* update stock tujuan */
			$stock_tuju  = Stock::where('cabang_id', $idto)
			                   ->where('product_id', $idbrg)
			                   ->where('no_seri', $noseri)
			                   ->get();
				
		
			$ada_stock   = $stock_tuju->count();

			if ($ada_stock==0)
			{
				/* insert stock */
				 $stock = New Stock;
				 $stock->cabang_id      = $idto;    
				 $stock->product_id     = $idbrg;
				 $stock->no_seri        = $noseri;
				 $stock->trf_in     	= $qty;
				 $stock->tgl_trin       = $tgltrf;
				 $stock->stock_akhir    = $qty;
				 $stock->user_id        = Auth::user()->id;
				 
				 $stock->save();

			 }else{
			     
				foreach ($stock_tuju as $stk_tuju)
				{ $idstock   = $stk_tuju->id_stock; }
			        
   			    $dtstock  	= Stock::find($idstock);
				$stk_old	= $dtstock->stock_akhir;
				$in_old		= $dtstock->trf_in;
				    			     
    			$dtstock->trf_in        = $in_old + $qty;
    			$dtstock->tgl_trin	    = $tgltrf;
    			$dtstock->stock_akhir   = $stk_old + $qty;
    			$dtstock->user_id       = Auth::user()->id;
			    
		        $dtstock->update();
			         
		     } 

            /*update status posted opn detail */
            $det_trf = TransferDetail::find($id_detail);
            $det_trf->trf_posted = 1;
            
            $det_trf->update();
            
		 }
		 
		 /* update ms_transfer */
		 
		 $mtrf->trf_posted   = 1;
		 $mtrf->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Posting Transfer Barang';
		$userlog->content	= 'Posting Transfer '.$mtrf->trf_no.' berhasil diposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

 		//return Redirect::route('stockopnamedetail.cetak');					//cetak invoice
 		return Redirect::route('home');
    }
	

	
	
/* history */
//-------------------------------
	public function history()
	{		
		$customer = Customer::all();
		
		return view('penjualan.history', compact('customer'));
	}	

/*------------------------------------------------------*/
    function history_header()
    {

      	$jual = Penjualan::where('ms_sale.sale_posted',1)
							->orderby('ms_sale.sale_no','ASC')->get();
		
		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
			
			$sts="";
			if($list->sale_lunas == 0){ $sts='blm lunas';}else{ $sts='LUNAS'; }
				   
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $this->NamaRute($list->sale_route)->driver;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $this->NamaCustomer($list->cust_id)->cus_name;
			$row[] = $sts;
			$row[] = '<div class="text" align="right">'.format_uang($list->sale_netto - $list->sale_bayar1 - $list->sale_bayar2 - $list->sale_bayar3).'</div>';
			$row[] = User::NamaUser($list->user_id)->username;
		    $row[] = '<div class="btn-btn">
				        <a onclick="showDetail('.$list->id_sale.')" class="btn btn-success btn-sm"><i class="fa fa-list"> detail </i></a></div>';	

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
										
			
    }


//------------------------------history detail

	public function history_detail($id)
	{

		$dtsale	= PenjualanDetail::where('sale_id','=',$id)->get();
		
		$data=array();
		
		foreach($dtsale as $list)
		{
		    
		    if($list->type_brg==0){
			    $tltrans = $list->harga_retail * $list->isi - $list->potongan;
			}else{
			    $tltrans = $list->harga_retail * $list->qty* $list->isi - $list->potongan;
			}
			
			$row   = array();
		    $row[] = $list->brg_nama;
            $row[] = '<div class="text" align="right">'.format_uang($list->harga_retail).'</div>';
            $row[] = $list->qty;
            $row[] = $list->isi;
            $row[] = $list->potongan;
            $row[] = '<div class="text" align="right">'.format_uang( $tltrans).'</div>';
            
            $data[] = $row;
		}
		
		$output = array("data" => $data);
		return response()->json($output);								
	
	} 
	
/* tagihan */
//-------------------------------
	public function tagihan()
	{		
		$sekarang = Date('Y-m-d');
		$awal	  = Date('Y-m-d', strtotime('-6 day', strtotime( $sekarang )));
        $customer = Customer::all();
        $rute     = Rute::whereBetween('tanggal', array($awal, $sekarang))->get();

        
		return view('penjualan.tagihan', compact('customer','rute'));
	}
	
    function tagihan_hdr()
    {

     	$jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.sale_batal',0)
								->where('ms_sale.sale_lunas', '=',0)
								->where('ms_sale.sale_netto', '>',0)
								->orderBy('ms_sale.cust_id','ASC')
								->orderby('ms_sale.sale_no','ASC')->get();
		
		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
			
			$sss = $list->status_retur;
			$sts="";
				switch ($sss){
					case '1': $sts = 'Invoice'; break;
					case '2': $sts = 'Retur'; break;}			
		
		    $row[] = "<input type='checkbox' name='id[]'' value='".$list->id_sale."'>";
			
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $this->NamaRute($list->sale_route)->driver;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $list->cus_name;
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto - $list->sale_bayar1 - $list->sale_bayar2 -$list->sale_bayar3).'</div>';

            if($sss==1){
		    $row[] = '<div class="btn-btn">
				        <a class="btn btn-primary btn-xs">Invoice </a>
				      </div>';	
            }else{
                $row[] = '<div class="btn-btn">
				        <a  class="btn btn-danger btn-xs">Retur  </a>
				      </div>';	
            }
            
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }
	
    public function printbill(Request $request)
    {
        $dtbill = array();
        
        foreach($request['id'] as $id){
            
   	        $jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.id_sale','=', $id)
								->where('ms_sale.sale_netto','>', 0)
								->orderBy('ms_sale.cust_id','ASC')
								->get();
								
			foreach($jual as $penjualan){
                    $dtbill[] = $penjualan;
			}
        }
        
        $no = 1;
        return view('penjualan.cetakbill', compact('dtbill','no'));
  
    }	
    
    public function printpdf(Request $request, $ukur)
    {
        $data = array();
     	$no=0;   
  
        foreach($request['id'] as $id){
            
   	        $jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.id_sale','=', $id)
								->where('ms_sale.sale_netto','>', 0)
								->orderBy('ms_sale.cust_id','ASC')
								->get();
			

			foreach($jual as $list){
			
			    $row = array();
			    $no++;
			    
			    $row[] = $no;
			    $row[] = $list->cus_name;
			    $row[] = $list->sale_no;
			    $row[] = tanggal_indonesia($list->sale_tgl, false);
			    $row[] = format_uang($list->sale_netto - $list->sale_bayar1 -$list->sale_bayar2 - $list->sale_bayar3);
			    
			    if($list->sale_bayar1>0){
			        $row[] = "ada cicilan";}else{$row[] ="";}
                
                $data[] = $row;
			}
        }
        $data[] = array("", "Admin", "Sopir", "","Mengetahui","");
         
        $pdf = app('dompdf.wrapper');
        $pdf->getDomPDF()->set_option("enable_php", true);
        $pdf->loadView('penjualan.pdf_tagihan', compact('data','ukur'));
        
        if($ukur=="2"){ $pdf->setPaper('a5', 'landscape'); } else {$pdf->setPaper('a4', 'portrait'); }
         
        return $pdf->stream();
        
    }

  public function exportPDF(Request $request){

 
     $data = $this->printpdf($request);

    // $pdf = PDF::loadView('report.pdf', compact('tanggal_awal', 'tanggal_akhir', 'data','hal'));
     
     $pdf = app('dompdf.wrapper');
     $pdf->getDomPDF()->set_option("enable_php", true);
     $pdf->loadView('penjualan.pdf_tagihan', compact('data'));
    
     $pdf->setPaper('a4', 'potrait');
     
     return $pdf->stream();
   }


    public function printbill_new($id)
    {
        $dtbill = array();
        $idrute = $id;
        $jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
						->where('ms_sale.sale_route','=', $id)
						->where('ms_sale.sale_netto','>', 0)
						->where('ms_sale.sale_lunas', '=', 0)
						->orderBy('ms_sale.cust_id','ASC')
						->get();
								
		foreach($jual as $penjualan){
            $dtbill[] = $penjualan;
		}
        
        $no = 1;
        return view('penjualan.cetakbill', compact('dtbill','no','idrute'));
  
    }	

    
}
