<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Customer;
use App\Rute;
use App\Penjualan;
use App\Piutang;
use App\Setor;
use App\SetorDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;
use PDF;

class SetorController extends Controller
{

	public function index()
	{		
		
		$customer = Customer::all();
	
		return view('setor.index', compact('customer'));
	}
	
    function getheader()
    {
		$tglnow = date("Y-m-d");

        $setor  = Setor::where('is_cancel',0)->get();

		$data = array();
		
		foreach($setor as $list)
		{
			$row = array();
				   
			$row[] = $list->setor_tgl;
			$row[] = $list->setor_bank;
			$row[] = $list->deskripsi;
			$row[] = tanggal_indonesia($list->tgl_terima, false);			
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->setor_total).'</div>';

			$row[] = User::NamaUser($list->user_id)->username;	
			
			if(!is_null($list->image)){
			   // $row[] = '<img src="'.$list->image.'" style="height:80px;width:100px;">';

                $row[]='<a style="cursor:pointer" onclick="showImage('.$list->id_setor.')"> <img src="'.$list->image.'" style="height:60px;width:100px;"></a>';

			}else{ $row[]=""; }
			
			if(Auth::user()->group=="MANAGER")
            {			
		    //     $row[] = '<div class="btn-btn">
			//	   <a href="setor/'.$list->id_setor.'/input" class="btn btn-success btn-sm"><i class="fa fa-plus"></i></a>
			//	   <a onclick="editHeader('.$list->id_setor.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
			//	   <a onclick="uploadImage('.$list->id_setor.')" class="btn btn-info btn-sm"><i class="fa fa-picture-o"></i></a>
			//	   <a onclick="batal('.$list->id_setor.')" class="btn btn-danger btn-sm"><i class="fa fa-times"></i></a>
			//	   </div>';	
			
			    $row[]= '<div class="btn-group">
                  <button  class="btn btn-outline-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				  <i class="fa fa-caret-down"></i>
                  </button>
                  <ul class="dropdown-menu dropdown-menu-right" style="border:1px black solid;">
                    <li><a href="setor/'.$list->id_setor.'/input"><i class="fa fa-plus"></i>Input Detail</a></li>
                    <li><a onclick="editHeader('.$list->id_setor.')"><i class="fa fa-pencil"></i>Edit Header </a></li>
                    <li><a onclick="uploadImage('.$list->id_setor.')"><i class="fa fa-picture-o"></i>Upload Slip </a></li>
                    <li><a onclick="batal('.$list->id_setor.')"><i class="fa fa-trash"></i>Batal Setoran</a></li>
                  </ul>
                </div>';			
			
			
            }else{
            //    $row[] = '<div class="btn-btn">
			//	   <a href="setor/'.$list->id_setor.'/input" class="btn btn-success btn-sm"><i class="fa fa-plus"></i></a>
			//	   <a onclick="editHeader('.$list->id_setor.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
			//	   <a onclick="uploadImage('.$list->id_setor.')" class="btn btn-info btn-sm"><i class="fa fa-picture-o"></i></a>
			//	   </div>';	
			
			    $row[]= '<div class="btn-group">
                  <button  class="btn btn-outline-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				  <i class="fa fa-caret-down"></i>
                  </button>
                  <ul class="dropdown-menu dropdown-menu-right" style="border:1px black solid;">
                    <li><a href="setor/'.$list->id_setor.'/input"><i class="fa fa-plus"></i>Input Detail</a></li>
                    <li><a onclick="editHeader('.$list->id_setor.')"><i class="fa fa-pencil"></i>Edit Header </a></li>
                    <li><a onclick="uploadImage('.$list->id_setor.')"><i class="fa fa-picture-o"></i>Upload Slip </a></li>
                  </ul>
                </div>';	
			
            }


		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }

///-- create new 
	public function store(Request $request)
	{

		$trans	= New Setor;
		$trans->setor_tgl       = $request['tgltrx'];
		$trans->tgl_terima      = $request['tgltrm'];
		$trans->setor_bank      = $request['bank'];
		$trans->deskripsi       = $request['catat'];
		$trans->posted_sts      = 0;
		$trans->user_id	        = Auth::user()->id;
		
		$trans->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'SETORAN baru';
			$userlog->content	= 'Setoran tgl. '.$request['tgltrx'].' berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}

//-------------------------------
	function input($id)
	{
	    if(Auth::user()->setor_add!=1){
	        return Redirect::route('setor.index');
	    }
	    
		session(['idtrx'=>$id]);
		
		$idtrx	    = $id;
		$setor      = Setor::find($id);
		
		$byr    	= Piutang::where('lunas_tgl','=', $setor->tgl_terima)
		                       ->where('sts_posted', '=', 1)->get();
		                       
        $cicil1     = Penjualan::where('bayar1_tgl', '=', $setor->tgl_terima)->get();
        $cicil2     = Penjualan::where('bayar2_tgl', '=', $setor->tgl_terima)->get();
        $cicil3     = Penjualan::where('bayar3_tgl', '=', $setor->tgl_terima)->get();
        
		$ttl = 0;
		foreach($byr as $list)
		{
			$ttl += $list->total_bayar;
		}
		
        foreach($cicil1 as $list)
        {
            $ttl    += $list->sale_bayar1;
        }

        foreach($cicil2 as $list)
        {
            $ttl    += $list->sale_bayar2;
        }


        foreach($cicil3 as $list)
        {
            $ttl    += $list->sale_bayar3;
        }
        
    	
    	if($setor->penerimaan==0)
    	{
    	    $setor->penerimaan = $ttl;
    	    $setor->update();
    	    
        	$setord = New SetorDetail;
        	
        	$setord->setor_id   = $id;
        	$setord->deskripsi  = 'Total Penerimaan dari Customer tgl. '.$setor->tgl_terima;
        	$setord->nominal    = $ttl;
        	$setord->type       = "D";
        	$setord->status_hdr  = 1;
        	$setord->save();
    	}else{
    	    
    	    $setor->penerimaan = $ttl;
    	    $setor->update();
    	    
        	$strd = SetorDetail::where('setor_id', '=', $id)
        	                        ->where('status_hdr', '=',1)
        	                        ->get();
        	
        	foreach($strd as $dt){  $idstr = $dt->id_dsetor; 
        	
            	$setord = SetorDetail::find($idstr);
    
            	$setord->nominal    = $ttl;
            	$setord->update();    	    
        	}
    	}
    	
     	return view('setor.index_detail', compact('idtrx', 'setor'));

	} 

	public function update(Request $request, $id)
	{
		$str = Setor::find($id);
		
		$str->setor_tgl     = $request['tgltrx'];
		$str->setor_bank    = $request['bank'];
		$str->deskripsi     = $request['catat'];
		$str->update();
		
		echo json_encode(array('msg'=>'success'));
	}	

    public function posting($id){
        
        $setor  = Setor::find($id);
        $setor->posted_sts = 1;
        $setor->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Posting Setoran';
		$userlog->content	= 'Setoran tgl. '.$setor->setor_tgl.' berhasil diposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        return Redirect::route('setor.index');	
    }
 
/*-----------------------------------------------------*/
	function tampil($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
			$ppn	= $list->inv_ppn;
			$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		$no=1;
		$m_inv		= Invoice::find($id);
		$supplier	= Supplier::find($idsupp);
		$product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    	
    
		return view('invoice_detail.index_history', compact('m_inv','supplier','product','idinv','no'));

	} 
	
/*-----------------------------------------------------*/
    public function edit($id)
    {
        $str = Setor::find($id);
        echo json_encode($str);
    }
    
 
    public function show($id)
    {
        $str = Setor::find($id);
        echo json_encode($str);
    }

   public function slip($id)
   {
	    $setor 	= Setor::where('id_setor', '=', $id)->get();
	    
		$data   = array();	
		
		$no=0;
		
		foreach ($setor as $detail)
		{
	
			$usernm	= User::find($detail->user_id);
			
			$no++;
			
     		$row    = array();
			$row[]  = $no;
			$row[]  = "Tgl. Setor";
			$row[]	= tanggal_indonesia($detail->setor_tgl, false);
			$data[] = $row;
			
			$no++;
			$row    = array();
			$row[]  = $no;
			$row[]  = "Bank";
			$row[]	= $detail->setor_bank;
 			$data[] = $row;

			$no++;
			$row    = array();
			$row[]  = $no;
			$row[]  = "Total Setor";
			$row[]	= format_uang($detail->setor_total);
 			$data[] = $row;			
			
			if(!is_null($detail->image)){
				$no++;
				$row	= array();
				$row[]	= $no;
				$row[]	= '<div><a onclick="removeImage('.$detail->id_setor.')" class="btn btn-danger"><i class="fa fa-trash"></i>remove</a></div>';
				$row[]	= '<img src="'.$detail->image.'" class="img-fluid" height="250" width="600" >';
				$row[]	= "";
				$data[]	= $row;			
			}
		}

        $output = array("data" => $data);
        return response()->json($output);
	 
   }
   
   
	public function removeImage($id)
	{
		$setor = Setor::find($id);
		$file_img = $setor->image;
		
		$setor->image = null;
		$setor->update();
		
		//hapus file gambar
		unlink($file_img);
		
		echo json_encode(array('msg'=>'success'));
		
	}   

	public function batal($id)	
	{
		$setor = Setor::find($id);
		
		if ($setor->setor_total != 0 || $setor->penerimaan !=0){
			echo json_encode(array('msg'=>'error'));
		}else{	
			$setor->is_cancel= 1;
			$setor->update();
			echo json_encode(array('msg'=>'success'));
		}
	}	
	
/////////////////////////////////////////////////////////////////////////



/* reprint inv */
    public function printform($id)
    {
		$setor	= Setor::find($id);
		$dsetor	= SetorDetail::where('setor_id', $id)->get();
		$no = 1;
					
		return view('setor.cetak', compact('setor', 'dsetor', 'no'));
    }


}
