<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use DB;
use Session;

use App\User;
use App\User_logs;
use App\Cashier;
use App\MSSession;
use App\Company;
use App\Outlet;
use App\MSale;
use App\MSPayment;

class SessiController extends Controller
{
    public function index()
    {
		return view('sessi.index');
    }

    public function startSessi(){
        
        if(CompanyController::CekValidStatus()==false){
            //Session::flash('error','Service Expired ! ');
            return back();
        }
        
        $outlet = Outlet::find(Auth::user()->outlet_id);
        return view('sessi.start_sessi', compact('outlet'));
    }
    
    public function sessiMgr()
    {
        return view('sessi.index_mgr');
    }

    public function listData()
    {
        Session::flash('');
        
	    $sesi = DB::table('ms_session')
	                ->where('company_id', Auth::user()->company_id)
                    ->where('tanggal', date('Y-m-d'))
                    ->where('outlet_id', Auth::user()->outlet_id)
                    ->orderBy('id','DESC')
                    ->get();
        $data =[];
        foreach($sesi as $list){
       
            switch($list->is_closed){
                case 0 : $sts ='<div class="label label-success">active</div>'; break;
                case 1 : $sts ='<div class="label label-danger">closed</div>'; break;
            }
    
            $row =[];

            //$total = $list->cash + $list->debit + $list->credit + $list->voucher;
    
            $row[] = tanggal_indonesia($list->tanggal, false);
            $row[] = Cashier::getCashier($list->cashier_id)->cashier_name;
            //$row[] = $list->shift;
            $row[] = format_uang($list->modal);
            $row[] = format_uang($list->brutto);
            $row[] = format_uang($list->disc);
            $row[] = format_uang($list->brutto-$list->disc);
            $row[] = format_uang($list->biaya);
            $row[] = $sts;
            $data[] = $row;
        }
    
        $output = array("data" => $data);
        return response()->json($output);
	 
   }

    public function listSessi()
    {
        $tgl1 = Date('Y-m-d');
        $tgl0 = date('Y-m-d', strtotime("-31 day", strtotime($tgl1)));
    
	    $sesi = DB::table('ms_session')
	                ->where('company_id', AUth::user()->company_id)
                    ->whereBetween('tanggal', [$tgl0, $tgl1])
                    ->orderBy('id','DESC')
                    ->get();

        $data = [];
        foreach($sesi as $list){
       
            switch($list->is_closed){
                case 0 : $sts ='<div class="label label-success">active</div>'; break;
                case 1 : $sts ='<div class="label label-danger">closed</div>'; break;
            }

            $row = [];

            $row[] = tanggal_indonesia($list->tanggal, false);
            $row[] = Cashier::getCashier($list->cashier_id)->cashier_name;
            $row[] = format_uang($list->modal);
            $row[] = format_uang($list->brutto);
            $row[] = format_uang($list->disc);
            $row[] = format_uang($list->brutto-$list->disc);
            $row[] = format_uang($list->biaya);
            $row[] = $sts;
            $row[] = '<a onclick="showDetail('.$list->id.')" class="btn btn-primary btn-xs"><i class="fa fa-list"></i></a>';
            $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
    }

    public function show($id){
        
    }

/*simpan sessi */    
    public function store(Request $request)
    {

        $ksr = Cashier::where('company_id', Auth::user()->company_id)
                        ->where('cashier_name', $request['kasir'])
                        ->where('password', $request['psw'])
                        ->where('is_active',1)
                        ->first();

        if(empty($ksr) || $ksr->outlet_id != Auth::user()->outlet_id){
            Session::flash('error','Invalid Kasir ! ');
            return back();
        }    
        
        $sesi1 = MSSession::where('company_id', Auth::user()->company_id)
                            ->where('tanggal', date('Y-m-d'))
                            ->where('cashier_id', $ksr->id)
                            ->where('is_closed', 1)
                            ->count();        
        
        if($sesi1>0) {
            //return Redirect::back()->withErrors(['error' => 'Sesi Anda sudah pernah !']); 
            //Session::flash('error','Sesi anda sudah pernah ! ');
            //return back();
            return json_encode(["msg"=>"error"]);
        }    
        
        $sesi = MSSession::where('company_id', Auth::user()->company_id)
                            ->where('tanggal', date('Y-m-d'))
                            ->where('cashier_id', $ksr->id)
                            ->where('is_closed',0)
                            ->first();
                            
        if(empty($sesi)){
        
    		$ss = new MSSession;
    	    
    	    $tkn = substr(bcrypt(date('Y-m-d').Auth::user()->company_id.$request['kasir']),0,50);
    		
    		$ss->company_id = Auth::user()->company_id;
    		$ss->outlet_id  = Auth::user()->outlet_id;
    		$ss->cashier_id	= $ksr->id;
    		$ss->tanggal  	= date('Y-m-d');
            $ss->shift      = 1;
            $ss->is_closed  = 0;
            $ss->modal      = $request->saldo;
            $ss->sessi_token= $tkn;
    		$ss->save();
        
        }else{
            
            if($ksr->id != $sesi->cashier_id){ 
                Session::flash('error','Invalid Kasir ! ');
                return back();
            }
            
            $tkn=$sesi->sessi_token;
        }
    		
    	session(['idtrx' => $tkn]);
		
		echo json_encode(array('msg'=>'success'));
		
    }

    public static function cekOutlet(){
        //if(empty(session('idtrx'))){ return false; }
        
        if(Auth::user()->outlet_id != 0){
            return Outlet::find(Auth::user()->outlet_id);
        }
    }

    public function edit($id)
    {
        $ss = Sessi::find($id);
        echo json_encode($ss);
    }

    public function update(Request $request, $id)
    {
		  $ss = Sessi::find($id);
		  $ss->is_closed	= 1;
		
		  $ss->update();
		  
		  echo json_encode(array('msg'=>'success'));
    }

    public function cek_sessi()
    {
        $se = MSSession::where('tanggal', '=', date('Y-m-d'))
                        ->where('is_closed', '=', 0)
                        ->count();
                        
        if ($se != 0){ return json_encode(array('msg' => 'error')); }
      
        $ss = MSSession::where('tanggal', '=', date('Y-m-d'))
                        ->where('is_closed', '=', 1)
                        ->count();

        if($ss==2) { return json_encode(array("msg"=>"error2")); }

        if($ss==0) { $shf="1"; }else{ $shf="2"; }
        echo json_encode(array("shift" => $shf));
    }

    public function ceksessi()
    {
        $se = MSSession::where('tanggal', '=', date('Y-m-d'))
                        ->where('is_closed', '=', 0)
                        ->count();
                        
        if ($se != 0){ return json_encode(array('msg' => 'error')); }
      
        $ss = MSSession::where('tanggal', '=', date('Y-m-d'))
                        ->where('is_closed', '=', 1)
                        ->count();

        if($ss==2) { return json_encode(array("msg"=>"error2")); }

        if($ss==0) { $shf="1"; }else{ $shf="2"; }
        echo json_encode(array("shift" => $shf));
    }


    public function cekstatus()
    {
        $se = MSSession::where('tanggal', '=', date('Y-m-d'))
                        ->where('sessi_token', session('idtrx'))
                        ->where('is_closed', '=', 0)
                        ->first();

        if (empty($se))
        { return json_encode(array('shift' => 'shift0')); }

        if($se->shift=="1")
        { return json_encode(array("shift"=>"shift1")); }

        if($se->shift=="2")
        { return json_encode(array("shift"=>"shift2")); }
    }

    public function detail($id)
    {
        $cmp        = Company::find(Auth::user()->company_id);
        $se = MSSession::where('id',$id)->get();
        
        $dt = DB::table('msale as A')
                    ->select('A.type_bayar as type')
                    ->addSelect(DB::raw('SUM(A.sale_total) as totalsl'))
                    ->where('A.sessi_id', $id)
                    ->groupBy('A.type_bayar')
                    ->get();

        
        $data= [];

        foreach($se as $ss)
        {
            $row = [];
            $row[] = "Tanggal";
            $row[] = tanggal_indonesia($ss->tanggal, false);
            $data[] = $row;
    
            $row = [];
            $row[] = "Kasir";
            $row[] = Cashier::getCashier($ss->cashier_id)->cashier_name;
            $data[] = $row;
    
            $row= [];
            $row[] = "Modal Awal";
            $row[] = format_uang($ss->modal);
            $data[] = $row;

            $row= [];
            $row[] = "BRUTTO";
            $row[] = format_uang($ss->brutto);
            $data[] = $row;            
    
            $row= [];
            $row[] = "DISC";
            $row[] = format_uang($ss->disc);
            $data[] = $row;
            
            $row= [];
            $row[] = "TOTAL NETTO";
            $row[] = format_uang($ss->brutto-$ss->disc);
            $data[] = $row;

		    foreach($dt as $list){
		        $row=[];
		        $row[] = MSPayment::getPayment($cmp->id, $list->type)->pay_kode;
		        $row[] = format_uang($list->totalsl);
		        $data[]=$row;
            }

        }

        $output = array("data" => $data);
        return response()->json($output);
    }

/*fungsi string*/
    public function strAngka($hg, $len){
        $strangka = format_uang($hg);
        $langka = strlen($strangka);
        $lspc = $len - $langka;
        
        $strHg=$this->space($lspc).$strangka;
        return $strHg;
    }
    
    public function space($len){
        $strSpc="";
        $i=1;
        while($i<=$len){ $strSpc=$strSpc."%20"; $i++; }
        return $strSpc;
    }
    
    public function center($strCenter,$lbrkolom){
        $lspc=($lbrkolom-strlen($strCenter))/2;

        return $this->space($lspc).$strCenter;
    }



/* closing shift 1 */
    public function closing__1()
    {

        $sesi = MSSession::where('tanggal', date('Y-m-d'))
                        ->where('company_id', Auth::user()->company_id)
                        ->where('sessi_token', session('idtrx'))
                        ->where('shift', '=', 1)
                        ->first();

        if(empty($sesi)){ return json_encode(['msg' => 'error']); }
        
        $sesi->is_closed=1;
        $sesi->update();
        
        echo json_encode(['msg'=>'success']);
        
    }
    
     
    public function closing1(){ 
        
		$cmp        = Company::find(Auth::user()->company_id);
		
        $sesi = MSSession::where('tanggal', date('Y-m-d'))
                        ->where('company_id', Auth::user()->company_id)
                        ->where('sessi_token', session('idtrx'))
                        ->where('is_closed',0)
                        ->first();
        
        if(empty($sesi)){ return json_encode(["msg"=>"error"]); }
                                
        $outlet = Outlet::find($sesi->outlet_id);
        
        $det = DB::table('dsale as A')
                    ->select('A.product_name')
                    ->addSelect(DB::raw('SUM(A.qty) as qty'))
                    ->leftjoin('msale as B', function($join)
                        {
                            $join->on('A.msale_id','=','B.id');
                        })
                    ->where('B.sessi_id', $sesi->id)
                    ->where('B.is_posted',1)
                    ->groupBy('A.product_name')
                    ->orderBy('A.product_name')
                    ->get();

                    
        $dt = DB::table('msale as A')
                    ->select('A.type_bayar as type')
                    ->addSelect(DB::raw('SUM(A.sale_total) as totalsl'))
                    ->where('A.sessi_id', $sesi->id)
                    ->groupBy('A.type_bayar')
                    ->get();
                   
		$ksr   = Cashier::getCashier($sesi->cashier_id)->cashier_name;        
        
 
        /*initial font/printer */
        $pin = 0;
        $on_ms = 120;
        $off_ms = 240;
        
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);
        $cut        = Chr(27) . Chr(109);   
        $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);
        //chr(27)+'p'+chr(0)+chr(20)+chr(20))
        
        
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontSedang	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);

        $lebarkolom = $outlet->printer_col;     /*40;*/
        
        if($lebarkolom==31){
            $grs ="-------------------------------\n";
        }else{
            $grs ="----------------------------------------\n";
        }        
        $struk   = $initialized;
        $struk  .= $outlet->outlet_name."\n\n";       
		$struk  .="-- REKAP PENJUALAN -- \n";
		
                /* 123456789012345*/

		$struk  .="Tanggal       : " .tanggal_indonesia($sesi->tanggal, false)."\n";
		$struk  .="Kasir         : " .$ksr."\n";
		$struk  .="MODAL         : " .SalesController::strAngka($sesi->modal,12)."\n";
		$struk  .="BRUTTO        : " .SalesController::strAngka($sesi->brutto,12)."\n";
		$struk  .="DSICOUNT      : " .SalesController::strAngka($sesi->disc,12)."\n";
		$struk  .="NETTO         : " .SalesController::strAngka($sesi->brutto-$sesi->disc,12)."\n\n";
		
		foreach($dt as $list){
		    
		    $ketpay = MSPayment::getPayment($cmp->id, $list->type)->pay_kode;
		    $lspc   = 14 - strlen($ketpay);           //lebar kolom untuk keteranga 15kol-1 untuk tanda (:)
		    
		    $strPay = $ketpay.SalesController::space($lspc).": ".SalesController::strAngka($list->totalsl,12);
		    
            $struk .= $strPay."\n";
               
        }
        
        $struk  .="BIAYA         : " .SalesController::strAngka($sesi->biaya,12)."\n";
        $struk  .= $grs."\n\n\n";
        
        $struk .= "= Rekap Penjualan Produk = \n";
        $struk .= $grs;
        
        foreach($det as $dd){
            $aa = $dd->product_name.str_repeat(' ',40);
            $aaa = substr($aa, 0 , $lebarkolom-5);

            $struk .= $aaa.SalesController::strAngka($dd->qty,5)."\n";
        }
        $struk .= $grs."\n";
        $struk .= "*** end of Rekap *** "."\n\n";
        $struk .= $fontKecil.date('Y-m-d H:i:s')."\n\n\n\n\n\n".$fontNormal;
        $struk .= $cut;
        
        $sesi->is_closed=1;
        $sesi->update();        
        session(['idtrx' =>"" ]);   //reset session
        
        $dt = "intent:base64," . base64_encode($struk) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
  
        $output = ["data"=>$dt];

        return response()->json($output);
    }

  //proses tutup hari
  public function closing2()
  {
    // cek transaksi yg belum selesai
      $tglnow = date('Y-m-d');
        $sl = MSale::where('company_id', Auth::user()->company_id)
                        ->where('sale_tgl', date('Y-m-d'))
                        ->where('is_posted',0)
                        ->count();
                        
      if($sl>0) { return Redirect::back()->withErrors(['closing-gagal' => 'Masih ada transaksi yang belum selesai !']); }
          
      $se = Sessi::where('tanggal', $tglnow)
                    ->where('shift', '=', 2)
                    ->first();

        if(empty($se)){ return json_encode(array('msg' => 'error')); }

        //print rekap sessi kasir shift-1
        try {
           
              $ip 	 = Seting::Seting()->prtdapur_noip;
              $printer = Seting::Seting()->prtdapur_name;
          
              $connector = new WindowsPrintConnector("smb://" . $ip . "/" . $printer);
              $printer = new Printer($connector);
                
                //cetak header
              $printer -> text("REKAP  \n");
              $printer -> text("KASIR-Shift : " . User::cekUser($se->kasir_id)->username.' - '.$se->shift. "\n");
              $printer -> text("Tanggal     : " . tanggal_indonesia($se->tanggal, false). "\n");
              $printer -> text("==============================="."\n");
                
              $printer -> text("\n"); 
      
    
              $printer -> text("\n---------eof: rekap------------\n\n");		
        

              //potong kertas & close
              $printer -> cut();
              $printer -> close();

              $se->is_closed = 1;
              $se->update();
            
              //cetak rekap
             // $this->rekapMenu($tglnow);
             $trx = Transaksi::where('sale_tgl', '=', $tglnow)->get();
             $dtrans = [];
             foreach($trx as $list){ $dtrans[] = $list->order_id; }
         
             $rkpMenu = DB::table('dt_order as A')
                           ->select('A.menu_id', 'B.btn_id', 'B.menu_desk')
                           ->addSelect(DB::raw('SUM(A.qty) as qty, A.order_id'))
                           ->leftjoin('ms_menu as B', function($join)
                               {
                                   $join->on('A.menu_id', '=', 'B.id_menu');
                               })
                           ->whereIn('A.order_id', $dtrans)
                           ->groupBy('B.btn_id')
                           ->groupBy('A.menu_id')
                           ->groupBy('B.menu_desk')
                           ->orderBy('B.btn_id','ASC')
                           ->get();
         
               $no=0;
               return view('sessi.rekap', compact('rkpMenu', 'no'));
             //return Redirect::back()->withErrors(['closing-shift' => 'Proses Tutup Hari berhasil !']);
        
            } catch (Exception $e) {
                $response = ['success'=>'false'];
          }		

  }

  public function rekapMenu($tglnow)
  {

    $trx = Transaksi::where('sale_tgl', '=', $tglnow)->get();
    $dtrans = [];
    foreach($trx as $list){ $dtrans[] = $list->order_id; }

    $rkpMenu = DB::table('dt_order as A')
                  ->select('A.menu_id', 'B.btn_id', 'B.menu_desk')
                  ->addSelect(DB::raw('SUM(A.qty) as qty, A.order_id'))
                  ->leftjoin('ms_menu as B', function($join)
                      {
                          $join->on('A.menu_id', '=', 'B.id_menu');
                      })
                  ->whereIn('A.order_id', $dtrans)
                  ->groupBy('B.btn_id')
                  ->groupBy('A.menu_id')
                  ->groupBy('B.menu_desk')
                  ->orderBy('B.btn_id','ASC')
                  ->get();

      $no=0;
      return view('sessi.rekap', compact('rkpMenu', 'no'));
     
      foreach($rkpMenu as $data)
      {
        //print rekap menu terjual
        try {
           
          $ip 	   = Seting::Seting()->prtdapur_noip;
          $printer = Seting::Seting()->prtdapur_name;
      
          $connector = new WindowsPrintConnector("smb://" . $ip . "/" . $printer);
          $printer   = new Printer($connector);
            
            //cetak header
          $printer -> text("REKAP MENU \n");
          $printer -> text("Tanggal     : " . tanggal_indonesia($tglrekap, false). "\n");
          $printer -> text("==============================="."\n");
            
          $printer -> text("\n"); 
  

          $printer -> text("\n---------eof: rekap------------\n\n");		
    

          //potong kertas & close
          $printer -> cut();
          $printer -> close();

          return;
    
        } catch (Exception $e) {
            $response = ['success'=>'false'];
        }		
      }
  }

  public function log_out()
  {
    return Redirect('logout');
  }

}
