<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use Datatables;
use Auth;
use DB;
use Session;

use App\User;
use App\Setting;
use App\Company;
use App\Outlet;
use App\Category;
use App\Product;
use App\Stock;
use App\MSSession;
use App\Customer;
use App\MSale;
use App\DSale;
use App\Cashier;
use App\Biaya;
use App\MSPayment;


class SalesController extends Controller
{
    
    public function index(){
        //return view('sales.index_sales');
    }
    
    public function cashier(){
        $outlet = Outlet::where('company_id', Auth::user()->company_id)
                        ->get();
                        
        return view('sales.cashier', compact('outlet'));
    }

    public function dataCashier(){
        $ksr = Cashier::all();
        
        $data=[];
        foreach($ksr as $csr){
            $row=[];
            $row[]=$csr->cashier_name;
            $row[]=tanggal_indonesia($csr->tglkerja, false);
            $row[]=Outlet::getOutlet($csr->outlet_id)->outlet_name;
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$csr->id.')" class="btn btn-danger btn-sm"><i class="fa fa-pencil-square-o"></i> </a>
    			    </div>';
    			    
            $data[]=$row;
        }
        
        $output = ["data"=>$data];
        return response()->json($output);
        
    }
    
    public function simpanCashier(Request $request){
        $ksr = new Cashier;
        $ksr->company_id    = Auth::user()->company_id;
        $ksr->outlet_id     = $request['outlet'];
        $ksr->cashier_name  = $request['nama'];
        $ksr->tglkerja      = $request['tgl'];
        $ksr->password      = $request['psw'];
        $ksr->is_active     = 1;
        $ksr->save();
        
        echo json_encode(["msg"=>"success"]);
    }

    public function editcashier($id){
        $ksr = Cashier::find($id);
        echo json_encode($ksr);
    }

    public function simpaneditcashier(Request $request, $id){
        $ksr = Cashier::find($id);
        
        $ksr->outlet_id     = $request['outlet'];
        $ksr->cashier_name  = $request['nama'];
        $ksr->tglkerja      = $request['tgl'];
        $ksr->password      = $request['psw'];        
        $ksr->update();
        
        echo json_encode(["msg"=>"success"]);
    }
    
/*-----------------------------------------------------*/
    public function index_product(){
        return view('sales.index_product');
    }
    
    public function ProductList(){
        $prd = Product::all();
		$data = [];
		
		foreach($prd as $list){
			$row = [];
			
			$row[] = $list->product_name ;
            $row[] = '<div style="text-align:right" class="container">'.format_uang($list->retail_price).'</div>';
  		
			$data[] = $row;
        }

        $output = ["data" => $data];
        return response()->json($output);
	}	         


    public function index_stock(){
        
        $outlet = Outlet::find(Auth::user()->outlet_id);
        return view('sales.index_stock', compact('outlet'));
    }
    
    public function stock(){
        /*
        if(empty(session('idtrx'))){
            Session::flash('error','Sessi Penjualan belum ada ! ');
            return back();
        }
        
        $sesi= MSSession::where('company_id', Auth::user()->company_id)
                            ->where('tanggal', date('Y-m-d'))
                            ->where('sessi_token', session('idtrx'))
                            ->where('is_closed', 0)
                            ->first();
        if(empty($sesi)){ return false; }
        */
        $dt = DB::table('dt_stock as A')
                    ->select('A.id','A.product_id','B.product_name','A.stock_awal','A.stock_in','A.stock_out','A.stock_sale')
                    ->leftjoin('ms_product as B', function($join)
                        {
                            $join->on('A.product_id','=','B.id');
                        })
                    ->where('A.company_id', Auth::user()->company_id)
                    ->where('A.outlet_id', Auth::user()->outlet_id)
                    ->get();                        
                        
        $data=[];
        foreach($dt as $list){
            $row=[];
            $row[]=$list->product_name;
            $row[]='<div style="text-align:right">'.format_uang($list->stock_awal+$list->stock_in-$list->stock_out-$list->stock_sale).'&nbsp;</div>';
            $data[]=$row;
        }
        
        $output = ["data"=>$data];
        return response()->json($output);
	}	         

    public function index_penjualan() 
    {
        
        if(empty(session('idtrx'))){
            Session::flash('error','Kasir belum Login ! ');
            return back();
        }

        $sesi= MSSession::where('company_id', Auth::user()->company_id)
                            ->where('tanggal', date('Y-m-d'))
                            ->where('sessi_token', session('idtrx'))
                            ->where('is_closed', 0)
                            ->first();
                            
        if(empty($sesi)){
            Session::flash('error','Kasir belum Login ! ');
            return back();
        }                           
        $ksr = Cashier::find($sesi->cashier_id);
        
        $btn = Category::where('is_active', 1)->count();
        $cat = Category::where('is_active', 1)
                            ->orderBy('category_name','ASC')
                            ->get();
                            
        $pay = MSPayment::where('company_id', Auth::user()->company_id)
                            ->where('is_active',1)
                            ->orderBy('pay_kode', 'ASC')
                            ->get();
                                    
        $cust = Customer::where('company_id', Auth::user()->company_id)
                            ->where('is_active', 1)
                            ->orderBy('id','ASC')
                            ->get();
                            
        return view('sales.index_trx', compact('cat','btn', 'ksr','sesi','pay', 'cust'));        
    }
    
    public function show(){
        
    }
    
    public function datapenjualan()
    {
        $sesi= MSSession::where('company_id', Auth::user()->company_id)
                            ->where('tanggal', date('Y-m-d'))
                            ->where('sessi_token', session('idtrx'))
                            ->where('is_closed', 0)
                            ->first();
        if(empty($sesi)){ return false; }
        
        $msale = MSale::where('company_id', Auth::user()->company_id)
                            ->where('sale_tgl', date('Y-m-d'))
                            ->where('sessi_id', $sesi->id)
                            ->where('is_posted', 0)
                            ->get();

        $data = [];
        
        foreach($msale as $list){
            
            $row=[];
            $row[] = '<div class="card" style="width:auto; height:auto;margin-top:-13px;margin-bottom:-12px;background-color:#ADD8E6;border:1px black solid; padding-top:5px;padding-bottom:5px">
                        <h6>'.$list->sale_no.'</h6>
                        <h5>'.$list->customer.'</h5>
                        <a onclick="addSale('.$list->id.')" style="cursor:pointer"><i class="material-icons md-36 pull-right" style="margin-top:-20px;">chevron_right</i></a>                       
                        <h5>TOTAL '.format_uang($list->sale_total).'</h5>
                    </div>';            
            
            
            $data[] = $row;
         }

         $output = array("data" => $data);
         return response()->json($output);
    }
	
	public function newInvoice(Request $request){
	    
	    $ss = MSSession::where('company_id', Auth::user()->company_id)
	                       ->where('tanggal', date('Y-m-d'))
	                       ->where('sessi_token',session('idtrx'))
	                       ->where('is_closed',0)
	                       ->first();
	                       
	    $csr = Cashier::find($ss->cashier_id);
	    
	    if(empty($ss)){ return false; }
	    
	    $outl = Outlet::find($ss->outlet_id);
	    $cus  = Customer::find($request['cus']);
	    
	    $noinv = $this->cekNoInvoice($outl->outlet_init);
	    
	    $dt = new MSale;
	    $dt->company_id = Auth::user()->company_id;
	    $dt->sessi_id   = $request['idsesi'];
	    $dt->sale_tgl   = date('Y-m-d');
	    $dt->sale_no    = $noinv;
	    $dt->customer   = $cus->cust_name;
	    $dt->price_up   = $cus->cust_mup;
	    $dt->is_ppn     = $cus->is_ppn;
	    $dt->cashier    = $csr->cashier_name;
	    $dt->save();

        echo json_encode(["msg"=>"success"]);	    
	}

    public function cekNoInvoice($outl){
    	/* cek no terakhir */
    	
    	//return 'INV0001/2109/00001';
    	
    	$kd     = $outl.sprintf("%04s", Auth::user()->company_id);
		$noref	= '';
		$tahun	= date('y');
		$bulan	= date('m');
		$nomor	=$kd."/".$tahun.$bulan."/";		
			
		$ada_no	= DB::table('msale')
						->select(DB::raw('SUBSTR(MAX(sale_no),14,5) as last_no'))
						->where('sale_no', 'LIKE', "$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%05s", $no);		//format: IN/202101/0001
			$noref = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "00001";
			$noref = $nomor.$nomorbaru;
		}
		
		return $noref;
    }	

    public function loadInvoice($id){
        $msale = MSale::find($id);
        
        if($msale->is_posted==1){
            return json_encode(["msg"=>"error"]);
        }
        echo json_encode($msale);
    }
    
    public function loadSummary($id){
        $dt = DSale::where('msale_id', $id)
                            ->get();
        $tl1 = 0;
        $dsc = 0;

        foreach($dt as $list){
            $tl1 += $list->qty * $list->price + ($list->qty * $list->price * $list->ppn/100) ;
            $dsc += $list->disc;
        }
        
        $tl = $tl1 - $dsc;
        
        $msl = MSale::find($id);
        $msl->sale_total = $tl1;
        $msl->sale_disc  = $dsc;
        $msl->update();
        
        echo json_encode(["totalsale"=>format_uang($tl)]);
    }
    
	public function tampilProduct($id, $idsl)
	{
        $msl = MSale::find($idsl);
        $mup = 1 + ($msl->price_up/100);
        
		$dt = Product::where('company_id', Auth::user()->company_id)
		                        ->where('category_id', $id)
		                        ->get();

				$no=0;
				$data = [];

				foreach($dt as $list)
				{
					$row = [];	 
					$row[] = $list->product_name;
					$row[] = '<div style="text-align:right">'.format_uang($list->retail_price * $mup).'</div>';
					$row[] = '<a onclick="selectItem('.$list->id.')" style="cursor:pointer"><i class="material-icons pull-right">task_alt</i></a>';
						  
					$data[] =$row;
				}

			$output = array("data" => $data);
			return response()->json($output);

	}

    public function saleDetail($id){
        
        $dt = DSale::where('msale_id', $id)
                        ->orderBy('id', 'DESC')
                        ->get();
                    
        $data=[];
        
        foreach($dt as $list){
            $row=[];
            
            $jlh=format_uang($list->qty * $list->price + ($list->qty * $list->price * $list->ppn/100) - $list->disc );
            
            if($list->ppn==10){
                $row[]='<li style"margin-top:-20px">'.Product::Product($list->product_id)->product_name.'</li>
                    <h6 style="margin-top:-3px;">'.$list->qty." x ".$list->price. '&nbsp;&nbsp;&nbsp; PPN :'.$list->ppn.'<br></h6>
                    <a onclick="plusSale('.$list->id.')" style="cursor:pointer"><i class="material-icons md-48">add_circle_outline</i></a>
                    <a onclick="minSale('.$list->id.')" style="cursor:pointer"><i class="material-icons md-48">remove_circle_outline</i></a>
                    <h5 style="text-align:right;margin-top:-40px;margin-bottom:-5px">'.$jlh.'</h5>
                    <hr>';
            }else{        
                $row[]='<li style="margin-top:-20px">'.Product::Product($list->product_id)->product_name.'</li>
                    <h6 style="margin-top:-3px;">'.$list->qty." x ".$list->price.'<br></h6>
                    <a onclick="plusSale('.$list->id.')" style="cursor:pointer"><i class="material-icons md-48">add_circle_outline</i></a>
                    <a onclick="minSale('.$list->id.')" style="cursor:pointer"><i class="material-icons md-48">remove_circle_outline</i></a>
                    <h5 style="text-align:right;margin-top:-40px;margin-bottom:-5px;">'.$jlh.'</h5>
                    <hr>';
            }  
            //$row[]='<div class="btn-btn">
            //            <a onclick="plusSale('.$list->id.')" style="cursor:pointer"><i class="material-icons">add_circle_outline</i></a>
            //            <a onclick="minSale('.$list->id.')" style="cursor:pointer"><i class="fa fa-minus">remove_circle_outline</i></a>
        	//		</div>';        			
        			
            $data[]=$row;
            
          /*  <a onclick="potSale('.$list->id.')" class="btn btn-primary btn-flat pull-right"><i class="fa fa-percent"></i></a>  untuk disc **/
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }

    public function simpanSale(Request $request){
        
        $idprd  = $request['kode'];
        $msl    = $request['id_msale'];
        $prd    = Product::find($idprd);
        
        $msale = MSale::find($msl);
        $mup = 1 + ($msale->price_up/100);
        
        $dt = new DSale;
        $dt->msale_id       = $msl;
        $dt->product_id     = $idprd;
        $dt->product_name   = $prd->product_name;
        $dt->price          = $prd->retail_price * $mup;
        $dt->cost           = $prd->product_cost;
        $dt->qty            = 1;
        $dt->disc           = 0;
        
        if($msale->is_ppn==1){
            if($prd->is_ppn==1){
                $dt->ppn    = 10;
            }
        }
        
        $dt->save();
        
        echo json_encode(["msg"=>"success"]);
    }

    public function updQty($id, $mode){
        $dt = DSale::find($id);
        
        if ($mode=='1'){
            $dt->qty  += 1;
        }else{
            if ($dt->qty>0){ 
                $dt->qty -= 1; 
            }else{
                return false;
            }
        }
        
        $dt->update();

        echo json_encode(["msg"=>"success"]);
    }
    
    public function simpanPotongan(Request $request,$id){
        
        $dt = DSale::find($id);
        $dt->disc   = $request['pot'];
        $dt->update();
        
        echo json_encode(["msg"=>"success"]);
    }
    
    public function potongan($id){
        $dt = KanvasDSale::find($id);
        $prd= Product::find($dt->product_id);
        
        echo json_encode(array_merge(json_decode($prd, true), json_decode($dt, true)));
    }
    
    public function closeBill(Request $request, $id){
        
        $tp     = $request['pay'];
        $byr    = $request['tlbayar'];
        $msale  = MSale::find($id);
        $sesi   = MSSession::find($msale->sessi_id);
        $dt     = DSale::where('msale_id', $id)
                            ->get();
        
       // return (["msg"=>"success"]);
        
        $tl=0; $dsc=0;
        
        /* hitung total */
        foreach($dt as $list){
            $tl  += ($list->qty * $list->price) + ($list->qty * $list->price * $list->ppn/100) ;
            
            $dsc += $list->disc;
            
        }
        
        $ttl = $tl - $dsc;                
        
        if($byr< $ttl){ return (["msg"=>"error"]); }

        /* posting stock */
        foreach($dt as $list){
            $prd =Product::find($list->product_id);
            
            if($prd->is_inventory==1){
                
                $stk = Stock::where('company_id', $msale->company_id)
                                ->where('outlet_id', $sesi->outlet_id)
                                ->where('product_id', $list->product_id)
                                ->first();
                                
                if(!empty($stk)){ 
                    $stk->stock_sale += $list->qty;
                    $stk->tgl_sale   = date('Y-m-d');
                    $stk->update();
                }else{
                    $stok = new Stock;
                    $stok->company_id = $msale->company_id;
                    $stok->outlet_id  = $sesi->outlet_id;
                    $stok->product_id = $list->product_id;
                    $stok->stock_sale = $list->qty;
                    $stok->tgl_sale   = date('Y-m-d');
                    $stok->save();
        
                }
            }
        }
                    
        $msale->type_bayar = $tp;
        $msale->sale_total = $ttl;
        $msale->sale_disc  = $dsc;
        $msale->sale_bayar = $byr;
        $msale->reff_no    = $request['reff'];
        $msale->is_posted  = 1;
        $msale->update();
        
        $ss = MSSession::find($msale->sessi_id);
        $ss->brutto += $tl;
        $ss->disc   += $dsc;
        $ss->update();
        
        echo json_encode(["msg"=>"success"]);
    }
    

/** ini yang dipake ***/
	public function cetakStruk($id)
	{
	    
		$cmp        = Company::find(Auth::user()->company_id);
		
		$msale		= MSale::find($id);
		$dsale	 	= DSale::where('dsale.msale_id', $id)
		                        ->where('qty', '>',0)
								->get();
		$sesi       = MSSession::find($msale->sessi_id);
		$ksr        = Cashier::getCashier($sesi->cashier_id)->cashier_name;
		$outlet     = Outlet::find($sesi->outlet_id);
		
		$tlbyr      = $msale->sale_bayar;

        $pay = MSPayment::where('company_id', Auth::user()->company_id)
                            ->where('id', $msale->type_bayar)
                            ->first();
        $ket = $pay->pay_kode;
        
    /*initial font/printer */
        $pin = 0;
        $on_ms = 120;
        $off_ms = 240;
        
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);
        $cut        = Chr(27) . Chr(109);   
        $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);
        //chr(27)+'p'+chr(0)+chr(20)+chr(20))
        
        
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontSedang	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);
    
        /*initial barcode */
        $barcode_h = Chr(29) . 'h' . Chr(100);                          //tinggi barcode 100
        $barcode_M = Chr(29) . "L" . Chr(10) . Chr(0);                  //margin Left 10
        $barcode_H = Chr(29) . 'H' . Chr(2);			                //posisi data dibawah barcode
        $barcode_f = Chr(29) . 'f' . Chr(0);                            //type font
        $barcode_k = Chr(29) . 'k' . Chr(2) . '123456789012' . Chr(0);	//data dan type barocde 2=EAN13
        $barcode_L = Chr(29) . "L" . Chr(0) . Chr(0);                   //set margin ke posisi awal
        
            $lebarkolom = $outlet->printer_col;     /*40;*/
        
        if($lebarkolom==31){
            $grs ="-------------------------------\n";
        }else{
            $grs ="----------------------------------------\n";
        }
		
		$tlqty=0;
		$totalrp=0;
		$tlppn=0;
		
		$hdr1=$initialized;
		$hdr1.=$fontBesar.$this->center($outlet->outlet_name,$lebarkolom).$fontNormal;
		$hdr2=$fontNormal.$this->center($outlet->outlet_address, $lebarkolom).$fontNormal."\n";
		
		$struk  = $hdr1."\n";
		$struk .= $hdr2."\n";
		
		if($outlet->struk_lengkap==1){
		    $struk .= $msale->sale_no.' - '.$ksr."\n";
		}else{
		    $struk .= substr($msale->sale_no,13,5).' - '.$ksr."\n";
		}
		
        $struk .= $msale->customer."\n";
        if(is_null($msale->reff_no)){
            $struk .="\n";
        }else{
            $struk .= $fontKecil.$msale->reff_no.$fontNormal."\n\n";
        }
		
		foreach($dsale as $list){

		    $q=" ".$list->qty.' x '.$list->price;            //.' = '.format_uang($list->qty*$list->price);
            $lspc=$lebarkolom-strlen($q);
            $qq=$q.$this->strAngka($list->qty * $list->price, $lspc);
            
            if($list->ppn==10){
			    $struk .= substr($list->product_name,0,30)."*\n";
            }else{
                $struk .= substr($list->product_name,0,31)."\n";
            }
            
			$struk .= $qq."\n";
			
			$tlqty += $list->qty;
			$tlppn += ($list->qty*$list->price-$list->disc) * $list->ppn/100;
			$totalrp += $list->qty * $list->price - $list->disc ;

		}
        
        $grandtl = $totalrp+$tlppn;
        
        $struk .= $grs;
        /*sub total */
        $subtl ="   Sub Total";
        $lspc  =$lebarkolom-strlen($subtl)-2;
        $strSub="  ".$subtl.$this->strAngka($totalrp, $lspc)."\n";
        /* ppn */
        $ppn   ="   PPn *)   ";
        $lspc  =$lebarkolom-strlen($ppn)-2;
        $strPPn="  ".$ppn.$this->strAngka($tlppn, $lspc)."\n";

        $total ="** TOTAL ** ";
        $lspc=$lebarkolom-strlen($total)-2;
        $strTtl="  ".$total.$fontBesar.$this->strAngka($grandtl, $lspc).$fontNormal."\n\n";

        $bayar=$ket;
        $lspc=$lebarkolom-strlen($bayar)-2;
        $strByr="  ".$bayar.$this->strAngka($tlbyr,$lspc)."\n";        
        
        $tlkbl  = $tlbyr-$grandtl;
        
        $kembali=">> Kembali ...";
        $lspc=$lebarkolom-strlen($kembali)-2;

        $strKbl="\n"."  ".$kembali.$this->strAngka($tlkbl,$lspc)."\n";     
        
        $struk .= $strSub;
        $struk .= $strPPn;
        $struk .= $strTtl;
        $struk .= $strByr;
        $struk .= $strKbl;
        
        $struk .= $this->center('*** THANK YOU ***',$lebarkolom)."\n";
        
        if($outlet->print_time==1){
            $struk .= $fontKecil.date('Y-m-d H:i:s').$fontNormal;
        }
        
        $struk .= "\n\n\n\n".$cut;

        $dt = "intent:base64," . base64_encode($struk) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
  
        $output = ["data"=>$dt];

        return response()->json($output);

    } 	    

    /* reprint struk */
    public function index_reprint(){
        return view('sales.index_reprint');
    }
    
    public function reprintstruk(Request $request){

		$msale		= MSale::where('sale_no',$request['nostruk'])
		                        ->where('sale_tgl', date('Y-m-d'))
		                        ->where('is_posted',1)
		                        ->first();
		                        
        if(empty($msale)){ return json_encode(["msg"=>"error"]); }
        
        $cmp        = Company::find(Auth::user()->company_id);        
        		                        
		$dsale	 	= DSale::where('dsale.msale_id', $msale->id)
		                        ->where('qty', '>',0)
								->get();
								
		$sesi       = MSSession::find($msale->sessi_id);
		$ksr        = Cashier::getCashier($sesi->cashier_id)->cashier_name;
		$outlet     = Outlet::find($sesi->outlet_id);
		
		$tlbyr      = $msale->sale_bayar;

        $pay = MSPayment::where('company_id', Auth::user()->company_id)
                            ->where('id', $msale->type_bayar)
                            ->first();
        $ket = $pay->pay_kode;
        
    /*initial font/printer */
        $pin = 0;
        $on_ms = 120;
        $off_ms = 240;
        
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);
        $cut        = Chr(27) . Chr(109);   
        $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);
    
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontSedang	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);

		
        $lebarkolom = $outlet->printer_col;     /*40;*/
        
        if($lebarkolom==31){
            $grs ="-------------------------------\n";
        }else{
            $grs ="----------------------------------------\n";
        }
		
		$tlqty=0;
		$totalrp=0;
		$tlppn=0;
		
		$hdr1=$initialized;
		$hdr1.=$fontBesar.$this->center($outlet->outlet_name,$lebarkolom).$fontNormal;
		$hdr2=$fontNormal.$this->center($outlet->outlet_address, $lebarkolom).$fontNormal."\n";
		
		$struk  = $hdr1."\n";
		$struk .= $hdr2."\n";
		
		if($outlet->struk_lengkap==1){
		    $struk .= $msale->sale_no.' - '.$ksr."\n";
		}else{
		    $struk .= substr($msale->sale_no,13,5).' - '.$ksr."\n";
		}
		
        $struk .= $msale->customer."\n";
        if(is_null($msale->reff_no)){
            $struk .="\n";
        }else{
            $struk .= $fontKecil.$msale->reff_no.$fontNormal."\n\n";
        }
        $struk .= $this->center('** Reprint **', $lebarkolom)."\n\n";
		
		foreach($dsale as $list){

		    $q=" ".$list->qty.' x '.$list->price;            //.' = '.format_uang($list->qty*$list->price);
            $lspc=$lebarkolom-strlen($q);
            $qq=$q.$this->strAngka($list->qty * $list->price, $lspc);

			$struk .= substr($list->product_name,0,31)."\n";
			$struk .= $qq."\n";
			
			$tlqty += $list->qty;
			$tlppn += ($list->qty*$list->price-$list->disc) * $list->ppn/100;
			$totalrp += $list->qty * $list->price - $list->disc ;

		}
        
        $grandtl = $totalrp+$tlppn;
        
        $struk .= $grs;
        /*sub total */
        $subtl ="   Sub Total";
        $lspc  =$lebarkolom-strlen($subtl)-2;
        $strSub="  ".$subtl.$this->strAngka($totalrp, $lspc)."\n";
        /* ppn */
        $ppn   ="   PPn      ";
        $lspc  =$lebarkolom-strlen($ppn)-2;
        $strPPn="  ".$ppn.$this->strAngka($tlppn, $lspc)."\n";

        $total ="** TOTAL ** ";
        $lspc=$lebarkolom-strlen($total)-2;
        $strTtl="  ".$total.$fontBesar.$this->strAngka($grandtl, $lspc).$fontNormal."\n\n";

        $bayar=$ket;
        $lspc=$lebarkolom-strlen($bayar)-2;
        $strByr="  ".$bayar.$this->strAngka($tlbyr,$lspc)."\n";        
        
        $tlkbl  = $tlbyr-$grandtl;
        
        $kembali=">> Kembali ...";
        $lspc=$lebarkolom-strlen($kembali)-2;

        $strKbl="\n"."  ".$kembali.$this->strAngka($tlkbl,$lspc)."\n";     
        
        $struk .= $strSub;
        $struk .= $strPPn;
        $struk .= $strTtl;
        $struk .= $strByr;
        $struk .= $strKbl;
        
        $struk .= $this->center('*** THANK YOU ***',$lebarkolom)."\n";
        $struk .= $fontKecil.date('Y-m-d H:i:s')."\n\n\n\n\n\n".$fontNormal;
        $struk .= $cut;

        $dt = "intent:base64," . base64_encode($struk) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
  
        $output = ["data"=>$dt];

        return response()->json($output);

    }

/** print bill sementara ***/
	public function cetakSementara($id)
	{
	    
		$cmp        = Company::find(Auth::user()->company_id);
		
		$msale		= MSale::find($id);
		$dsale	 	= DSale::where('dsale.msale_id', $id)
		                        ->where('qty', '>',0)
								->get();
		$sesi       = MSSession::find($msale->sessi_id);
		$ksr        = Cashier::getCashier($sesi->cashier_id)->cashier_name;
		$outlet     = Outlet::find($sesi->outlet_id);
		

    /*initial font/printer */
        $pin = 0;
        $on_ms = 120;
        $off_ms = 240;
        
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);
        $cut        = Chr(27) . Chr(109);   
        $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);
        //chr(27)+'p'+chr(0)+chr(20)+chr(20))
        
        
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontSedang	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);
    
        /*initial barcode */
        $barcode_h = Chr(29) . 'h' . Chr(100);                          //tinggi barcode 100
        $barcode_M = Chr(29) . "L" . Chr(10) . Chr(0);                  //margin Left 10
        $barcode_H = Chr(29) . 'H' . Chr(2);			                //posisi data dibawah barcode
        $barcode_f = Chr(29) . 'f' . Chr(0);                            //type font
        $barcode_k = Chr(29) . 'k' . Chr(2) . '123456789012' . Chr(0);	//data dan type barocde 2=EAN13
        $barcode_L = Chr(29) . "L" . Chr(0) . Chr(0);                   //set margin ke posisi awal
        
            $lebarkolom = $outlet->printer_col;     /*40;*/
        
        if($lebarkolom==31){
            $grs ="-------------------------------\n";
        }else{
            $grs ="----------------------------------------\n";
        }
		
		$tlqty=0;
		$totalrp=0;
		$tlppn=0;
		
		$hdr1=$initialized;
		$hdr1.=$fontNormal.$this->center($outlet->outlet_name,$lebarkolom).$fontNormal;
		$hdr2=$fontNormal.$this->center("-Bukan bukti Pembayaran-", $lebarkolom).$fontNormal."\n";
		
		$struk  = $hdr1."\n";
		$struk .= $hdr2."\n";
        $struk .= $msale->customer."\n";

		foreach($dsale as $list){

		    $q=" ".$list->qty.' x '.$list->price;            //.' = '.format_uang($list->qty*$list->price);
            $lspc=$lebarkolom-strlen($q);
            $qq=$q.$this->strAngka($list->qty * $list->price, $lspc);
            
            if($list->ppn==10){
			    $struk .= substr($list->product_name,0,30)."*\n";
            }else{
                $struk .= substr($list->product_name,0,31)."\n";
            }
            
			$struk .= $qq."\n";
			
			$tlqty += $list->qty;
			$tlppn += ($list->qty*$list->price-$list->disc) * $list->ppn/100;
			$totalrp += $list->qty * $list->price - $list->disc ;

		}
        
        $grandtl = $totalrp+$tlppn;
        
        $struk .= $grs;
        /*sub total */
        $subtl ="   Sub Total";
        $lspc  =$lebarkolom-strlen($subtl)-2;
        $strSub="  ".$subtl.$this->strAngka($totalrp, $lspc)."\n";
        /* ppn */
        $ppn   ="   PPn *)   ";
        $lspc  =$lebarkolom-strlen($ppn)-2;
        $strPPn="  ".$ppn.$this->strAngka($tlppn, $lspc)."\n";

        $total ="** TOTAL ** ";
        $lspc=$lebarkolom-strlen($total)-2;
        $strTtl="  ".$total.$fontNormal.$this->strAngka($grandtl, $lspc).$fontNormal."\n\n";


        $struk .= $strSub;
        $struk .= $strPPn;
        $struk .= $strTtl."\n\n";
        $struk .= $cut;

        $dt = "intent:base64," . base64_encode($struk) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
  
        $output = ["data"=>$dt];

        return response()->json($output);

    } 	    

    
/*----------------------------------------------------fungsi string bisa dipanggil dari controller lain*/    
    public static function strAngka($hg, $len){
        $strangka = format_uang($hg);
        $langka = strlen($strangka);
        $lspc = $len - $langka;
        
        $strHg=self::space($lspc).$strangka;
        return $strHg;
    }
    
    public static function space($len){
        $strSpc="";
        $i=1;
        while($i<=$len){ $strSpc=$strSpc." "; $i++; }
        return $strSpc;
    }
    
    public function space_android($len){
        $strSpc="";
        $i=1;
        while($i<=$len){ $strSpc=$strSpc."%20"; $i++; }
        return $strSpc;
    }
    
    public static function center($strCenter,$lbrkolom){
        $lspc=($lbrkolom-strlen($strCenter))/2;

        return self::space($lspc).$strCenter;
    }
/*---------------------------------------------------------------------------------*/
    
    public function index_customer(){
        return view('sales.index_customer');
    }
    
    public function masterCustomer(){
        $cus = Customer::where('company_id', Auth::user()->company_id)
                            ->where('is_active',1)
                            ->get();
                            
        $data=[];
        foreach ($cus as $list){
            
            if($list->is_ppn==1){ $ppn='<div class="label label-success">Ya</div>'; }else{$ppn='<div class="label label-danger">No</div>'; }
            $row=[];
            $row[] = $list->cust_name;
            $row[] = $list->cust_mup."%";
            $row[] = $ppn;
            
            $data[]=$row;
        }
        
        $output = ["data"=>$data];
        return response()->json($output);
    }


/* ------------ biaya ----------------------------*/

    public function index_biaya(){

        if(empty(session('idtrx'))){
            Session::flash('error','Kasir belum Login ! ');
            return back();
        }
        
		
        $sesi= MSSession::where('company_id', Auth::user()->company_id)
                            ->where('tanggal', date('Y-m-d'))
                            ->where('sessi_token', session('idtrx'))
                            ->where('is_closed', 0)
                            ->first();
        
        if(empty($sesi)){ return false; }
        
        $msale = MSale::where('company_id', Auth::user()->company_id)
                            ->where('sale_tgl', date('Y-m-d'))
                            ->where('sessi_id', $sesi->id)
                            ->where('is_posted', 0)
                            ->get();
		
		$ksr        = Cashier::getCashier($sesi->cashier_id)->cashier_name;
		$outlet     = Outlet::find($sesi->outlet_id);

        return view('sales.index_biaya', compact('sesi'));      
    }

    public function dataBiaya($id){
       
        $biaya = Biaya::where('sessi_id', $id)
                        ->get();
       
                            
        $data=[];
        foreach($biaya as $list)
        {
            $row=[];
            
            $row[] = '<div class="card" style="width:auto; height:auto; margin:auto;background-color:#98FB98;border:1px black solid;">
                        <div class="card-block">
                            <div class="card-body">
                                <h5>'.tanggal_indonesia($list->tanggal, false).'</h5>
                                <h6>'.$list->notes.'</h6>
                                <h5><b>RP '.format_uang($list->nominal).'</b></h5>
                            </div>
                        </div>
                    </div>';
                
            $data[]=$row;
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }

    public function addBiaya(Request $request, $id){
        
        $sesi = MSSession::find($id);
        
        $by = new Biaya;
        
        $by->company_id = Auth::user()->company_id;
        $by->outlet_id  = $sesi->outlet_id;
        $by->tanggal    = $request['tgl'];
        $by->sessi_id   = $id;
        $by->notes      = $request['notes'];
        $by->nominal    = $request['jumlah'];
        $by->save();
        
        
        $sesi->biaya += $request['jumlah'];
        $sesi->update();
        
        echo json_encode(["msg"=>"success"]);
    }

    public function testPrinter(){
        return view('sales.testprinter');
    }

/* yg ini tidak dipake */
    public function tescetak_android(){
        
        $outlet = Outlet::find(Auth::user()->outlet_id);
        $lebarkolom = $outlet->printer_col;     /*40;*/
        
        $initialized= "%1B%40";
        $pin =0;
        $on_ms = 120;
        $off_ms = 240;
        $cut        = "%1B%6D";   
        $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);        
        $fontKecil  ="%1B"."!"."%01";
        $fontNormal ="%1B"."!"."%00";
        $fontSedang ="%1B"."!"."%08";
        $fontBesar  ="%1B"."!"."%10";
        $fontLebar  ="%1B"."!"."%20";
        $fontBlock  ="%1B"."!"."%80";
 
        $barcode_h  ="%1D" ."h". "%32";
        $barcode_M  ="%1D" ."L". "%90%20";
        $barcode_H  ="%1D" ."H". "%02";
        $barcode_f  ="%1D" ."f". "%00";
        $barcode_k  ="%1D" ."k". "%02".'123456789012'."%00"."%1D"."L"."%00%00";     
        $barcode_L  ="%1D" ."L". "%00%00";                   //set margin ke posisi awal
        
        $spc  = "%20";
        $enter= "%0D";
        
        //$img = EscposImage::load("logo_img.png", false);    
    
        //$rasterData = $img -> toRasterFormat();
        //$header = Printer::imgHeader([$img -> getWidthBytes(), $img -> getHeight()], true);

        //$logoimg = "%1D" . "v0" . "%00" . $header. $rasterData;
        
        
        $Data  = $initialized;
        $Data .= $fontNormal;
        $Data .= "================================".$enter;
        $Data .= $this->center_android("DAFTAR PRODUK", $lebarkolom).$enter;
        $Data .= "================================".$enter;
        $Data .= "1. Pakaian Wanita    Rp. 250.000".$enter;
        $Data .= "2. Pakaian Pria      Rp. 300.000".$enter;
        $Data .= "3. Pakaian Anak      Rp.  75.000".$enter;
        $Data .= "--------------------------------".$enter;
        $Data .= "       Total         Rp. 625.000".$enter;
        //$Data .= $logoimg;        
        $Data .= $fontKecil;
        $Data .= "Font Kecil abcd12345".$enter;
        $Data .= $fontNormal;
        $Data .= "Font Normal abcd12345".$enter;
        $Data .= $fontBesar;
        $Data .= "Font Besar abc123".$enter;
        $Data .= $fontLebar;
        $Data .= "Font Lebar abc12".$fontNormal.$enter;        
        $Data .= $barcode_h.$barcode_M.$barcode_H.$barcode_f.$barcode_k.$barcode_L.$enter;
        //$Data .= $qrcode_model.$qrcode_size.$qrcode_level.$qrcode_content.$qrcode_print."\n\n";

        //$Data .= $enter;
        //$Data .= $cut;
        
        //$dt = "rawbt:".$Data;
        //$dt = "intent:base64," . base64_encode($Data) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
        $output=["data"=>$dt];
        return response()->json($output);
    }

    public function tescetak(){

        $outlet = Outlet::find(Auth::user()->outlet_id);
        $lebarkolom = $outlet->printer_col;     /*40;*/        
        
        $img = EscposImage::load("logo_img.png", false);    
    
        $rasterData = $img -> toRasterFormat();
        $header = Printer::imgHeader([$img -> getWidthBytes(), $img -> getHeight()], true);

        $logoimg = chr(29) . "v0" . chr(0) . $header. $rasterData;
        
        
        $profile = CapabilityProfile::load("POS-5890");
        //$connector = new RawbtPrintConnector();        
        //$printer = new Printer($connector, $profile);
        $connector = new FilePrintConnector("php://stdout");
        $printer = new Printer($connector);

    $pin    = 0;
    $on_ms  = 120;
    $off_ms = 240;
    
    $bold1      = Chr(27) . Chr(69);
    $bold0      = Chr(27) . Chr(70);
    $initialized= chr(27) . chr(64);
    $condensed1 = chr(15);
    $condensed0 = chr(18);
    $cut        = Chr(27) . Chr(109);   
    $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);
    //chr(27)+'p'+chr(0)+chr(20)+chr(20))
    
    $setLeft    = chr(27) . "a" . chr(0);
    $setCenter  = chr(27) . "a" . chr(1);
    $setRight   = chr(27) . "a" . chr(2); 

    //$EmphasisOn = chr(27) . "E" . chr(1);
    //$EmphasisOff= chr(27) . "E" . chr(0);
    $fontNormal	= chr(27) . "!" . chr(0);
    $fontKecil	= chr(27) . "!" . chr(1);
    $fontSedang	= chr(27) . "!" . chr(8);
    $fontBesar	= chr(27) . "!" . chr(16);
    $fontLebar	= chr(27) . "!" . chr(32);
    $fontUline	= chr(27) . "!" . chr(128);

    /*initial barcode */
    $barcode_h = Chr(29) . 'h' . Chr(70);                          //tinggi barcode 100
    $barcode_M = Chr(29) . "L" . Chr(10) . Chr(0);                  //margin Left 10
    $barcode_H = Chr(29) . 'H' . Chr(2);			                //posisi data dibawah barcode
    $barcode_f = Chr(29) . 'f' . Chr(0);                            //type font
    $barcode_39= chr(29) . 'k' . chr(4);
    $barcode_93= chr(29) . 'k' . chr(7);
    $barcode_128=chr(29) . 'k' . chr(8);
    $barcode_bar=chr(29) . 'k' . chr(6);
    $barcode_k = Chr(29) . 'k' . Chr(2) . '123456789012' . Chr(0);	//data dan type barocde 2=EAN13
    $barcode_L = Chr(29) . "L" . Chr(0) . Chr(0);                   //set margin ke posisi awal
    
    $cn     = '1'; // Code type for QR code
    $model  = 2;  // Select model: 1, 2 or micro.
    $size   = 8;
    $ec     = 1;
    $content= "--- AlfredoYustar";
    $textbarcode = '123456789';
    $textBar128='abcdefg';
    
    // A21C1E11P0 <content> 1Q0
    $qrcode_model   = chr(65) . $cn . chr(48 + $model) . chr(0);        //A12
    $qrcode_size    = chr(67) . $cn . chr($size);                       //C1
    $qrcode_level   = chr(69) . $cn . chr(48 + $ec);                    //E11
    $qrcode_content = chr(80) . $cn . $content . '1';                   //P1 content 0
    $qrcode_print   = chr(81) . $cn . '' . '0';                         //.... A12C1E11P1 content  0Q1
    
        
        $Data  = $initialized;
        $Data .= $condensed0;
        $Data .= $content."\n";
        $Data .= $fontNormal."Barcode Code39 \n";
        $Data .= $barcode_h. $barcode_M.$barcode_H.$barcode_f.$barcode_39.$textbarcode.chr(0).$barcode_L."\n";
        $Data .= $fontNormal."Barcode Codebar \n";
        $Data .= $barcode_h. $barcode_M.$barcode_H.$barcode_f.$barcode_bar.$textbarcode.chr(0).$barcode_L."\n";        
        
        //$Data .= $fontNormal."Barcode Code93 \n";
        //$Data .= $barcode_h. $barcode_M.$barcode_H.$barcode_f.$barcode_93.$textbarcode.chr(0).$barcode_L."\n";

/*        
        $Data .= "================================\n";
        $Data .= $this->center("DAFTAR PRODUK", $lebarkolom)."\n";
        $Data .= "================================\n";
        $Data .= "1. Pakaian Wanita    Rp. 250.000\n";
        $Data .= "2. Pakaian Pria      Rp. 300.000\n";
        $Data .= "3. Pakaian Anak      Rp.  75.000\n";
        $Data .= "--------------------------------\n";
        $Data .= "       Total         Rp. 625.000\n";
        $Data .= $logoimg;        
        $Data .= $fontKecil."\n";
        $Data .= "Font Kecil abcd12345 \n";        
        $Data .= $fontNormal;
        $Data .= "Font Normal abcd12345\n";
        $Data .= $fontBesar;
        $Data .= "Font Besar abc123\n";
        $Data .= $fontLebar;
        $Data .= "Font Lebar abc12\n".$fontNormal;        
        $Data .= $barcode_h.$barcode_M.$barcode_H.$barcode_f.$barcode_k.$barcode_L."\n\n";
*/        
        //***function qrCode($content, $ec = Printer::QR_ECLEVEL_L, $size = 3, $model = Printer::QR_MODEL_2)       
        //$qr = $printer->qrCode($content, Printer::QR_ECLEVEL_M, 3, Printer::QR_MODEL_1)  ;  
        
        //$qr = $setCenter.$qrcode_model.$qrcode_size.$qrcode_level.$qrcode_content.$qrcode_print."\n\n";
        //$Data .= $qr;

        $Data .= "\n \n ";
        $Data .= $cut;
        
        $dt = "intent:base64," . base64_encode($Data) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
        $output = ["data"=>$dt];

        return response()->json($output);
       
    }
    
    public function testScanner(){
        return view('sales.index_scanner');
    }
    
    public function dataCategory(){
        $comp = Auth::user()->company_id;
        $cat  = Category::where('is_active',1)
                            ->where('company_id', $comp)
		                    ->get();
		                    
        $data=[];
        $row='';
        foreach($cat as $list){

            $row .= '<a onclick="showProduct('.$list->id.')" style="cursor:pointer" class="card-panel teal">'.$list->category_name.'</a> ';
            
        }
        $data[]=$row;
        return response()->json(["data"=>$data]);
    }
    
// profile
    public function index_profile(){
        return view('sales.index_profile'); 
    }
    
    public function editProfile(){
        
		$outlet     = Outlet::find(Auth::user()->outlet_id);
        echo json_encode($outlet);                 
    }
    
    public function simpanProfile(Request $request){
        
        //return json_encode(["msg"=>"error"]);
	    
	    $ou     = Outlet::find(Auth::user()->outlet_id);
	    
	    $ou->printer_col    = $request['lbr'];
	    $ou->print_time     = $request['jam'];
	    $ou->struk_lengkap  = $request['cetak'];
	    
	    $ou->update();
	    
	    echo json_encode(["msg"=>"success"]);
   
    }
    
    
}
