<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Rute;
use App\Penjualan;
use App\Customer;
use App\User_logs;

class RuteController extends Controller
{
   public function index()
   {
        $sekarang = date('Y-m-d');
        return view('rute.index', compact('sekarang')); 
   }

   public function listData()
   {
        
        $tgl1 = Date('Y-m-d');
        $tgl0 = date('Y-m-d', strtotime("-200 day", strtotime($tgl1)));
        
 	    $rute = Rute::whereBetween('tanggal', array($tgl0, $tgl1))
 	                    ->where('status_batal', '=', 0)->get();
 
        $data = array();
        foreach($rute as $list){
       
       $row = array();
       $row[] = $list->tanggal;
       $row[] = $list->route_name;;
       $row[] = $list->driver;
       $row[] = $list->no_pol;
	   $row[] = '<div class="btn-btn">
                <a onclick="editForm('.$list->id_route.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
                <a onclick="batal('.$list->id_route.')" class="btn btn-danger btn-sm"><i class="fa fa-times"></i></a>
                <a onclick="listData('.$list->id_route.')" class="btn btn-info btn-sm"><i class="fa fa-info"></i></a>
               </div>';
       $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
   }

   public function store(Request $request)
   {
        $tgl  = Date('Y-m-d');
        
		$rute = new Rute;
		$rute->tanggal      = $request['tgl'];
		$rute->route_name   = $request['nama'];
		$rute->driver       = $request['sopir'];
		$rute->no_pol       = $request['nopol'];
		$rute->save();
		
		echo json_encode(array('msg'=>'success'));
   }

   public function edit($id)
   {
     $rute = Rute::find($id);
     echo json_encode($rute);
   }

   public function update(Request $request, $id)
   {
		$rute = Rute::find($id);
		$rute->route_name = $request['nama'];
		$rute->driver     = $request['sopir'];
		$rute->no_pol     = $request['nopol'];
		$rute->update();
   }
   
	public function batal($id)	
	{
	    
	    $ada_data = Penjualan::where('sale_route', '=', $id)
	                            ->where('sale_batal','=', 0)
	                            ->count();
        if($ada_data>0)
        {
            return json_encode(array('msg'=>'error'));    
        }
        
		$rute = Rute::find($id);
		
		$rute->status_batal = 1;
		$rute->update();
			
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'BATAL RUTE';
			$userlog->content	= 'Rute '.$rute->route_name.' tgl. '.tanggal_indonesia($rute->tanggal, false).' berhasil dibatalkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
			
			echo json_encode(array('msg'=>'success'));
		
	}	   

    function detail($id){
        
        $dtrute = Penjualan::where('sale_route', '=', $id)->get();
						
		$data=array();
		$no=0;
		foreach($dtrute as $list){
		    $row = array();
		    $no++;
		    
		    $sts="";
		    if($list->sale_batal==1){ $sts= "BATAL"; }
		    
		    $row[] = $no;
		    $row[] = tanggal_indonesia($list->sale_tgl, false);
		    $row[] = $list->sale_no;
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
            $row[] = $sts;

		    $data[]= $row;
		}
        
        $output = array("data" => $data);
        return response()->json($output);
        
    }

   
   public static function Rute($id){
       return Rute::find($id);
   }


	public function listrute($tgl, $tp){
		
		$rute = Rute::where('tanggal', '=', $tgl)
		                ->where('status_batal','=',0)->get();
		
		$data = array();
		foreach($rute as $list){
			$row = array();
			$row[] = $list->tanggal ;
            $row[] = $list->route_name ;
            $row[] = $list->no_pol ;
			$row[] = $list->driver ;
			
			if($tp==1){
      		    $row[] = '<div class="btn-btn">
						<a onclick="selectRute('.$list->id_route.')" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
					</div>';
			}else{
			    $row[] = '<div class="btn-btn">
						<a onclick="selectRuteDO('.$list->id_route.')" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
					</div>';
			}
			
			$data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
	}	

   public function tampil($id)
   {
     $rute = Rute::find($id);
     echo json_encode($rute);
   }

}
