<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Redirect;
use DB;
use Datatables;
use App\Penjualan;
use App\PenjualanDetail;
use App\Piutang;
use App\Invoice;
use App\Customer;
use App\Supplier;
use PDF;

use App\Exports\SaleExport;

use Illuminate\Support\Facades\Input;
use Excel;

class ReportController extends Controller
{
    public function index_sale()
    {
		$customer = Customer::all();
		$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
		$akhir = date('Y-m-d');
		
		return view('report.index_sale', compact('customer', 'awal','akhir')); 
    }

    public function index_saledetail()
    {
		$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
		$akhir = date('Y-m-d');
		
		return view('report.index_saledetail', compact('awal','akhir')); 
    }
   
    public function reportDetail($tgl1, $tgl2, $cash, $credit){
        
        ini_set('memory_limit', '-1');
        
        $sale = Penjualan::whereBetween('sale_tgl', array($tgl1, $tgl2))
                            ->where('status_retur', 1)
							->orderBy('sale_no','ASC')
							->get();
							

        foreach($sale as $sl){ $noinv=$sl->sale_no; break; }        /* untuk mendapatakan record 1 */
        
        $det = PenjualanDetail::leftjoin('ms_sale', 'ms_sale.id_sale','=', 'dt_sale.sale_id')
                                ->whereBetween('ms_sale.sale_tgl', [$tgl1, $tgl2])
                                ->where('ms_sale.sale_posted',1)
                                ->where('dt_sale.harga_retail','>',0)
                                ->where('ms_sale.status_retur',1)
                                ->orderBy('ms_sale.sale_no', 'ASC')
                                ->orderBy('dt_sale.id_dsale', 'ASC')
                                ->get();
 
        
        $tlq=0;
        $tlv=0;
        $gtl=0;
        $totalv=0;
        $data=[];
        $awal=true;
        $start=true;
        
        //$noinv='INV/202009/0001';
        
        foreach($det as $list){
            
            if($start==true){
                $row=[];
        		$row[]=$list->sale_no;
            	$row[]=Customer::Customer($list->cust_id)->cus_name;   
            	$start=false;
            }else{
    
                if($awal==true){
                    $row=[];
                    $row[]='';
                	$row[]='';
                }
            }
            
            if($list->sale_no==$noinv){
                
                if($awal==false){
                    $row=[];
        			$row[]='';
        			$row[]=''; 

                }

                $row[]=$list->brg_nama;
        		$row[]=number_format($list->harga_retail);
        		$row[]=number_format($list->qty).'/'.$list->isi;
        		if($list->type_brg==0){
        		    $row[]=number_format($list->harga_retail*$list->isi);
        		}else{
        		    $row[]=number_format($list->harga_retail*$list->qty);
        		}
        		$data[]=$row;
        		$awal=false;

    			$tlq = $tlq + $list->qty;
    			$gtl = $gtl + $list->qty;
    			if($list->type_brg==0){
    			    $tlv = $tlv + ($list->isi*$list->harga_retail);
    			}else{ $tlv = $tlv + ($list->qty*$list->harga_retail); }
    			
    			$totalv = $totalv + $tlv;
    			
            }else{

                $row=[];
    			$row[]='';
    			$row[]='';
    			$row[]='--- Total ---';    			
    			$row[]='';
    			$row[]='';      /*number_format($tlq);*/
    			$row[]=number_format($tlv);
    			$data[]=$row;            
                
                $noinv=$list->sale_no;
                $tlq=0;
                $tlv=0;
                $awal=true;
                
                $row=[];
        		$row[]=$list->sale_no;
            	$row[]=Customer::Customer($list->cust_id)->cus_name;
                $row[]=$list->brg_nama;
        		$row[]=number_format($list->harga_retail);
        		$row[]=number_format($list->qty).'/'.$list->isi;
        		if($list->type_brg==0){
        		    $row[]=number_format($list->harga_retail*$list->isi);
        		}else{
        		    $row[]=number_format($list->harga_retail*$list->qty);
        		}
        		$data[]=$row;
        		
        		$tlq = $tlq + $list->qty;
    			$gtl = $gtl + $list->qty;
    			if($list->type_brg==0){
    			    $tlv = $tlv + ($list->isi*$list->harga_retail);
    			}else{ $tlv = $tlv + ($list->qty*$list->harga_retail); }
    			
    			$totalv = $totalv + $tlv;                
                
                
            }
            
		}
		
		$row=[];
		$row[]='';
		$row[]='';
		$row[]='### Grand Total ###';		
		$row[]='';
		$row[]='';      /*format_uang($gtl);		*/
		$row[]=format_uang($totalv);
		$data[]=$row;
        
        //echo json_encode($data);
        
        return view('report.saledetail', compact('data','tgl1','tgl2'));
    }

    public static function export_to_Excell($tgl1, $tgl2, $cash, $credit){
        
        ini_set('memory_limit', '-1');
        
        //$sale = Penjualan::whereBetween('sale_tgl', array($tgl1, $tgl2))
        //                    ->where('status_retur', 1)
		//					->orderBy('sale_no','ASC')
		//					->get();
							

        //foreach($sale as $sl){ $noinv=$sl->sale_no; break; }        /* untuk mendapatakan record 1 */
        
        /*
        $det = PenjualanDetail::leftjoin('ms_sale', 'ms_sale.id_sale','=', 'dt_sale.sale_id')
                                ->whereBetween('ms_sale.sale_tgl', [$tgl1, $tgl2])
                                ->where('ms_sale.sale_posted',1)
                                ->where('dt_sale.harga_retail','>',0)
                                ->where('ms_sale.status_retur',1)
                                ->orderBy('ms_sale.sale_no', 'ASC')
                                ->orderBy('dt_sale.id_dsale', 'ASC')
                                ->get();
        */
        /* kontan */
        if($cash==1 && $credit==0){
            $aaa = Piutang::leftjoin('dt_piutang', 'piutang_id','=','id_piutang')
                            ->where('ms_piutang.is_kontan',1)
                            ->whereBetween('ms_piutang.lunas_tgl', [$tgl1,$tgl2])
                            ->get();
                            
            $idmsl=[];
            foreach($aaa as $bbb){ $idmsl[] = $bbb->sale_id;}
            
            if(empty($idmsl)){ return back(); }
            
            $data = DB::table('dt_sale as A')
                            ->select('B.sale_no','C.cus_name','B.sale_tgl','A.brg_nama','A.type_brg','A.harga_retail','A.qty','A.isi')
                            ->addSelect(DB::raw('CASE WHEN type_brg=0 THEN A.harga_retail*A.isi WHEN type_brg=1 THEN A.harga_retail*A.qty END as jumlah'))
                            ->leftjoin('ms_sale as B', 'B.id_sale','=','A.sale_id')
                            ->leftjoin('ms_customer as C', function($join)
                                {
                                    $join->on('C.id_cust','=','B.cust_id');
                                })
                            ->whereIN('B.id_sale', $idmsl)
                            //->where('B.sale_posted',1)
                            ->where('A.harga_retail','>',0)
                            ->where('B.status_retur',1)
                            ->orderBy('B.sale_no', 'ASC')
                            ->orderBy('A.id_dsale', 'ASC')
                            ->get();  
                            
        }
            
        /* kredit */
        if($cash==0 && $credit==1){
            $aaa = Piutang::leftjoin('dt_piutang', 'piutang_id','=','id_piutang')
                            ->where('ms_piutang.is_kontan',0)
                            ->whereBetween('ms_piutang.lunas_tgl', [$tgl1,$tgl2])
                            ->get();
                            
            $idmsl=[];
            foreach($aaa as $bbb){ $idmsl[] = $bbb->sale_id;}
            
            if(empty($idmsl)){ return back(); }
            
            $data = DB::table('dt_sale as A')
                            ->select('B.sale_no','C.cus_name','B.sale_tgl','A.brg_nama','A.type_brg','A.harga_retail','A.qty','A.isi')
                            ->addSelect(DB::raw('CASE WHEN type_brg=0 THEN A.harga_retail*A.isi WHEN type_brg=1 THEN A.harga_retail*A.qty END as jumlah'))
                            ->leftjoin('ms_sale as B', 'B.id_sale','=','A.sale_id')
                            ->leftjoin('ms_customer as C', function($join)
                                {
                                    $join->on('C.id_cust','=','B.cust_id');
                                })
                            ->whereIN('B.id_sale', $idmsl)
                            //->where('B.sale_posted',1)
                            ->where('A.harga_retail','>',0)
                            ->where('B.status_retur',1)
                            ->orderBy('B.sale_no', 'ASC')
                            ->orderBy('A.id_dsale', 'ASC')
                            ->get();            

        }
          
        /* all */ 
        if($credit==1 and $cash==1){
        
            $data = DB::table('dt_sale as A')
                            ->select('B.sale_no','C.cus_name','B.sale_tgl','A.brg_nama','A.type_brg','A.harga_retail','A.qty','A.isi')
                            ->addSelect(DB::raw('CASE WHEN type_brg=0 THEN A.harga_retail*A.isi WHEN type_brg=1 THEN A.harga_retail*A.qty END as jumlah'))
                            ->leftjoin('ms_sale as B', 'B.id_sale','=','A.sale_id')
                            ->leftjoin('ms_customer as C', function($join)
                                {
                                    $join->on('C.id_cust','=','B.cust_id');
                                })
                            ->whereBetween('B.sale_tgl', [$tgl1, $tgl2])
                            ->where('B.sale_posted',1)
                            ->where('A.harga_retail','>',0)
                            ->where('B.status_retur',1)
                            ->orderBy('B.sale_no', 'ASC')
                            ->orderBy('A.id_dsale', 'ASC')
                            ->get();
        }
        
        return $data;
                    
    }
    
	public function reportExcell($tgl1, $tgl2, $cash, $credit)
	{
	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
		$file_xls = 'reportsale_detail.xls';
		return Excel::download(new SaleExport($tgl1, $tgl2, $cash, $credit), $file_xls);
	}        
    
/*-------------------*/
    public function reportDetail2($tgl1, $tgl2){
        
        ini_set('memory_limit', '-1');
        
        $sale = Penjualan::whereBetween('sale_tgl', array($tgl1, $tgl2))
                            ->where('status_retur', 1)
							->orderBy('sale_no','ASC')
							->get();
							
        $msale=[];
        //foreach($sale as $sl){ $msale[]=$sl->id_sale; }
        foreach($sale as $sl){ $noinv=$sl->sale_no; break; }
        
        $det = PenjualanDetail::leftjoin('ms_sale', 'ms_sale.id_sale','=', 'dt_sale.sale_id')
                                ->whereBetween('ms_sale.sale_tgl', [$tgl1, $tgl2])
                                ->where('ms_sale.sale_posted',1)
                                ->where('ms_sale.status_retur',1)
                                ->orderBy('ms_sale.sale_no', 'ASC')
                                ->get();
 
        
        $tlq=0;
        $tlv=0;
        $gtl=0;
        $totalv=0;
        $data=[];
        $awal=true;
        
        foreach($det as $list){
            
            $row=[];
            if($list->sale_no != $noinv){ 				
				$row[]='';
				$row[]='';
				$row[]='--- Total ---';
				$row[]='';
				$row[]=number_format($tlq);
				$row[]=number_format($tlv);
				$data[]=$row;
				
				$noinv=$list->sale_no;
				$tlq=0;
				$tlv=0;
				$awal=true;
				
            }else{
                if($awal==true){
        		    //$row=[];
        		    $row[]=$list->sale_no;
        		    $row[]=Customer::Customer($list->cust_id)->cus_name;
        		    $awal=false;
                }else{
                   	$row[]='';
				    $row[]=''; 
                }
            
            
    			$row[]=$list->brg_nama;
    			$row[]=number_format($list->harga_retail);
    			$row[]=number_format($list->qty);
    			$row[]=number_format($list->harga_retail*$list->qty);
    				
    			$tlq = $tlq + $list->qty;
    			$tlv = $tlv + ($list->qty*$list->harga_retail);
    			$gtl = $gtl + $list->qty;
    			$totalv = $totalv + ($list->qty*$list->harga);
    			
            }
            
			$data[]=$row;
		}
		
        $row=[];
		$row[]='';
		$row[]='';
		$row[]='--- Total ---';		
		$row[]='';
		$row[]='';      /*number_format($tlq);		*/
		$row[]=number_format($tlv);
		$data[]=$row;
		
		$row=[];
		$row[]='';
		$row[]='';
		$row[]='--- Grand Total ---';		
		$row[]='';
		$row[]=format_uang($gtl);		
		$row[]='';      /*format_uang($totalv);*/
		$data[]=$row;
        
        return view('report.saledetail', compact('data','tgl1','tgl2'));
    }
   
    
    
   
    public function getData($tgl1, $tgl2){

		$sale = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id', 'ms_customer.id_cust')
							->where('ms_sale.sale_posted', '=', 1)
							->where('ms_sale.sale_netto', '!=', 0)
							->whereBetween('ms_sale.sale_tgl', array($tgl1, $tgl2))
							->get();
		
		$no = 0;
		$totalsale=0;
		$data = array();

		foreach($sale as $list){
			
			$row = array();
			$lns="";
			
			if($list->sale_lunas == 0)
				{$lns = "Blm Lunas"; }else{ $lns="LUNAS" ;}
			$no++;
			
			if($list->status_retur==1)
				{ $totalsale += $list->sale_netto; 
				  $jlh = $list->sale_netto;
 			    }else{ 
					$totalsale -= $list->sale_netto;
					$jlh= $list->sale_netto * -1;
				}
			
			$row[] = $no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $list->cus_name;
			$row[] = $list->sale_no;
			$row[] = '<div class="text" align="right">'.format_uang($jlh).'</div>';
			$row[] = $lns;
		   
			$data[] = $row;
		}
		
		$ttl= '<div class="text" align="right">'.format_uang($totalsale).'</div>';
        $data[] = array("", "", "","TOTAL", $ttl, "");

		$output = array("data" => $data);
		return response()->json($output);

   }
   

/*-----------------------------------------------------------*/
  public function getDataPDF($tgl1, $tgl2){

		$sale = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id', 'ms_customer.id_cust')
							->where('ms_sale.sale_posted', '=', 1)
							->where('ms_sale.sale_netto', '!=', 0)
							->whereBetween('ms_sale.sale_tgl', array($tgl1, $tgl2))
							->get();
		
		$no = 0;
		$totalsale =0 ;
		$data = array();

		foreach($sale as $list){
			
			$row = array();
			$lns="";
			$jlh=0;
			if($list->sale_lunas == 0)
				{$lns = "Blm Lunas"; }else{ $lns="LUNAS" ;}
			$no++;
			
			if($list->status_retur==1)
				{ $totalsale += $list->sale_netto; 
				  $jlh = $list->sale_netto;
 			    }else{ 
					$totalsale -= $list->sale_netto;
					$jlh= $list->sale_netto * -1;
				}
			
			$row[] = $no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $list->cus_name;
			$row[] = $list->sale_no;
			$row[] = format_uang($jlh);
			$row[] = $lns;
		   
			$data[] = $row;
		}
		
		$data[] = array("", "", "", "Total Penjualan", format_uang($totalsale),"");

		return $data;

   }
   
  public function exportPDF($awal, $akhir){

     $tanggal_awal = $awal;
     $tanggal_akhir = $akhir;
     $data = $this->getDataPDF($awal, $akhir);

    // $pdf = PDF::loadView('report.pdf', compact('tanggal_awal', 'tanggal_akhir', 'data','hal'));
     
     $pdf = app('dompdf.wrapper');
     $pdf->getDomPDF()->set_option("enable_php", true);
     $pdf->loadView('report.pdf', compact('tanggal_awal', 'tanggal_akhir', 'data'));
    
     $pdf->setPaper('a4', 'potrait');
     
     return $pdf->stream();
   }	



/* report pelunasan */

   public function index_lunas()
   {
       return view('report.index_lunas');
   }

   public function pelunasan($tgl1, $tgl2){

		$lunas = Piutang::where('sts_posted', '=', 1)
		                    ->where('sts_batal', '=', 0)
							->whereBetween('lunas_tgl', array($tgl1, $tgl2))
							->orderBy('lunas_tgl')
							->get();
							
		$cicil1  = Penjualan::whereBetween('bayar1_tgl', array($tgl1, $tgl2))
		                    ->get();
		                    
        $cicil2	 = Penjualan::whereBetween('bayar2_tgl', array($tgl1, $tgl2))
		                    ->get();
		                    
        $cicil3	 = Penjualan::whereBetween('bayar3_tgl', array($tgl1, $tgl2))
		                    ->get();	 		                    
		
		$no = 0;
		$total=0;
		$data = array();

		foreach($lunas as $list){
			
			$row = array();
			$tp="";
			$no++;
			$total += $list->total_bayar;
			
			switch($list->lunas_type){
			    case 1 : $tp = "CASH"; break;
			    case 2 : $tp = "Trf/Giro"; break;
			    case 3 : $tp = "Lain2"; break;
			}

			$row[] = $no;
			$row[] = tanggal_indonesia($list->lunas_tgl, false);
			$row[] = Customer::Customer($list->cust_id)->cus_name;
			$row[] = '<div class="text" align="right">'.format_uang($list->total_bayar).'</div>';
			$row[] = $tp;
			$row[] = '<div class="text" align="right">'.format_uang($list->pembulatan).'</div>';

			$data[] = $row;
		
		}
		
		foreach($cicil1 as $list){
		
		    $row = array();    
		    $no++;
		    $total += $list->sale_bayar1;
		    
		    $row[] = $no;
		    $row[] = tanggal_indonesia($list->bayar1_tgl, false);
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = '<div class="text" align="right">'.format_uang($list->sale_bayar1).'</div>';
		    $row[] = "Cicilan-1";
		    $row[] ='';
		    
		    $data[] = $row;
		}
		
		foreach($cicil2 as $list){
		    
		    $row = array();
		    $no++;
		    $total += $list->sale_bayar2;
		    
		    $row[] = $no;		    
		    $row[] = tanggal_indonesia($list->bayar2_tgl, false);
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = '<div class="text" align="right">'.format_uang($list->sale_bayar2).'</div>';
		    $row[] = "Cicilan-2";
		    $row[] ='';		    
		    
		    $data[] = $row;
		}
		
		foreach($cicil3 as $list){
		    
		    $row = array();
		    
		    $no++;
		    $total += $list->sale_bayar3;
		    
		    $row[] = $no;		    
		    $row[] = tanggal_indonesia($list->bayar3_tgl, false);
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = '<div class="text" align="right">'.format_uang($list->sale_bayar3).'</div>';
		    $row[] = "Cicilan-3";
		    $row[] ='';		    
		    
		    $data[] = $row;
		}
				
		$ttl= '<div class="text" align="right">'.format_uang($total).'</div>';
        $data[] = array("", "", "TOTAL", $ttl, "","");
        
		$output = array("data" => $data);
		return response()->json($output);

   }

   public function getlunasPDF($tgl1, $tgl2){

		$lunas = Piutang::where('sts_posted', '=', 1)
							->whereBetween('lunas_tgl', array($tgl1, $tgl2))
							->orderBy('lunas_tgl')
							->get();
							
		$cicil1  = Penjualan::whereBetween('bayar1_tgl', array($tgl1, $tgl2))
		                    ->get();
		                    
        $cicil2	= Penjualan::whereBetween('bayar2_tgl', array($tgl1, $tgl2))
		                    ->get();
		                    
        $cicil3	= Penjualan::whereBetween('bayar3_tgl', array($tgl1, $tgl2))
		                    ->get();	 								
		
		$no = 0;
		$total=0;
		$data = array();

		foreach($lunas as $list){
			
			$row = array();
			$tp="";
			$no++;
			$total += $list->total_bayar;
			
			switch($list->lunas_type){
			    case 1 : $tp = "CASH"; break;
			    case 2 : $tp = "Trf/Giro"; break;
			    case 3 : $tp = "Lain2"; break;
			}

			$row[] = $no;
			$row[] = tanggal_indonesia($list->lunas_tgl, false);
			$row[] = Customer::Customer($list->cust_id)->cus_name;
			$row[] = format_uang($list->total_bayar);
			$row[] = $tp;
			$row[] = format_uang($list->pembulatan);

			$data[] = $row;
		
		}

		foreach($cicil1 as $list){
		    
		    $row = array();
		    $no++;
		    $total += $list->sale_bayar1;
		    
		    $row[] = $no;
		    $row[] = tanggal_indonesia($list->bayar1_tgl, false);
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = format_uang($list->sale_bayar1);
		    $row[] = "Cicilan-1";
		    $row[] = "";

		    $data[] = $row;
		}
		
		foreach($cicil2 as $list){
		    
		    $row = array();
		    $no++;
		    $total += $list->sale_bayar2;
		    
		    $row[] = $no;		    
		    $row[] = tanggal_indonesia($list->bayar2_tgl, false);
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = format_uang($list->sale_bayar2);
		    $row[] = "Cicilan-2";
		    $row[] = "";		    
		    
		    $data[] = $row;
		}
		
		foreach($cicil3 as $list){
		    
		    $row = array();
		    $no++;
		    $total += $list->sale_bayar3;
		    
		    $row[] = $no;		    
		    $row[] = tanggal_indonesia($list->bayar3_tgl, false);
		    $row[] = Customer::Customer($list->cust_id)->cus_name;
		    $row[] = format_uang($list->sale_bayar3);
		    $row[] = "Cicilan-3";
		    $row[] = "";		    
		    
		    $data[] = $row;
		}
		
        $data[] = array("", "", "TOTAL", format_uang($total), "","");
        
        return $data;

   }   
   
  public function pelunasanPDF($awal, $akhir){

     $tanggal_awal = $awal;
     $tanggal_akhir = $akhir;
     $data = $this->getlunasPDF($awal, $akhir);

     $pdf = app('dompdf.wrapper');
     $pdf->getDomPDF()->set_option("enable_php", true);
     $pdf->loadView('report.lunas_pdf', compact('tanggal_awal', 'tanggal_akhir', 'data'));
    
     $pdf->setPaper('f4', 'potrait');
     
     return $pdf->stream();
   }	    


/* report pembelian */

   public function index_beli()
   {
       return view('report.index_beli');
   }

   public function pembelian($tgl1, $tgl2){

		$beli = Invoice::where('inv_posted', '=', 1)
							->whereBetween('inv_tgl', array($tgl1, $tgl2))
							->orderBy('inv_tgl')
							->get();
		
		$no = 0;
		$total=0;
		$data = array();

		foreach($beli as $list){
			
			$row = array();
			$no++;
			$total += $list->inv_total;
			
			$row[] = $no;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = Supplier::Supplier($list->supp_id)->sup_nama;
			$row[] = $list->inv_no;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_total).'</div>';

			$data[] = $row;
		
		}
		$ttl= '<div class="text" align="right">'.format_uang($total).'</div>';
        $data[] = array("", "","", "TOTAL", $ttl);
        
		$output = array("data" => $data);
		return response()->json($output);

   }

   public function getbeliPDF($tgl1, $tgl2){

		$beli = Invoice::where('inv_posted', '=', 1)
							->whereBetween('inv_tgl', array($tgl1, $tgl2))
							->orderBy('inv_tgl')
							->get();
		
		$no = 0;
		$total=0;
		$data = array();

		foreach($beli as $list){
			
			$row = array();
			$no++;
			$total += $list->inv_total;
			
			$row[] = $no;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = Supplier::Supplier($list->supp_id)->sup_nama;
			$row[] = $list->inv_no;
			$row[] = format_uang($list->inv_total);

			$data[] = $row;
		
		}
	
        $data[] = array("", "", "","TOTAL",format_uang($total));
        
        return $data;

   }   
   
  public function pembelianPDF($awal, $akhir){

     $tanggal_awal = $awal;
     $tanggal_akhir = $akhir;
     $data = $this->getbeliPDF($awal, $akhir);

     $pdf = app('dompdf.wrapper');
     $pdf->getDomPDF()->set_option("enable_php", true);
     $pdf->loadView('report.beli_pdf', compact('tanggal_awal', 'tanggal_akhir', 'data'));
    
     $pdf->setPaper('a4', 'potrait');
     
     return $pdf->stream();
   }	    
    
}

