<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Price;
use App\Toko;
use App\Promotion;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

class PromotionController extends Controller
{

/// masuk ke form pilih toko dulu
	public function index()
	{
		$toko	= Toko::where('str_type', '=', 1)
					->orderby('str_name', 'ASC')->get();
		
		return view('promotion.index', compact('toko'));
	}

// tampil daftar toko
   public function listData()
   {
		$toko	= Toko::where('str_type', '=', 1)
				->orderby('str_name', 'ASC')->get();
 
		$data = array();
		foreach($toko as $list){
       
		   $row = array();
		   $row[] = $list->str_kode;
		   $row[] = $list->str_name;
		   $row[] = $list->str_address;
		   $row[] = $list->str_city;
		   $row[] = '<div class="btn-btn">
				   <a href="/mms/promotion/'.$list->id_store.'/tampil" class="btn btn-primary btn-xs"><i class="fa fa-check"></i></a>
				   </div>';
		   $data[] = $row;
		 }

     $output = array("data" => $data);
     return response()->json($output);
   }	

	public function tampil($id)
	{
		session(['idstore' => $id]);
		$toko = Toko::find($id);
	
		return view('promotion.promo_data', compact('toko'));
	} 


    function getdata()
    {
		$tglnow = date("Y-m-d");
     	$promosi = Promotion::leftJoin('ms_barang', 'ms_promosi.sku_id', '=', 'ms_barang.id_sku')
								->where('ms_promosi.prm_end','>=', $tglnow)
								->where('str_id', '=', session('idstore'))
								->orderBy('str_id','ASC')
								->orderby('prm_sku','ASC')->get();
		
		$data = array();
		foreach($promosi as $list)
		{
		   $row = array();
		   
		   $row[] = '<div class="btn-btn">
				   <a onclick="editForm('.$list->id_promo.')" class="btn btn-danger btn-sm"><i class="fa fa-pencil"></i></a>
				   <a onclick="detailForm('.$list->id_promo.')" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>
				   </div>';	   
		   $row[] = $list->str_kode;
		   $row[] = $list->prm_sku;
		   $row[] = $list->sku_name;
		   $row[] = $list->prm_start;
		   $row[] = $list->prm_end;
		   $row[] = $list->prm_qty;
		   $row[] = $list->prm_max;
		   $row[] = $list->reguler_01;
		   $row[] = $list->promo_01;		   
		   $row[] = $list->disc_01;		   
		   $row[] = $list->reguler_02;
		   $row[] = $list->promo_02;		   
		   $row[] = $list->disc_02;		   
		   $row[] = $list->reguler_03;
		   $row[] = $list->promo_03;		   
		   $row[] = $list->disc_03;		   
		   $row[] = $list->reguler_04;
		   $row[] = $list->promo_04;		   
		   $row[] = $list->disc_04;		   
		   $row[] = $list->reguler_05;
		   $row[] = $list->promo_05;		   
		   $row[] = $list->disc_05;		   
		   $row[] = $list->reguler_06;
		   $row[] = $list->promo_06;		   
		   $row[] = $list->disc_06;		   
		   $row[] = $list->reguler_07;
		   $row[] = $list->promo_07;		   
		   $row[] = $list->disc_07;		   
		   $row[] = $list->reguler_08;
		   $row[] = $list->promo_08;		   
		   $row[] = $list->disc_08;		   
		   $row[] = $list->reguler_09;
		   $row[] = $list->promo_09;		   
		   $row[] = $list->disc_09;		

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);
		
    }

    function getdata2($id)
    {
		$tglnow = date("Y-m-d");
		if ($id==0)
		{
     	$promosi = Promotion::leftJoin('ms_barang', 'ms_promosi.sku_id', '=', 'ms_barang.id_sku')
								->where('ms_promosi.prm_end','>=', $tglnow)
								->orderBy('str_id','ASC')
								->orderby('prm_sku','ASC')->get();
		}			
		else{
		$promosi = Promotion::leftJoin('ms_barang', 'ms_promosi.sku_id', '=', 'ms_barang.id_sku')
								->where('ms_promosi.prm_end','>=', $tglnow)
								->where('ms_promosi.str_id', '=',$id )
								->orderBy('str_id','ASC')
								->orderby('prm_sku','ASC')->get();
		}			
		

   		
		return $promosi;
				
    }

	function pilihsku($id)
	{
		$toko	= Toko::find($id);
					
		return view('promotion.pilihproduct', compact('toko'));	
	}


	
    function pilihdata()
    {
		$Produk = Price::leftjoin('ms_barang', 'dt_price.sku_id', '=', 'ms_barang.id_sku');
	 
		return Datatables::of($Produk)->make(true);
    }	

    function pilihdata2()
    {
     	
		$Produk = Price::leftjoin('ms_barang', 'dt_price.sku_id', '=', 'ms_barang.id_sku');
	 
		return Datatables::of($Produk)->make(true);
    }	


    public function store(Request $request)
    {
		$tglnow = date("Y-m-d");
		$tokoid	= $request['idtoko'];
		$sku	= $request['kode'];
		$zone	= $request['zona'];
		
		//jika toko=ALL /id=0		
		if ($tokoid=="0")
		{
			$ada_promo	= DB::table('ms_promosi')
								->where('prm_sku', '=', $sku)
								->where('prm_end','>=', $tglnow)->get();
		}else{
			$ada_promo	= DB::table('ms_promosi')
								->where('prm_sku', '=', $sku)
								->where('prm_end','>=', $tglnow)
								->whereIn('str_id',[$tokoid,0])								
								->get();		
		}
		
		if ($ada_promo<>0)		//sudah ada di promo
		{
			return json_encode(array('msg'=>'error'));
			
		} else {
		
		//save promo
			$promosi = new Promotion;
			
			$valid_promo = true;
			//cek zonasi
			if ($tokoid==0)
			{	
				if($request['zona']==0)
				{
				}
					
			}else{
				
			}
		
			$produk->sku_kode	 = $sku_no;
			$produk->sku_name    = $request['nama'];
			$produk->cat_id      = $request['cat'];
			$produk->brd_id		 = $request['brand'];
			$produk->sku_struk	 = $request['struk'];
			$produk->sku_art	 = $request['art'];
			$produk->sku_distr	 = $request['dist'];
			$produk->sku_pack	 = $request['pack'];
			$produk->sku_size	 = $request['size'];
			$produk->deskripsi	 = $request['desk'];
			$produk->sku_kdmodal = $request['kdmodal'];
			$produk->sku_ongkos	 = $request['ongkir'];
			$produk->sku_expdt	 = $request['expd'];
			$produk->sku_type	 = '3';
			$produk->sku_clust	 = 'YYYY';
			$produk->sku_sales	 = 'YYYY';
			$produk->sku_flag	 = 'N';
			$produk->sku_status	 = '0';
			$produk->org_id		 = $request['origin'];
			$produk->user_id	 = Auth::user()->id;
	 
			$produk->save();
		
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'New Promotion';
			$userlog->content	= 'SKU '.$sku_no.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
        
		}
    }

    public function edit($id)
    {
      $produk = Product::find($id);
      echo json_encode($produk);
    }

   public function show($id)
   {
		$detail = Promotion::leftJoin('ms_barang', 'ms_promosi.sku_id', '=', 'ms_barang.id_sku')
								->where('ms_promosi.id_promo', '=', $id)->get();
		
		return Redirect::route('promotion/detail');      
		//return view('promotion.detail', compact('detail'));
   }


	public function tambah($id)
	{
		//$barang  = Product::leftJoin('dt_price', 'dt_price.sku_id', '=', 'ms_barang.id_sku')
		//					->where('ms_barang.id_sku', '=', $id)->get();
		
		$harga  = Price::find($id);
		$idbrg	= $harga->sku_id;
		$barang = Product::find($idbrg);

		//$harga	= Price::where('sku_id','=',$id)->get();
		
		//echo json_encode($barang);
		echo json_encode(array_merge(json_decode($barang, true),json_decode($harga, true)));
	}
	
    public function detail()
    {
    }
////////////////
	
    public function update(Request $request, $id)
    {
		$produk = Product::find($id);
		
			$skuno	= $produk->sku_kode;
			
			$produk->sku_name    = $request['nama'];
			$produk->cat_id      = $request['cat'];
			$produk->brd_id		 = $request['brand'];
			$produk->sku_struk	 = $request['struk'];
			$produk->sku_art	 = $request['art'];
			$produk->sku_distr	 = $request['dist'];
			$produk->sku_pack	 = $request['pack'];
			$produk->sku_size	 = $request['size'];
			$produk->deskripsi	 = $request['desk'];			
			$produk->sku_kdmodal = $request['kdmodal'];
			$produk->sku_ongkos	 = $request['ongkir'];
			$produk->sku_expdt	 = $request['expd'];
			$produk->org_id		 = $request['origin'];
			$produk->user_id	 = Auth::user()->id; 
 
			$produk->update();
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit Master SKU';
		$userlog->content	= 'SKU '.$skuno.' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }

	
}
