<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Category;
use App\User;
use App\User_logs;
use Datatables;
use DB;
use Auth;
use Session;

class ProductController extends Controller
{
	
    public function index()
    {
		$category 	= Category::where('company_id', Auth::user()->company_id)
		                          ->where('is_active', 1)
		                          ->orderBy('category_name')
		                          ->get();  
 
		return view('product.index', compact('category'));
    }	
    
    public function index_api(){
       // $Produk = DB::table('ms_product')
     //	                    ->select(DB::raw("*, CASE WHEN (type_brg)=0 THEN 'KEMASAN' ELSE 'SATUAN' END as type"))
     //	                    ->leftJoin('ms_category', 'ms_category.id_cat', '=', 'ms_product.cat_id')
     //	                    ->leftjoin('ms_supp', 'ms_supp.id_supp', '=', 'ms_product.supplier');
     	                    
     	                    return Product::all();
    }

    function getdata()
    {
     	
     	$Produk = DB::table('ms_product')
     	                    ->select(DB::raw("*, CASE WHEN (type_brg)=0 THEN 'KEMASAN' ELSE 'SATUAN' END as type"))
     	                    ->leftJoin('ms_category', 'ms_category.id_cat', '=', 'ms_product.cat_id')
     	                    ->leftjoin('ms_supp', 'ms_supp.id_supp', '=', 'ms_product.supplier');
		 
		return Datatables::of($Produk)->make(true);
    }

   public function listData()
   {
     	$Produk = Product::with('get_category')
     	                    ->where('company_id',Auth::user()->company_id)
     	                    ->get();

        $data = [];
         
        foreach($Produk as $list){
            
            if($list->is_inventory==1){ $inv='<div class="label label-success">Yes</div>'; }else{ $inv='<div class="label label-danger">No</div>';}
            if($list->is_active==1){ $sts='<div class="label label-success">Yes</div>'; }else{ $sts='<div class="label label-danger">No</div>';}
            if($list->is_ppn==1){ $ppn='<div class="label label-success">Yes</div>'; }else{ $ppn='<div class="label label-danger">No</div>';}
            
            $row = [];
            $row[] = $list->product_name;
            $row[] = $list->get_category->category_name;
         
            $row[] = '<div class="text-right">'.format_uang($list->retail_price).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[] = '<div class="text-right">'.format_uang($list->product_cost).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[] = '<div class="text-center">'.$list->product_pax.'</div>';
            $row[] = $ppn;
            $row[] = $inv;
            $row[] = $sts;
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$list->id.')" class="btn btn-danger btn-sm"><i class="fa fa-pencil-square-o"></i> </a>
                        <a onclick="showDetail('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i> </a>
    			    </div>';
            $data[] = $row;
         }

         $output = array("data" => $data);
         return response()->json($output);
   }

	
    function pilihdata()
    {
     	 $Produk = Product::leftJoin('ms_category', 'ms_category.id_cat', '=', 'ms_product.cat_id');
	 
		return Datatables::of($Produk)->make(true);
    }	

    public function store(Request $request)
    {

    	$produk = new Product;
		
		$produk->company_id     = Auth::user()->company_id;
		$produk->product_name   = ucwords(strtolower($request['nama']));
		$produk->category_id    = $request['cat'];
		$produk->is_inventory   = $request['inv'];
		$produk->retail_price   = $request['harga1'];
		$produk->product_cost   = $request['pokok'];
		$produk->is_ppn         = $request['ppn'];
		$produk->product_pax    = $request['stn'];
		$produk->description    = $request['desk'];
		$produk->is_active      = 1;
		$produk->save();

	// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'New Product';
		$userlog->content	= 'Product '.$request['nama'].' berhasil ditambahkan oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();

		echo json_encode(array('msg'=>'success'));
        
    }

    public function edit($id)
    {
      $produk = Product::find($id);
      echo json_encode($produk);
    }

   public function show($id)
   {
	    $produk 	= Product::where('id',$id)->get();
		$data   = array();	
		$no =0;
		
		foreach ($produk as $detail)
		{
	
			$category	= Category::find($detail->cat_id);
			$supplier	= Supplier::find($detail->supplier);
						
	
			$usernm	= User::find($detail->user_id);
			
			$no++;
     		$row    = array();
			$row[]  = $no.". Nama Barang";
			$row[]	= $detail->nama_brg;
			$data[] = $row;

			$no++;
			$row    = array();
			$row[]  = $no.". Category";
			$row[]	= $category->cat_name;
 			$data[] = $row;
 			
 			$tp = $detail->type_brg;
 			switch ($tp){
 			    case "0": $type="KEMASAN"; break;
 			    case "1": $type="SATUAN"; break;
 			}
 			/*
			$no++;
			$row    = array();
			$row[]  = $no.". Type Barang";
			$row[]	= $type;
 			$data[] = $row;
 			
			if(!is_null($detail->child_to))
			{
				$no++;
				$row	= array();
				$row[]	= $no.'. Produk Turunan';
				$row[]	= Product::Product($detail->child_to)->nama_brg;
				$data[]	= $row;
			}
			*/
			
			$no++;
			$row    = array();
			$row[]  = $no.". Harga Jual";
			$row[]	= format_uang($detail->harga_jual);
 			$data[] = $row;
			
			$no++;
			$row    = array();
			$row[]  = $no.". Supplier";
			$row[]	= $supplier->sup_nama;
 			$data[] = $row;
			
			$no++;
			$row    = array();
			$row[]  = $no.". Deskripsi";
			$row[]	= $detail->deskripsi;
 			$data[] = $row;				
			
			$no++;
			$row	= array();
			$row[]	= $no.". Last Updates";
			$row[]	= $detail->updated_at."&nbsp;&nbsp;&nbsp;by.&nbsp;".$usernm->username;
			$row[]	= "";
			$data[]	= $row;
		}

        $output = array("data" => $data);
        return response()->json($output);
	 
   }

////////////////
	
    public function update(Request $request, $id)
    {
		
		$produk = Product::find($id);

		$produk->product_name   = ucwords(strtolower($request['nama']));
		$produk->category_id    = $request['cat'];
		$produk->is_inventory   = $request['inv'];
		$produk->retail_price   = $request['harga1'];
		$produk->product_cost   = $request['pokok'];
		$produk->is_ppn         = $request['ppn'];
		$produk->product_pax    = $request['stn'];
		$produk->description    = $request['desk']; 
		$produk->update();
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit Master Product';
		$userlog->content	= 'Produk '.$request['nama'].' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;

		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }

    public function simpansatuan(Request $request){
        
        $stn = new DtProduct;
        $stn->product_id    = $request['idproduct'];
        $stn->satuan_1      = $request['satuan1'];
        //$stn->isi           = $request['isi'];
        //$stn->satuan_2      = $request['satuan2'];
        
        $stn->save();
        echo json_encode(['msg'=>'success']);
        
        
    }
	
	
/* =======================     barang masuk ==============================*/

    public function masukBarang(){
        $prd = Product::all();
        return view('product.index_masuk', compact('prd'));
    }
    
    public function barangin(){
        $dt = MsProductIn::where('is_posted',0)
                            ->get();
        $data=[];                            
        foreach($dt as $list){
            $row=[];
            $row[]=$list->tgl_masuk;
            $row[]=$list->no_referensi;
            $row[]=$list->no_dokumen;
            $row[]=$list->description;
            $row[]=$list->penerima;
            $row[]='<a onclick="addDetail('.$list->id.')" class="btn btn-outline-success btn-xs"><i class="fa fa-plus"></i></a>';
            
            $data[]=$row;
            
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }

    public function createmasuk(Request $request){
        
        $noref = $this->cekNoRef();
        
        $dt = new MsProductIn;
        
        $dt->tgl_masuk      = $request['tglin'];
        $dt->no_referensi   = $noref;
        $dt->no_dokumen     = $request['dok_no'];
        $dt->description    = $request['desk'];
        $dt->penerima       = $request['penerima'];
        $dt->save();

			
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Masuk Barang ';
			$userlog->content	= 'Masuk Barang '.$request['dok_no'].' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
        
        echo json_encode(["msg"=>"success"]);
    }

    public static function cekNoRef(){
    	/* cek no terakhir */
		$noref	= '';
		$tahun	= date('Y');
		$bulan	= date('m');
		$nomor	="IN/".$tahun.$bulan."/";		
			
		$ada_no	= DB::table('product_in_ms')
						->select(DB::raw('SUBSTR(MAX(no_referensi),11,4) as last_no'))
						->where('no_referensi', 'LIKE', "$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$noref = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "0001";
			$noref = $nomor.$nomorbaru;
		}
		
		return $noref;
    }

    public function loadHeader($id){
        $dt = MsProductIn::find($id);
        echo json_encode($dt);
    }
    
    /* data detail*/
    public function dataDetail($id){
        
        //$ms = MsProductIn::find($id);
        $dt = DtProductIn::where('masuk_id', $id)
                            ->get();
                    
        $data=[];            
        foreach($dt as $list){
            
            $prd = Product::find($list->product_id);
            $tl = $list->qty_big * $prd->vol_small + $list->qty_small;
            
            $row=[];
            $row[] = $prd->nama_brg;
            $row[] = $list->qty_in.' '.$prd->stn_stock;

            if($list->is_posted==0){
      		    $row[] = '<div class="btn-btn">
						<a onclick="editDetail('.$list->id.')" class="btn btn-flat btn-xs btn-outline-success" style="margin-top:-4px;margin-bottom:-5px;"><i class="fa fa-pencil"></i></a>
					</div>';  
            }else{
                $row[]="";
            }
            
            $data[]=$row;
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }
        
    public function simpanDetail(Request $request, $id){
        
        $qty   = $request['qty'];
        $prd = Product::find($request['prd']);

        $dt = new DtProductIn;
        
        $dt->masuk_id   = $id;
        $dt->product_id = $request['prd'];
        $dt->qty_in     = $qty;
        $dt->save();
        
        
        
        	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Detail Masuk Barang ';
			$userlog->content	= 'Masuk Barang '.$prd->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
        
        echo json_encode(["msg"=>"success"]);
    }
    
    public function editDetail($id){
        
        $dt = DtProductIn::find($id);
        $prd = Product::find($dt->product_id);
        
        echo json_encode(array_merge(json_decode($prd, true), json_decode($dt,true)));
    }
    
    public function simpanEditDetail(Request $request, $id){
        
        $prd = Product::find($request['prd']);
        $dt = DtProductIn::find($id);

        $dt->qty_in    = $request['qty'];
        $dt->update();
        
        
        	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Edit Detail Masuk Barang ';
			$userlog->content	= 'Masuk Barang '.$prd->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
        
        echo json_encode(["msg"=>"success"]);
    }    
    
    public function cetakDokumen($id){
        $ms = MsProductIn::find($id);
        $dt = DtProductIn::leftjoin('ms_product','product_in_dt.product_id','=','ms_product.id')
                            ->where('product_in_dt.masuk_id', $id)
                            ->get();
                            
        $no=1;
        
        return view('product.masuk_dokumen', compact('ms','dt','no'));
    }
    
    public function postingStock($id){
        
        $ms = MsProductIn::find($id);
        $st = DtProductIn::where('masuk_id', $id)
                    ->get();
        
        foreach($st as $dt){
            
            $adastock = StockProduct::find($dt->product_id);
            
            if(empty($adastock)){
                $stk = new StockProduct;
                
                $stk->product_id= $dt->product_id;
                $stk->stock_in  = $dt->qty_in;  
                $stk->tgl_in    = $ms->tgl_masuk;
                $stk->save();
            }else{
                $old = $adastock->stock_in;
                $adastock->stock_in = $old + $dt->qty_in;
                $adastock->tgl_in   = $ms->tgl_masuk;
                $adastock->update();
            }    
        }    
        
        $ms->is_posted=1;
        $ms->update();
        //echo json_encode(["msg"=>"success"]);
                
        Session::flash('sukses','Posting berhasil !');
    	return back();
    }

    public function index_stock(){
        return view('product.index_stock');
    }
    
    public function dataStock(){
        
        $dt = DB::table('product_stock as A')
                    ->select('A.id','A.product_id','B.nama_brg','A.stock_awal','A.stock_in','A.stock_out','B.stn_stock')
                    ->leftjoin('ms_product as B', function($join)
                        {
                            $join->on('A.product_id','=','B.id');
                        })
                    ->get();
        
        $data=[];
        foreach($dt as $list){
            $row=[];
            $row[]=$list->nama_brg;
            $row[]=format_uang($list->stock_awal);
            $row[]=format_uang($list->stock_in);
            $row[]=format_uang($list->stock_out);
            $row[]=format_uang($list->stock_awal+$list->stock_in-$list->stock_out).' '.$list->stn_stock;
            $row[]='<div class="btn-btn">
                        <a onclick="stockDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-list"></i></a>
                    </div>';
                    
            $data[]=$row;
        }
        
        $output = ["data"=>$data];
        return response()->json($output);
    }

	
	
	
}
