<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Product;
use App\Customer;
use App\Penjualan;
use App\PenjualanDetail;
use App\Stock;
use App\InvoiceDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

//last update : 23/06/2020

class PenjualanDetailController extends Controller
{

	public function index()
	{
		return view('penjualan_detail.index');
	}
	
   public function listData()
   {
		$msale		= Penjualan::find(session('idtrx'));
		
		$dtrans 	= PenjualanDetail::leftJoin('ms_product', 'dt_sale.brg_id', '=', 'ms_product.id')
										->where('dt_sale.sale_id', session('idtrx'))->get();
										
				
		$no=0;
		$data = array();
				
		foreach($dtrans as $list){
			$no++;

			$row = array();
			
			$tp ="";
			if($list->type_brg==0){
			    $tltrans = $list->harga_retail * $list->isi - $list->potongan;
			    $tp = "Kemasan";
			}else{
			    $tltrans = $list->harga_retail * $list->qty* $list->isi - $list->potongan;
			    $tp = "Satuan";
			}
				
			$row[] = $no;
			$row[] = $list->nama_brg;
			$row[] = $tp;
			$row[] = '<div class="text" align="right">'.$list->qty.'</div>';
			$row[] = $list->isi;
			$row[] = '<div class="text" align="right">'.format_uang($list->harga_retail).'</div>';
			$row[] = '<div class="text" align="right">'.format_uang($list->potongan).'</div>';
            $row[] = '<div class="text" align="right">'.format_uang($tltrans).'</div>';

			if(Auth::user()->sale_del==1){
				$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_dsale.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
					<a onclick="deleteItem('.$list->id_dsale.')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
					</div>';
			}else{
				$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_dsale.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
					<a onclick="error_mess()" class="btn btn-default btn-sm"><i class="fa fa-trash"></i></a>
					</div>';
			}					
            
			$data[] = $row;		

			}
		

		$output = array("data" => $data);
		return response()->json($output);
	}
			
/*--------------------------------------------------------------------*/
   public function listData2()
   {
		$minv	= Invoice::find(session('idinv'));
		
		$ppn	= $minv->inv_ppn;
		$disc1	= $minv->inv_disc;
			
		$dtinvoice	= InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
										->where('dt_invoice.invoice_id', session('idinv'))->get();
										
				
		$no=0;
		$totalinv1	= 0;
		$totalinv	= 0;
		$disc1	 	= 0;
		$disc2		= 0;
		$disc3		= 0;
			
		$last_no	= 0;
		$data = array();
				
		foreach($dtinvoice as $list){
			$no++;
			$jlh 	= $list->inv_gross*$list->inv_qty;
			$disc1	= $jlh *$list->inv_disc1/100;
			$jumlahinv	= $jlh - $disc1;
			
			$row = array();
				
			$row[] = $no;
			$row[] = $list->kode_brg;
			$row[] = $list->nama_brg;
			$row[] = $list->no_seri;			
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_gross).'</div>';
			$row[] = $list->inv_qty.' '.$list->inv_stn;
			$row[] = $list->inv_disc1;
			$row[] = '<div class="text" align="right">'.format_uang($jumlahinv).'</div>';
			$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_inv.')" class="btn btn-primary btn-sm"><i class="fa fa-eye"> detail </i></a>
					</div>';

			$totalinv1 += $list->inv_gross * $list->inv_qty;
						
			$totalinv = $totalinv1;	
							
			$data[] = $row;		

			}
				
		$no++;
		$data[] = array($no,"","","","<span class='hide totalopn'>$totalinv</span>", "<span class='hide totalqty'>$totalqty</span>", "", "","");
				
		$output = array("data" => $data);
		return response()->json($output);
	}
			

    public function loadSummary(){
        
		$dtrans	= PenjualanDetail::where('sale_id',session('idtrx'))->get();
		
		$totalqty=0;
		$totalrp=0;
		$totaldisc=0;
										
        foreach($dtrans as $list){
            
			if($list->type_brg==0){
			    $totalrp += $list->harga_retail * $list->isi - $list->potongan;
			}else{
			    $totalrp += $list->harga_retail * $list->qty* $list->isi - $list->potongan;
			}
			
            //$totalrp    += $list->harga_retail * $list->qty * $list->isi - $list->potongan;
            $totaldisc  += $list->potongan;
            $totalqty   += $list->qty;
        }
        
        $mtrans = Penjualan::find(session('idtrx'));
        
        $mtrans->sale_disc = $totaldisc;
        $mtrans->sale_netto= $totalrp ;
        $mtrans->update();
        
        $data = array("totalqty"=>format_uang($totalqty),
                      "totalrp" =>format_uang($totalrp));
                      
        return response()->json($data);
    }
////////////////////////////////////////////////////////////////////////

 
//simpan detail type satuan
	public function store(Request $request)
	{
	    $msale		= Penjualan::find(session('idtrx'));
	    
		$idtrx		= $msale->id_sale;
		$idcust     = $msale->cust_id;
		
		$idstock	= $request['kode'];
		$stock		= Stock::find($idstock);
		$idbrg		= $stock->brg_id;

		$product	= Product::find($idbrg);

		$trxdetail	= New PenjualanDetail;
		
		$trxdetail->sale_id	    = $idtrx;
		$trxdetail->brg_id	    = $idbrg;
		$trxdetail->type_brg    = $product->type_brg;
		$trxdetail->brg_nama	= $product->nama_brg;
		$trxdetail->harga_retail  = $product->harga_jual;
		$trxdetail->qty		    = 1;		//default qty
		$trxdetail->isi         = 1;
		$trxdetail->potongan    = 0;
		$trxdetail->user_id	= Auth::user()->id;
		
		$trxdetail->save();

	//	if($msale->status_retur==1){
			$this->updatestock( $idstock, $qty=1, $msale->sale_tgl);
	//	}

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Penjualan Detail '.$msale->sale_no;
			$userlog->content	= $product->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}
	
	function updatestock( $id, $qty, $tgl)
	{
		$stock  = Stock::find($id);

 		/*update stock */
    	$stkakhir   = $stock->stock_akhir;
    	$jual       = $stock->penjualan;
    	   			     
    	$stock->penjualan      = $jual + $qty;
    	$stock->tgl_jual       = $tgl;
    	$stock->stock_akhir    = $stkakhir - $qty;
    			     
		$stock->update();		
	}



//simpan detail type kemasan
	public function simpan(Request $request)
	{
	    $msale		= Penjualan::find(session('idtrx'));
	    
		$idtrx		= $msale->id_sale;
		$idcust     = $msale->cust_id;
		
		$idinv  	= $request['kode2'];
		$dtinv  	= InvoiceDetail::find($idinv);
		$idbrg		= $dtinv->id_brg;

		$product	= Product::find($idbrg);

		$trxdetail	= New PenjualanDetail;
		
		$trxdetail->sale_id	    = $idtrx;
		$trxdetail->brg_id	    = $idbrg;
		$trxdetail->type_brg    = $product->type_brg;
		$trxdetail->brg_nama	= $product->nama_brg;
		$trxdetail->harga_retail  = $product->harga_jual;
		$trxdetail->qty		    = 1;		//default qty
		$trxdetail->isi         = 1;
		$trxdetail->potongan    = 0;
		$trxdetail->inv_id      = $idinv;
	
		$trxdetail->user_id	= Auth::user()->id;
		
		$trxdetail->save();

    //update dt_invoice    
	//	if($msale->status_retur==1)
	//	{
			$old_qqq    = $dtinv->qty_sale;
			$old_tonase = $dtinv->tonase_sale;
			
			$dtinv->tonase_sale = $old_tonase + 1;
			$dtinv->qty_sale    = $old_qqq + 1;
			$dtinv->tgl_sale    =date('Y-m-d');
			$dtinv->update();
	//	}
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Penjualan Detail '.$msale->sale_no;
			$userlog->content	= $product->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}
	
/*-------------------------------------------------------------------*/
	public function show($id)
	{
		$dtinv = PenjualanDetail::find($id);

		echo json_encode($dtinv);		
	}
	
    public function edit($id)
    {
      $dttrx  = PenjualanDetail::find($id);
	  $barang = Product::find($dttrx->brg_id);
	 
	  echo json_encode(array_merge(json_decode($barang, true),json_decode($dttrx, true)));
	
    }

    public function caribrg($id)
    {
	  $barang = Product::find($id);
	 
	  echo json_encode($barang);
    }
////////////////
	
    public function update(Request $request, $id)		
    {
		$dttrx 		= PenjualanDetail::find($id);
		$product	= Product::find($dttrx->brg_id);
		$msale		= Penjualan::find($dttrx->sale_id);
		
		$old_isi    = $dttrx->isi;
		$old_qqq    = $dttrx->qty;
		
		$dttrx->qty 	        = $request['qty'];
		$dttrx->harga_retail    = $request['retail'];
		$dttrx->isi             = $request['isi'];
		$dttrx->potongan        = $request['dis'];
		$dttrx->user_id	        = Auth::user()->id; 
 
		$dttrx->update();
		
	//	if($msale->status_retur==1)
	//	{
			if($product->type_brg==0){
				$dtinv = InvoiceDetail::find($dttrx->inv_id);
				
				$old_tonase = $dtinv->tonase_sale;
				$old_qty    = $dtinv->qty_sale;
				
				$dtinv->qty_sale    = $old_qty - $old_qqq + $request['qty'];
				$dtinv->tonase_sale = $old_tonase - $old_isi + $request['isi'];
				$dtinv->update();
			}else{
				$stk = Stock::where('brg_id','=', $product->id)->get();
				foreach($stk as $sss){ $idstock = $sss->id_stock ;}

				$old_q = $old_qqq * $old_isi;
				$new_q = $request->qty * $request->isi; 
				$new_qty = $new_q - $old_q;

				$this->updatestock( $idstock, $new_qty, $msale->sale_tgl);
			}
	//	}
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit QTY Transaksi '.$msale->sale_no;
		$userlog->content	=  $product->nama_brg. 'berhasil diedit by. '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }


//hapus data detail
   public function destroy($id)
   {
		$dttrx      = PenjualanDetail::find($id);
		$msale      = Penjualan::find($dttrx->sale_id);
		$product    = Product::find($dttrx->brg_id);
	    
		$old_isi    = $dttrx->isi;
		$old_qqq    = $dttrx->qty;
	    
	    if($dttrx->type_brg==0){
	        $idinv = $dttrx->inv_id;
	        $dtinv = InvoiceDetail::find($idinv);
	        
		    $old_tonase = $dtinv->tonase_sale;
		    $old_qty    = $dtinv->qty_sale;
		    
		    $dtinv->qty_sale    = $old_qty - $old_qqq ;
		    $dtinv->tonase_sale = $old_tonase - $old_isi ;
			$dtinv->update();	        
		}else{
			
			//update stock
			$stk = Stock::where('brg_id', '=', $product->id)->get();
			foreach($stk as $sss){ $idstock = $sss->id_stock ;}

			$update_qqq = $old_qqq * $old_isi * -1 ; 
			$this->updatestock( $idstock, $update_qqq, $msale->sale_tgl);

		}
	    
	    
		$dttrx->delete(); 
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'DELETE Transaksi '.$msale->sale_no;
		$userlog->content	=  $product->nama_brg.' berhasil didelete by. '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));		
    }
	
	public function cetak($id)
	{
		
		$msale		= Penjualan::find($id);
		$dsale	 	= PenjualanDetail::leftjoin('ms_product', 'dt_sale.brg_id', 'ms_product.id')
									->where('dt_sale.sale_id', '=', session('idtrx'))
									->orderBy('dt_sale.brg_id','ASC')
									->get();
		$tlqty=0;
		$totalrp=0;
		
		foreach($dsale as $list){
			$tlqty += $list->qty;
			//$tlval += ($list->qty * $list->harga_retail * $list->isi - $list->potongan);
			
			if($list->type_brg==0){
			    $totalrp += $list->harga_retail * $list->isi - $list->potongan;
			}else{
			    $totalrp += $list->harga_retail * $list->qty* $list->isi - $list->potongan;
			}			
		}

		$customer	= Customer::find($msale->cust_id);
		$no 	= 1;
     
	 	return view('penjualan_detail.printinv', compact('msale','dsale','no','customer', 'tlqty', 'totalrp')); 
    } 	
   
/*  reprint po */
	public function reprintForm()
	{
		
		$minv		= Invoice::find(session('idinv'));
		
		$dinv	 	= InvoiceDetail::leftjoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
									->where('dt_invoice.invoice_id', '=', session('idinv'))
									->get();
								
									
		$supplier	= Supplier::find($minv->supp_id);

		$no 		= 1;

	 	return view('invoice_detail.reprintinv', compact('minv','dinv','no','supplier')); 
    } 	   
   
/*  history */
   public function historyData()
   {
		$mtrf		= Transfer::find(session('idtrf'));
		
		$dtransfer	= TransferDetail::leftJoin('ms_product', 'dt_transfer.product_id', '=', 'ms_product.id')
										->where('dt_transfer.transfer_id', session('idtrf'))->get();
										
				
		$no=0;
		$totalqty	= 0;
		$data = array();
				
		foreach($dtransfer as $list){
			$no++;

			$row = array();
				
			$row[] = $no;
			$row[] = $list->nama_brg;
			$row[] = $list->no_seri;			
			$row[] = '<div class="text" align="right">'.format_uang($list->harga_retail).'</div>';
			$row[] = '<div class="text" align="right">'.format_uang($list->trf_qty).'</div>';
            
			$data[] = $row;		

			}

		$output = array("data" => $data);
		return response()->json($output);
	}
			   
	
}	
