<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Product;
use App\Customer;
use App\Stock;
use App\Rute;
use App\InvoiceDetail;
use App\Penjualan;
use App\PenjualanDetail;
use App\Tagihan;
use App\TagihanDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;
use PDF;

//last update : 23/06/2020

class PenjualanController extends Controller
{

	public function index()
	{		
		$sekarang = Date('Y-m-d');
		$awal	  = Date('Y-m-d', strtotime('-15 day', strtotime( $sekarang )));
		$akhir	  = Date('Y-m-d', strtotime('+2 day', strtotime( $sekarang )));
        $customer = Customer::all();
        
        if(Auth::user()->group=="MANAGER"){
            $rute     = Rute::whereBetween('tanggal', array($awal, $akhir))
                                ->where('status_batal','=',0)->get();	    
        }else{
            $rute     = Rute::where('tanggal','=', $sekarang)
                                ->where('status_batal','=',0)->get();	    
        }
	    
		return view('penjualan.index', compact('customer', 'rute'));
	}
	
    function getheader()
    {
		$tglnow = date("Y-m-d");

        $jual  = DB::table('ms_sale')
                        ->select(DB::raw('id_sale, sale_route,sale_no, sale_tgl, cust_id, sale_netto, status_retur, user_id '))
						->where('ms_sale.sale_posted',0)
					    ->where('ms_sale.sale_batal',0)
						->orderby('ms_sale.id_sale','DESC')->get();

		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
				   
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $this->NamaRute($list->sale_route)->driver;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $this->NamaCustomer($list->cust_id)->cus_name;
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto).'</div>';

			if($list->status_retur==1){
			    $row[] = "Invoice";
			}else{
			    $row[] = "Retur";
			}
			
			$row[] = User::NamaUser($list->user_id)->username;	
			
			if(Auth::user()->group=="MANAGER")
            {			

			    $row[]= '<div class="btn-group">
                  <button  class="btn btn-outline-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				  <i class="fa fa-caret-down"></i>
                  </button>
                    <ul class="dropdown-menu dropdown-menu-right" style="border:1px black solid;">
                    <li><a href="penjualan/'.$list->id_sale.'/input"><i class="fa fa-plus"></i>Input Detail</a></li>
                    <li><a onclick="editHeader('.$list->id_sale.')"><i class="fa fa-pencil"></i>Edit Header </a></li>
                    <li><a onclick="batal('.$list->id_sale.')"><i class="fa fa-trash"></i>Batal Penjualan</a></li>
                  </ul>
                </div>';
			
            }else{

			    $row[]= '<div class="btn-group">
                  <button  class="btn btn-outline-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				  <i class="fa fa-caret-down"></i>
                  </button>
                  <ul class="dropdown-menu dropdown-menu-right" style="border:1px black solid;">
                    <li><a href="penjualan/'.$list->id_sale.'/input"><i class="fa fa-plus"></i>Input Detail</a></li>
                    <li><a onclick="editHeader('.$list->id_sale.')"><i class="fa fa-pencil"></i>Edit Header </a></li>
                  </ul>
                </div>';			
			
            }


		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }

///-- create new invoice
	public function store(Request $request)
	{
	    $tipe   = $request['tipe'];
	    
		$notrx  = "";
		$rute   = $request['rute'];
		$tahun	= date('Y');
		$bulan  = date('m');
		
		if ($tipe==1){
    		$nomor	= "INV/".$tahun.$bulan."/";		
    		$ada_no	= DB::table('ms_sale')
    					->select(DB::raw('SUBSTR(MAX(sale_no),12,4) as last_no'))
    					->where('sale_no', 'LIKE', "$nomor%" )->get();
		}else{
    		$nomor	= "RTR/".$tahun.$bulan."/";		
    		$ada_no	= DB::table('ms_sale')
    					->select(DB::raw('SUBSTR(MAX(sale_no),12,4) as last_no'))
    					->where('sale_no', 'LIKE', "$nomor%" )->get();
		}	
		
		$jml	= $ada_no->count();
			
		if ($jml >0)
		{
			foreach( $ada_no as $ada ){	$no	= $ada->last_no; }
			$no1	= $no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no1);		//format: INV/2019/00001
			$notrx = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "0001";
			$notrx = $nomor.$nomorbaru;
		}
			
		$idcust		= $request['cus'];
		$tgltrx		= $request['tgltrx'];
		
		$customer	= Customer::find($idcust);
	
		$trans	= New Penjualan;
		$trans->sale_no         = $notrx;
		$trans->cust_id	        = $idcust;
		$trans->sale_tgl	    = $tgltrx;
		$trans->sale_route      = $rute;
		$trans->status_retur    = $tipe;
		$trans->user_id	        = Auth::user()->id;
		
		$trans->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Transaksi Penjualan baru';
			$userlog->content	= 'Invoice '.$notrx.' - cust:'.$customer->cus_name.' berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}

//-------------------------------
	function input($id)
	{
		session(['idtrx'=>$id]);
		
		$idtrx	= $id;
		$trans	= Penjualan::where('id_sale',$id)->get();
		
		foreach($trans as $list)
		{
			
			$idcust	= $list->cust_id;
			$notrx	= $list->sale_no;
			$posted	= $list->sale_posted;
		}
		
		if($posted==1)
		{
			//return Redirect::route('invoice.index');	
			$customer = Customer::where('id_cust', $idcust)->get();
			return view('penjualan.index', compact('customer'));
		}else{
		
    		$no=1;
    		$m_sale		= Penjualan::find($idtrx);
    		$customer	= Customer::find($idcust);
    		
            //utk barang satuan
 			$dtstock	= Stock::leftJoin('ms_product', 'dt_stock.brg_id', 'ms_product.id')
									->where('dt_stock.stock_akhir', '>', 0)
									->where('ms_product.type_brg', '=', 1)
									->where('dt_stock.active_sts', '=', 1)
									->get();

            //utk barang kemasan ambil dari data barang masuk yg status_sale=0 type=0
            $dtinv      = InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
                                    ->where('dt_invoice.type_brg', '=', '0')
                                    ->where('dt_invoice.inv_posted', '=', '1')
                                    ->where('dt_invoice.active_sts', '=', '1')
                                    ->where('dt_invoice.inv_qty','>','dt_invoice.qty_sale + dt_invoice.qty_out - dt_invoice.qty_adj')
                                    ->get();
            
    		return view('penjualan_detail.index', compact('m_sale','customer','dtstock','dtinv', 'idtrx','no'));
		}
	
	} 

	public function tampilsatuan()
	{
		$dtstock = Stock::leftJoin('ms_product', 'dt_stock.brg_id', 'ms_product.id')
							->where('dt_stock.stock_akhir', '>', 0)
							->where('ms_product.type_brg', '=', 1)
							->where('dt_stock.active_sts', '=', 1)
							->get();

				$no=0;
				$data = array();

				foreach($dtstock as $list)
				{
					$row = array();	 
					$no++;
					
//number_format($number, 2, ',', ' ');

					$row[] = $no;
					$row[] = $list->nama_brg;
					$row[] = format_uang($list->harga_jual);
					$row[] = number_format($list->stock_akhir, 2, ',', '.');
					$row[] = '<div class="btn-btn">
						<a onclick="selectItem('.$list->id_stock.')" class="btn btn-primary btn-xs"><i class="fa fa-check"></i></a></td>
						  </div>';
						  
					$data[] =$row;
				}

			$output = array("data" => $data);
			return response()->json($output);

	}

	public function tampilkemasan()
	{
		$dtinv  = InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
						->where('dt_invoice.type_brg', '=', '0')
						->where('dt_invoice.inv_posted', '=', '1')
						->where('dt_invoice.active_sts', '=', '1')
						->where('dt_invoice.inv_qty','>','dt_invoice.qty_sale + dt_invoice.qty_out - dt_invoice.qty_adj')
						->get();

						$data = array();


//number_format($number, 2, ',', ' ');

						foreach($dtinv as $list)
						{
							$row = array();	 
			
							$row[] = $list->nama_brg;
							$row[] = $list->inv_tgl;
							$row[] = $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
							$row[] = number_format($list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj,2,',','.');
							$row[] = format_uang($list->harga_jual);
							$row[] = '<div class="btn-btn">
								<a onclick="selectItem2('.$list->id_inv.')" class="btn btn-primary btn-xs"><i class="fa fa-check"></i></a></td>
								  </div>';
								  
							$data[] =$row;
						}
		
					$output = array("data" => $data);
					return response()->json($output);						
	}
/*-----------------------------------------------------*/
	function tampil($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
			$ppn	= $list->inv_ppn;
			$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		$no=1;
		$m_inv		= Invoice::find($id);
		$supplier	= Supplier::find($idsupp);
		$product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    	
    
		return view('invoice_detail.index_history', compact('m_inv','supplier','product','idinv','no'));

	} 
	
	public function cekrute($tgrute, $id_rute){
        $rute = Rute::find($id_rute);
        
        if($rute->tanggal != $tgrute){
            echo json_encode(array('msg'=>'error'));
        }else{
            echo json_encode(array('msg'=>'susccess'));
        }
    
	}
	
	
	public function NamaRute($id){
	    return Rute::find($id);
	}
	
	public function NamaCustomer($id){
	    return Customer::find($id);
	}
/*-----------------------------------------------------*/
    public function edit($id)
    {
      $jual = Penjualan::find($id);
      $rute = Rute::find($jual->sale_route);
      
      echo json_encode(array_merge(json_decode($jual, true),json_decode($rute, true)));
      
      //echo json_encode($jual);
    }
    
 
    public function show($id)
    {
        
    }

	public function editheader(Request $request, $id)
	{
		$msale = Penjualan::find($id);
		
		$msale->sale_route = $request['rute2'];
		$msale->update();
		
		echo json_encode(array('msg'=>'success'));
	}	
	
	public function update(Request $request, $id)	
	{
		$msale = Penjualan::find($id);
		
		$msale->sale_tgl   = $request['tgltrx'];
		$msale->sale_route = $request['rute'];
		$msale->update();
		
		echo json_encode(array('msg'=>'success'));
	}
	
	public function batal($id)	
	{
		$msale = Penjualan::find($id);
		
		if ($msale->sale_netto != 0){
			echo json_encode(array('msg'=>'error'));
		}else{	
			$msale->sale_batal = 1;
			$msale->update();
			echo json_encode(array('msg'=>'success'));
		}
	}	
	
/////////////////////////////////////////////////////////////////////////

	/* posting sale ke stock & cetak invoice */
	
    public function posting($id)
    {

		$msale 	    = Penjualan::find($id);
		$noinv      = $msale->sale_no;
		
		$dtinv  	= PenjualanDetail::where('sale_id', $id )->get();

		$totalinv	= 0;

		foreach($dtinv as $list){
            
            $iddsale    = $list->id_dsale;
            $idbrg      = $list->brg_id;
            $tglsale    = $list->sale_tgl;
            $qty        = $list->qty * $list->isi;
            $posted     = $list->sale_posted;
            
            if($list->type_brg==0){
			    $totalinv += $list->isi * $list->harga_retail - $list->potongan ;
            }else{
				$totalinv += $list->qty * $list->isi * $list->harga_retail - $list->potongan ;
				
            }
	// update stock pada saat input detail penjualan //

         //   if($list->type_brg==1){			
			    /* posting stock */
		//	    $data_stock  = Stock::where('brg_id',$idbrg)
		//	                    ->get();

		//	     if ($posted==0 AND $msale->status_retur==1){			     
    			     /*update stock */
    	//		     foreach ($data_stock as $dtstock)
    	//		     { 
    	//		        $stkakhir   = $dtstock->stock_akhir;
    	//		        $idstock    = $dtstock->id_stock; 
    	//		        $jual       = $dtstock->penjualan;
    	//		     }
    			     
    	//		     $stock = Stock::find($idstock);
    			     
    	//		     $stock->penjualan      = $jual + $qty;
    	//		     $stock->tgl_jual       = $tglsale;
    	//		     $stock->stock_akhir    = $stkakhir - $qty;
    			     
		//	         $stock->update();
		//	     } 
		//	 }

        /*update status posted inv detail */
        $det_sale = PenjualanDetail::find($iddsale);
        $det_sale->sale_posted = 1;
            
        $det_sale->update();
            
 		}
		 
		 /* update ms_sale */
		 
		 $msale->sale_netto     = $totalinv;
		 $msale->sale_posted    = 1;
		 $msale->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Posting Penjualan';
		$userlog->content	= 'Inovice No. '.$noinv.' berhasil diposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

 		return Redirect::route('penjualan.index');					//cetak invoice
 		
    }



/*=================================================================================*/
/* print DO keluar pertgl hari ini */

    public function printdo($id){
        //$tgl = date('Y-m-d');
        $no  = 1;
        $idrute = $id;
        $rt = Rute::find($id);
        $tgl = $rt->tanggal;
        
        $data = DB::table('dt_sale as A')
                ->select('A.brg_id','A.brg_nama','B.sale_route','A.type_brg')
                ->addSelect(DB::raw('SUM(A.qty) as qty, SUM(A.isi) as isi'))
                ->leftjoin('ms_sale as B', function($join)
                    {
                        $join->on('A.sale_id', '=', 'B.id_sale');
                    })
                ->where('B.sale_tgl','=', $tgl)
                ->where('B.sale_route', '=', $id)
				->where('B.status_retur', '=', 1)
                ->groupBy('A.brg_id')
                ->groupBy('A.brg_nama')
                ->groupBy('B.sale_route')
                ->groupBy('A.type_brg')
                ->get();
    
 
        //foreach($data as $list){ $idrute = $list->sale_route ;break;}        
        
        return view('penjualan.cetakdo', compact('data','no','idrute','tgl'));
    }

/* posting stock */
	/* posting opname ke stock & cetak opname */
	
    public function updatestock($id)
    {

		$mtrf    	= Transfer::find($id);
        $tgltrf     = $mtrf->trf_tgl;
        $idfrom     = $mtrf->from_id;
		$idto		= $mtrf->to_id;
        $cabang     = Cabang::find($idto);
        
		$dtrf 	 	= TransferDetail::where('transfer_id', $id )
		                                ->where('trf_posted', 0)
		                                ->get();

    /* proses posting stock  kurangi stock asal(from_id) dan tambah stock tujuan(to_id) */
		foreach($dtrf as $list) 
        {
            $id_detail  = $list->id_trf;
            $qty        = $list->trf_qty;
            $idbrg      = $list->product_id;
            $noseri     = $list->no_seri;
            
			$data_stock  = Stock::where('cabang_id', $idfrom)
			                    ->where('product_id', $idbrg)
			                    ->where('no_seri', $noseri)
			                    ->get();

			/* update stock asal (dikurangi) */			
			foreach ($data_stock as $dtstock)
			{  $idstock    = $dtstock->id_stock; }
			   			     
  			    $datastock  = Stock::find($idstock);
				$stk_old	= $datastock->stock_akhir;
				$out_old	= $datastock->trf_out;
				    			     
    			$datastock->trf_out       = $out_old + $qty;
    			$datastock->tgl_trout     = $tgltrf;
    			$datastock->stock_akhir   = $stk_old - $qty;
    			$datastock->user_id       = Auth::user()->id;
			    
		        $datastock->update();

			/* update stock tujuan */
			$stock_tuju  = Stock::where('cabang_id', $idto)
			                   ->where('product_id', $idbrg)
			                   ->where('no_seri', $noseri)
			                   ->get();
				
		
			$ada_stock   = $stock_tuju->count();

			if ($ada_stock==0)
			{
				/* insert stock */
				 $stock = New Stock;
				 $stock->cabang_id      = $idto;    
				 $stock->product_id     = $idbrg;
				 $stock->no_seri        = $noseri;
				 $stock->trf_in     	= $qty;
				 $stock->tgl_trin       = $tgltrf;
				 $stock->stock_akhir    = $qty;
				 $stock->user_id        = Auth::user()->id;
				 
				 $stock->save();

			 }else{
			     
				foreach ($stock_tuju as $stk_tuju)
				{ $idstock   = $stk_tuju->id_stock; }
			        
   			    $dtstock  	= Stock::find($idstock);
				$stk_old	= $dtstock->stock_akhir;
				$in_old		= $dtstock->trf_in;
				    			     
    			$dtstock->trf_in        = $in_old + $qty;
    			$dtstock->tgl_trin	    = $tgltrf;
    			$dtstock->stock_akhir   = $stk_old + $qty;
    			$dtstock->user_id       = Auth::user()->id;
			    
		        $dtstock->update();
			         
		     } 

            /*update status posted opn detail */
            $det_trf = TransferDetail::find($id_detail);
            $det_trf->trf_posted = 1;
            
            $det_trf->update();
            
		 }
		 
		 /* update ms_transfer */
		 
		 $mtrf->trf_posted   = 1;
		 $mtrf->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Posting Transfer Barang';
		$userlog->content	= 'Posting Transfer '.$mtrf->trf_no.' berhasil diposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

 		//return Redirect::route('stockopnamedetail.cetak');					//cetak invoice
 		return Redirect::route('home');
    }
	

	
	
/* history */
//-------------------------------
	public function history()
	{		
		$customer = Customer::all();
		
		return view('penjualan.history', compact('customer'));
	}	

/*------------------------------------------------------*/
    function history_header($tgl1,$tgl2)
    {

        $jual = Penjualan::where('ms_sale.sale_posted',1)
                            ->whereBetween('sale_tgl', [$tgl1, $tgl2])
      	                    ->orderby('ms_sale.sale_no','ASC')
							->get();
		/*					
      	$jual = Penjualan::where('ms_sale.sale_posted',1)
      	                    ->leftjoin('ms_customer', 'ms_customer.id_cust','=','ms_sale.cust_id')
      	                    ->leftjoin('ms_route', 'ms_route.id_route','=','ms_sale.sale_route')
      	                    ->lefjoin('users', 'users.id', '=', 'ms_sale.user_id')
							->orderby('ms_sale.sale_no','ASC');
							//->get();
		*/
		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
			
			$sts="";
			if($list->sale_lunas == 0){ $sts='<span class="label label-danger">blm lunas</span>';}else{ $sts='<span class="label label-success">LUNAS</span>'; }
				   
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $this->NamaRute($list->sale_route)->driver;
			$row[] = $list->sale_no;
			$row[] = $list->sale_tgl;
			$row[] = $this->NamaCustomer($list->cust_id)->cus_name;
			$row[] = $sts;
			$row[] = '<div class="text" align="right">'.format_uang($list->sale_netto - $list->sale_bayar1 - $list->sale_bayar2 - $list->sale_bayar3).'</div>';
			$row[] = User::NamaUser($list->user_id)->username;
		    $row[] = '<div class="btn-btn">
				        <a onclick="showDetail('.$list->id_sale.')" class="btn btn-success btn-xs"><i class="fa fa-list"></i></a>
				     </div>';	

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
								
		//return Datatables::of($jual)->make(true);
		
    }



//------------------------------history detail

	public function history_detail($id)
	{

		$dtsale	= PenjualanDetail::where('sale_id',$id)->get();
		
		$data=array();
		
		foreach($dtsale as $list)
		{
		    
		    if($list->type_brg==0){
			    $tltrans = $list->harga_retail * $list->isi - $list->potongan;
			}else{
			    $tltrans = $list->harga_retail * $list->qty* $list->isi - $list->potongan;
			}
			
			$row   = array();
		    $row[] = $list->brg_nama;
            $row[] = '<div class="text" align="right">'.format_uang($list->harga_retail).'</div>';
            $row[] = $list->qty;
            $row[] = $list->isi;
            $row[] = $list->potongan;
            $row[] = '<div class="text" align="right">'.format_uang( $tltrans).'</div>';
            
            $data[] = $row;
		}
		
		$output = array("data" => $data);
		return response()->json($output);								
	
	} 
	
/* tagihan */
//-------------------------------
	public function tagihan()
	{		
		$sekarang = Date('Y-m-d');
		$awal	  = Date('Y-m-d', strtotime('-2 day', strtotime( $sekarang )));
        $customer = Customer::all();
        //$rute     = Rute::whereBetween('tanggal', array($awal, $sekarang))->get();
        $rute    = Rute::where('tanggal', $sekarang)
                            ->where('status_batal',0)->get();

        
		return view('penjualan.tagihan', compact('customer','rute'));
	}
	
	public function history_tagihan()
	{
	    return view('penjualan.history_tagihan');
	}
	
    public function tagihan_hdr()
    {

     	$jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.sale_batal',0)
								->where('ms_sale.sale_lunas', '=',0)
								->where('ms_sale.sale_netto', '>',0)
								->orderBy('ms_sale.cust_id','ASC')
								->orderby('ms_sale.sale_no','ASC')->get();
		
		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
			
			$sss = $list->status_retur;
			$sts="";
				switch ($sss){
					case '1': $sts = 'Invoice'; break;
					case '2': $sts = 'Retur'; break;}			
		
		    $row[] = "<input type='checkbox' name='id[]'' value='".$list->id_sale."'>";
			
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $this->NamaRute($list->sale_route)->driver;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $list->cus_name;
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto - $list->sale_bayar1 - $list->sale_bayar2 -$list->sale_bayar3).'</div>';

            if($sss==1){
		    $row[] = '<div class="btn-btn">
				        <a class="btn btn-primary btn-xs">Invoice </a>
				      </div>';	
            }else{
                $row[] = '<div class="btn-btn">
				        <a  class="btn btn-danger btn-xs">Retur  </a>
				      </div>';	
            }
            
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }
    
    public function tagihan_hist($tgl1, $tgl2){
        $tagihan = Tagihan::orderBy('tanggal', 'ASC')
                            ->whereBetween('tanggal', [$tgl1, $tgl2])
                            ->where('is_cancel', '=', 0)
                            ->get();
        
        $data=[];
        foreach($tagihan as $list)
        {
            $row=[];
            $row[]= $list->tanggal;
            $row[]= $list->deskripsi;
            $row[]= User::NamaUser($list->user_id)->username;
            $row[] = '<div class="btn-btn">
			    	    <a onclick="showDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-list"></i> </a>
			    	    <a onclick="delHist('.$list->id.')" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i> </a>
			    	  </div>';	
			    	  
            $data[]= $row;
        }
        
		$output = array("data" => $data);
		return response()->json($output);	        
       
    }
    
    public function histtagihan_detail($id){
        
        $dt = TagihanDetail::leftjoin('ms_sale', 'ms_sale.id_sale', '=', 'dt_tagihan.invoice_id')
                                    ->where('dt_tagihan.id_tagihan', '=', $id)
                                    ->get();
                                
        $data=[];
        foreach($dt as $list)
        {
            $row=[];
            $sts="";
            if ($list->sale_lunas==0) 
            { $sts='<div class="label label-danger">Blm Lunas</div>'; 
            }else
            { $sts='<div class="label label-success">LUNAS</div>'; }
            
            $row[] = Customer::Customer($list->cust_id)->cus_name;
            $row[] = $list->sale_no;
            $row[] = $list->sale_tgl;
            $row[] = format_uang($list->sale_netto);
            $row[] = $sts;
            
            if(Auth::user()->tagihan_del==1)
            {
                $row[] = '<div class="btn-btn">
			    	    <a onclick="delItem('.$list->id.')" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i></a>
			    	  </div>';	
            }else{
                 $row[] = '<div class="btn-btn">
			    	    <a class="btn btn-default btn-sm"><i class="fa fa-trash"></i></a>
			    	  </div>';	
            }
            
            $data[] = $row;
        }
        
        $output = array("data" => $data);
        return response()->json($output);
        
    }
    
    public function tagihan_add($id){
        
        $dt = TagihanDetail::where('id_tagihan','=', $id)->get();
        $ll=[];
        foreach($dt as $dd){ $ll[]=$dd->invoice_id ; }
        
     	$inv = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.sale_batal',0)
								->where('ms_sale.sale_lunas', '=',0)
								->where('ms_sale.sale_netto', '>',0)
								->whereNotIN('ms_sale.id_sale', $ll)
								->orderBy('ms_sale.cust_id','ASC')
								->orderby('ms_sale.sale_no','ASC')->get();
		
		$no=1;
		$data = array();
		
		foreach($inv as $list)
		{
			$row = array();
			
			$sss = $list->status_retur;
			$sts="";
				switch ($sss){
					case '1': $sts = 'Invoice'; break;
					case '2': $sts = 'Retur'; break;}			
		
		    $row[] = "<input type='checkbox' name='id[]'' value='".$list->id_sale."'>";
			
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $this->NamaRute($list->sale_route)->driver;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $list->cus_name;
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto - $list->sale_bayar1 - $list->sale_bayar2 -$list->sale_bayar3).'</div>';
/*
            if($sss==1){
		    $row[] = '<div class="btn-btn">
				        <a class="btn btn-primary btn-xs">Invoice </a>
				      </div>';	
            }else{
                $row[] = '<div class="btn-btn">
				        <a  class="btn btn-danger btn-xs">Retur  </a>
				      </div>';	
            }
*/            
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);						        
        
    }
    
    
	public function delhistory($id)	
	{
		$tgh = TagihanDetail::where('id_tagihan','=',$id)->count();
		
		if ($tgh != 0){
			echo json_encode(array('msg'=>'error'));
		}else{
		    
		    $tagih = Tagihan::find($id);
		    
			$tagih->is_cancel = 1;
			$tagih->update();
			echo json_encode(array('msg'=>'success'));
		}
	}	    
	
    public function printbill(Request $request)
    {
        $dtbill = array();
        
        foreach($request['id'] as $id){
            
   	        $jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.id_sale','=', $id)
								->where('ms_sale.sale_netto','>', 0)
							//	->where('ms_sale.status_retur', 1)
								->orderBy('ms_sale.cust_id','ASC')
								->get();
								
			foreach($jual as $penjualan){
                    $dtbill[] = $penjualan;
			}
        }
        
        $no = 1;
        return view('penjualan.cetakbill', compact('dtbill','no'));
  
    }	
    
    public function simpantagih(Request $request, $idrute)
    {
        $rute = Rute::find($idrute);
        
        $mtagih = New Tagihan;
        $mtagih->tanggal    = date('Y-m-d');
        $mtagih->rute_id    = $idrute;
        $mtagih->deskripsi  = "Tagihan tgl. ".date('Y-m-d').' Rute '.$rute->route_name;
        $mtagih->user_id    = Auth::user()->id;
        $mtagih->save();
        
        $last = Tagihan::latest()->first();
        
        foreach($request['id'] as $id){
  
            $dtagih = New TagihanDetail;
 
            $dtagih->id_tagihan = $last->id;
            $dtagih->invoice_id = $id;
            $dtagih->save();
         }
         
         echo json_encode(array('msg' => 'success'));
    }
    
    public function simpantagih_add(Request $request, $idbill)
    {

        foreach($request['id'] as $id){
  
            $dtagih = New TagihanDetail;
 
            $dtagih->id_tagihan = $idbill;
            $dtagih->invoice_id = $id;
            $dtagih->save();
         }
         
         echo json_encode(array('msg' => 'success'));
    }    
    
    
    public function destroy($id){
        
        $dt = TagihanDetail::find($id);
        $dt->delete();
        echo json_encode(array('msg' => 'success'));
    }
    
    
    public function printpdf(Request $request, $ukur, $idrute)
    {
        $rute = Rute::find($idrute);
        $tgh  = Rute::find($idrute);
        $data = array();
     	$no=0;   
  
        foreach($request['id'] as $id){
            
   	        $jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.id_sale','=', $id)
								->where('ms_sale.sale_netto','>', 0)
								->orderBy('ms_sale.cust_id','ASC')
								->get();
			

			foreach($jual as $list){
			
			    $row = array();
			    $no++;
			    
			    $row[] = $no;
			    $row[] = $list->cus_name;
			    $row[] = $list->sale_no;
			    $row[] = tanggal_indonesia($list->sale_tgl, false);
			    $row[] = format_uang($list->sale_netto - $list->sale_bayar1 -$list->sale_bayar2 - $list->sale_bayar3);
			    
			    if($list->sale_bayar1>0){
			        $row[] = "ada cicilan";}else{$row[] ="";}
                
                $data[] = $row;
			}
        }
        $data[] = array("", "Admin", "Sopir", "","Mengetahui","");
        
        $pdf = app('dompdf.wrapper');
        $pdf->getDomPDF()->set_option("enable_php", true);
        $pdf->loadView('penjualan.pdf_tagihan', compact('data', 'ukur', 'rute', 'tgh'));
        
        if($ukur=="2"){ $pdf->setPaper('a5', 'landscape'); } else {$pdf->setPaper('a4', 'portrait'); }
         
        return $pdf->stream();
        
    }


    public function reprint($bill)
    {
        $tgh = Tagihan::find($bill);
        $rute = Rute::find($tgh->rute_id);
        $dt = TagihanDetail::where('id_tagihan', '=', $bill)->get();
        
        $ukur='1';
        $dd=[];
        foreach($dt as $ll) { $dd[]=$ll->invoice_id; }
                
        $inv = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->whereIN('ms_sale.id_sale', $dd)
								->orderBy('ms_sale.cust_id','ASC')
								->get();
								
        $data = array();
     	$no=0;   			

		foreach($inv as $list){
			
		    $row = array();
		    $no++;
			    
		    $row[] = $no;
		    $row[] = $list->cus_name;
		    $row[] = $list->sale_no;
		    $row[] = tanggal_indonesia($list->sale_tgl, false);
		    $row[] = format_uang($list->sale_netto - $list->sale_bayar1 -$list->sale_bayar2 - $list->sale_bayar3);
		    
		    if($list->sale_bayar1>0){
		       $row[] = "ada cicilan";}else{$row[] ="";}
                
            $data[] = $row;
		
        }
        
        $data[] = array("", "Admin", "Sopir", "","Mengetahui","");
         
        $pdf = app('dompdf.wrapper');
        $pdf->getDomPDF()->set_option("enable_php", true);
        $pdf->loadView('penjualan.pdf_tagihan', compact('data', 'ukur', 'rute', 'tgh'));
        
        if($ukur=="2"){ $pdf->setPaper('a5', 'landscape'); } else {$pdf->setPaper('a4', 'portrait'); }
         
        return $pdf->stream();
        
    }

  public function exportPDF(Request $request){

 
     $data = $this->printpdf($request);

    // $pdf = PDF::loadView('report.pdf', compact('tanggal_awal', 'tanggal_akhir', 'data','hal'));
     
     $pdf = app('dompdf.wrapper');
     $pdf->getDomPDF()->set_option("enable_php", true);
     $pdf->loadView('penjualan.pdf_tagihan', compact('data'));
    
     $pdf->setPaper('a4', 'potrait');
     
     return $pdf->stream();
   }


    public function printbill_new($id)
    {
        $dtbill = array();
        $idrute = $id;
        $jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
						->where('ms_sale.sale_route','=', $id)
						->where('ms_sale.sale_netto','>', 0)
						->where('ms_sale.sale_lunas', '=', 0)
						->orderBy('ms_sale.cust_id','ASC')
						->get();
								
		foreach($jual as $penjualan){
            $dtbill[] = $penjualan;
		}
        
        $no = 1;
        return view('penjualan.cetakbill', compact('dtbill','no','idrute'));
  
    }	

    
    public function index_unpost(){
        
        return view('penjualan.index_unpost');
    }
    
    public function data_unpost(){
        
        $jual  = DB::table('ms_sale')
                        ->select(DB::raw('id_sale, sale_route,sale_no, sale_tgl, cust_id, sale_netto, status_retur, user_id '))
						->where('ms_sale.sale_posted',1)
					   // ->where('ms_sale.status_retur',1)
					    ->where('ms_sale.sale_lunas',0)
						->orderby('ms_sale.id_sale','ASC')->get();

		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
				   
			$row[] = $this->NamaRute($list->sale_route)->route_name;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $this->NamaCustomer($list->cust_id)->cus_name;
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto).'</div>';
			$row[] = User::NamaUser($list->user_id)->username;	
			
		    $row[]= '<div class="btn-group">
                        <a onclick="unPosting('.$list->id_sale.')" class="btn btn-danger btn-xs"><i class="fa fa-unlock"></i></a>
                    </div>';
			
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }
    
    public function unposting($id){
        
        $dt = Penjualan::find($id);
        $dt->sale_posted = 0 ;
        $dt->update();
        
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Unposting Penjualan';
		$userlog->content	= $dt->sale_no.' berhasil di-Unposting oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		        
        
        echo json_encode(['msg'=>'success']);
        
    }
    
}
